/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IIndexedElement;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.ILogger;
import org.eclipse.e4.xwt.INamespaceHandler;
import org.eclipse.e4.xwt.IStyle;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.ResourceDictionary;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.XWTMaps;
import org.eclipse.e4.xwt.core.IBinding;
import org.eclipse.e4.xwt.core.IDynamicBinding;
import org.eclipse.e4.xwt.core.IRenderingContext;
import org.eclipse.e4.xwt.core.IVisualElementLoader;
import org.eclipse.e4.xwt.core.Setter;
import org.eclipse.e4.xwt.core.Style;
import org.eclipse.e4.xwt.input.ICommand;
import org.eclipse.e4.xwt.internal.core.DataBindingTrack;
import org.eclipse.e4.xwt.internal.core.NameScope;
import org.eclipse.e4.xwt.internal.utils.ClassLoaderUtil;
import org.eclipse.e4.xwt.internal.utils.DocumentObjectSorter;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.internal.utils.NamespaceHelper;
import org.eclipse.e4.xwt.internal.utils.ObjectUtil;
import org.eclipse.e4.xwt.internal.utils.TableEditorHelper;
import org.eclipse.e4.xwt.internal.utils.UserDataHelper;
import org.eclipse.e4.xwt.internal.xml.Attribute;
import org.eclipse.e4.xwt.internal.xml.DocumentObject;
import org.eclipse.e4.xwt.internal.xml.Element;
import org.eclipse.e4.xwt.javabean.Controller;
import org.eclipse.e4.xwt.javabean.StaticResourceBinding;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableItemProperty;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.utils.PathHelper;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader
implements IVisualElementLoader {
    static Map<String, Object> EMPTY_MAP = Collections.EMPTY_MAP;
    static final String RESOURCE_LOADER_PROPERTY = "XWT.ResourceLoader";
    private static final HashMap<String, Collection<Class<?>>> DELAYED_ATTRIBUTES = new HashMap();
    private static final String COLUMN = "Column";
    protected ResourceLoader parentLoader;
    protected IRenderingContext context;
    protected IXWTLoader loader;
    protected Object scopedObject;
    protected NameScope nameScoped;
    protected LoadingData loadData = new LoadingData();
    private DataBindingTrack dataBindingTrack;

    static {
        ArrayList<Class<TableEditor>> types = new ArrayList<Class<TableEditor>>();
        types.add(Viewer.class);
        DELAYED_ATTRIBUTES.put("input", types);
        types = new ArrayList();
        types.add(Sash.class);
        types.add(SashForm.class);
        DELAYED_ATTRIBUTES.put("weights", types);
        types = new ArrayList();
        types.add(Combo.class);
        types.add(CCombo.class);
        DELAYED_ATTRIBUTES.put("text", types);
        types = new ArrayList();
        types.add(Browser.class);
        DELAYED_ATTRIBUTES.put("url", types);
        types = new ArrayList();
        types.add(TableEditor.class);
        DELAYED_ATTRIBUTES.put("dynamic", types);
    }

    public ResourceLoader(IRenderingContext context, IXWTLoader loader) {
        this.context = context;
        this.loader = loader;
    }

    @Override
    public Object createCLRElement(Element element, Map<String, Object> options) {
        try {
            Object styles;
            Composite parent = (Composite)options.get("XWT.Container");
            if (!this.loader.getTrackings().isEmpty()) {
                this.dataBindingTrack = new DataBindingTrack();
            }
            this.parentLoader = (ResourceLoader)options.get(RESOURCE_LOADER_PROPERTY);
            options.remove(RESOURCE_LOADER_PROPERTY);
            ResourceDictionary resourceDictionary = (ResourceDictionary)options.get("XWT.Resources");
            if (resourceDictionary != null && (styles = resourceDictionary.get("XWT.DefaultStyles")) != null) {
                this.loadData.setStyles((Collection)styles);
                resourceDictionary.remove("XWT.DefaultStyles");
            }
            Object control = this.doCreate(parent, element, null, options);
            if (this.dataBindingTrack != null) {
                String dataBindingMessage = this.dataBindingTrack.getDataBindMessage();
                ILogger log = this.loader.getLogger();
                log.addMessage(dataBindingMessage, Tracking.DATABINDING);
                log.printInfo(dataBindingMessage, Tracking.DATABINDING, this.loader.getTrackings());
            }
            if (control instanceof Composite) {
                ((Composite)control).layout();
            }
            return control;
        }
        catch (Exception e) {
            LoggerManager.log(e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object doCreate(Object parent, Element element, Class<?> constraintType, Map<String, Object> options) throws Exception {
        DocumentObject doc;
        DocumentObject[] documentObjectArray;
        int n;
        void var11_21;
        Widget widget;
        int styles = -1;
        if (options.containsKey("XWT.Style")) {
            styles = (Integer)options.get("XWT.Style");
        }
        ResourceDictionary dico = (ResourceDictionary)options.get("XWT.Resources");
        Object dataContext = options.get("XWT.DataContext");
        String name = element.getName();
        String namespace = element.getNamespace();
        if ("http://www.eclipse.org/xwt".equalsIgnoreCase(namespace)) {
            if ("Null".equalsIgnoreCase(name)) {
                return null;
            }
            if (!"Type".equalsIgnoreCase(name) || constraintType == null || constraintType != Class.class) return null;
            DocumentObject[] children = element.getChildren();
            if (children != null && children.length > 0) {
                Element element2;
                IMetaclass metaclass;
                if (!(children[0] instanceof Element) || (metaclass = this.loader.getMetaclass((element2 = (Element)children[0]).getName(), element2.getNamespace())) == null) return null;
                return metaclass.getType();
            }
            String string = element.getContent();
            return this.loader.convertFrom(Class.class, string);
        }
        IMetaclass metaclass = this.loader.getMetaclass(name, namespace);
        if (!(constraintType == null || IBinding.class.isAssignableFrom(metaclass.getType()) || constraintType.isAssignableFrom(metaclass.getType()) || constraintType.isArray() && constraintType.getComponentType().isAssignableFrom(metaclass.getType()))) {
            return null;
        }
        Object var11_14 = null;
        Integer styleValue = this.getStyleValue(element, styles);
        if (parent == null || metaclass.getType() == Shell.class) {
            if (this.dataBindingTrack != null) {
                this.dataBindingTrack.addWidgetElement(element);
            }
            Shell shell = null;
            if (styleValue == null || styleValue == -1) {
                styleValue = 1264;
            }
            Display display = Display.getDefault();
            Shell shell2 = shell = new Shell(display, styleValue.intValue());
            this.loadData.setCurrentWidget((Widget)shell);
            if (metaclass.getType() != Shell.class) {
                shell.setLayout((Layout)new FillLayout());
                return this.doCreate(shell2, element, constraintType, options);
            }
            if (dataContext != null) {
                this.setDataContext(metaclass, shell2, dico, dataContext);
            }
            this.pushStack();
            Attribute classAttribute = element.getAttribute("http://www.eclipse.org/xwt", "Class");
            if (classAttribute != null) {
                String className = classAttribute.getContent();
                this.loadShellCLR(className, shell);
            }
        } else {
            this.pushStack();
            Class<?> type = metaclass.getType();
            URL file = type.getResource(String.valueOf(type.getSimpleName()) + ".xwt");
            if (file != null && this.nameScoped != null) {
                if (!(parent instanceof Composite)) throw new XWTException("Cannot add user control: Parent is not a composite");
                Object childDataContext = this.getDataContext(element, (Widget)parent);
                if (dataContext != null) {
                    childDataContext = dataContext;
                }
                HashMap<String, Object> nestedOptions = new HashMap<String, Object>();
                nestedOptions.put("XWT.Container", parent);
                if (styleValue != null) {
                    nestedOptions.put("XWT.Style", styleValue);
                }
                nestedOptions.put("XWT.DataContext", childDataContext);
                nestedOptions.put(RESOURCE_LOADER_PROPERTY, this);
                Control control = this.loader.loadWithOptions(file, nestedOptions);
                if (control == null) {
                    return null;
                }
            } else {
                void var11_20;
                void var11_18;
                Object parameters = null;
                if (TableViewerColumn.class.isAssignableFrom(type)) {
                    Object[] objectArray;
                    int columnIndex = this.getColumnIndex(element);
                    if (styleValue != null) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = parent;
                        objectArray2[1] = styleValue;
                        objectArray = objectArray2;
                        objectArray2[2] = columnIndex;
                    } else {
                        Object[] objectArray3 = new Object[3];
                        objectArray3[0] = parent;
                        objectArray3[1] = 0;
                        objectArray = objectArray3;
                        objectArray3[2] = columnIndex;
                    }
                    parameters = objectArray;
                } else {
                    Object[] objectArray;
                    if (styleValue != null) {
                        Object[] objectArray4 = new Object[2];
                        objectArray4[0] = parent;
                        objectArray = objectArray4;
                        objectArray4[1] = styleValue;
                    } else {
                        Object[] objectArray5 = new Object[1];
                        objectArray = objectArray5;
                        objectArray5[0] = parent;
                    }
                    parameters = objectArray;
                }
                Attribute classAttribute = element.getAttribute("http://www.eclipse.org/xwt", "Class");
                if (classAttribute != null) {
                    String className = classAttribute.getContent();
                    Object object = this.loadCLR(className, (Object[])parameters, metaclass.getType(), options);
                } else {
                    Object clr = options.get("XWT.Class");
                    if (clr != null) {
                        this.loadData.setClr(clr);
                    }
                }
                if (var11_18 == null) {
                    Object clr;
                    Object object = metaclass.newInstance((Object[])parameters);
                    Widget widget2 = this.getWidget(object);
                    if (widget2 != null && (clr = this.loadData.getClr()) != null) {
                        UserDataHelper.setCLR(widget2, clr);
                    }
                } else {
                    metaclass = this.loader.getMetaclass(var11_18);
                }
                if (var11_20 == null) {
                    return null;
                }
            }
        }
        if ((widget = this.getWidget(var11_21)) != null) {
            this.loadData.setCurrentWidget(widget);
        }
        if (this.scopedObject == null && widget != null) {
            this.scopedObject = widget;
            this.nameScoped = new NameScope(parent == null ? null : this.loader.findNameContext((Widget)parent));
            UserDataHelper.bindNameContext(widget, this.nameScoped);
        }
        this.setDataContext(metaclass, var11_21, dico, dataContext);
        this.applyStyles(element, var11_21);
        if (this.dataBindingTrack != null) {
            this.dataBindingTrack.tracking(var11_21, element, dataContext);
        }
        if (var11_21 instanceof Widget) {
            if (parent != null) {
                ((Widget)var11_21).setData("__XWT.Parent", parent);
            }
        } else if (JFacesHelper.isViewer(var11_21)) {
            Control control = JFacesHelper.getControl(var11_21);
            control.setData("__XWT.Parent", parent);
            control.setData("__XWT.Viewer", (Object)var11_21);
        } else if (var11_21 instanceof TableItemProperty.Cell) {
            ((TableItemProperty.Cell)var11_21).setParent((TableItem)parent);
        }
        for (String key : options.keySet()) {
            if ("XWT.Container".equalsIgnoreCase(key) || "XWT.Style".equalsIgnoreCase(key) || "XWT.DataContext".equalsIgnoreCase(key) || "XWT.Resources".equalsIgnoreCase(key) || "XWT.Class".equalsIgnoreCase(key) || "XWT.DesignMode".equalsIgnoreCase(key)) continue;
            IProperty property = metaclass.findProperty(key);
            if (property == null) {
                throw new XWTException("Property " + key + " not found.");
            }
            property.setValue(var11_21, options.get(key));
        }
        ArrayList<String> delayedAttributes = new ArrayList<String>();
        this.init(metaclass, var11_21, element, delayedAttributes);
        if (var11_21 instanceof Style && element.getChildren().length > 0) {
            ArrayList<Setter> setters = new ArrayList<Setter>();
            DocumentObject[] documentObjectArray2 = element.getChildren();
            int n2 = documentObjectArray2.length;
            n = 0;
            while (n < n2) {
                DocumentObject doc2 = documentObjectArray2[n];
                Object child = this.doCreate(var11_21, (Element)doc2, null, Collections.EMPTY_MAP);
                if (!(child instanceof Setter)) {
                    throw new XWTException("Setter is expected in Style.");
                }
                setters.add((Setter)child);
                ++n;
            }
            ((Style)var11_21).setSetters(setters);
        } else if (var11_21 instanceof ControlEditor) {
            documentObjectArray = element.getChildren();
            n = documentObjectArray.length;
            int n3 = 0;
            while (n3 < n) {
                doc = documentObjectArray[n3];
                Object editor = this.doCreate(parent, (Element)doc, null, Collections.EMPTY_MAP);
                if (editor != null && editor instanceof Control) {
                    ((ControlEditor)var11_21).setEditor((Control)editor);
                    ((Control)editor).setData("TableEditor of a control", (Object)var11_21);
                }
                ++n3;
            }
        } else if (var11_21 instanceof IDataProvider) {
            documentObjectArray = element.getChildren();
            n = documentObjectArray.length;
            int n4 = 0;
            while (n4 < n) {
                String content;
                doc = documentObjectArray[n4];
                if ("http://www.eclipse.org/xwt".equals(doc.getNamespace()) && (content = doc.getContent()) != null) {
                    ((IDataProvider)var11_21).setProperty(doc.getName(), content);
                }
                ++n4;
            }
        } else {
            documentObjectArray = element.getChildren();
            n = documentObjectArray.length;
            int n5 = 0;
            while (n5 < n) {
                doc = documentObjectArray[n5];
                this.doCreate(var11_21, (Element)doc, null, Collections.EMPTY_MAP);
                ++n5;
            }
        }
        for (String delayed : delayedAttributes) {
            this.initAttribute(metaclass, var11_21, element, null, delayed);
        }
        this.popStack();
        return var11_21;
    }

    protected Widget getWidget(Object target) {
        if (JFacesHelper.isViewer(target)) {
            return JFacesHelper.getControl(target);
        }
        if (target instanceof Widget) {
            return (Widget)target;
        }
        return null;
    }

    private void setDataContext(IMetaclass metaclass, Object targetObject, ResourceDictionary dico, Object dataContext) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Control widget = null;
        IMetaclass widgetMetaclass = metaclass;
        if (JFacesHelper.isViewer(targetObject)) {
            widget = JFacesHelper.getControl(targetObject);
            widgetMetaclass = this.loader.getMetaclass(widget.getClass());
        } else {
            widget = targetObject instanceof Widget ? (Widget)targetObject : this.loadData.getCurrentWidget();
        }
        if (widget != null) {
            if (targetObject instanceof IDynamicBinding) {
                ((IDynamicBinding)targetObject).setControl((Widget)widget);
            }
            if (dico != null) {
                widget.setData("__XWT.Resources", (Object)dico);
            }
            if (dataContext != null) {
                IProperty property = widgetMetaclass.findProperty("DataContext");
                if (property != null) {
                    property.setValue(widget, dataContext);
                } else {
                    throw new XWTException("DataContext is missing in " + widgetMetaclass.getType().getName());
                }
            }
        }
    }

    private void applyStyles(Element element, Object targetObject) throws Exception {
        if (targetObject instanceof Widget) {
            Widget widget = (Widget)targetObject;
            ResourceDictionary dico = (ResourceDictionary)widget.getData("__XWT.Resources");
            Attribute attribute = element.getAttribute("Resources");
            if (attribute == null) {
                attribute = element.getAttribute("http://www.eclipse.org/xwt/presentation", "Resources");
            }
            if (attribute != null && attribute.getChildren().length > 0) {
                if (dico == null) {
                    dico = new ResourceDictionary();
                    widget.setData("__XWT.Resources", (Object)dico);
                }
                DocumentObject[] documentObjectArray = attribute.getChildren();
                int n = documentObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DocumentObject doc = documentObjectArray[n2];
                    Element elem = (Element)doc;
                    Object doCreate = this.doCreate(widget, elem, null, EMPTY_MAP);
                    Attribute keyAttribute = elem.getAttribute("http://www.eclipse.org/xwt", "Key");
                    if (keyAttribute == null) {
                        keyAttribute = elem.getAttribute("http://www.eclipse.org/xwt", "Type");
                    }
                    if (keyAttribute != null) {
                        dico.put(keyAttribute.getContent(), doCreate);
                    }
                    if (doCreate instanceof IStyle) {
                        IStyle style = (IStyle)doCreate;
                        this.loadData.addStyle(style);
                    }
                    ++n2;
                }
            }
            Widget current = widget;
            while (current != null) {
                dico = (ResourceDictionary)current.getData("__XWT.Resources");
                if (dico != null) {
                    for (Object value : dico.values()) {
                        Style style;
                        Class<?> targetType;
                        if (!(value instanceof Style) || (targetType = (style = (Style)value).getTargetType()) == null || !targetType.isInstance(widget)) continue;
                        style.apply(targetObject);
                    }
                }
                current = UserDataHelper.getParent(current);
            }
        }
        for (IStyle style : this.loadData.getStyles()) {
            style.applyStyle(targetObject);
        }
    }

    private int getColumnIndex(Element columnElement) {
        String name = columnElement.getName();
        String namespace = columnElement.getNamespace();
        IMetaclass metaclass = this.loader.getMetaclass(name, namespace);
        int index = -1;
        Class<?> type = metaclass.getType();
        if (TableViewerColumn.class.isAssignableFrom(type)) {
            DocumentObject parent = columnElement.getParent();
            List<DocumentObject> children = DocumentObjectSorter.sortWithAttr(parent.getChildren(), "Index");
            index = children.indexOf(columnElement);
        }
        return index;
    }

    private void installTableEditors(TableItem tableItem) {
        Table table = tableItem.getParent();
        TableColumn[] columns = table.getColumns();
        if (columns == null || columns.length == 0) {
            return;
        }
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            Object data = tableColumn.getData("Defined table editors");
            if (data != null && data instanceof Element) {
                int column = table.indexOf(tableColumn);
                Element editor = (Element)data;
                try {
                    TableEditor tableEditor = (TableEditor)this.doCreate(table, editor, null, EMPTY_MAP);
                    if (tableEditor != null) {
                        tableEditor.setColumn(column);
                        tableEditor.setItem(tableItem);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    private Object getDataContext(Element element, Widget swtObject) {
        try {
            Attribute dataContextAttribute = element.getAttribute("DataContext");
            if (dataContextAttribute != null) {
                Widget composite = swtObject;
                DocumentObject documentObject = dataContextAttribute.getChildren()[0];
                if ("StaticResource".equals(documentObject.getName()) || "DynamicResource".equals(documentObject.getName())) {
                    String key = documentObject.getContent();
                    return new StaticResourceBinding(composite, key);
                }
                if ("Binding".equals(documentObject.getName())) {
                    return this.doCreate(swtObject, (Element)documentObject, null, EMPTY_MAP);
                }
                LoggerManager.log(new UnsupportedOperationException(documentObject.getName()));
            }
        }
        catch (Exception e) {
            LoggerManager.log(e);
        }
        return null;
    }

    private void pushStack() {
        this.loadData = new LoadingData(this.loadData);
    }

    private void popStack() {
        LoadingData previous = this.loadData;
        this.loadData = previous.getParent();
        previous.end();
    }

    private Integer getStyleValue(Element element, int styles) {
        Attribute attribute = element.getAttribute("http://www.eclipse.org/xwt", "Style");
        if (attribute == null) {
            if (styles != -1) {
                return styles;
            }
            return null;
        }
        if (styles == -1) {
            return (Integer)this.loader.findConvertor(String.class, Integer.class).convert((Object)attribute.getContent());
        }
        return styles | (Integer)this.loader.findConvertor(String.class, Integer.class).convert((Object)attribute.getContent());
    }

    private void init(IMetaclass metaclass, Object targetObject, Element element, List<String> delayedAttributes) throws Exception {
        int n;
        String namespace;
        String attrName;
        Attribute dataContextAttribute;
        if (targetObject instanceof TableItem) {
            this.installTableEditors((TableItem)targetObject);
        }
        if ((dataContextAttribute = element.getAttribute("DataContext")) != null) {
            IProperty property = metaclass.findProperty("DataContext");
            Widget composite = (Widget)targetObject;
            DocumentObject documentObject = dataContextAttribute.getChildren()[0];
            if ("StaticResource".equals(documentObject.getName()) || "DynamicResource".equals(documentObject.getName())) {
                String key = documentObject.getContent();
                property.setValue(composite, new StaticResourceBinding(composite, key));
            } else if ("Binding".equals(documentObject.getName())) {
                Object object = this.doCreate(targetObject, (Element)documentObject, null, EMPTY_MAP);
                property.setValue(composite, object);
            } else {
                LoggerManager.log(new UnsupportedOperationException(documentObject.getName()));
            }
        }
        HashSet<String> done = new HashSet<String>();
        Attribute nameAttr = element.getAttribute("Name");
        if (nameAttr == null) {
            nameAttr = element.getAttribute("http://www.eclipse.org/xwt", "Name");
        }
        if (nameAttr != null && this.getWidget(targetObject) != null) {
            this.nameScoped.addObject(nameAttr.getContent(), targetObject);
            done.add("Name");
        }
        String[] stringArray = element.attributeNames();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            attrName = stringArray[n3];
            if (!"http://www.eclipse.org/xwt".equals(element.getAttribute(attrName).getNamespace())) {
                if (delayedAttributes != null && ResourceLoader.isDelayedProperty(attrName.toLowerCase(), metaclass.getType())) {
                    delayedAttributes.add(attrName);
                } else if (!done.contains(attrName)) {
                    this.initAttribute(metaclass, targetObject, element, null, attrName);
                    done.add(attrName);
                }
            }
            ++n3;
        }
        stringArray = element.attributeNamespaces();
        n2 = stringArray.length;
        n3 = 0;
        while (n3 < n2) {
            String attrName2;
            int n4;
            String[] stringArray2;
            namespace = stringArray[n3];
            if ("http://www.eclipse.org/xwt".equals(namespace)) {
                stringArray2 = element.attributeNames(namespace);
                n = stringArray2.length;
                n4 = 0;
                while (n4 < n) {
                    attrName2 = stringArray2[n4];
                    if (!"class".equalsIgnoreCase(attrName2) && !"Style".equalsIgnoreCase(attrName2)) {
                        if ("Name".equalsIgnoreCase(attrName2)) {
                            this.nameScoped.addObject(element.getAttribute(namespace, attrName2).getContent(), targetObject);
                            done.add(attrName2);
                        } else if (!"DataContext".equalsIgnoreCase(attrName2)) {
                            if ("Array".equalsIgnoreCase(attrName2)) {
                                IProperty property = metaclass.findProperty(attrName2);
                                Class<?> type = property.getType();
                                Object value = this.getArrayProperty(type, targetObject, element, attrName2);
                                if (value != null) {
                                    property.setValue(targetObject, value);
                                }
                            } else if (!"Resources".equalsIgnoreCase(attrName2) && !done.contains(attrName2)) {
                                this.initAttribute(metaclass, targetObject, element, namespace, attrName2);
                                done.add(attrName2);
                            }
                        }
                    }
                    ++n4;
                }
            } else {
                stringArray2 = element.attributeNames(namespace);
                n = stringArray2.length;
                n4 = 0;
                while (n4 < n) {
                    attrName2 = stringArray2[n4];
                    if (!("Name".equalsIgnoreCase(attrName2) && targetObject instanceof Widget || done.contains(attrName2))) {
                        this.initAttribute(metaclass, targetObject, element, namespace, attrName2);
                        done.add(attrName2);
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        stringArray = element.attributeNames();
        n2 = stringArray.length;
        n3 = 0;
        while (n3 < n2) {
            attrName = stringArray[n3];
            if (!("Name".equalsIgnoreCase(attrName) && this.getWidget(targetObject) != null || done.contains(attrName) || delayedAttributes.contains(attrName))) {
                this.initAttribute(metaclass, targetObject, element, null, attrName);
                done.add(attrName);
            }
            ++n3;
        }
        stringArray = element.attributeNamespaces();
        n2 = stringArray.length;
        n3 = 0;
        while (n3 < n2) {
            INamespaceHandler namespaceHandler;
            namespace = stringArray[n3];
            if (!XWT.isXWTNamespace(namespace) && (namespaceHandler = this.loader.getNamespaceHandler(namespace)) != null) {
                String[] stringArray3 = element.attributeNames(namespace);
                int n5 = stringArray3.length;
                n = 0;
                while (n < n5) {
                    String attrName3 = stringArray3[n];
                    Attribute attribute = element.getAttribute(namespace, attrName3);
                    namespaceHandler.handleAttribute(this.loadData.getCurrentWidget(), targetObject, attrName3, attribute.getContent());
                    ++n;
                }
            }
            ++n3;
        }
    }

    private Object getArrayProperty(Class<?> type, Object swtObject, DocumentObject element, String attrName) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        if (!type.isArray()) {
            throw new XWTException("Type mismatch: property " + attrName + " isn't an array.");
        }
        Class<?> arrayType = type.getComponentType();
        if (arrayType != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            DocumentObject[] documentObjectArray = element.getChildren();
            int n = documentObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                DocumentObject childModel = documentObjectArray[n2];
                if (childModel instanceof Element) {
                    Object child = this.createInstance(swtObject, (Element)childModel);
                    list.add(child);
                }
                ++n2;
            }
            Object[] array = (Object[])Array.newInstance(arrayType, list.size());
            list.toArray(array);
            int i = 0;
            while (i < array.length) {
                if (array[i] instanceof IIndexedElement) {
                    ((IIndexedElement)array[i]).setIndex(swtObject, i);
                }
                ++i;
            }
            return array;
        }
        return null;
    }

    private Object getCollectionProperty(Class<?> type, Object swtObject, DocumentObject element, String attrName) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Collection<Object> collector = null;
        if (type.isInterface()) {
            collector = new ArrayList();
        } else {
            if (Modifier.isAbstract(type.getModifiers())) {
                LoggerManager.log(new XWTException("Collection " + type.getSimpleName() + " is abstract type"));
            }
            try {
                collector = (Collection)type.newInstance();
            }
            catch (InstantiationException e) {
                LoggerManager.log(new XWTException(e));
            }
        }
        DocumentObject[] documentObjectArray = element.getChildren();
        int n = documentObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentObject childModel = documentObjectArray[n2];
            if (childModel instanceof Element) {
                Object child = this.createInstance(swtObject, (Element)childModel);
                collector.add(child);
                if (child instanceof IIndexedElement) {
                    ((IIndexedElement)child).setIndex(swtObject, collector.size() - 1);
                }
            }
            ++n2;
        }
        return collector;
    }

    private String findNamespace(DocumentObject context, String prefix) {
        String namespace;
        while (context != null && !(context instanceof Element)) {
            context = context.getParent();
        }
        if (context == null) {
            return null;
        }
        Element element = (Element)context;
        if (prefix != null) {
            String string = prefix = prefix.length() == 0 ? null : prefix;
        }
        if ((namespace = element.getXmlns(prefix)) != null) {
            return namespace;
        }
        DocumentObject parent = element.getParent();
        return this.findNamespace(parent, prefix);
    }

    private Object createInstance(Object swtObject, Element element) {
        String name = element.getName();
        String namespace = element.getNamespace();
        if ("http://www.eclipse.org/xwt".equalsIgnoreCase(namespace) && "Null".equalsIgnoreCase(name)) {
            return null;
        }
        try {
            Class<?> type = NamespaceHelper.loadCLRClass(this.context.getLoadingContext(), name, namespace);
            IMetaclass metaclass = this.loader.getMetaclass(name, namespace);
            if (type == null && metaclass != null) {
                type = metaclass.getType();
            }
            String content = element.getContent();
            Object instance = null;
            if (content == null) {
                instance = metaclass.newInstance(new Object[]{swtObject});
                if (instance instanceof TableEditor) {
                    TableEditor tableEditor = (TableEditor)instance;
                    if (swtObject instanceof TableItem) {
                        TableItem item = (TableItem)swtObject;
                        tableEditor.setItem(item);
                        DocumentObject[] documentObjectArray = element.getChildren();
                        int n = documentObjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DocumentObject doc = documentObjectArray[n2];
                            Control control = (Control)this.doCreate(((TableItem)swtObject).getParent(), (Element)doc, null, EMPTY_MAP);
                            tableEditor.setEditor(control);
                            int column = ResourceLoader.getColumnValue(element);
                            TableEditorHelper.initEditor(item, control, column);
                            ++n2;
                        }
                    }
                }
            } else {
                Constructor<?> constructor = type.getConstructor(type);
                if (constructor != null) {
                    instance = constructor.newInstance(this.loader.convertFrom(type, content));
                } else {
                    LoggerManager.log(new XWTException("Constructor \"" + name + "(" + type.getSimpleName() + ")\" is not found"));
                }
            }
            ArrayList<String> delayedAttributes = new ArrayList<String>();
            this.init(metaclass, instance, element, delayedAttributes);
            for (String delayed : delayedAttributes) {
                this.initAttribute(metaclass, instance, element, null, delayed);
            }
            return instance;
        }
        catch (Exception e) {
            LoggerManager.log(e);
            return null;
        }
    }

    protected static int getColumnValue(Element context) {
        String content;
        Attribute attribute = context.getAttribute(COLUMN);
        if (attribute != null && (content = attribute.getContent()) != null) {
            return Integer.parseInt(content);
        }
        return 0;
    }

    private void loadShellCLR(String className, Shell shell) {
        Class<?> type = ClassLoaderUtil.loadClass(this.context.getLoadingContext(), className);
        try {
            Object instance = type.newInstance();
            this.loadData.setClr(instance);
            UserDataHelper.setCLR((Widget)shell, instance);
        }
        catch (Exception e) {
            LoggerManager.log(e);
        }
    }

    private Object loadCLR(String className, Object[] parameters, Class<?> currentTagType, Map<String, Object> options) {
        Class<?> type = ClassLoaderUtil.loadClass(this.context.getLoadingContext(), className);
        if (type == null) {
            return null;
        }
        try {
            Object clr = options.get("XWT.Class");
            if (clr != null && type.isInstance(clr)) {
                this.loadData.setClr(clr);
                if (clr instanceof Widget) {
                    UserDataHelper.setCLR((Widget)clr, clr);
                }
            } else {
                if (currentTagType != null && currentTagType.isAssignableFrom(type)) {
                    IMetaclass metaclass = this.loader.getMetaclass(type);
                    Object instance = metaclass.newInstance(parameters);
                    this.loadData.setClr(instance);
                    if (instance instanceof Widget) {
                        UserDataHelper.setCLR((Widget)instance, instance);
                    }
                    return instance;
                }
                Object instance = type.newInstance();
                this.loadData.setClr(instance);
                if (instance instanceof Widget) {
                    UserDataHelper.setCLR((Widget)instance, instance);
                }
            }
        }
        catch (Exception e) {
            LoggerManager.log(e);
        }
        return null;
    }

    private void initAttribute(IMetaclass metaclass, Object targetObject, Element element, String namespace, String attrName) throws Exception {
        if (attrName.indexOf(46) != -1) {
            String[] segments = attrName.split("\\.");
            IMetaclass currentMetaclass = metaclass;
            Object target = targetObject;
            int i = 0;
            while (i < segments.length - 1) {
                IProperty property = currentMetaclass.findProperty(segments[i]);
                if (property != null) {
                    if ((target = property.getValue(target)) == null) {
                        LoggerManager.log(new XWTException("Property \"" + segments[i] + "\" is null."));
                    }
                    currentMetaclass = this.loader.getMetaclass(target);
                } else {
                    LoggerManager.log(new XWTException("Property \"" + segments[i] + "\" not found in " + element.getName() + "."));
                }
                ++i;
            }
            this.initSegmentAttribute(currentMetaclass, segments[segments.length - 1], target, element, namespace, attrName);
            return;
        }
        this.initSegmentAttribute(metaclass, attrName, targetObject, element, namespace, attrName);
    }

    private void addCommandExecuteListener(String commandName, final Widget targetButton) {
        final ICommand commandObj = this.loader.getCommand(commandName);
        if (commandObj != null) {
            targetButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    commandObj.execute(targetButton);
                }
            });
        }
    }

    private void initSegmentAttribute(IMetaclass metaclass, String propertyName, Object target, Element element, String namespace, String attrName) throws Exception {
        Attribute attribute;
        Attribute attribute2 = attribute = namespace == null ? element.getAttribute(attrName) : element.getAttribute(namespace, attrName);
        if (attribute == null) {
            attribute = element.getAttribute(attrName);
        }
        IProperty property = metaclass.findProperty(propertyName);
        if (propertyName.equals("DataContext")) {
            property = null;
        }
        if ("Command".equalsIgnoreCase(propertyName) && ICommand.class.isAssignableFrom(property.getType()) && target instanceof Widget) {
            this.addCommandExecuteListener(attribute.getContent(), (Widget)target);
        }
        if (property == null) {
            IEvent event = metaclass.findEvent(attrName);
            if (event == null) {
                return;
            }
            if (!(target instanceof Widget)) {
                return;
            }
            this.loadData.updateEvent(this.context, (Widget)target, event, attribute, propertyName);
            return;
        }
        try {
            Attribute attributeAccelerator;
            String contentValue = attribute.getContent();
            if ("MenuItem".equalsIgnoreCase(element.getName()) && "Text".equalsIgnoreCase(attrName) && (attributeAccelerator = element.getAttribute("Accelerator")) != null) {
                contentValue = String.valueOf(contentValue) + '\t' + this.getContentValue(attributeAccelerator.getContent());
            }
            if (contentValue != null && "Accelerator".equalsIgnoreCase(attrName) && (contentValue = XWTMaps.getCombAccelerator(contentValue)).contains("'")) {
                contentValue = this.removeSubString(contentValue, "'");
            }
            if (contentValue != null && Image.class.isAssignableFrom(property.getType())) {
                contentValue = this.getImagePath(attribute, contentValue);
            }
            if (contentValue != null && URL.class.isAssignableFrom(property.getType())) {
                contentValue = this.getSourceURL(contentValue);
            }
            Object value = null;
            DocumentObject[] children = attribute.getChildren();
            if (contentValue == null) {
                Class<?> type = property.getType();
                if (Collection.class.isAssignableFrom(type)) {
                    value = this.getCollectionProperty(type, target, attribute, attrName);
                } else {
                    if (TableViewerColumn.class.isAssignableFrom(type) && attrName.equalsIgnoreCase("columns")) {
                        children = DocumentObjectSorter.sortWithAttr(children, "Index").toArray(new DocumentObject[children.length]);
                    }
                    DocumentObject[] documentObjectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DocumentObject child = documentObjectArray[n2];
                        String name = child.getName();
                        String ns = child.getNamespace();
                        if (name.equalsIgnoreCase("Static") && ns.equals("http://www.eclipse.org/xwt")) {
                            value = this.getStaticValue(child);
                        } else if (name.equalsIgnoreCase("StaticResource") && ns.equals("http://www.eclipse.org/xwt/presentation")) {
                            String key = child.getContent();
                            value = new StaticResourceBinding(this.loadData.getCurrentWidget(), key);
                        } else if ("http://www.eclipse.org/xwt".equals(ns) && "Array".equalsIgnoreCase(name)) {
                            value = this.getArrayProperty(property.getType(), target, child, name);
                        } else {
                            if (property.getType().isArray()) {
                                value = this.getArrayProperty(property.getType(), target, attribute, name);
                                break;
                            }
                            if (this.isAssignableFrom(element, TableColumn.class) && this.isAssignableFrom(child, TableEditor.class)) {
                                value = child;
                            } else if (TableViewerColumn.class.isAssignableFrom(property.getType()) && attribute.getContent() != null) {
                                value = attribute.getContent();
                            } else {
                                value = this.doCreate(target, (Element)child, type, EMPTY_MAP);
                                if (value instanceof IDynamicBinding) {
                                    ((IDynamicBinding)value).setType(attrName);
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
            if (contentValue != null && value == null && !"Command".equalsIgnoreCase(propertyName)) {
                int index;
                if (property.getType().isInstance(Class.class) && (index = contentValue.lastIndexOf(58)) != -1) {
                    String prefix = contentValue.substring(0, index);
                    contentValue = String.valueOf(this.findNamespace(attribute, prefix)) + contentValue.substring(index);
                }
                value = this.loader.convertFrom(property.getType(), contentValue);
            }
            if (value != null) {
                Class<?> propertyType = property.getType();
                if (!propertyType.isAssignableFrom(value.getClass()) || value instanceof IBinding) {
                    Object orginalValue = value;
                    IConverter converter = this.loader.findConvertor(value.getClass(), propertyType);
                    if (converter != null) {
                        if ((value = converter.convert(value)) != null && orginalValue instanceof IBinding && !propertyType.isAssignableFrom(value.getClass())) {
                            converter = this.loader.findConvertor(value.getClass(), propertyType);
                            if (converter != null) {
                                value = converter.convert(value);
                            } else {
                                LoggerManager.log(new XWTException("Convertor " + value.getClass().getSimpleName() + "->" + propertyType.getSimpleName() + " is not found"));
                            }
                        }
                    } else {
                        LoggerManager.log(new XWTException("Convertor " + value.getClass().getSimpleName() + "->" + propertyType.getSimpleName() + " is not found"));
                    }
                }
                property.setValue(target, value);
            } else {
                if (value == null) {
                    value = property.getValue(target);
                }
                if (value != null) {
                    DocumentObject[] documentObjectArray = children;
                    int converter = children.length;
                    int orginalValue = 0;
                    while (orginalValue < converter) {
                        Class<?> type;
                        DocumentObject child = documentObjectArray[orginalValue];
                        String name = child.getName();
                        String ns = child.getNamespace();
                        if (!("http://www.eclipse.org/xwt".equals(ns) && "Array".equalsIgnoreCase(name) || Collection.class.isAssignableFrom(type = property.getType()))) {
                            this.doCreate(value, (Element)child, null, EMPTY_MAP);
                        }
                        ++orginalValue;
                    }
                }
            }
            if (attribute.attributeNames("http://www.eclipse.org/xwt/presentation").length > 0) {
                IMetaclass propertyMetaclass = this.loader.getMetaclass(property.getType());
                if (value == null) {
                    value = property.getValue(target);
                }
                if (value != null) {
                    ArrayList<String> delayedAttributes = new ArrayList<String>();
                    this.init(propertyMetaclass, value, attribute, delayedAttributes);
                    for (String delayed : delayedAttributes) {
                        this.initAttribute(metaclass, target, element, null, delayed);
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerManager.log(e);
        }
    }

    private String getSourceURL(String contentValue) {
        URL url = null;
        try {
            url = new URL(contentValue);
        }
        catch (MalformedURLException malformedURLException) {
            ILoadingContext loadingContext;
            URL resource;
            if (!contentValue.startsWith("/")) {
                contentValue = "/" + contentValue;
            }
            if ((resource = (loadingContext = this.context.getLoadingContext()).getClassLoader().getResource(contentValue)) == null) {
                try {
                    resource = new URL(this.context.getResourcePath() + contentValue);
                }
                catch (MalformedURLException malformedURLException2) {}
            }
            return resource.toString();
        }
        if (url != null) {
            return url.toString();
        }
        return contentValue;
    }

    private Class<?> getJavaType(DocumentObject element) {
        String name = element.getName();
        String namespace = element.getNamespace();
        if ("http://www.eclipse.org/xwt".equalsIgnoreCase(namespace) && "Null".equalsIgnoreCase(name)) {
            return null;
        }
        IMetaclass metaclass = this.loader.getMetaclass(name, namespace);
        if (metaclass == null) {
            return null;
        }
        return metaclass.getType();
    }

    private boolean isAssignableFrom(DocumentObject element, Class<?> type) {
        Class<?> targetType = this.getJavaType(element);
        if (targetType == null) {
            return false;
        }
        return targetType.isAssignableFrom(type);
    }

    private Object getStaticValue(DocumentObject child) {
        Element element;
        DocumentObject[] children = child.getChildren();
        if (children.length == 1 && (element = (Element)children[0]) != null) {
            return ClassLoaderUtil.loadStaticMember(this.context.getLoadingContext(), element);
        }
        return null;
    }

    private String getImagePath(Attribute attribute, String contentValue) {
        String value = contentValue;
        try {
            ILoadingContext loadingContext;
            URL resource;
            File file = new File(contentValue);
            if (file.exists()) {
                return file.toURI().toURL().toString();
            }
            if (!contentValue.startsWith("/")) {
                URL url = this.context.getResourcePath();
                if (url != null) {
                    return String.valueOf(url.toString()) + "/" + contentValue;
                }
                contentValue = "/" + contentValue;
            }
            if ((resource = (loadingContext = this.context.getLoadingContext()).getClassLoader().getResource(contentValue)) == null) {
                URL resourcePath = this.context.getResourcePath();
                String fPath = resourcePath.toString();
                String absolutePath = PathHelper.getAbsolutePath(fPath, contentValue);
                file = new File(absolutePath);
                if (file.exists()) {
                    return file.toURI().toURL().toString();
                }
                resource = new URL(absolutePath);
            }
            return resource.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return value;
        }
    }

    private String removeSubString(String str, String subString) {
        int i;
        StringBuffer stringBuffer = new StringBuffer();
        int lenOfsource = str.length();
        int posStart = 0;
        while ((i = str.indexOf(subString, posStart)) >= 0) {
            stringBuffer.append(str.substring(posStart, i));
            posStart = i + subString.length();
        }
        if (posStart < lenOfsource) {
            stringBuffer.append(str.substring(posStart));
        }
        return stringBuffer.toString();
    }

    private String getContentValue(String text) {
        StringBuffer stringBuffer = new StringBuffer();
        String subString = "SWT.";
        String str = XWTMaps.getCombAccelerator(text);
        if (str.contains(subString)) {
            str = this.removeSubString(str, subString);
        }
        if (str.contains("'")) {
            str = this.removeSubString(str, "'");
        }
        if (str.contains(" ")) {
            str = this.removeSubString(str, " ");
        }
        if (str.contains("|")) {
            str = str.replace('|', '+');
        }
        stringBuffer.append(str);
        return stringBuffer.toString();
    }

    protected static boolean isDelayedProperty(String attr, Class<?> type) {
        Collection<Class<?>> types = DELAYED_ATTRIBUTES.get(attr);
        if (types == null) {
            return false;
        }
        if (types.contains(type)) {
            return true;
        }
        for (Class<?> class1 : types) {
            if (!class1.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoadingData {
        protected LoadingData parent;
        protected Object clr;
        protected Collection<IStyle> styles = Collections.EMPTY_LIST;
        private Object loadedObject = null;
        private Method loadedMethod = null;
        private Widget hostWidget = null;
        private Widget currentWidget = null;

        public Widget getCurrentWidget() {
            return this.currentWidget;
        }

        public void setCurrentWidget(Widget currentWidget) {
            this.currentWidget = currentWidget;
        }

        public LoadingData getParent() {
            return this.parent;
        }

        public LoadingData() {
        }

        public LoadingData(LoadingData loadingData) {
            this.loadedObject = loadingData.loadedObject;
            this.loadedMethod = null;
            this.hostWidget = loadingData.hostWidget;
            this.parent = loadingData;
            this.styles = loadingData.styles;
            this.clr = loadingData.clr;
            this.currentWidget = loadingData.currentWidget;
        }

        public Collection<IStyle> getStyles() {
            return this.styles;
        }

        public void setStyles(Collection<IStyle> styles) {
            this.styles = styles;
        }

        public Object getClr() {
            return this.clr;
        }

        public void setClr(Object clr) {
            this.clr = clr;
        }

        public void updateEvent(IRenderingContext context, Widget control, IEvent event, Attribute attribute, String propertyName) {
            Controller eventController = (Controller)control.getData("__XWT.Controller");
            if (eventController == null) {
                eventController = new Controller();
                control.setData("__XWT.Controller", (Object)eventController);
            }
            Method method = null;
            Object clrObject = null;
            String methodName = attribute.getContent();
            LoadingData current = this;
            ResourceLoader currentParentLoader = ResourceLoader.this.parentLoader;
            while (current != null) {
                Object receiver = current.getClr();
                if (receiver != null) {
                    Class<?> clazz = receiver.getClass();
                    method = ObjectUtil.findMethod(clazz, methodName, Event.class);
                    if (method == null) {
                        clazz = ClassLoaderUtil.loadClass(context.getLoadingContext(), clazz.getName());
                        method = ObjectUtil.findMethod(clazz, methodName, Event.class);
                    }
                    if (method != null) {
                        clrObject = receiver;
                        if (propertyName.equalsIgnoreCase("Loaded")) {
                            method.setAccessible(true);
                            this.loadedObject = receiver;
                            this.loadedMethod = method;
                            this.hostWidget = control;
                        }
                        eventController.setEvent(event, control, clrObject, method);
                        break;
                    }
                }
                if ((current = current.getParent()) != null || currentParentLoader == null) continue;
                current = currentParentLoader.loadData;
                currentParentLoader = currentParentLoader.parentLoader;
            }
            if (method == null) {
                LoggerManager.log(new XWTException("Event handler \"" + methodName + "\" is not found."));
            }
        }

        public void end() {
            if (this.parent == null || this.clr != this.parent.getClr()) {
                Method method = ObjectUtil.findDeclaredMethod(this.clr.getClass(), "initializeComponent", new Class[0]);
                if (method == null) {
                    method = ObjectUtil.findDeclaredMethod(this.clr.getClass(), "InitializeComponent", new Class[0]);
                }
                if (method != null) {
                    try {
                        method.setAccessible(true);
                        method.invoke(this.clr, new Object[0]);
                    }
                    catch (Exception e) {
                        LoggerManager.log(e);
                    }
                }
            }
            if (this.loadedObject != null && this.loadedMethod != null && this.hostWidget != null) {
                Event event = new Event();
                event.doit = true;
                event.widget = this.hostWidget;
                try {
                    this.loadedMethod.invoke(this.loadedObject, event);
                }
                catch (Exception exception) {
                    throw new XWTException("");
                }
                this.loadedObject = null;
                this.loadedMethod = null;
                this.hostWidget = null;
            }
        }

        public void addStyle(IStyle style) {
            if (this.styles == Collections.EMPTY_LIST) {
                this.styles = new ArrayList<IStyle>();
            }
            this.styles.add(style);
        }
    }
}

