/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.internal.utils.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataContextChangeListener
implements PropertyChangeListener {
    IObservableValue observeWidget;
    private List<Object> dataContexts;
    private IObservableValue observableValue;
    private String path;

    public DataContextChangeListener(IObservableValue observeWidget, String path, List<Object> dataContexts, IObservableValue observableValue) {
        this.observeWidget = observeWidget;
        this.path = path;
        this.dataContexts = dataContexts;
        this.observableValue = observableValue;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Method readMethod;
        if (this.observableValue == null || this.dataContexts == null || this.dataContexts.isEmpty()) {
            return;
        }
        Object source = evt.getSource();
        Object evtOldvalue = evt.getOldValue();
        Object evtNewValue = evt.getNewValue();
        if (!this.dataContexts.contains(source)) {
            return;
        }
        if (evtOldvalue == this.observableValue.getValue()) {
            return;
        }
        Object observed = null;
        PropertyDescriptor pd = null;
        if (this.observableValue instanceof IBeanObservable) {
            IBeanObservable javaObservor = (IBeanObservable)this.observableValue;
            observed = javaObservor.getObserved();
            pd = javaObservor.getPropertyDescriptor();
        }
        if (observed != null && pd != null && evtOldvalue != evtNewValue && (readMethod = pd.getReadMethod()) != null) {
            if (observed.getClass() == evtNewValue.getClass()) {
                this.BindingDataContent(observed, evtNewValue, pd);
            } else if (observed.getClass() == source.getClass()) {
                this.BindingDataContent(observed, source, pd);
            } else {
                Object bindingResouse = this.getObservedObj(evtNewValue);
                if (bindingResouse != null) {
                    this.BindingDataContent(observed, bindingResouse, pd);
                }
            }
        }
    }

    private void BindingDataContent(Object observed, Object bindingResouse, PropertyDescriptor pd) {
        this.dataContexts.remove(observed);
        this.dataContexts.add(bindingResouse);
        IObservableValue newBinding = BeansObservables.observeValue((Object)bindingResouse, (String)pd.getName());
        if (this.observeWidget != null) {
            DataBindingContext bindingContext = new DataBindingContext();
            bindingContext.bindValue(this.observeWidget, newBinding, null, null);
        }
    }

    private Object getObservedObj(Object evtNewValue) {
        String[] paths = this.path.split("\\.");
        Object object = evtNewValue;
        int i = 1;
        while (paths.length - 1 > i) {
            String path1 = paths[i];
            try {
                Method getMethod1 = ObjectUtil.findGetter(object.getClass(), path1, null);
                if (getMethod1 != null) {
                    object = getMethod1.invoke(object, new Object[0]);
                    break;
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        if (object == evtNewValue) {
            return null;
        }
        return object;
    }
}

