/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean.metadata.properties;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.javabean.metadata.properties.AbstractProperty;

public class FieldProperty
extends AbstractProperty {
    private Field field;

    public FieldProperty(Field field) {
        super(field.getName(), field.getType());
        if (field == null) {
            throw new NullPointerException();
        }
        this.field = field;
    }

    public Object getValue(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        return this.field.get(target);
    }

    public void setValue(Object target, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        if (value != null) {
            Class<?> fieldType = this.field.getType();
            Class<?> valueType = value.getClass();
            if (!fieldType.isAssignableFrom(value.getClass())) {
                IConverter converter = XWT.findConvertor(valueType, fieldType);
                if (converter != null) {
                    value = converter.convert(value);
                } else {
                    throw new XWTException("Converter " + valueType.getName() + "->" + fieldType.getName());
                }
            }
        }
        this.field.set(target, value);
        this.fireSetPostAction(target, this, value);
    }

    public boolean isDefault() {
        return true;
    }
}

