/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.jface;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.jface.TextCellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFacesHelper {
    private static Class<?>[] JFACES_SUPPORTED_ELEMENTS;
    private static Class<?> JFACES_VIEWER;

    static {
        ArrayList collector = new ArrayList();
        try {
            JFACES_VIEWER = Class.forName("org.eclipse.jface.viewers.Viewer");
            collector.add(Class.forName("org.eclipse.jface.viewers.ListViewer"));
            collector.add(Class.forName("org.eclipse.jface.viewers.TreeViewer"));
            collector.add(Class.forName("org.eclipse.jface.viewers.TableViewer"));
            collector.add(Class.forName("org.eclipse.jface.viewers.TableTreeViewer"));
            collector.add(Class.forName("org.eclipse.jface.viewers.CheckboxTableViewer"));
            collector.add(Class.forName("org.eclipse.jface.viewers.CheckboxTreeViewer"));
            collector.add(Class.forName("org.eclipse.jface.dialogs.TitleAreaDialog"));
            collector.add(Class.forName("org.eclipse.jface.viewers.CellEditor"));
            collector.add(Class.forName("org.eclipse.jface.viewers.ComboBoxViewerCellEditor"));
            collector.add(Class.forName("org.eclipse.jface.viewers.DialogCellEditor"));
            collector.add(Class.forName("org.eclipse.jface.viewers.ColorCellEditor"));
            collector.add(TextCellEditor.class);
            collector.add(CheckboxCellEditor.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("No JFaces support");
        }
        JFACES_SUPPORTED_ELEMENTS = collector.toArray(new Class[collector.size()]);
    }

    public static Class<?>[] getSupportedElements() {
        return JFACES_SUPPORTED_ELEMENTS;
    }

    public static boolean isViewer(Object obj) {
        if (JFACES_VIEWER == null) {
            return false;
        }
        return JFACES_VIEWER.isAssignableFrom(obj.getClass());
    }

    public static Control getControl(Object obj) {
        if (!JFacesHelper.isViewer(obj)) {
            throw new XWTException("Expecting a JFaces viewer:" + obj);
        }
        try {
            Method method = JFACES_VIEWER.getMethod("getControl", new Class[0]);
            return (Control)method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

