/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.swt.graphics.Color;

public class ColorsShop {
    private static ResourceBundle COLORS = ResourceBundle.getBundle("org.eclipse.e4.xwt.utils.colors");
    private static String[] colorNames;

    public static String[] getColorNames() {
        if (colorNames == null) {
            ArrayList<String> colors = new ArrayList<String>();
            Enumeration<String> keys = COLORS.getKeys();
            while (keys.hasMoreElements()) {
                String color = keys.nextElement();
                colors.add(color);
            }
            if (!colors.isEmpty()) {
                colorNames = colors.toArray(new String[0]);
                Arrays.sort(colorNames);
            }
        }
        return colorNames;
    }

    public static String getColorValue(String name) {
        if (!ColorsShop.hasColor(name)) {
            return null;
        }
        String value = COLORS.getString(name);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public static boolean hasColor(String name) {
        if (name == null) {
            return false;
        }
        String[] colorNames = ColorsShop.getColorNames();
        if (colorNames == null) {
            return false;
        }
        return Arrays.asList(colorNames).contains(name);
    }

    public static Color getColor(String name) {
        IConverter c;
        if (!ColorsShop.hasColor(name)) {
            return null;
        }
        String colorValue = ColorsShop.getColorValue(name);
        if (colorValue != null && (c = XWT.findConvertor(String.class, Color.class)) != null) {
            return (Color)c.convert((Object)colorValue);
        }
        return null;
    }

    private ColorsShop() {
    }
}

