/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Scenario;
import org.eclipse.test.internal.performance.db.SummaryEntry;
import org.eclipse.test.internal.performance.db.Variations;

public class DBHelpers {
    private Connection fConnection = DB.getConnection();

    public static void main(String[] args) throws SQLException {
        DBHelpers db = new DBHelpers();
        String outFile = null;
        PrintStream ps = null;
        if (outFile != null) {
            try {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("can't create output file");
            }
        }
        if (ps == null) {
            ps = System.out;
        }
        long start = System.currentTimeMillis();
        db.dumpSizes(ps);
        System.out.println("time: " + (double)(System.currentTimeMillis() - start) / 1000.0);
        if (ps != System.out) {
            ps.close();
        }
    }

    void renameVariation(String oldName, String newName) throws SQLException {
        PreparedStatement update = this.fConnection.prepareStatement("update VARIATION set KEYVALPAIRS = ? where KEYVALPAIRS = ? ");
        update.setString(1, newName);
        update.setString(2, oldName);
        update.executeUpdate();
        update.close();
    }

    void dumpSummaries(Variations variations, String scenarioPattern) {
        SummaryEntry[] summries = DB.querySummaries(variations, scenarioPattern);
        int i = 0;
        while (i < summries.length) {
            System.out.println(summries[i]);
            ++i;
        }
    }

    void count(PrintStream ps) throws SQLException {
        PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from SCALAR where DATAPOINT_ID not in (select DATAPOINT.ID from DATAPOINT)");
        ResultSet set = stmt.executeQuery();
        if (set.next()) {
            ps.println("count: " + set.getInt(1));
        }
        set.close();
        stmt.close();
    }

    void countDimension(PrintStream ps, Dim dim) throws SQLException {
        PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from SCALAR where DIM_ID = ?");
        stmt.setInt(1, dim.getId());
        ResultSet set = stmt.executeQuery();
        if (set.next()) {
            ps.println("dimension " + dim + ": " + set.getInt(1));
        }
    }

    void countAllDimensions(PrintStream ps) throws SQLException {
        PreparedStatement stmt = this.fConnection.prepareStatement("select distinct DIM_ID from SCALAR");
        ResultSet set = stmt.executeQuery();
        while (set.next()) {
            Dim dimension = Dim.getDimension(set.getInt(1));
            if (dimension == null) continue;
            this.countDimension(ps, dimension);
        }
    }

    int countSamples(PrintStream ps, Variations v) throws SQLException {
        PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from SAMPLE, VARIATION where VARIATION.KEYVALPAIRS = ? and SAMPLE.VARIATION_ID = VARIATION.ID");
        stmt.setString(1, v.toExactMatchString());
        ResultSet set = stmt.executeQuery();
        int n = 0;
        if (set.next()) {
            n = set.getInt(1);
        }
        ps.println("samples with variation " + v + ": " + n);
        return n;
    }

    void countDatapoints(PrintStream ps, Variations v) throws SQLException {
        PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from DATAPOINT, SAMPLE, VARIATION where VARIATION.KEYVALPAIRS = ? and SAMPLE.VARIATION_ID = VARIATION.ID and DATAPOINT.SAMPLE_ID= SAMPLE.ID");
        stmt.setString(1, v.toExactMatchString());
        ResultSet set = stmt.executeQuery();
        if (set.next()) {
            ps.println("datapoints with variation " + v + ": " + set.getInt(1));
        }
    }

    void countScalars(PrintStream ps, Variations v) throws SQLException {
        PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from SCALAR, DATAPOINT, SAMPLE, VARIATION where VARIATION.KEYVALPAIRS = ? and SAMPLE.VARIATION_ID = VARIATION.ID and DATAPOINT.SAMPLE_ID= SAMPLE.ID and DATAPOINT.ID = SCALAR.DATAPOINT_ID");
        stmt.setString(1, v.toExactMatchString());
        ResultSet set = stmt.executeQuery();
        if (set.next()) {
            ps.println("scalars with variation " + v + ": " + set.getInt(1));
        }
    }

    void removeSamples(Variations v) throws SQLException {
        boolean delete = true;
        int n = this.countSamples(System.out, v);
        int variation_id = 0;
        PreparedStatement stmt = this.fConnection.prepareStatement("select ID from VARIATION where KEYVALPAIRS = ?");
        stmt.setString(1, v.toExactMatchString());
        ResultSet set = stmt.executeQuery();
        if (set.next()) {
            variation_id = set.getInt(1);
            System.err.println("variation_id: " + variation_id);
        }
        if (variation_id <= 0) {
            System.err.println("nothing found for variation " + v);
            return;
        }
        PreparedStatement iterSamples = this.fConnection.prepareStatement("select SAMPLE.ID, SAMPLE.SCENARIO_ID from SAMPLE where SAMPLE.VARIATION_ID = ?");
        PreparedStatement iterDatapoints = this.fConnection.prepareStatement("select DATAPOINT.ID from DATAPOINT where DATAPOINT.SAMPLE_ID = ?");
        PreparedStatement deleteScalars = this.fConnection.prepareStatement("delete from SCALAR where DATAPOINT_ID = ?");
        PreparedStatement deleteDatapoints = this.fConnection.prepareStatement("delete from DATAPOINT where SAMPLE_ID = ?");
        PreparedStatement deleteSamples = this.fConnection.prepareStatement("delete from SAMPLE where SAMPLE.ID = ?");
        PreparedStatement deleteScenario = this.fConnection.prepareStatement("delete from SCENARIO where SCENARIO.ID = ?");
        ResultSet samples = null;
        ResultSet datapoints = null;
        ResultSet configs = null;
        iterSamples.setInt(1, variation_id);
        samples = iterSamples.executeQuery();
        while (samples.next()) {
            int sample_id = samples.getInt(1);
            int scenario_id = samples.getInt(2);
            System.out.print(String.valueOf(n) + ": sample(" + sample_id + "):");
            iterDatapoints.setInt(1, sample_id);
            datapoints = iterDatapoints.executeQuery();
            int dps = 0;
            while (datapoints.next()) {
                int dp_id = datapoints.getInt(1);
                if (!delete) continue;
                deleteScalars.setInt(1, dp_id);
                try {
                    deleteScalars.executeUpdate();
                    this.fConnection.commit();
                    ++dps;
                }
                catch (SQLException e) {
                    System.err.println("removing scalars: " + e);
                }
            }
            System.out.println(" dps: " + dps);
            if (delete) {
                deleteDatapoints.setInt(1, sample_id);
                try {
                    deleteDatapoints.executeUpdate();
                    this.fConnection.commit();
                }
                catch (SQLException e1) {
                    System.err.println("removing datapoints: " + e1);
                }
                deleteSamples.setInt(1, sample_id);
                try {
                    deleteSamples.executeUpdate();
                    this.fConnection.commit();
                }
                catch (SQLException e) {
                    System.err.println("removing sample: " + e);
                }
                deleteScenario.setInt(1, scenario_id);
                try {
                    deleteScenario.executeUpdate();
                    this.fConnection.commit();
                }
                catch (SQLException sQLException) {}
            }
            --n;
        }
        if (delete) {
            PreparedStatement deleteSummaries = this.fConnection.prepareStatement("delete from SUMMARYENTRY where VARIATION_ID = ?");
            deleteSummaries.setInt(1, variation_id);
            deleteSummaries.executeUpdate();
            deleteSummaries.close();
            PreparedStatement deleteVariation = this.fConnection.prepareStatement("delete from VARIATION where ID = ?");
            deleteVariation.setInt(1, variation_id);
            try {
                deleteVariation.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("removing variation: " + e);
            }
            deleteVariation.close();
        }
        if (configs != null) {
            configs.close();
        }
        if (samples != null) {
            samples.close();
        }
        if (datapoints != null) {
            datapoints.close();
        }
        if (iterSamples != null) {
            iterSamples.close();
        }
        if (iterDatapoints != null) {
            iterDatapoints.close();
        }
        if (deleteSamples != null) {
            deleteSamples.close();
        }
        if (deleteScenario != null) {
            deleteScenario.close();
        }
        if (deleteScalars != null) {
            deleteScalars.close();
        }
        if (deleteDatapoints != null) {
            deleteDatapoints.close();
        }
    }

    void countSamplesWithNullVariations() throws SQLException {
        Statement stmt = this.fConnection.createStatement();
        ResultSet rs = stmt.executeQuery("select count(*) from SAMPLE where SAMPLE.VARIATION_ID is null");
        while (rs.next()) {
            int config_id = rs.getInt(1);
            System.out.println("samples with NULL variation: " + config_id);
        }
        rs.close();
        stmt.close();
    }

    void removeDimension(Dim dim) throws SQLException {
        PreparedStatement q = this.fConnection.prepareStatement("delete from SCALAR where SCALAR.DIM_ID = ?");
        q.setInt(1, dim.getId());
        q.executeUpdate();
        q.close();
    }

    void dumpScenarios(PrintStream ps, String pattern) throws SQLException {
        PreparedStatement stmt = this.fConnection.prepareStatement("select NAME from SCENARIO where NAME like ? order by NAME");
        stmt.setString(1, pattern);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            ps.println(rs.getString(1));
        }
        rs.close();
        stmt.close();
    }

    void dumpSizes(PrintStream ps) throws SQLException {
        if (this.fConnection == null) {
            return;
        }
        Statement stmt = this.fConnection.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT sys.systables.tablename FROM sys.systables WHERE sys.systables.tablename NOT LIKE 'SYS%' ");
            while (rs.next()) {
                this.dumpSize(ps, rs.getString(1));
            }
            rs.close();
        }
        finally {
            stmt.close();
        }
    }

    void dumpSize(PrintStream ps, String table) throws SQLException {
        Statement stmt = this.fConnection.createStatement();
        ResultSet rs = stmt.executeQuery("select Count(*) from " + table);
        if (rs.next()) {
            ps.println(String.valueOf(table) + ": " + rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void dumpAll(PrintStream ps, int maxRow) throws SQLException {
        if (this.fConnection == null) {
            return;
        }
        if (maxRow < 0) {
            maxRow = 1000000;
        }
        Statement stmt = this.fConnection.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("select SYS.SYSTABLES.TABLENAME from SYS.SYSTABLES where SYS.SYSTABLES.TABLENAME not like 'SYS%' ");
            while (rs.next()) {
                this.dumpTable(ps, rs.getString(1), maxRow);
                ps.println();
            }
            rs.close();
        }
        finally {
            stmt.close();
        }
    }

    void dumpTable(PrintStream ps, String tableName, int maxRow) throws SQLException {
        ps.print(String.valueOf(tableName) + '(');
        Statement select = this.fConnection.createStatement();
        ResultSet result = select.executeQuery("select * from " + tableName);
        ResultSetMetaData metaData = result.getMetaData();
        int n = metaData.getColumnCount();
        int i = 0;
        while (i < n) {
            ps.print(metaData.getColumnLabel(i + 1));
            if (i < n - 1) {
                ps.print(", ");
            }
            ++i;
        }
        ps.println("):");
        int r = 0;
        while (result.next() && r < maxRow) {
            int i2 = 0;
            while (i2 < n) {
                ps.print(String.valueOf(' ') + result.getString(i2 + 1));
                ++i2;
            }
            ps.println();
            ++r;
        }
        select.close();
    }

    void view(PrintStream ps, Variations v, String scenarioPattern) throws SQLException {
        Scenario[] scenarios = DB.queryScenarios(v, scenarioPattern, "build", null);
        ps.println(String.valueOf(scenarios.length) + " Scenarios");
        ps.println();
        int s = 0;
        while (s < scenarios.length) {
            scenarios[s].dump(ps, "build");
            ++s;
        }
    }
}

