/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectVariableProviderManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FileFolderSelectionDialog;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.PathVariablesGroup;
import org.eclipse.ui.internal.ide.dialogs.SimpleListContentProvider;

public final class PathVariableSelectionDialog
extends SelectionDialog {
    private static final int EXTEND_ID = 1025;
    private PathVariablesGroup pathVariablesGroup;
    private IProject currentProject = null;
    private int variableType;

    public PathVariableSelectionDialog(Shell parentShell, int variableType) {
        super(parentShell);
        this.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_title);
        this.variableType = variableType;
        this.pathVariablesGroup = new PathVariablesGroup(false, variableType, new Listener(){

            public void handleEvent(Event event) {
                PathVariableSelectionDialog.this.updateExtendButtonState();
            }
        });
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x10000000);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            PathVariablesGroup.PathVariableElement selection = this.pathVariablesGroup.getSelection()[0];
            ProjectVariableProviderManager.Descriptor desc = ProjectVariableProviderManager.getDefault().findDescriptor(selection.name);
            if (desc != null && desc.getExtensions(selection.name, this.currentProject) != null) {
                EnvSelectionDialog dialog = new EnvSelectionDialog(this.getShell(), desc.getExtensions(selection.name, this.currentProject));
                dialog.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_title);
                dialog.setMessage(NLS.bind((String)IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_description, (Object)selection.name));
                if (dialog.open() == 0 && this.pathVariablesGroup.performOk()) {
                    this.setSelectionResult(new String[]{"${" + selection.name + "-" + dialog.getResult()[0] + "}"});
                    super.okPressed();
                }
            } else {
                FileFolderSelectionDialog dialog = new FileFolderSelectionDialog(this.getShell(), false, this.variableType);
                dialog.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_title);
                dialog.setMessage(NLS.bind((String)IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_description, (Object)selection.name));
                IPath selectionPath = selection.path;
                if (this.currentProject != null) {
                    selectionPath = this.currentProject.getPathVariableManager().resolvePath(selectionPath);
                }
                try {
                    dialog.setInput(EFS.getStore((URI)URIUtil.toURI((IPath)selectionPath)));
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
                }
                if (dialog.open() == 0 && this.pathVariablesGroup.performOk()) {
                    this.setExtensionResult(selection, (IFileStore)dialog.getResult()[0]);
                    super.okPressed();
                }
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.path_variable_selection_dialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1025, IDEWorkbenchMessages.PathVariableSelectionDialog_extendButton, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateExtendButtonState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.pathVariablesGroup.createContents(dialogArea);
        return dialogArea;
    }

    public boolean close() {
        this.pathVariablesGroup.dispose();
        return super.close();
    }

    protected void okPressed() {
        if (this.pathVariablesGroup.performOk()) {
            PathVariablesGroup.PathVariableElement[] selection = this.pathVariablesGroup.getSelection();
            Object[] variableNames = new String[selection.length];
            int i = 0;
            while (i < selection.length) {
                variableNames[i] = selection[i].name;
                ++i;
            }
            this.setSelectionResult(variableNames);
        } else {
            this.setSelectionResult(null);
        }
        super.okPressed();
    }

    private void setExtensionResult(PathVariablesGroup.PathVariableElement variable, IFileStore extensionFile) {
        Path extensionPath = new Path(extensionFile.toString());
        IPath selectionPath = variable.path;
        if (this.currentProject != null) {
            selectionPath = this.currentProject.getPathVariableManager().resolvePath(selectionPath);
        }
        int matchCount = extensionPath.matchingFirstSegments(selectionPath);
        Path resultPath = new Path(variable.name);
        extensionPath = extensionPath.removeFirstSegments(matchCount);
        resultPath = resultPath.append((IPath)extensionPath);
        this.setSelectionResult(new String[]{resultPath.toPortableString()});
    }

    private void updateExtendButtonState() {
        PathVariablesGroup.PathVariableElement[] selection = this.pathVariablesGroup.getSelection();
        Button extendButton = this.getButton(1025);
        if (extendButton == null) {
            return;
        }
        if (selection.length == 1) {
            IPath selectionPath = selection[0].path;
            if (this.currentProject != null) {
                selectionPath = this.currentProject.getPathVariableManager().resolvePath(selectionPath);
            }
            IFileInfo info = IDEResourceInfoUtils.getFileInfo(selectionPath);
            ProjectVariableProviderManager.Descriptor desc = ProjectVariableProviderManager.getDefault().findDescriptor(selection[0].name);
            if (info.exists() && info.isDirectory() || desc != null && desc.getExtensions(selection[0].name, this.currentProject) != null) {
                extendButton.setEnabled(true);
            } else {
                extendButton.setEnabled(false);
            }
        } else {
            extendButton.setEnabled(false);
        }
    }

    public void setProject(IProject project) {
        this.currentProject = project;
        this.pathVariablesGroup.setProject(project);
    }

    class EnvSelectionDialog
    extends SelectionDialog {
        ListViewer viewer;
        Object[] extensions;

        protected EnvSelectionDialog(Shell parentShell, Object[] ext) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.extensions = ext;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createMessageArea(composite);
            this.viewer = new ListViewer(composite, 2820);
            GridData data = new GridData(1808);
            data.heightHint = this.convertHeightInCharsToPixels(10);
            data.widthHint = this.convertWidthInCharsToPixels(30);
            this.viewer.getList().setLayoutData((Object)data);
            this.viewer.getList().setFont(parent.getFont());
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(this){
                final /* synthetic */ EnvSelectionDialog this$1;
                {
                    this.this$1 = envSelectionDialog;
                }

                public String getText(Object element) {
                    if (element instanceof String) {
                        return (String)element;
                    }
                    return null;
                }
            });
            SimpleListContentProvider cp = new SimpleListContentProvider();
            cp.setElements(this.extensions);
            this.viewer.setContentProvider((IContentProvider)cp);
            this.viewer.setInput(new Object());
            this.viewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ EnvSelectionDialog this$1;
                {
                    this.this$1 = envSelectionDialog;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    this.this$1.getOkButton().setEnabled(!event.getSelection().isEmpty());
                }
            });
            this.viewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ EnvSelectionDialog this$1;
                {
                    this.this$1 = envSelectionDialog;
                }

                public void doubleClick(DoubleClickEvent event) {
                    this.this$1.okPressed();
                }
            });
            return composite;
        }

        protected Control createButtonBar(Composite parent) {
            Control result = super.createButtonBar(parent);
            this.getOkButton().setEnabled(false);
            return result;
        }

        protected void okPressed() {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            this.setResult(selection.toList());
            super.okPressed();
        }
    }
}

