/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.model.WorkbenchFile;

public class ContentTypeDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        IContentType contentType;
        if (!(element instanceof IFile)) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.isClosing()) {
            return;
        }
        IFile file = (IFile)element;
        ImageDescriptor image = null;
        IContentDescription contentDescription = null;
        try {
            contentDescription = file.getContentDescription();
        }
        catch (CoreException coreException) {}
        if (contentDescription != null && (contentType = contentDescription.getContentType()) != null) {
            image = workbench.getEditorRegistry().getImageDescriptor(file.getName(), contentType);
        }
        try {
            if (file.getSessionProperty(WorkbenchFile.IMAGE_CACHE_KEY) != image) {
                file.setSessionProperty(WorkbenchFile.IMAGE_CACHE_KEY, image);
            }
        }
        catch (CoreException coreException) {}
        if (image != null) {
            decoration.addOverlay(image);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

