/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.BindingComparator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;

class JavaScriptUnitBinding
implements ITypeBinding {
    private static final IFunctionBinding[] NO_METHOD_BINDINGS = new IFunctionBinding[0];
    private static final String NO_NAME = "";
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    private static final IVariableBinding[] NO_VARIABLE_BINDINGS = new IVariableBinding[0];
    private static final int VALID_MODIFIERS = 3103;
    TypeBinding binding;
    private String key;
    private BindingResolver resolver;

    public JavaScriptUnitBinding(BindingResolver resolver, TypeBinding binding) {
        this.binding = binding;
        this.resolver = resolver;
    }

    public ITypeBinding createArrayType(int dimension) {
        return null;
    }

    public String getBinaryName() {
        char[] constantPoolName = this.binding.constantPoolName();
        if (constantPoolName == null) {
            return null;
        }
        char[] dotSeparated = CharOperation.replaceOnCopy(constantPoolName, '/', '.');
        return new String(dotSeparated);
    }

    public ITypeBinding getBound() {
        return null;
    }

    private IJavaScriptUnit getCompilationUnit(char[] fileName) {
        IJavaScriptUnit workingCopy;
        char[] slashSeparatedFileName = CharOperation.replaceOnCopy(fileName, File.separatorChar, '/');
        int pkgEnd = CharOperation.lastIndexOf('/', slashSeparatedFileName);
        if (pkgEnd == -1) {
            return null;
        }
        IPackageFragment pkg = this.getPackageFragment(slashSeparatedFileName, pkgEnd, -1);
        if (pkg == null) {
            return null;
        }
        int start = pkgEnd + 1;
        IJavaScriptUnit cu = pkg.getJavaScriptUnit(new String(slashSeparatedFileName, start, slashSeparatedFileName.length - start));
        if (this.resolver instanceof DefaultBindingResolver && (workingCopy = cu.findWorkingCopy(((DefaultBindingResolver)this.resolver).workingCopyOwner)) != null) {
            return workingCopy;
        }
        return cu;
    }

    public ITypeBinding getComponentType() {
        return null;
    }

    public IVariableBinding[] getDeclaredFields() {
        try {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            FieldBinding[] fields = referenceBinding.fields();
            int length = fields.length;
            IVariableBinding[] newFields = new IVariableBinding[length];
            int i = 0;
            while (i < length) {
                newFields[i] = this.resolver.getVariableBinding(fields[i]);
                ++i;
            }
            return newFields;
        }
        catch (RuntimeException runtimeException) {
            return NO_VARIABLE_BINDINGS;
        }
    }

    public IFunctionBinding[] getDeclaredMethods() {
        try {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            MethodBinding[] methods = referenceBinding.methods();
            int length = methods.length;
            IFunctionBinding[] newMethods = new IFunctionBinding[length];
            int i = 0;
            while (i < length) {
                MethodBinding methodBinding = methods[i];
                newMethods[i] = this.resolver.getMethodBinding(methodBinding);
                ++i;
            }
            return newMethods;
        }
        catch (RuntimeException runtimeException) {
            return NO_METHOD_BINDINGS;
        }
    }

    public int getDeclaredModifiers() {
        return this.getModifiers();
    }

    public ITypeBinding[] getDeclaredTypes() {
        return NO_TYPE_BINDINGS;
    }

    public IFunctionBinding getDeclaringMethod() {
        return null;
    }

    public ITypeBinding getDeclaringClass() {
        return null;
    }

    public int getDimensions() {
        return 0;
    }

    public ITypeBinding getElementType() {
        return null;
    }

    public ITypeBinding getTypeDeclaration() {
        return this;
    }

    public ITypeBinding getErasure() {
        return this.resolver.getTypeBinding(this.binding);
    }

    public ITypeBinding[] getInterfaces() {
        return NO_TYPE_BINDINGS;
    }

    public IJavaScriptElement getJavaElement() {
        JavaElement element = this.getUnresolvedJavaElement();
        if (element == null) {
            return null;
        }
        return element.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        return this.getUnresolvedJavaElement(this.binding);
    }

    private JavaElement getUnresolvedJavaElement(TypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        char[] fileName = referenceBinding.getFileName();
        if (fileName == null) {
            return null;
        }
        ITypeBinding declaringTypeBinding = this.getDeclaringClass();
        if (declaringTypeBinding == null) {
            if (((ReferenceBinding)this.binding).isBinaryBinding()) {
                ClassFile classFile = (ClassFile)this.getClassFile(fileName);
                return classFile;
            }
            IJavaScriptUnit cu = this.getCompilationUnit(fileName);
            return (JavaElement)((Object)cu);
        }
        IType declaringType = (IType)declaringTypeBinding.getJavaElement();
        if (declaringType == null) {
            return null;
        }
        return (JavaElement)((Object)declaringType.getType(new String(referenceBinding.sourceName())));
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public int getKind() {
        return 2;
    }

    public int getModifiers() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int accessFlags = referenceBinding.getAccessFlags() & 0xC1F;
            if (referenceBinding.isAnonymousType()) {
                return accessFlags & 0xFFFFFFEF;
            }
            return accessFlags;
        }
        if (this.isAnnotation()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int accessFlags = referenceBinding.getAccessFlags() & 0xC1F;
            return accessFlags & 0xFFFFFBFF;
        }
        if (this.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int accessFlags = referenceBinding.getAccessFlags() & 0xC1F;
            return accessFlags & 0xFFFFFBFF;
        }
        return 0;
    }

    public String getName() {
        return new String(this.binding.sourceName());
    }

    public IPackageBinding getPackage() {
        switch (this.binding.kind()) {
            case 68: 
            case 132: {
                return null;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        return this.resolver.getPackageBinding(referenceBinding.getPackage());
    }

    private IPackageFragment getPackageFragment(char[] fileName, int pkgEnd, int jarSeparator) {
        if (jarSeparator != -1) {
            String jarMemento = new String(fileName, 0, jarSeparator);
            IPackageFragmentRoot root = (IPackageFragmentRoot)JavaScriptCore.create(jarMemento);
            if (pkgEnd == jarSeparator) {
                return root.getPackageFragment(NO_NAME);
            }
            char[] pkgName = CharOperation.subarray(fileName, jarSeparator + 1, pkgEnd);
            CharOperation.replace(pkgName, '/', '.');
            return root.getPackageFragment(new String(pkgName));
        }
        Path path = new Path(new String(fileName, 0, pkgEnd));
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Object folder = path.segmentCount() == 1 ? workspaceRoot.getProject(path.lastSegment()) : workspaceRoot.getFolder((IPath)path);
        IJavaScriptElement element = JavaScriptCore.create((IResource)folder);
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 4: {
                return (IPackageFragment)element;
            }
            case 3: {
                return ((IPackageFragmentRoot)element).getPackageFragment(NO_NAME);
            }
            case 2: {
                IPackageFragmentRoot root = ((IJavaScriptProject)element).getPackageFragmentRoot((IResource)folder);
                if (root == null) {
                    return null;
                }
                return root.getPackageFragment(NO_NAME);
            }
        }
        return null;
    }

    public String getQualifiedName() {
        if (this.isAnonymous() || this.isLocal()) {
            return NO_NAME;
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isMember()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getDeclaringClass().getQualifiedName()).append('.');
            buffer.append(this.getName());
            return String.valueOf(buffer);
        }
        PackageBinding packageBinding = this.binding.getPackage();
        StringBuffer buffer = new StringBuffer();
        if (packageBinding != null && packageBinding.compoundName != CharOperation.NO_CHAR_CHAR) {
            buffer.append(CharOperation.concatWith(packageBinding.compoundName, '.')).append('.');
        }
        buffer.append(this.getName());
        return String.valueOf(buffer);
    }

    public ITypeBinding getSuperclass() {
        return null;
    }

    public ITypeBinding[] getTypeArguments() {
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeBounds() {
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeParameters() {
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding getWildcard() {
        return null;
    }

    public boolean isGenericType() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAssignmentCompatible(ITypeBinding type) {
        return false;
    }

    public boolean isCapture() {
        return false;
    }

    public boolean isCastCompatible(ITypeBinding type) {
        return false;
    }

    public boolean isClass() {
        return this.binding.isClass();
    }

    public boolean isDeprecated() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isDeprecated();
        }
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof JavaScriptUnitBinding)) {
            return false;
        }
        TypeBinding otherBinding = ((JavaScriptUnitBinding)other).binding;
        return BindingComparator.isEqual(this.binding, otherBinding);
    }

    public boolean isFromSource() {
        return !((ReferenceBinding)this.binding).isBinaryBinding();
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isMember() {
        return false;
    }

    public boolean isNested() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isSubTypeCompatible(ITypeBinding type) {
        return false;
    }

    public boolean isTopLevel() {
        return true;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUpperbound() {
        return false;
    }

    public boolean isWildcardType() {
        return false;
    }

    public String toString() {
        return this.binding.toString();
    }

    public boolean isCompilationUnit() {
        return true;
    }

    private IClassFile getClassFile(char[] fileName) {
        int jarSeparator = CharOperation.indexOf('|', fileName);
        int pkgEnd = CharOperation.lastIndexOf('/', fileName);
        if (pkgEnd == -1) {
            pkgEnd = CharOperation.lastIndexOf(File.separatorChar, fileName);
        }
        if (jarSeparator != -1 && pkgEnd < jarSeparator) {
            pkgEnd = jarSeparator;
        }
        if (pkgEnd == -1) {
            return null;
        }
        IPackageFragment pkg = this.getPackageFragment(fileName, pkgEnd, jarSeparator);
        if (pkg == null) {
            return null;
        }
        int start = pkgEnd + 1;
        return pkg.getClassFile(new String(fileName, start, fileName.length - start));
    }

    public boolean isRecovered() {
        return false;
    }
}

