/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.infer;

import org.eclipse.wst.jsdt.core.ast.ASTVisitor;
import org.eclipse.wst.jsdt.core.ast.IAbstractFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IAbstractVariableDeclaration;
import org.eclipse.wst.jsdt.core.ast.IAllocationExpression;
import org.eclipse.wst.jsdt.core.ast.IArgument;
import org.eclipse.wst.jsdt.core.ast.IAssignment;
import org.eclipse.wst.jsdt.core.ast.ICharLiteral;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFalseLiteral;
import org.eclipse.wst.jsdt.core.ast.IFieldReference;
import org.eclipse.wst.jsdt.core.ast.IFunctionCall;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IFunctionExpression;
import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.core.ast.ILocalDeclaration;
import org.eclipse.wst.jsdt.core.ast.INumberLiteral;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteral;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteralField;
import org.eclipse.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.wst.jsdt.core.ast.IReturnStatement;
import org.eclipse.wst.jsdt.core.ast.IScriptFileDeclaration;
import org.eclipse.wst.jsdt.core.ast.ISingleNameReference;
import org.eclipse.wst.jsdt.core.ast.IStringLiteral;
import org.eclipse.wst.jsdt.core.ast.IThisReference;
import org.eclipse.wst.jsdt.core.ast.ITrueLiteral;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferOptions;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMember;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class InferEngine
extends ASTVisitor {
    InferOptions inferOptions;
    CompilationUnitDeclaration compUnit;
    Context[] contexts = new Context[100];
    int contextPtr = -1;
    Context currentContext = new Context();
    protected int passNumber = 1;
    boolean isTopLevelAnonymousFunction;
    int anonymousCount = 0;
    public int appliesTo;
    public InferrenceProvider inferenceProvider;
    public InferredType StringType = new InferredType(new char[]{'S', 't', 'r', 'i', 'n', 'g'});
    public InferredType NumberType = new InferredType(new char[]{'N', 'u', 'm', 'b', 'e', 'r'});
    public InferredType BooleanType = new InferredType(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'});
    public InferredType FunctionType = new InferredType(InferredType.FUNCTION_NAME);
    public InferredType ArrayType = new InferredType(InferredType.ARRAY_NAME);
    public InferredType VoidType = new InferredType(new char[]{'v', 'o', 'i', 'd'});
    public InferredType ObjectType = new InferredType(InferredType.OBJECT_NAME);
    public InferredType GlobalType = new InferredType(InferredType.GLOBAL_NAME);
    public static HashtableOfObject WellKnownTypes = new HashtableOfObject();
    protected InferredType inferredGlobal;
    static final char[] CONSTRUCTOR_ID = new char[]{'c', 'o', 'n', 's', 't', 'r', 'u', 'c', 't', 'o', 'r'};
    public static final char[] ANONYMOUS_PREFIX = new char[]{'_', '_', '_'};
    public static final char[] ANONYMOUS_CLASS_ID = new char[]{'a', 'n', 'o', 'n', 'y', 'm', 'o', 'u', 's'};
    private static boolean REPORT_INFER_TIME = false;

    public InferEngine(InferOptions inferOptions) {
        WellKnownTypes.put(InferredType.OBJECT_NAME, null);
        WellKnownTypes.put(InferredType.ARRAY_NAME, null);
        WellKnownTypes.put(new char[]{'S', 't', 'r', 'i', 'n', 'g'}, null);
        WellKnownTypes.put(new char[]{'N', 'u', 'm', 'b', 'e', 'r'}, null);
        WellKnownTypes.put(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'}, null);
        WellKnownTypes.put(InferredType.FUNCTION_NAME, null);
        WellKnownTypes.put(new char[]{'D', 'a', 't', 'e'}, null);
        WellKnownTypes.put(new char[]{'M', 'a', 't', 'h'}, null);
        WellKnownTypes.put(new char[]{'R', 'e', 'g', 'E', 'x', 'p'}, null);
        WellKnownTypes.put(new char[]{'E', 'r', 'r', 'o', 'r'}, null);
        this.inferredGlobal = null;
        this.inferOptions = inferOptions;
    }

    public InferEngine() {
        WellKnownTypes.put(InferredType.OBJECT_NAME, null);
        WellKnownTypes.put(InferredType.ARRAY_NAME, null);
        WellKnownTypes.put(new char[]{'S', 't', 'r', 'i', 'n', 'g'}, null);
        WellKnownTypes.put(new char[]{'N', 'u', 'm', 'b', 'e', 'r'}, null);
        WellKnownTypes.put(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'}, null);
        WellKnownTypes.put(InferredType.FUNCTION_NAME, null);
        WellKnownTypes.put(new char[]{'D', 'a', 't', 'e'}, null);
        WellKnownTypes.put(new char[]{'M', 'a', 't', 'h'}, null);
        WellKnownTypes.put(new char[]{'R', 'e', 'g', 'E', 'x', 'p'}, null);
        WellKnownTypes.put(new char[]{'E', 'r', 'r', 'o', 'r'}, null);
        this.inferredGlobal = null;
        this.inferOptions = new InferOptions();
    }

    public void initialize() {
        this.contextPtr = -1;
        this.currentContext = new Context();
        this.passNumber = 1;
        this.isTopLevelAnonymousFunction = false;
        this.anonymousCount = 0;
        this.inferredGlobal = null;
    }

    public void setCompilationUnit(CompilationUnitDeclaration scriptFileDeclaration) {
        this.compUnit = scriptFileDeclaration;
        this.buildDefinedMembers(scriptFileDeclaration.getStatements(), null);
    }

    public boolean visit(IFunctionCall functionCall) {
        boolean visitChildren = this.handleFunctionCall(functionCall);
        if (visitChildren && this.contextPtr == -1 && functionCall.getReceiver() instanceof FunctionExpression) {
            this.isTopLevelAnonymousFunction = true;
        }
        return visitChildren;
    }

    public boolean visit(ILocalDeclaration localDeclaration) {
        this.currentContext.addMember(localDeclaration.getName(), localDeclaration);
        if (localDeclaration.getJsDoc() != null) {
            InferredType type;
            Javadoc javadoc = (Javadoc)localDeclaration.getJsDoc();
            this.createTypeIfNecessary(javadoc);
            InferredAttribute attribute = null;
            if (javadoc.memberOf != null) {
                type = this.addType(javadoc.memberOf.getSimpleTypeName(), true);
                attribute = type.addAttribute(localDeclaration.getName(), localDeclaration);
                this.handleAttributeDeclaration(attribute, localDeclaration.getInitialization());
                if (localDeclaration.getInitialization() != null) {
                    attribute.initializationStart = localDeclaration.getInitialization().sourceStart();
                }
                attribute.type = type;
            }
            if (javadoc.returnType != null) {
                type = this.addType(javadoc.returnType.getSimpleTypeName());
                localDeclaration.setInferredType(type);
                if (attribute != null) {
                    attribute.type = type;
                }
            }
        }
        if (localDeclaration.getInferredType() == null && localDeclaration.getInitialization() != null) {
            localDeclaration.setInferredType(this.getTypeOf(localDeclaration.getInitialization()));
        }
        return true;
    }

    private void createTypeIfNecessary(Javadoc javadoc) {
        if (javadoc.memberOf != null) {
            Object namespace = new char[][]{};
            char[][] typeName = javadoc.memberOf.getTypeName();
            if (javadoc.namespace != null) {
                namespace = javadoc.namespace.getTypeName();
            }
            char[] name = CharOperation.concat(CharOperation.concatWith(namespace, '.'), CharOperation.concatWith(typeName, '.'), '.');
            this.currentContext.currentType = this.addType(name);
            if (javadoc.extendsType != null) {
                char[] superName = CharOperation.concatWith(javadoc.extendsType.getTypeName(), '.');
                this.currentContext.currentType.superClass = this.addType(superName);
            }
            this.currentContext.isJsDocClass = true;
        }
    }

    public boolean visit(IAssignment assignment) {
        this.pushContext();
        IExpression assignmentExpression = assignment.getExpression();
        if (!this.handlePotentialType(assignment)) {
            if (assignmentExpression instanceof FunctionExpression) {
                boolean keepVisiting = this.handleFunctionExpressionAssignment(assignment);
                if (!keepVisiting) {
                    return false;
                }
            } else if (assignmentExpression instanceof SingleNameReference && this.currentContext.currentType != null && InferEngine.isThis(assignment.getLeftHandSide())) {
                ISingleNameReference snr = (ISingleNameReference)assignmentExpression;
                Object object = this.currentContext.getMember(snr.getToken());
                IFieldReference fieldReference = (IFieldReference)assignment.getLeftHandSide();
                char[] memberName = fieldReference.getToken();
                InferredMember member = null;
                if (object instanceof MethodDeclaration) {
                    MethodDeclaration method = (MethodDeclaration)object;
                    member = this.currentContext.currentType.addMethod(memberName, method, false);
                } else {
                    member = this.currentContext.currentType.addAttribute(memberName, assignment);
                    this.handleAttributeDeclaration((InferredAttribute)member, assignment.getExpression());
                    member.type = this.getTypeOf(assignmentExpression);
                }
                if (member != null) {
                    member.isStatic = false;
                    member.nameStart = fieldReference.sourceEnd() - memberName.length + 1;
                }
            } else if (assignmentExpression instanceof IObjectLiteral && assignment.getLeftHandSide() instanceof ISingleNameReference) {
                IAbstractVariableDeclaration varDecl = this.getVariable(assignment.getLeftHandSide());
                if (varDecl != null) {
                    InferredType type = varDecl.getInferredType();
                    if (type == null) {
                        type = this.getTypeOf(assignmentExpression);
                        varDecl.setInferredType(type);
                        return true;
                    }
                    return false;
                }
            } else if (assignmentExpression instanceof IObjectLiteral && assignment.getLeftHandSide() instanceof FieldReference) {
                boolean isKnownName;
                FieldReference fRef = (FieldReference)assignment.getLeftHandSide();
                boolean bl = isKnownName = fRef.receiver.isThis() && this.isKnownType(fRef.getToken()) && this.inferredGlobal != null && this.inferredGlobal == this.currentContext.currentType;
                if (isKnownName || this.inferOptions.useAssignments && this.passNumber == 2) {
                    InferredAttribute attr;
                    InferredType receiverType = this.getInferredType(fRef.receiver);
                    if (receiverType == null && this.passNumber == 2) {
                        receiverType = this.getInferredType2(fRef.receiver);
                    }
                    if (receiverType != null && ((attr = receiverType.findAttribute(fRef.getToken())) == null || attr.type == null)) {
                        attr = receiverType.addAttribute(fRef.getToken(), assignment);
                        this.handleAttributeDeclaration(attr, assignment.getExpression());
                        attr.type = this.getTypeOf(assignmentExpression);
                        if (isKnownName && attr.type.isAnonymous) {
                            InferredType existingType = this.compUnit.findInferredType(fRef.getToken());
                            if (existingType != null) {
                                attr.type = existingType;
                            } else {
                                this.compUnit.inferredTypesHash.removeKey(attr.type.name);
                                attr.type.name = fRef.getToken();
                                this.compUnit.inferredTypesHash.put(attr.type.name, attr.type);
                            }
                        }
                        char[] possibleTypeName = this.constructTypeName(fRef.receiver);
                        attr.isStatic = receiverType.allStatic || possibleTypeName != null && this.compUnit.findInferredType(possibleTypeName) != null;
                        attr.nameStart = (int)(fRef.nameSourcePosition >>> 32);
                        return false;
                    }
                }
            } else if (assignmentExpression instanceof AllocationExpression && ((AllocationExpression)assignmentExpression).member instanceof FunctionExpression) {
                this.handleFunctionExpressionAssignment((Assignment)assignment);
            } else if (assignmentExpression instanceof Assignment && ((Assignment)assignmentExpression).expression instanceof FunctionExpression) {
                this.handleFunctionExpressionAssignment((Assignment)assignment);
            } else if (this.inferOptions.useAssignments && assignment.getLeftHandSide() instanceof FieldReference) {
                char[] typeName;
                IFunctionDeclaration function;
                FieldReference fRef = (FieldReference)assignment.getLeftHandSide();
                int nameStart = (int)(fRef.nameSourcePosition >>> 32);
                InferredType receiverType = this.getInferredType(fRef.receiver);
                if (receiverType == null && (function = this.getDefinedFunction(fRef.receiver)) != null && (typeName = this.constructTypeName(fRef.receiver)) != null) {
                    receiverType = this.addType(typeName);
                }
                if (receiverType == null && this.passNumber == 2) {
                    receiverType = this.getInferredType2(fRef.receiver);
                }
                if (receiverType != null) {
                    InferredMethod method = null;
                    InferredAttribute attr = receiverType.findAttribute(fRef.token);
                    if (attr == null) {
                        method = receiverType.findMethod(fRef.token, null);
                    }
                    if (method == null && attr == null || method == null && attr != null && attr.type == null) {
                        IFunctionDeclaration definedFunction = null;
                        InferredType exprType = this.getTypeOf(assignmentExpression);
                        if (exprType == null) {
                            definedFunction = this.getDefinedFunction(assignmentExpression);
                        }
                        if (definedFunction != null) {
                            method = receiverType.addMethod(fRef.token, definedFunction, false);
                            method.nameStart = nameStart;
                            method.isStatic = receiverType.allStatic;
                        } else {
                            attr = receiverType.addAttribute(fRef.token, assignment);
                            this.handleAttributeDeclaration(attr, assignmentExpression);
                            attr.type = exprType;
                            char[] possibleTypeName = this.constructTypeName(fRef.receiver);
                            attr.isStatic = receiverType.allStatic || possibleTypeName != null && this.compUnit.findInferredType(possibleTypeName) != null;
                            attr.nameStart = (int)(fRef.nameSourcePosition >>> 32);
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected InferredType getInferredType2(IExpression fieldReceiver) {
        char[] name;
        InferredAttribute attr;
        InferredType receiverType = null;
        IAbstractVariableDeclaration var = this.getVariable(fieldReceiver);
        if (var != null) {
            receiverType = this.createAnonymousType(var);
        } else if (this.inferredGlobal != null && fieldReceiver instanceof ISingleNameReference && (attr = this.inferredGlobal.findAttribute(name = ((ISingleNameReference)fieldReceiver).getToken())) != null) {
            receiverType = attr.type;
        }
        return receiverType;
    }

    private InferredType createAnonymousType(IAbstractVariableDeclaration var) {
        InferredType currentType = var.getInferredType();
        if (currentType == null || !currentType.isAnonymous) {
            InferredType type = this.createAnonymousType(var.getName(), currentType);
            var.setInferredType(type);
        }
        return var.getInferredType();
    }

    protected InferredType createAnonymousType(char[] possibleTypeName, InferredType currentType) {
        char[] name;
        if (this.isKnownType(possibleTypeName)) {
            name = possibleTypeName;
        } else {
            char[] cs = String.valueOf(this.anonymousCount++).toCharArray();
            name = CharOperation.concat(ANONYMOUS_PREFIX, possibleTypeName, cs);
        }
        InferredType type = this.addType(name, true);
        type.isAnonymous = true;
        if (currentType != null) {
            type.superClass = currentType;
        }
        return type;
    }

    private InferredType createAnonymousType(IObjectLiteral objLit) {
        if (objLit.getInferredType() != null) {
            return objLit.getInferredType();
        }
        char[] loc = (String.valueOf(String.valueOf(objLit.sourceStart())) + '_' + String.valueOf(objLit.sourceEnd())).toCharArray();
        char[] name = CharOperation.concat(ANONYMOUS_PREFIX, ANONYMOUS_CLASS_ID, loc);
        InferredType anonType = this.addType(name, true);
        anonType.isAnonymous = true;
        anonType.isObjectLiteral = true;
        anonType.superClass = this.ObjectType;
        anonType.sourceStart = objLit.sourceStart();
        anonType.sourceEnd = objLit.sourceEnd();
        this.populateType(anonType, objLit, false);
        return anonType;
    }

    protected boolean handleFunctionExpressionAssignment(IAssignment assignment) {
        IFunctionExpression functionExpression = null;
        if (assignment.getExpression() instanceof IFunctionExpression) {
            functionExpression = (IFunctionExpression)assignment.getExpression();
        } else if (assignment.getExpression() instanceof IAllocationExpression) {
            functionExpression = (IFunctionExpression)((IAllocationExpression)((Object)assignment.getExpression())).getMember();
        } else if (assignment.getExpression() instanceof IAssignment) {
            functionExpression = (FunctionExpression)((IAssignment)assignment.getExpression()).getExpression();
        }
        MethodDeclaration methodDeclaration = functionExpression.getMethodDeclaration();
        char[] possibleTypeName = this.constructTypeName(assignment.getLeftHandSide());
        InferredType type = null;
        if (possibleTypeName != null) {
            type = this.compUnit.findInferredType(possibleTypeName);
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null && methodDeclaration.getJsDoc() != null && ((Javadoc)methodDeclaration.getJsDoc()).isConstructor) {
                type = this.addType(possibleTypeName, true);
                this.handleJSDocConstructor(type, methodDeclaration, assignment.sourceStart());
            }
        }
        if (type != null) {
            if (this.inferOptions.useInitMethod) {
                this.currentContext.currentType = type;
                this.currentContext.currentType = type;
                type.isDefinition = true;
                InferredMethod method = type.addMethod(type.name, methodDeclaration, true);
                type.updatePositions(assignment.getLeftHandSide().sourceStart(), assignment.getExpression().sourceEnd());
                method.nameStart = assignment.getLeftHandSide().sourceStart();
            }
        } else if (assignment.getLeftHandSide() instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)assignment.getLeftHandSide();
            int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
            InferredType receiverType = this.getInferredType(fieldReference.receiver);
            if (receiverType != null) {
                InferredMethod method = receiverType.findMethod(fieldReference.token, methodDeclaration);
                if (method == null) {
                    method = receiverType.addMethod(fieldReference.token, methodDeclaration, false);
                    receiverType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                    method.nameStart = nameStart;
                    receiverType.isDefinition = true;
                    char[] possibleInTypeName = this.constructTypeName(fieldReference.receiver);
                    method.isStatic = receiverType.allStatic || possibleInTypeName != null && this.compUnit.findInferredType(possibleInTypeName) != null;
                    return true;
                }
                return false;
            }
            if (this.passNumber == 2 && (receiverType = this.getInferredType2(fieldReference.receiver)) != null) {
                InferredMethod method = receiverType.addMethod(fieldReference.token, methodDeclaration, false);
                method.isStatic = receiverType.isAnonymous;
                method.nameStart = nameStart;
                receiverType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
            }
        } else {
            boolean cfr_ignored_0 = assignment.getLeftHandSide() instanceof SingleNameReference;
        }
        return true;
    }

    protected boolean handlePotentialType(IAssignment assignment) {
        IExpression lhs = assignment.getLeftHandSide();
        if (lhs instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)lhs;
            if (fieldReference.isPrototype()) {
                InferredType newType = null;
                char[] possibleTypeName = this.constructTypeName(fieldReference.getReceiver());
                if (possibleTypeName == null) {
                    return true;
                }
                newType = this.compUnit.findInferredType(possibleTypeName);
                if (newType == null) {
                    newType = this.addType(possibleTypeName, true);
                }
                newType.isDefinition = true;
                newType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                if (assignment.getExpression() instanceof IAllocationExpression) {
                    IAllocationExpression allocationExpression = (IAllocationExpression)((Object)assignment.getExpression());
                    InferredType superType = null;
                    char[] possibleSuperTypeName = this.constructTypeName(allocationExpression.getMember());
                    if (possibleSuperTypeName != null) {
                        superType = this.compUnit.findInferredType(possibleSuperTypeName);
                        if (superType == null) {
                            superType = this.addType(possibleSuperTypeName);
                        }
                        if (newType.superClass == null) {
                            newType.superClass = superType;
                        }
                    }
                    return true;
                }
                if (assignment.getExpression() instanceof IObjectLiteral) {
                    this.populateType(newType, (IObjectLiteral)assignment.getExpression(), false);
                    if (newType.superClass == null) {
                        newType.superClass = this.ObjectType;
                    }
                    return true;
                }
            } else {
                if (fieldReference.receiver.isPrototype()) {
                    FieldReference prototype = (FieldReference)fieldReference.receiver;
                    InferredType newType = null;
                    char[] possibleTypeName = this.constructTypeName(prototype.receiver);
                    if (possibleTypeName == null) {
                        return true;
                    }
                    newType = this.compUnit.findInferredType(possibleTypeName);
                    if (newType == null) {
                        newType = this.addType(possibleTypeName);
                    }
                    newType.isDefinition = true;
                    newType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                    if (this.passNumber == 1 && assignment.getExpression() instanceof IObjectLiteral) {
                        return false;
                    }
                    char[] memberName = fieldReference.token;
                    int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                    InferredType typeOf = this.getTypeOf(assignment.getExpression());
                    IFunctionDeclaration methodDecl = null;
                    if (typeOf == null || typeOf == this.FunctionType) {
                        methodDecl = this.getDefinedFunction(assignment.getExpression());
                    }
                    if (methodDecl != null) {
                        InferredMethod method = newType.addMethod(memberName, methodDecl, false);
                        method.nameStart = nameStart;
                    } else {
                        InferredAttribute attribute = newType.addAttribute(memberName, assignment);
                        this.handleAttributeDeclaration(attribute, assignment.getExpression());
                        attribute.initializationStart = assignment.getExpression().sourceStart();
                        attribute.nameStart = nameStart;
                        if (attribute.type == null) {
                            attribute.type = typeOf;
                        }
                    }
                    return true;
                }
                if (fieldReference.receiver instanceof IThisReference) {
                    InferredType newType = null;
                    IFunctionDeclaration parentMethod = this.currentContext.currentMethod;
                    if (parentMethod == null || parentMethod.getName() == null) {
                        return false;
                    }
                    newType = this.compUnit.findInferredType(parentMethod.getName());
                    if (newType == null) {
                        newType = this.addType(parentMethod.getName());
                    }
                    newType.isDefinition = true;
                    newType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                    if (this.passNumber == 1 && assignment.getExpression() instanceof IObjectLiteral) {
                        return false;
                    }
                    char[] memberName = fieldReference.token;
                    int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                    InferredType typeOf = this.getTypeOf(assignment.getExpression());
                    IFunctionDeclaration methodDecl = null;
                    if (typeOf == null || typeOf == this.FunctionType) {
                        methodDecl = this.getDefinedFunction(assignment.getExpression());
                    }
                    if (methodDecl != null) {
                        InferredMethod method = newType.addMethod(memberName, methodDecl, false);
                        method.nameStart = nameStart;
                    } else {
                        InferredAttribute attribute = newType.addAttribute(memberName, assignment);
                        this.handleAttributeDeclaration(attribute, assignment.getExpression());
                        attribute.initializationStart = assignment.getExpression().sourceStart();
                        attribute.nameStart = nameStart;
                        if (attribute.type == null) {
                            attribute.type = typeOf;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected IFunctionDeclaration getDefinedFunction(IExpression expression) {
        if (expression instanceof SingleNameReference) {
            Object object = this.currentContext.getMember(((SingleNameReference)expression).token);
            if (object instanceof AbstractMethodDeclaration) {
                return (MethodDeclaration)object;
            }
        } else {
            if (expression instanceof FunctionExpression) {
                return ((FunctionExpression)expression).methodDeclaration;
            }
            if (expression instanceof FieldReference) {
                InferredMethod method;
                FieldReference fieldReference = (FieldReference)expression;
                InferredType receiverType = this.getInferredType(fieldReference.receiver);
                if (receiverType == null && this.passNumber == 2) {
                    receiverType = this.getInferredType2(fieldReference.receiver);
                }
                if (receiverType != null && (method = receiverType.findMethod(fieldReference.token, null)) != null) {
                    return method.getFunctionDeclaration();
                }
            }
        }
        return null;
    }

    protected InferredType getTypeOf(IExpression expression) {
        if (expression instanceof IStringLiteral || expression instanceof ICharLiteral) {
            return this.StringType;
        }
        if (expression instanceof INumberLiteral) {
            return this.NumberType;
        }
        if (expression instanceof IAllocationExpression) {
            IAllocationExpression allocationExpression = (IAllocationExpression)((Object)expression);
            InferredType type = null;
            char[] possibleTypeName = this.constructTypeName(allocationExpression.getMember());
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
                if (type == null) {
                    type = this.addType(possibleTypeName);
                }
                return type;
            }
        } else if (expression instanceof ISingleNameReference) {
            InferredAttribute attribute;
            IAbstractVariableDeclaration varDecl = this.getVariable(expression);
            if (varDecl != null) {
                return varDecl.getInferredType();
            }
            if (this.inferredGlobal != null && (attribute = this.inferredGlobal.findAttribute(((ISingleNameReference)expression).getToken())) != null) {
                return attribute.type;
            }
        } else if (expression instanceof FieldReference) {
            InferredAttribute attribute;
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis() && this.currentContext.currentType != null && (attribute = this.currentContext.currentType.findAttribute(fieldReference.getToken())) != null) {
                return attribute.type;
            }
        } else {
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                boolean typeSet = false;
                InferredType memberType = null;
                if (arrayInitializer.expressions != null) {
                    int i = 0;
                    while (i < arrayInitializer.expressions.length) {
                        InferredType thisType = this.getTypeOf(arrayInitializer.expressions[i]);
                        if (thisType != null) {
                            if (!thisType.equals(memberType)) {
                                memberType = !typeSet ? thisType : null;
                            }
                            typeSet = true;
                        }
                        ++i;
                    }
                }
                if (memberType != null) {
                    InferredType type = new InferredType(InferredType.ARRAY_NAME);
                    type.referenceClass = memberType;
                    return type;
                }
                return this.ArrayType;
            }
            if (expression instanceof ITrueLiteral || expression instanceof IFalseLiteral) {
                return this.BooleanType;
            }
            if (expression instanceof IObjectLiteral) {
                InferredType type = this.createAnonymousType((IObjectLiteral)expression);
                type.sourceStart = expression.sourceStart();
                type.sourceEnd = expression.sourceEnd();
                return type;
            }
            if (expression instanceof IThisReference) {
                return this.currentContext.currentType;
            }
            if (expression instanceof Assignment) {
                return this.getTypeOf(((Assignment)expression).getExpression());
            }
            if (expression instanceof FunctionExpression) {
                return this.FunctionType;
            }
            if (expression instanceof UnaryExpression) {
                return this.getTypeOf(((UnaryExpression)expression).expression);
            }
            if (expression instanceof BinaryExpression) {
                BinaryExpression bExpression = (BinaryExpression)expression;
                int operator = (bExpression.bits & 0xFC0) >> 6;
                switch (operator) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: {
                        return this.NumberType;
                    }
                    case 14: {
                        InferredType leftType = this.getTypeOf(bExpression.left);
                        InferredType rightType = this.getTypeOf(bExpression.right);
                        if (leftType != null && leftType.equals(this.StringType)) {
                            return this.StringType;
                        }
                        if (rightType != null && rightType.equals(this.StringType)) {
                            return this.StringType;
                        }
                        if (leftType == null || rightType == null) {
                            return null;
                        }
                        if (leftType.equals(this.StringType) || rightType.equals(this.StringType)) {
                            return this.StringType;
                        }
                        if (leftType.equals(this.NumberType) && rightType.equals(this.NumberType)) {
                            return this.NumberType;
                        }
                        return null;
                    }
                    case 0: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 18: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 29: {
                        return this.BooleanType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    protected void populateType(InferredType type, IObjectLiteral objLit, boolean isStatic) {
        block14: {
            if (objLit.getInferredType() != null) break block14;
            objLit.setInferredType(type);
            if (objLit.getFields() == null) break block14;
            int i = 0;
            while (i < objLit.getFields().length) {
                block17: {
                    int nameStart;
                    char[] name;
                    IObjectLiteralField field;
                    block16: {
                        block15: {
                            field = objLit.getFields()[i];
                            name = null;
                            nameStart = -1;
                            if (!(field.getFieldName() instanceof SingleNameReference)) break block15;
                            SingleNameReference singleNameReference = (SingleNameReference)field.getFieldName();
                            name = singleNameReference.token;
                            nameStart = singleNameReference.sourceStart;
                            break block16;
                        }
                        if (!(field.getFieldName() instanceof IStringLiteral)) break block17;
                        IStringLiteral stringLiteral = (IStringLiteral)field.getFieldName();
                        name = stringLiteral.source();
                        nameStart = stringLiteral.sourceStart();
                    }
                    Javadoc javaDoc = (Javadoc)field.getJsDoc();
                    InferredType returnType = null;
                    if (javaDoc != null) {
                        InferredType previousType;
                        if (javaDoc.memberOf != null) {
                            char[] typeName = javaDoc.memberOf.getSimpleTypeName();
                            this.convertAnonymousTypeToNamed(type, typeName);
                            type.isDefinition = true;
                        } else if (this.currentContext.isJsDocClass && javaDoc.property != null && type.isAnonymous && (previousType = this.currentContext.currentType) != null) {
                            this.copyAnonymousTypeToNamed(type, previousType);
                            type = this.currentContext.currentType = previousType;
                            objLit.setInferredType(this.currentContext.currentType);
                        }
                        if (javaDoc.returnType != null) {
                            returnType = this.addType(javaDoc.returnType.getSimpleTypeName());
                        }
                    }
                    if (field.getInitializer() instanceof IFunctionExpression) {
                        IFunctionExpression functionExpression = (IFunctionExpression)field.getInitializer();
                        InferredMethod method = type.addMethod(name, functionExpression.getMethodDeclaration(), false);
                        method.nameStart = nameStart;
                        method.isStatic = isStatic;
                        if (javaDoc != null) {
                            functionExpression.getMethodDeclaration().modifiers = javaDoc.modifiers;
                        }
                        this.handleFunctionDeclarationArguments(functionExpression.getMethodDeclaration(), javaDoc);
                        if (returnType != null && functionExpression.getMethodDeclaration().getInferredType() == null) {
                            functionExpression.getMethodDeclaration().setInferredType(returnType);
                        }
                    } else {
                        InferredAttribute attribute = type.findAttribute(name);
                        if (attribute == null) {
                            attribute = type.addAttribute(name, field.getInitializer());
                            this.handleAttributeDeclaration(attribute, field.getInitializer());
                            attribute.nameStart = nameStart;
                            attribute.isStatic = isStatic;
                            attribute.type = returnType != null ? returnType : this.getTypeOf(field.getInitializer());
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void endVisit(IAssignment assignment) {
        this.popContext();
    }

    protected boolean handleAttributeDeclaration(InferredAttribute attribute, IExpression initializer) {
        return true;
    }

    protected boolean handleFunctionCall(IFunctionCall messageSend) {
        return true;
    }

    public void endVisit(IReturnStatement returnStatement) {
    }

    public boolean visit(IReturnStatement returnStatement) {
        if (this.currentContext.currentMethod != null && returnStatement.getExpression() != null) {
            InferredType type = null;
            IExpression expression = returnStatement.getExpression();
            if (expression instanceof IObjectLiteral) {
                type = this.createAnonymousType((ObjectLiteral)expression);
                type.sourceStart = expression.sourceStart();
                type.sourceEnd = expression.sourceEnd();
            } else {
                type = this.getTypeOf(expression);
            }
            if (this.currentContext.currentMethod.getInferredType() == this.VoidType) {
                this.currentContext.currentMethod.setInferredType(type);
            } else if (type == null || !type.equals(this.currentContext.currentMethod.getInferredType())) {
                this.currentContext.currentMethod.setInferredType(null);
            }
        }
        return false;
    }

    public void endVisit(IFunctionDeclaration methodDeclaration) {
        this.popContext();
    }

    public boolean visit(IFunctionDeclaration methodDeclaration) {
        InferredType type;
        this.pushContext();
        if (this.isTopLevelAnonymousFunction && this.currentContext.currentType == null) {
            this.inferredGlobal = this.currentContext.currentType = this.addType(InferredType.GLOBAL_NAME, true);
        }
        this.isTopLevelAnonymousFunction = false;
        char[] methodName = methodDeclaration.getName();
        if (this.passNumber == 1) {
            this.buildDefinedMembers((ProgramElement[])methodDeclaration.getStatements(), (Argument[])methodDeclaration.getArguments());
            if (methodDeclaration.getJsDoc() != null) {
                InferredType type2;
                InferredMethod method = null;
                Javadoc javadoc = (Javadoc)methodDeclaration.getJsDoc();
                this.createTypeIfNecessary(javadoc);
                if (javadoc.isConstructor) {
                    type2 = !this.currentContext.isJsDocClass && methodName != null ? this.addType(methodName) : this.currentContext.currentType;
                    if (type2 != null) {
                        this.handleJSDocConstructor(type2, methodDeclaration, methodDeclaration.sourceStart());
                    }
                } else if (javadoc.memberOf != null) {
                    type2 = this.addType(javadoc.memberOf.getSimpleTypeName(), true);
                    char[] name = methodName;
                    if (name != null) {
                        method = type2.addMethod(methodName, methodDeclaration, false);
                    }
                } else if (javadoc.methodDef != null && this.currentContext.isJsDocClass) {
                    type2 = this.currentContext.currentType;
                    char[][] methName = javadoc.methodDef.getTypeName();
                    if (methName.length == 1) {
                        method = type2.addMethod(methName[0], methodDeclaration, false);
                    } else {
                        method = type2.addMethod(methName[methName.length - 1], methodDeclaration, false);
                        method.isStatic = true;
                    }
                    method.nameStart = ((MethodDeclaration)methodDeclaration).sourceStart;
                }
                if (javadoc.returnType != null) {
                    type2 = this.addType(javadoc.returnType.getSimpleTypeName());
                    methodDeclaration.setInferredType(type2);
                    ((MethodDeclaration)methodDeclaration).bits |= 0x4000;
                }
            }
            this.handleFunctionDeclarationArguments((MethodDeclaration)methodDeclaration, (Javadoc)methodDeclaration.getJsDoc());
        }
        if (this.passNumber == 2 && methodName != null && (type = this.compUnit.findInferredType(methodName)) != null) {
            this.currentContext.currentType = type;
            type.isDefinition = true;
            InferredMethod method = type.addMethod(methodName, methodDeclaration, true);
            method.nameStart = methodDeclaration.sourceStart();
            method.isConstructor = true;
            methodDeclaration.setInferredType(type);
        }
        this.currentContext.currentMethod = (MethodDeclaration)methodDeclaration;
        if (methodDeclaration.getInferredMethod() != null && methodDeclaration.getInferredMethod().inType != null) {
            this.currentContext.currentType = methodDeclaration.getInferredMethod().inType;
        }
        if (methodDeclaration.getInferredType() == null) {
            methodDeclaration.setInferredType(this.VoidType);
        }
        return true;
    }

    protected void handleJSDocConstructor(InferredType type, IFunctionDeclaration methodDeclaration, int nameStart) {
        Javadoc javadoc = (Javadoc)methodDeclaration.getJsDoc();
        type.isDefinition = true;
        InferredMethod method = type.addMethod(type.name, methodDeclaration, true);
        method.nameStart = nameStart;
        method.isConstructor = true;
        if (javadoc.extendsType != null) {
            InferredType superType;
            type.superClass = superType = this.addType(javadoc.extendsType.getSimpleTypeName());
        }
    }

    protected void handleFunctionDeclarationArguments(IFunctionDeclaration methodDeclaration, IJsDoc jsdoc) {
        if (jsdoc == null || !(jsdoc instanceof Javadoc)) {
            return;
        }
        Javadoc javadoc = (Javadoc)jsdoc;
        IArgument[] arguments = methodDeclaration.getArguments();
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                JavadocSingleNameReference param;
                if (arguments[i].getInferredType() == null && (param = javadoc.findParam(arguments[i].getName())) != null && param.types != null) {
                    char[] name = new char[]{};
                    int j = 0;
                    while (j < param.types.length) {
                        char[] typeName = param.types[j].getSimpleTypeName();
                        if (j == 0) {
                            name = typeName;
                        } else {
                            name = CharOperation.append(name, '|');
                            name = CharOperation.concat(name, typeName);
                        }
                        ++j;
                    }
                    InferredType paramType = this.addType(name);
                    arguments[i].setInferredType(paramType);
                }
                ++i;
            }
        }
    }

    public boolean visit(IAllocationExpression allocationExpression) {
        InferredType type = null;
        char[] possibleTypeName = this.constructTypeName(allocationExpression.getMember());
        if (possibleTypeName != null && (type = this.compUnit.findInferredType(possibleTypeName)) == null) {
            type = this.addType(possibleTypeName);
        }
        return true;
    }

    public void endVisit(IObjectLiteralField field) {
    }

    private void copyAnonymousTypeToNamed(InferredType inClass, InferredType toType) {
        this.compUnit.inferredTypesHash.removeKey(inClass.name);
        if (inClass.methods != null) {
            if (toType != null) {
                toType.methods.addAll(inClass.methods);
            } else {
                toType.methods = inClass.methods;
            }
        }
        if (inClass.attributes != null) {
            int i = 0;
            while (i < inClass.numberAttributes) {
                toType.addAttribute(inClass.attributes[i]);
                ++i;
            }
        }
    }

    private void convertAnonymousTypeToNamed(InferredType inClass, char[] typeName) {
        if (inClass.isAnonymous) {
            inClass.isAnonymous = false;
            this.compUnit.inferredTypesHash.removeKey(inClass.name);
            inClass.name = typeName;
            this.compUnit.inferredTypesHash.put(typeName, inClass);
        }
    }

    protected boolean isMatch(IExpression expr, char[][] names, int index) {
        char[] matchName = names[index];
        if (expr instanceof SingleNameReference) {
            SingleNameReference snr = (SingleNameReference)expr;
            return CharOperation.equals(snr.token, matchName);
        }
        if (expr instanceof FieldReference && names.length > 1 && index > 0) {
            FieldReference fieldReference = (FieldReference)expr;
            if (CharOperation.equals(fieldReference.token, matchName)) {
                return this.isMatch(fieldReference.receiver, names, index - 1);
            }
        }
        return false;
    }

    protected boolean isFunction(IFunctionCall messageSend, String string) {
        String[] names = string.split("\\.");
        char[] functionName = names[names.length - 1].toCharArray();
        if (!CharOperation.equals(functionName, messageSend.getSelector())) {
            return false;
        }
        char[][] namesChars = new char[names.length][];
        int i = 0;
        while (i < namesChars.length) {
            namesChars[i] = names[i].toCharArray();
            ++i;
        }
        if (names.length > 1) {
            return this.isMatch(messageSend.getReceiver(), namesChars, namesChars.length - 2);
        }
        return true;
    }

    protected boolean isFunction(IFunctionCall messageSend, char[][] names) {
        char[] functionName = names[names.length - 1];
        if (!CharOperation.equals(functionName, messageSend.getSelector())) {
            return false;
        }
        if (names.length > 1) {
            return this.isMatch(messageSend.getReceiver(), names, names.length - 2);
        }
        return true;
    }

    public void doInfer() {
        try {
            long time0 = 0L;
            if (REPORT_INFER_TIME) {
                time0 = System.currentTimeMillis();
            }
            this.compUnit.traverse(this);
            this.passNumber = 2;
            this.compUnit.traverse(this);
            int i = 0;
            while (i < this.compUnit.numberInferredTypes) {
                if (this.compUnit.inferredTypes[i].sourceStart < 0) {
                    this.compUnit.inferredTypes[i].sourceStart = 0;
                }
                ++i;
            }
            if (REPORT_INFER_TIME) {
                long time = System.currentTimeMillis() - time0;
                System.err.println(String.valueOf(this.getClass().getName()) + " inferred " + new String(this.compUnit.getFileName()) + " in " + time + "ms");
            }
            this.compUnit = null;
        }
        catch (RuntimeException e) {
            org.eclipse.wst.jsdt.internal.core.util.Util.log(e, "error during type inferencing");
        }
    }

    protected InferredType addType(char[] className) {
        return this.addType(className, false);
    }

    protected InferredType addType(char[] className, boolean isDefinition) {
        InferredType type = this.compUnit.addType(className, isDefinition, this.inferenceProvider.getID());
        return type;
    }

    protected final void pushContext() {
        Context newContext = new Context(this.currentContext);
        this.contexts[++this.contextPtr] = this.currentContext;
        this.currentContext = newContext;
    }

    protected final void popContext() {
        this.currentContext = this.contexts[this.contextPtr];
        this.contexts[this.contextPtr--] = null;
    }

    protected final boolean isInNamedMethod() {
        return this.currentContext.currentMethod != null && this.currentContext.currentMethod.getName() != null;
    }

    protected IAbstractVariableDeclaration getVariable(IExpression expression) {
        Object var;
        char[] name = null;
        if (expression instanceof ISingleNameReference) {
            name = ((ISingleNameReference)expression).getToken();
        } else if (expression instanceof IFieldReference) {
            name = ((IFieldReference)expression).getToken();
        }
        if (name != null && (var = this.currentContext.getMember(name)) instanceof IAbstractVariableDeclaration) {
            return (IAbstractVariableDeclaration)var;
        }
        return null;
    }

    protected IAbstractFunctionDeclaration getFunction(IExpression expression) {
        Object method;
        char[] name = null;
        if (expression instanceof ISingleNameReference) {
            name = ((ISingleNameReference)expression).getToken();
        } else if (expression instanceof IFieldReference) {
            name = ((IFieldReference)expression).getToken();
        }
        if (name != null && (method = this.currentContext.getMember(name)) instanceof IAbstractFunctionDeclaration) {
            return (IAbstractFunctionDeclaration)method;
        }
        return null;
    }

    private void buildDefinedMembers(IProgramElement[] statements, IArgument[] arguments) {
        int i;
        if (arguments != null) {
            i = 0;
            while (i < arguments.length) {
                this.currentContext.addMember(arguments[i].getName(), arguments[i]);
                ++i;
            }
        }
        if (statements != null) {
            i = 0;
            while (i < statements.length) {
                IAbstractFunctionDeclaration method;
                if (statements[i] instanceof ILocalDeclaration) {
                    ILocalDeclaration local = (ILocalDeclaration)statements[i];
                    this.currentContext.addMember(local.getName(), local);
                } else if (statements[i] instanceof IAbstractFunctionDeclaration && (method = (IAbstractFunctionDeclaration)statements[i]).getName() != null) {
                    this.currentContext.addMember(method.getName(), method);
                }
                ++i;
            }
        }
    }

    private static boolean isThis(IExpression expression) {
        return expression instanceof FieldReference && ((FieldReference)expression).receiver.isThis();
    }

    private InferredType getInferredType(Expression expression) {
        InferredType type = null;
        if (expression instanceof IThisReference) {
            if (this.passNumber == 2 && this.currentContext.currentType == null) {
                char[] possibleTypeName = new char[]{'g', 'l', 'o', 'b', 'a', 'l'};
                if (this.currentContext.currentMethod != null) {
                    possibleTypeName = this.currentContext.currentMethod.getName();
                }
                this.currentContext.setCurrentType(this.createAnonymousType(possibleTypeName, null));
            }
            type = this.currentContext.currentType;
        } else if (expression instanceof SingleNameReference) {
            char[] possibleTypeName = this.constructTypeName(expression);
            if (possibleTypeName != null) {
                IAbstractVariableDeclaration varDecl;
                type = this.compUnit.findInferredType(possibleTypeName);
                if (type == null) {
                    if (WellKnownTypes.containsKey(possibleTypeName)) {
                        type = this.addType(possibleTypeName, true);
                    } else if (this.isKnownType(possibleTypeName)) {
                        type = this.addType(possibleTypeName, true);
                    }
                }
                if (type == null && (varDecl = this.getVariable(expression)) != null && (type = varDecl.getInferredType()) != null && !type.isAnonymous) {
                    if (varDecl.getInitialization() instanceof IAllocationExpression && !type.isFunction()) {
                        type = this.createAnonymousType(varDecl);
                    } else {
                        InferredType superType = type;
                        type = this.addType(varDecl.getName(), true);
                        type.superClass = superType;
                    }
                    type.updatePositions(varDecl.sourceStart(), varDecl.sourceEnd());
                }
            }
        } else if (expression instanceof FieldReference) {
            char[] possibleTypeName = this.constructTypeName(expression);
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
            }
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null) {
                InferredAttribute typeAttribute;
                FieldReference fRef = (FieldReference)expression;
                InferredType parentType = this.getInferredType(fRef.receiver);
                if (parentType != null && (typeAttribute = parentType.findAttribute(fRef.token)) != null && (type = typeAttribute.type) != null && !type.isAnonymous) {
                    if (possibleTypeName == null) {
                        possibleTypeName = typeAttribute.name;
                    }
                    typeAttribute.type = type = this.createAnonymousType(possibleTypeName, type);
                }
            }
        }
        return type;
    }

    protected boolean isKnownType(char[] possibleTypeName) {
        return false;
    }

    protected final char[] constructTypeName(IExpression expression) {
        return Util.getTypeName(expression);
    }

    public boolean visit(IObjectLiteral literal) {
        if (this.passNumber == 1 && literal.getInferredType() == null) {
            this.createAnonymousType((ObjectLiteral)literal);
        }
        this.pushContext();
        this.currentContext.currentType = literal.getInferredType();
        return true;
    }

    public void endVisit(IObjectLiteral literal) {
        this.popContext();
    }

    public void initializeOptions(InferOptions options) {
    }

    protected boolean isPossibleClassName(char[] name) {
        return false;
    }

    public IScriptFileDeclaration getScriptFileDeclaration() {
        return this.compUnit;
    }

    public InferredType findDefinedType(char[] className) {
        return this.compUnit.findInferredType(className);
    }

    static class Context {
        InferredType currentType;
        IFunctionDeclaration currentMethod;
        boolean isJsDocClass;
        private HashtableOfObject definedMembers;
        private Context parent = null;

        Context() {
        }

        Context(Context parent) {
            this.parent = parent;
            this.currentType = parent.currentType;
            this.currentMethod = parent.currentMethod;
            this.isJsDocClass = parent.isJsDocClass;
        }

        public Object getMember(char[] key) {
            Object value = null;
            if (this.definedMembers != null) {
                value = this.definedMembers.get(key);
            }
            if (value == null && this.parent != null) {
                value = this.parent.getMember(key);
            }
            return value;
        }

        public void addMember(char[] key, Object member) {
            if (this.definedMembers == null) {
                this.definedMembers = new HashtableOfObject();
            }
            this.definedMembers.put(key, member);
        }

        public void setCurrentType(InferredType type) {
            this.currentType = type;
            Context parentContext = this.parent;
            while (parentContext != null && parentContext.currentMethod == this.currentMethod) {
                parentContext.currentType = type;
                parentContext = parentContext.parent;
            }
        }
    }
}

