/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.infer;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.infer.DefaultInferrenceProvider;
import org.eclipse.wst.jsdt.core.infer.IInferenceFile;
import org.eclipse.wst.jsdt.core.infer.InferEngine;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.core.infer.InferrenceSupportExtension;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class InferrenceManager {
    public static final String EXTENSION_POINT = "inferrenceSupport";
    protected static final String TAG_INFERENCE_PROVIDER = "inferenceProvider";
    protected static final String ATTR_INFERENGINE_CLASS = "class";
    private static InferrenceManager instance = null;
    private InferrenceSupportExtension[] extensions;

    public static InferrenceManager getInstance() {
        if (instance == null) {
            instance = new InferrenceManager();
        }
        return instance;
    }

    public InferrenceProvider[] getInferenceProviders() {
        if (this.extensions == null) {
            this.loadInferenceExtensions();
        }
        ArrayList<InferrenceProvider> extProviders = new ArrayList<InferrenceProvider>();
        extProviders.add(new DefaultInferrenceProvider());
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].inferProvider != null) {
                extProviders.add(this.extensions[i].inferProvider);
            }
            ++i;
        }
        return extProviders.toArray(new InferrenceProvider[extProviders.size()]);
    }

    public InferrenceProvider[] getInferenceProviders(IInferenceFile script) {
        InferrenceProvider[] inferenceProviders = this.getInferenceProviders();
        ArrayList<InferrenceProvider> extProviders = new ArrayList<InferrenceProvider>(inferenceProviders.length);
        int i = 0;
        while (i < inferenceProviders.length) {
            int applies = inferenceProviders[i].applysTo(script);
            switch (applies) {
                case 3: {
                    extProviders.add(inferenceProviders[i]);
                    break;
                }
                case 1: {
                    InferrenceProvider[] thisProvider = new InferrenceProvider[]{inferenceProviders[i]};
                    return thisProvider;
                }
            }
            ++i;
        }
        return extProviders.toArray(new InferrenceProvider[extProviders.size()]);
    }

    public InferEngine[] getInferenceEngines(CompilationUnitDeclaration script) {
        InferrenceProvider[] inferenceProviders = this.getInferenceProviders();
        if (inferenceProviders.length == 1) {
            return this.getSingleEngine(inferenceProviders[0]);
        }
        ArrayList<InferEngine> extEngines = new ArrayList<InferEngine>();
        int i = 0;
        while (i < inferenceProviders.length) {
            if (script.compilationResult != null && script.compilationResult.compilationUnit != null) {
                String inferenceID = script.compilationResult.compilationUnit.getInferenceID();
                if (inferenceProviders[i].getID().equals(inferenceID)) {
                    return this.getSingleEngine(inferenceProviders[i]);
                }
            }
            int applies = 2;
            try {
                applies = inferenceProviders[i].applysTo(script);
            }
            catch (Exception e) {
                Util.log(e, "exception in inferrence provider " + inferenceProviders[i].getID());
            }
            switch (applies) {
                case 3: {
                    InferEngine eng = inferenceProviders[i].getInferEngine();
                    eng.appliesTo = 3;
                    eng.inferenceProvider = inferenceProviders[i];
                    extEngines.add(eng);
                    break;
                }
                case 1: {
                    return this.getSingleEngine(inferenceProviders[i]);
                }
            }
            ++i;
        }
        return extEngines.toArray(new InferEngine[extEngines.size()]);
    }

    private InferEngine[] getSingleEngine(InferrenceProvider provider) {
        InferEngine engine = provider.getInferEngine();
        engine.appliesTo = 1;
        engine.inferenceProvider = provider;
        InferEngine[] thisEngine = new InferEngine[]{engine};
        return thisEngine;
    }

    protected void loadInferenceExtensions() {
        IExtensionPoint point;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<InferrenceSupportExtension> extList = new ArrayList<InferrenceSupportExtension>();
        if (registry != null && (point = registry.getExtensionPoint("org.eclipse.wst.jsdt.core", EXTENSION_POINT)) != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        InferrenceProvider inferProvider = null;
                        if (elements[j].getName().equals(TAG_INFERENCE_PROVIDER)) {
                            inferProvider = (InferrenceProvider)elements[j].createExecutableExtension(ATTR_INFERENGINE_CLASS);
                        }
                        InferrenceSupportExtension inferenceSupport = new InferrenceSupportExtension();
                        inferenceSupport.inferProvider = inferProvider;
                        extList.add(inferenceSupport);
                    }
                    catch (CoreException e) {
                        Util.log(e, "Error in loading inference extension");
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.extensions = extList.toArray(new InferrenceSupportExtension[extList.size()]);
    }
}

