/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IQualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class QualifiedNameReference
extends NameReference
implements IQualifiedNameReference {
    public char[][] tokens;
    public long[] sourcePositions;
    public FieldBinding[] otherBindings;
    public FieldBinding[] otherCodegenBindings;
    int[] otherDepths;
    public int indexOfFirstFieldBinding;
    public TypeBinding genericCast;
    public TypeBinding[] otherGenericCasts;

    public QualifiedNameReference(char[][] tokens, long[] positions, int sourceStart, int sourceEnd) {
        this.tokens = tokens;
        this.sourcePositions = positions;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        int otherBindingsCount = this.otherBindings == null ? 0 : this.otherBindings.length;
        boolean needValue = otherBindingsCount == 0 || !this.otherBindings[0].isStatic();
        long cfr_ignored_0 = currentScope.compilerOptions().complianceLevel;
        switch (this.bits & 0xF) {
            case 1: {
                FieldBinding cfr_ignored_1 = (FieldBinding)this.binding;
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                    currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                }
                if ((flowInfo.tagBits & 1) == 0) {
                    localBinding.useFlag = 1;
                } else if (localBinding.useFlag == 0) {
                    localBinding.useFlag = 2;
                }
                this.checkNPE(currentScope, flowContext, flowInfo, true);
            }
        }
        if (needValue) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        }
        if (this.otherBindings != null) {
            int i = 0;
            while (i < otherBindingsCount - 1) {
                FieldBinding cfr_ignored_2 = this.otherBindings[i];
                needValue = !this.otherBindings[i + 1].isStatic();
                ++i;
            }
            FieldBinding cfr_ignored_3 = this.otherBindings[otherBindingsCount - 1];
        }
        if (isCompound) {
            switch (otherBindingsCount) {
                case 0: {
                    break;
                }
                case 1: {
                    TypeBinding cfr_ignored_4 = ((VariableBinding)this.binding).type;
                    break;
                }
                default: {
                    TypeBinding cfr_ignored_5 = this.otherBindings[otherBindingsCount - 2].type;
                }
            }
        }
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        switch (otherBindingsCount) {
            case 0: {
                break;
            }
            case 1: {
                TypeBinding cfr_ignored_6 = ((VariableBinding)this.binding).type;
                break;
            }
            default: {
                TypeBinding cfr_ignored_7 = this.otherBindings[otherBindingsCount - 2].type;
            }
        }
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        int otherBindingsCount;
        int n = otherBindingsCount = this.otherBindings == null ? 0 : this.otherBindings.length;
        boolean needValue = otherBindingsCount == 0 ? valueRequired : !this.otherBindings[0].isStatic();
        boolean complyTo14 = currentScope.compilerOptions().complianceLevel >= 0x300000L;
        switch (this.bits & 0xF) {
            case 1: {
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                    if (localBinding.declaringScope instanceof CompilationUnitScope) {
                        currentScope.problemReporter().uninitializedGlobalVariable(localBinding, this);
                    } else {
                        currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                    }
                }
                if ((flowInfo.tagBits & 1) == 0) {
                    localBinding.useFlag = 1;
                } else if (localBinding.useFlag == 0) {
                    localBinding.useFlag = 2;
                }
                this.checkNPE(currentScope, flowContext, flowInfo, true);
            }
        }
        if (needValue) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        }
        if (this.otherBindings != null) {
            int i = 0;
            while (i < otherBindingsCount) {
                TypeBinding lastReceiverType;
                boolean bl = i < otherBindingsCount - 1 ? !this.otherBindings[i + 1].isStatic() : (needValue = valueRequired);
                if ((needValue || complyTo14) && (lastReceiverType = this.getGenericCast(i)) == null) {
                    lastReceiverType = i == 0 ? ((VariableBinding)this.binding).type : this.otherBindings[i - 1].type;
                }
                ++i;
            }
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        MethodScope methodScope = scope.methodScope();
        if (this.indexOfFirstFieldBinding == 1 && methodScope.enclosingSourceType() == fieldBinding.original().declaringClass && methodScope.lastVisibleFieldID >= 0 && fieldBinding.id >= methodScope.lastVisibleFieldID && (!fieldBinding.isStatic() || methodScope.isStatic)) {
            scope.problemReporter().forwardReference(this, 0, methodScope.enclosingSourceType());
        }
        this.bits &= 0xFFFFFFF0;
        this.bits |= 1;
        return this.getOtherFieldBindings(scope);
    }

    public void checkNPE(BlockScope scope, FlowContext flowContext, FlowInfo flowInfo, boolean checkString) {
        LocalVariableBinding local;
        if ((this.bits & 0xF) == 2 && (local = (LocalVariableBinding)this.binding) != null && (local.type.tagBits & 2L) == 0L && (checkString || local.type.id != 11)) {
            if ((this.bits & 0x20000) == 0) {
                flowContext.recordUsingNullReference(scope, local, this, 3, flowInfo);
            }
            flowInfo.markAsComparedEqualToNonNull(local);
            if (flowContext.initsOnFinally != null) {
                flowContext.initsOnFinally.markAsComparedEqualToNonNull(local);
            }
        }
    }

    public void computeConversion(Scope scope, TypeBinding runtimeTimeType, TypeBinding compileTimeType) {
        int length;
        if (runtimeTimeType == null || compileTimeType == null) {
            return;
        }
        FieldBinding field = null;
        int n = length = this.otherBindings == null ? 0 : this.otherBindings.length;
        if (length == 0) {
            if ((this.bits & 1) != 0 && this.binding != null && this.binding.isValidBinding()) {
                field = (FieldBinding)this.binding;
            }
        } else {
            field = this.otherBindings[length - 1];
        }
        if (field != null) {
            field.original();
        }
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    protected FieldBinding getCodegenBinding(int index) {
        return (FieldBinding)this.binding;
    }

    protected TypeBinding getGenericCast(int index) {
        if (index == 0) {
            return this.genericCast;
        }
        if (this.otherGenericCasts == null) {
            return null;
        }
        return this.otherGenericCasts[index - 1];
    }

    public TypeBinding getOtherFieldBindings(BlockScope scope) {
        FieldBinding field;
        int length = this.tokens.length;
        if ((this.bits & 1) != 0) {
            field = (FieldBinding)this.binding;
            if (!field.isStatic()) {
                if (this.indexOfFirstFieldBinding > 1 || scope.methodScope().isStatic) {
                    scope.problemReporter().staticFieldAccessToNonStaticVariable(this, field);
                    return null;
                }
            } else if (this.indexOfFirstFieldBinding > 1 && field.declaringClass != this.actualReceiverType && field.declaringClass.canBeSeenBy(scope)) {
                scope.problemReporter().indirectAccessToStaticField(this, field);
            }
            if (this.isFieldUseDeprecated(field, scope, (this.bits & 0x2000) != 0 && this.indexOfFirstFieldBinding == length)) {
                scope.problemReporter().deprecatedField(field, this);
            }
        } else {
            field = null;
        }
        TypeBinding type = ((VariableBinding)this.binding).type;
        int index = this.indexOfFirstFieldBinding;
        if (index == length) {
            return type;
        }
        int otherBindingsLength = length - index;
        this.otherBindings = new FieldBinding[otherBindingsLength];
        this.otherCodegenBindings = this.otherBindings;
        this.otherDepths = new int[otherBindingsLength];
        int firstDepth = (this.bits & 0x1FE0) >> 5;
        while (index < length) {
            char[] token = this.tokens[index];
            if (type == null) {
                return null;
            }
            this.bits &= 0xFFFFE01F;
            FieldBinding previousField = field;
            field = scope.getField(type, token, this);
            int place = index - this.indexOfFirstFieldBinding;
            this.otherBindings[place] = field;
            this.otherDepths[place] = (this.bits & 0x1FE0) >> 5;
            if (field.isValidBinding()) {
                if (previousField != null) {
                    TypeBinding receiverErasure = type;
                    if (receiverErasure instanceof ReferenceBinding && receiverErasure.findSuperTypeWithSameErasure(field.declaringClass) == null) {
                        ReferenceBinding cfr_ignored_0 = field.declaringClass;
                    }
                    previousField.original();
                }
                if (this.isFieldUseDeprecated(field, scope, (this.bits & 0x2000) != 0 && index + 1 == length)) {
                    scope.problemReporter().deprecatedField(field, this);
                }
                if (field.isStatic()) {
                    scope.problemReporter().nonStaticAccessToStaticField(this, field);
                    if (field.declaringClass != type) {
                        scope.problemReporter().indirectAccessToStaticField(this, field);
                    }
                }
                type = field.type;
                ++index;
                continue;
            }
            this.constant = Constant.NotAConstant;
            scope.problemReporter().invalidField(this, field, index, type);
            this.setDepth(firstDepth);
            return null;
        }
        this.setDepth(firstDepth);
        type = this.otherBindings[otherBindingsLength - 1].type;
        return type;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            if ((this.bits & 0x1FE0) == 0 || this.constant != Constant.NotAConstant) {
                return;
            }
            if ((this.bits & 0xF) == 2) {
                currentScope.emulateOuterAccess((LocalVariableBinding)this.binding);
            }
        }
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    public Constant optimizedBooleanConstant() {
        switch (this.resolvedType.id) {
            case 5: 
            case 33: {
                if (this.constant != Constant.NotAConstant) {
                    return this.constant;
                }
                switch (this.bits & 0xF) {
                    case 1: {
                        if (this.otherBindings == null) {
                            return Constant.NotAConstant;
                        }
                    }
                    case 2: {
                        return Constant.NotAConstant;
                    }
                }
            }
        }
        return Constant.NotAConstant;
    }

    public TypeBinding postConversionType(Scope scope) {
        TypeBinding convertedType = this.resolvedType;
        TypeBinding requiredGenericCast = this.getGenericCast(this.otherCodegenBindings == null ? 0 : this.otherCodegenBindings.length);
        if (requiredGenericCast != null) {
            convertedType = requiredGenericCast;
        }
        int runtimeType = (this.implicitConversion & 0xFF) >> 4;
        switch (runtimeType) {
            case 5: {
                convertedType = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                convertedType = TypeBinding.BYTE;
                break;
            }
            case 4: {
                convertedType = TypeBinding.SHORT;
                break;
            }
            case 2: {
                convertedType = TypeBinding.CHAR;
                break;
            }
            case 10: {
                convertedType = TypeBinding.INT;
                break;
            }
            case 9: {
                convertedType = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                convertedType = TypeBinding.LONG;
                break;
            }
            case 8: {
                convertedType = TypeBinding.DOUBLE;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            convertedType = scope.environment().computeBoxingType(convertedType);
        }
        return convertedType;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        int i = 0;
        while (i < this.tokens.length) {
            if (i > 0) {
                output.append('.');
            }
            output.append(this.tokens[i]);
            ++i;
        }
        return output;
    }

    public TypeBinding reportError(BlockScope scope) {
        if (this.binding instanceof ProblemFieldBinding) {
            scope.problemReporter().invalidField(this, (FieldBinding)this.binding);
        } else if (this.binding instanceof ProblemReferenceBinding) {
            scope.problemReporter().invalidType(this, (TypeBinding)this.binding);
        } else {
            scope.problemReporter().unresolvableReference(this, this.binding);
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.actualReceiverType = scope.enclosingReceiverType();
        this.constant = Constant.NotAConstant;
        this.binding = scope.getBinding(this.tokens, this.bits & 0xF, (InvocationSite)this, true);
        if (this.binding.isValidBinding()) {
            switch (this.bits & 0xF) {
                case 3: 
                case 7: {
                    if (this.binding instanceof LocalVariableBinding) {
                        if ((this.bits & 0x1FE0) != 0) {
                            scope.problemReporter().cannotReferToNonFinalOuterLocal((LocalVariableBinding)this.binding, this);
                        }
                        this.bits &= 0xFFFFFFF0;
                        this.bits |= 2;
                        this.resolvedType = this.getOtherFieldBindings(scope);
                        return this.resolvedType;
                    }
                    if (this.binding instanceof FieldBinding) {
                        FieldBinding fieldBinding = (FieldBinding)this.binding;
                        MethodScope methodScope = scope.methodScope();
                        if (this.indexOfFirstFieldBinding == 1 && methodScope.enclosingSourceType() == fieldBinding.original().declaringClass && methodScope.lastVisibleFieldID >= 0 && fieldBinding.id >= methodScope.lastVisibleFieldID && (!fieldBinding.isStatic() || methodScope.isStatic)) {
                            scope.problemReporter().forwardReference(this, 0, methodScope.enclosingSourceType());
                        }
                        if (!fieldBinding.isStatic() && this.indexOfFirstFieldBinding == 1 && scope.compilerOptions().getSeverity(0x400000L) != -1) {
                            scope.problemReporter().unqualifiedFieldAccess(this, fieldBinding);
                        }
                        this.bits &= 0xFFFFFFF0;
                        this.bits |= 1;
                        this.resolvedType = this.getOtherFieldBindings(scope);
                        return this.resolvedType;
                    }
                    this.bits &= 0xFFFFFFF0;
                    this.bits |= 4;
                }
                case 4: {
                    TypeBinding type;
                    this.resolvedType = type = (TypeBinding)this.binding;
                    return this.resolvedType;
                }
            }
        }
        this.resolvedType = this.reportError(scope);
        return this.resolvedType;
    }

    protected void setCodegenBinding(int index, FieldBinding someCodegenBinding) {
    }

    public void setFieldIndex(int index) {
        this.indexOfFirstFieldBinding = index;
    }

    protected void setGenericCast(int index, TypeBinding someGenericCast) {
        if (index == 0) {
            this.genericCast = someGenericCast;
        } else {
            if (this.otherGenericCasts == null) {
                this.otherGenericCasts = new TypeBinding[this.otherBindings.length];
            }
            this.otherGenericCasts[index - 1] = someGenericCast;
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public String unboundReferenceErrorName() {
        return new String(this.tokens[0]);
    }

    public int getASTType() {
        return 86;
    }
}

