/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.IGenericType;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.Member;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyType;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.util.ASTNodeFinder;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;

public class HierarchyResolver
implements ITypeRequestor {
    private ReferenceBinding focusType;
    private boolean superTypesOnly;
    private boolean hasMissingSuperClass;
    LookupEnvironment lookupEnvironment;
    private CompilerOptions options;
    HierarchyBuilder builder;
    private ReferenceBinding[] typeBindings;
    HashSet processedUnits = new HashSet();
    private int typeIndex;
    private IGenericType[] typeModels;

    public HierarchyResolver(INameEnvironment nameEnvironment, Map settings, HierarchyBuilder builder, IProblemFactory problemFactory) {
        this.options = new CompilerOptions(settings);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        ProblemReporter problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        this.setEnvironment(new LookupEnvironment(this, this.options, problemReporter, nameEnvironment), builder);
    }

    public HierarchyResolver(LookupEnvironment lookupEnvironment, HierarchyBuilder builder) {
        this.setEnvironment(lookupEnvironment, builder);
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
    }

    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        if (this.processedUnits.contains(sourceUnit)) {
            return;
        }
        Parser parser = new Parser(this.lookupEnvironment.problemReporter, true);
        CompilationResult result = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration parsedUnit = parser.dietParse(sourceUnit, result);
        if (parsedUnit != null) {
            parser.inferTypes(parsedUnit, this.options);
            try {
                this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
                this.processedUnits.add(sourceUnit);
                this.rememberAllTypes(parsedUnit, sourceUnit, false);
                this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
            }
            catch (AbortCompilation abortCompilation) {}
        }
    }

    public void accept(LibraryAPIs libraryMetaData) {
        this.lookupEnvironment.buildTypeBindings(libraryMetaData);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        IProgressMonitor progressMonitor = this.builder.hierarchy.progressMonitor;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        CompilationResult result = new CompilationResult(sourceType.getFileName(), sourceType.getPackageName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{sourceType}, 8, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            try {
                this.lookupEnvironment.buildTypeBindings(unit, accessRestriction);
                IJavaScriptUnit cu = ((SourceTypeElementInfo)sourceType).getHandle().getJavaScriptUnit();
                this.rememberAllTypes(unit, cu, false);
                this.lookupEnvironment.completeTypeBindings(unit, true);
            }
            catch (AbortCompilation abortCompilation) {}
        }
    }

    private IType findSuperClass(IGenericType type, ReferenceBinding typeBinding) {
        ReferenceBinding superBinding = typeBinding.superclass();
        if (superBinding != null) {
            if (typeBinding.isHierarchyInconsistent()) {
                if (superBinding.problemId() == 1) {
                    this.hasMissingSuperClass = true;
                    this.builder.hierarchy.missingTypes.add(new String(superBinding.sourceName));
                    return null;
                }
                if (superBinding.id == 1) {
                    int separator;
                    char[] superclassName;
                    if (type instanceof IBinaryType) {
                        superclassName = ((IBinaryType)type).getSuperclassName();
                        separator = 47;
                    } else if (type instanceof ISourceType) {
                        superclassName = ((ISourceType)type).getSuperclassName();
                        separator = 46;
                    } else if (type instanceof HierarchyType) {
                        superclassName = ((HierarchyType)type).superclassName;
                        separator = 46;
                    } else {
                        return null;
                    }
                    if (superclassName != null) {
                        char[] simpleName;
                        int lastSeparator = CharOperation.lastIndexOf((char)separator, superclassName);
                        char[] cArray = simpleName = lastSeparator == -1 ? superclassName : CharOperation.subarray(superclassName, lastSeparator + 1, superclassName.length);
                        if (!CharOperation.equals(simpleName, TypeConstants.OBJECT)) {
                            this.hasMissingSuperClass = true;
                            this.builder.hierarchy.missingTypes.add(new String(simpleName));
                            return null;
                        }
                    }
                }
            }
            int t = this.typeIndex;
            while (t >= 0) {
                if (this.typeBindings[t] == superBinding) {
                    return this.builder.getHandle(this.typeModels[t], superBinding);
                }
                --t;
            }
        }
        return null;
    }

    private void fixSupertypeBindings() {
        int current = this.typeIndex;
        while (current >= 0) {
            ReferenceBinding typeBinding = this.typeBindings[current];
            if (typeBinding instanceof SourceTypeBinding) {
                ClassScope scope = (ClassScope)((SourceTypeBinding)typeBinding).scope;
                if (scope != null) {
                    TypeBinding superclass;
                    TypeDeclaration typeDeclaration = scope.referenceContext;
                    TypeReference superclassRef = typeDeclaration == null ? null : typeDeclaration.superclass;
                    TypeBinding typeBinding2 = superclass = superclassRef == null ? null : superclassRef.resolvedType;
                    if (superclass instanceof ProblemReferenceBinding) {
                        superclass = ((ProblemReferenceBinding)superclass).closestMatch();
                    }
                    if (superclass != null) {
                        ((SourceTypeBinding)typeBinding).superclass = (ReferenceBinding)superclass;
                    }
                }
            } else if (typeBinding instanceof BinaryTypeBinding) {
                try {
                    typeBinding.superclass();
                }
                catch (AbortCompilation abortCompilation) {
                    ((BinaryTypeBinding)typeBinding).tagBits &= 0xFFFFFFFFFDFFFFFFL;
                    this.builder.hierarchy.missingTypes.add(new String(typeBinding.superclass().sourceName()));
                    this.hasMissingSuperClass = true;
                }
            }
            --current;
        }
    }

    private void remember(IGenericType suppliedType, ReferenceBinding typeBinding) {
        if (typeBinding == null) {
            return;
        }
        if (++this.typeIndex == this.typeModels.length) {
            this.typeModels = new IGenericType[this.typeIndex * 2];
            System.arraycopy(this.typeModels, 0, this.typeModels, 0, this.typeIndex);
            this.typeBindings = new ReferenceBinding[this.typeIndex * 2];
            System.arraycopy(this.typeBindings, 0, this.typeBindings, 0, this.typeIndex);
        }
        this.typeModels[this.typeIndex] = suppliedType;
        this.typeBindings[this.typeIndex] = typeBinding;
    }

    private void remember(IType type, ReferenceBinding typeBinding) {
        if (((CompilationUnit)type.getJavaScriptUnit()).isOpen()) {
            try {
                IGenericType genericType = (IGenericType)((JavaElement)((Object)type)).getElementInfo();
                this.remember(genericType, typeBinding);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return;
            }
        } else {
            if (typeBinding == null) {
                return;
            }
            TypeDeclaration typeDeclaration = ((ClassScope)((SourceTypeBinding)typeBinding).scope).referenceType();
            char[] superclassName = null;
            TypeReference superclass = (typeDeclaration.bits & 0x200) != 0 ? typeDeclaration.allocation.type : typeDeclaration.superclass;
            if (superclass != null) {
                char[][] typeName = superclass.getTypeName();
                superclassName = typeName == null ? null : typeName[typeName.length - 1];
            }
            char[][] superInterfaceNames = null;
            HierarchyType hierarchyType = new HierarchyType(type, typeDeclaration.name, typeDeclaration.binding.modifiers, superclassName, superInterfaceNames);
            this.remember(hierarchyType, (ReferenceBinding)typeDeclaration.binding);
        }
    }

    private void rememberInferredType(InferredType inferredType, IType type, ReferenceBinding typeBinding) {
        if (type.getJavaScriptUnit() != null && ((CompilationUnit)type.getJavaScriptUnit()).isOpen()) {
            try {
                IGenericType genericType = (IGenericType)((JavaElement)((Object)type)).getElementInfo();
                this.remember(genericType, typeBinding);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return;
            }
        } else {
            if (typeBinding == null) {
                return;
            }
            char[] superclassName = inferredType.getSuperClassName();
            char[][] superInterfaceNames = null;
            HierarchyType hierarchyType = new HierarchyType(type, inferredType.getName(), 0, superclassName, superInterfaceNames);
            this.remember(hierarchyType, (ReferenceBinding)inferredType.binding);
        }
    }

    private void rememberAllTypes(CompilationUnitDeclaration parsedUnit, Object container, boolean includeLocalTypes) {
        int i;
        IJavaScriptUnit cu = container instanceof IJavaScriptUnit ? (IJavaScriptUnit)container : null;
        IClassFile classFile = container instanceof IClassFile ? (IClassFile)container : null;
        TypeDeclaration[] types = parsedUnit.types;
        if (types != null) {
            i = 0;
            int length = types.length;
            while (i < length) {
                TypeDeclaration type = types[i];
                IType typeHandle = cu != null ? cu.getType(new String(type.name)) : classFile.getType(new String(type.name));
                this.rememberWithMemberTypes(type, typeHandle);
                ++i;
            }
        }
        i = 0;
        while (i < parsedUnit.numberInferredTypes) {
            InferredType inferredType = parsedUnit.inferredTypes[i];
            if (inferredType.isDefinition && !inferredType.isEmptyGlobal()) {
                IType typeHandle = cu != null ? cu.getType(new String(inferredType.getName())) : classFile.getType(new String(inferredType.getName()));
                this.rememberInferredType(inferredType, typeHandle, inferredType.binding);
            }
            ++i;
        }
    }

    private void rememberWithMemberTypes(TypeDeclaration typeDecl, IType typeHandle) {
        this.remember(typeHandle, (ReferenceBinding)typeDecl.binding);
        TypeDeclaration[] memberTypes = typeDecl.memberTypes;
        if (memberTypes != null) {
            int i = 0;
            int length = memberTypes.length;
            while (i < length) {
                TypeDeclaration memberType = memberTypes[i];
                this.rememberWithMemberTypes(memberType, typeHandle.getType(new String(memberType.name)));
                ++i;
            }
        }
    }

    private void reportHierarchy(IType focus, CompilationUnitDeclaration parsedUnit, ReferenceBinding binaryTypeBinding) {
        if (focus != null) {
            if (binaryTypeBinding != null) {
                this.focusType = binaryTypeBinding;
            } else {
                Member declaringMember = ((Member)((Object)focus)).getOuterMostLocalContext();
                if (declaringMember == null) {
                    char[] fullyQualifiedName = focus.getElementName().toCharArray();
                    this.setFocusType(CharOperation.splitOn('.', fullyQualifiedName));
                } else if (parsedUnit != null) {
                    ASTNodeFinder nodeFinder = new ASTNodeFinder(parsedUnit);
                    InferredType inferredType = nodeFinder.findInferredType(focus);
                    if (inferredType != null) {
                        this.focusType = inferredType.binding;
                    } else {
                        TypeDeclaration typeDecl = nodeFinder.findType(focus);
                        if (typeDecl != null) {
                            this.focusType = typeDecl.binding;
                        }
                    }
                }
            }
        }
        this.fixSupertypeBindings();
        int objectIndex = -1;
        int current = this.typeIndex;
        while (current >= 0) {
            ReferenceBinding typeBinding = this.typeBindings[current];
            if (typeBinding.id == 1) {
                objectIndex = current;
            } else {
                IGenericType suppliedType = this.typeModels[current];
                if (this.subOrSuperOfFocus(typeBinding)) {
                    IType superclass = this.findSuperClass(suppliedType, typeBinding);
                    IType[] superinterfaces = new IType[]{};
                    this.builder.connect(suppliedType, this.builder.getHandle(suppliedType, typeBinding), superclass, superinterfaces);
                }
            }
            --current;
        }
        if (!this.hasMissingSuperClass && objectIndex > -1) {
            IGenericType objectType = this.typeModels[objectIndex];
            this.builder.connect(objectType, this.builder.getHandle(objectType, this.typeBindings[objectIndex]), null, null);
        }
    }

    private void reset() {
        this.lookupEnvironment.reset();
        this.focusType = null;
        this.superTypesOnly = false;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(IGenericType suppliedType) {
        try {
            try {
                block9: {
                    if (!suppliedType.isBinaryType()) break block9;
                    binaryTypeBinding = this.lookupEnvironment.cacheBinaryType((ISourceType)suppliedType, false, null);
                    this.remember(suppliedType, (ReferenceBinding)binaryTypeBinding);
                    i = startIndex = this.typeIndex;
                    if (true) ** GOTO lbl27
                }
                cu = ((SourceTypeElementInfo)suppliedType).getHandle().getJavaScriptUnit();
                localTypes = new HashSet<String>();
                localTypes.add(cu.getPath().toString());
                this.superTypesOnly = true;
                this.resolve(new Openable[]{(Openable)cu}, localTypes, null);
            }
            catch (AbortCompilation v0) {}
            ** GOTO lbl-1000
            do {
                if ((igType = this.typeModels[i]) != null && igType.isBinaryType()) {
                    try {
                        typeBinding = this.typeBindings[i];
                        typeBinding.superclass();
                    }
                    catch (AbortCompilation v1) {}
                }
                ++i;
lbl27:
                // 2 sources

            } while (i <= this.typeIndex);
            this.superTypesOnly = true;
            this.reportHierarchy(this.builder.getType(), null, binaryTypeBinding);
        }
        catch (Throwable var8_9) {
            var7_10 = null;
            this.reset();
            throw var8_9;
        }
lbl-1000:
        // 3 sources

        {
            var7_11 = null;
            this.reset();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(Openable[] openables, HashSet localTypes, IProgressMonitor monitor) {
        try {
            block41: {
                try {
                    CompilationUnitDeclaration parsedUnit;
                    int openablesLength = openables.length;
                    CompilationUnitDeclaration[] parsedUnits = new CompilationUnitDeclaration[openablesLength];
                    boolean[] hasLocalType = new boolean[openablesLength];
                    IJavaScriptUnit[] cus = new IJavaScriptUnit[openablesLength];
                    int unitsIndex = 0;
                    CompilationUnitDeclaration focusUnit = null;
                    ReferenceBinding focusBinaryBinding = null;
                    IType focus = this.builder.getType();
                    Openable focusOpenable = null;
                    if (focus != null) {
                        focusOpenable = focus.isBinary() ? (Openable)((Object)focus.getClassFile()) : (Openable)((Object)focus.getJavaScriptUnit());
                    }
                    this.processedUnits = new HashSet();
                    Parser parser = new Parser(this.lookupEnvironment.problemReporter, true);
                    int i = 0;
                    while (i < openablesLength) {
                        block40: {
                            Openable openable;
                            block42: {
                                openable = openables[i];
                                if (!(openable instanceof IJavaScriptUnit)) break block42;
                                IJavaScriptUnit cu = (IJavaScriptUnit)((Object)openable);
                                boolean containsLocalType = false;
                                if (localTypes == null) {
                                    containsLocalType = true;
                                } else {
                                    IPath path = cu.getPath();
                                    containsLocalType = localTypes.contains(path.toString());
                                }
                                CompilationUnitDeclaration parsedUnit2 = null;
                                if (cu.isOpen()) {
                                    CompilationResult result = new CompilationResult(((ICompilationUnit)((Object)cu)).getFileName(), ((ICompilationUnit)((Object)cu)).getPackageName(), i, openablesLength, this.options.maxProblemsPerUnit);
                                    ISourceType[] typeInfos = null;
                                    try {
                                        IType[] topLevelTypes = cu.getTypes();
                                        int topLevelLength = topLevelTypes.length;
                                        if (topLevelLength == 0) break block40;
                                        typeInfos = new SourceTypeElementInfo[topLevelLength];
                                        int j = 0;
                                        while (j < topLevelLength) {
                                            IType topLevelType = topLevelTypes[j];
                                            typeInfos[j] = (SourceTypeElementInfo)((JavaElement)((Object)topLevelType)).getElementInfo();
                                            ++j;
                                        }
                                    }
                                    catch (JavaScriptModelException javaScriptModelException) {}
                                    int flags = !containsLocalType ? 8 : 47;
                                    parsedUnit2 = SourceTypeConverter.buildCompilationUnit(typeInfos, flags, this.lookupEnvironment.problemReporter, result);
                                    if (containsLocalType) {
                                        parsedUnit2.bits |= 0x10;
                                    }
                                } else {
                                    IFile file = (IFile)cu.getResource();
                                    ICompilationUnit sourceUnit = this.builder.createCompilationUnitFromPath(openable, file);
                                    CompilationResult unitResult = new CompilationResult(sourceUnit, i, openablesLength, this.options.maxProblemsPerUnit);
                                    parsedUnit2 = parser.dietParse(sourceUnit, unitResult);
                                }
                                if (parsedUnit2 != null) {
                                    parser.inferTypes(parsedUnit2, this.options);
                                    hasLocalType[unitsIndex] = containsLocalType;
                                    cus[unitsIndex] = cu;
                                    parsedUnits[unitsIndex++] = parsedUnit2;
                                    try {
                                        if (!this.processedUnits.contains(openable)) {
                                            this.lookupEnvironment.buildTypeBindings(parsedUnit2, null);
                                        }
                                        this.processedUnits.add(openable);
                                        if (openable.equals(focusOpenable)) {
                                            focusUnit = parsedUnit2;
                                        }
                                        break block40;
                                    }
                                    catch (AbortCompilation abortCompilation) {}
                                }
                                break block40;
                            }
                            ClassFile classFile = (ClassFile)openable;
                            org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit sourceUnit = new org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit(null, new String(classFile.getFileName()), this.options.defaultEncoding);
                            sourceUnit.packageName = Util.toCharArrays(new String[]{classFile.getParent().getElementName()});
                            CompilationResult unitResult = new CompilationResult(sourceUnit, i, openablesLength, this.options.maxProblemsPerUnit);
                            CompilationUnitDeclaration parsedUnit3 = parser.dietParse(sourceUnit, unitResult);
                            if (parsedUnit3 != null) {
                                parser.inferTypes(parsedUnit3, this.options);
                                hasLocalType[unitsIndex] = true;
                                cus[unitsIndex] = null;
                                parsedUnits[unitsIndex++] = parsedUnit3;
                                try {
                                    this.lookupEnvironment.buildTypeBindings(parsedUnit3, null);
                                    if (openable.equals(focusOpenable)) {
                                        focusUnit = parsedUnit3;
                                    }
                                }
                                catch (AbortCompilation abortCompilation) {}
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i <= this.typeIndex) {
                        IGenericType suppliedType = this.typeModels[i];
                        if (suppliedType != null && suppliedType.isBinaryType()) {
                            try {
                                ReferenceBinding typeBinding = this.typeBindings[i];
                                typeBinding.superclass();
                            }
                            catch (AbortCompilation abortCompilation) {}
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < unitsIndex) {
                        parsedUnit = parsedUnits[i];
                        if (parsedUnit != null) {
                            try {
                                boolean containsLocalType = hasLocalType[i];
                                if (containsLocalType) {
                                    parser.getMethodBodies(parsedUnit);
                                }
                                this.lookupEnvironment.completeTypeBindings(parsedUnit, containsLocalType);
                            }
                            catch (AbortCompilation abortCompilation) {
                                hasLocalType[i] = false;
                            }
                        }
                        this.worked(monitor, 1);
                        ++i;
                    }
                    i = 0;
                    while (i < unitsIndex) {
                        parsedUnit = parsedUnits[i];
                        if (parsedUnit != null) {
                            boolean containsLocalType = hasLocalType[i];
                            if (containsLocalType) {
                                parsedUnit.scope.faultInTypes();
                                parsedUnit.resolve();
                            }
                            this.rememberAllTypes(parsedUnit, openables[i], containsLocalType);
                        }
                        ++i;
                    }
                    if (focusBinaryBinding == null && focus != null && focus.isBinary()) {
                        char[] typeName = focus.getElementName().toCharArray();
                        char[] pkgName = focus.getPackageFragment().getElementName().toCharArray();
                        char[][] qualifiedName = new char[][]{pkgName, typeName};
                        focusBinaryBinding = this.lookupEnvironment.getCachedType(qualifiedName);
                        if (focusBinaryBinding == null) {
                            qualifiedName = new char[][]{typeName};
                            focusBinaryBinding = this.lookupEnvironment.getCachedType(qualifiedName);
                        }
                        if (focusBinaryBinding == null) {
                            Object var25_33 = null;
                            this.reset();
                            return;
                        }
                    }
                    this.reportHierarchy(focus, focusUnit, focusBinaryBinding);
                }
                catch (ClassCastException classCastException) {
                }
                catch (AbortCompilation e) {
                    if (!TypeHierarchy.DEBUG) break block41;
                    e.printStackTrace();
                }
            }
            Object var25_35 = null;
            this.reset();
            return;
        }
        catch (Throwable throwable) {
            Object var25_34 = null;
            this.reset();
            throw throwable;
        }
    }

    private void setEnvironment(LookupEnvironment lookupEnvironment, HierarchyBuilder builder) {
        this.lookupEnvironment = lookupEnvironment;
        this.builder = builder;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
    }

    public ReferenceBinding setFocusType(char[][] compoundName) {
        if (compoundName == null || this.lookupEnvironment == null) {
            return null;
        }
        this.focusType = this.lookupEnvironment.getCachedType(compoundName);
        if (this.focusType == null) {
            this.focusType = this.lookupEnvironment.askForType(compoundName);
        }
        if (this.focusType == null) {
            char[][] singleName = new char[][]{CharOperation.concatWith(compoundName, '.')};
            this.focusType = this.lookupEnvironment.getCachedType(singleName);
            if (this.focusType == null) {
                this.focusType = this.lookupEnvironment.askForType(singleName);
            }
        }
        return this.focusType;
    }

    public boolean subOrSuperOfFocus(ReferenceBinding typeBinding) {
        block5: {
            if (this.focusType == null) {
                return true;
            }
            try {
                if (!this.subTypeOfType(this.focusType, typeBinding)) break block5;
                return true;
            }
            catch (AbortCompilation abortCompilation) {}
        }
        if (!this.superTypesOnly && this.subTypeOfType(typeBinding, this.focusType)) {
            return true;
        }
        return false;
    }

    private boolean subTypeOfType(ReferenceBinding subType, ReferenceBinding typeBinding) {
        if (typeBinding == null || subType == null) {
            return false;
        }
        if (subType == typeBinding) {
            return true;
        }
        ReferenceBinding superclass = subType.superclass();
        if (superclass != null && superclass.id == 1 && subType.isHierarchyInconsistent()) {
            return false;
        }
        return this.subTypeOfType(superclass, typeBinding);
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    public CompilationUnitDeclaration doParse(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        Parser parser = new Parser(this.lookupEnvironment.problemReporter, true);
        CompilationResult unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration declaration = parser.dietParse(sourceUnit, unitResult);
        parser.inferTypes(declaration, this.options);
        return declaration;
    }
}

