/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;

public class MatchLocatorParser
extends Parser {
    MatchingNodeSet nodeSet;
    PatternLocator patternLocator;
    private ASTVisitor localDeclarationVisitor;

    public static MatchLocatorParser createParser(ProblemReporter problemReporter, MatchLocator locator) {
        return new MatchLocatorParser(problemReporter, locator);
    }

    protected MatchLocatorParser(ProblemReporter problemReporter, MatchLocator locator) {
        super(problemReporter, true);
        this.reportOnlyOneSyntaxError = true;
        this.patternLocator = locator.patternLocator;
        this.localDeclarationVisitor = (locator.matchContainer & 2) != 0 ? ((locator.matchContainer & 4) != 0 ? new ClassAndMethodDeclarationVisitor() : new ClassButNoMethodDeclarationVisitor()) : ((locator.matchContainer & 4) != 0 ? new MethodButNoClassDeclarationVisitor() : new NoClassNoMethodDeclarationVisitor());
    }

    public void checkComment() {
        super.checkComment();
        if (this.javadocParser.checkDocComment && this.javadoc != null) {
            Expression[] references;
            TypeReference[] thrownExceptions;
            JavadocSingleTypeReference[] paramTypeParameters;
            JavadocSingleNameReference[] paramReferences = this.javadoc.paramReferences;
            if (paramReferences != null) {
                int i = 0;
                int length = paramReferences.length;
                while (i < length) {
                    this.patternLocator.match(paramReferences[i], this.nodeSet);
                    ++i;
                }
            }
            if ((paramTypeParameters = this.javadoc.paramTypeParameters) != null) {
                int i = 0;
                int length = paramTypeParameters.length;
                while (i < length) {
                    this.patternLocator.match(paramTypeParameters[i], this.nodeSet);
                    ++i;
                }
            }
            if ((thrownExceptions = this.javadoc.exceptionReferences) != null) {
                int i = 0;
                int length = thrownExceptions.length;
                while (i < length) {
                    this.patternLocator.match(thrownExceptions[i], this.nodeSet);
                    ++i;
                }
            }
            if ((references = this.javadoc.seeReferences) != null) {
                int i = 0;
                int length = references.length;
                while (i < length) {
                    JavadocArgumentExpression argument;
                    int al;
                    Expression reference = references[i];
                    if (reference instanceof TypeReference) {
                        TypeReference typeRef = (TypeReference)reference;
                        this.patternLocator.match(typeRef, this.nodeSet);
                    } else if (reference instanceof JavadocFieldReference) {
                        JavadocFieldReference fieldRef = (JavadocFieldReference)reference;
                        this.patternLocator.match(fieldRef, this.nodeSet);
                        if (fieldRef.receiver instanceof TypeReference && !fieldRef.receiver.isThis()) {
                            TypeReference typeRef = (TypeReference)fieldRef.receiver;
                            this.patternLocator.match(typeRef, this.nodeSet);
                        }
                    } else if (reference instanceof JavadocMessageSend) {
                        JavadocMessageSend messageSend = (JavadocMessageSend)reference;
                        this.patternLocator.match(messageSend, this.nodeSet);
                        if (messageSend.receiver instanceof TypeReference && !messageSend.receiver.isThis()) {
                            TypeReference typeRef = (TypeReference)messageSend.receiver;
                            this.patternLocator.match(typeRef, this.nodeSet);
                        }
                        if (messageSend.arguments != null) {
                            int a = 0;
                            al = messageSend.arguments.length;
                            while (a < al) {
                                argument = (JavadocArgumentExpression)messageSend.arguments[a];
                                if (argument.argument != null && argument.argument.type != null) {
                                    this.patternLocator.match(argument.argument.type, this.nodeSet);
                                }
                                ++a;
                            }
                        }
                    } else if (reference instanceof JavadocAllocationExpression) {
                        JavadocAllocationExpression constructor = (JavadocAllocationExpression)reference;
                        this.patternLocator.match(constructor, this.nodeSet);
                        if (constructor.type != null && !constructor.type.isThis()) {
                            this.patternLocator.match(constructor.type, this.nodeSet);
                        }
                        if (constructor.arguments != null) {
                            int a = 0;
                            al = constructor.arguments.length;
                            while (a < al) {
                                this.patternLocator.match(constructor.arguments[a], this.nodeSet);
                                argument = (JavadocArgumentExpression)constructor.arguments[a];
                                if (argument.argument != null && argument.argument.type != null) {
                                    this.patternLocator.match(argument.argument.type, this.nodeSet);
                                }
                                ++a;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void classInstanceCreation(boolean alwaysQualified, boolean isShort) {
        super.classInstanceCreation(alwaysQualified, isShort);
        this.patternLocator.match(this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeAssignment() {
        super.consumeAssignment();
        this.patternLocator.match(this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeFieldAccess(boolean isSuperAccess) {
        super.consumeFieldAccess(isSuperAccess);
        this.patternLocator.match((Reference)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumePropertyOperator() {
        super.consumePropertyOperator();
        this.patternLocator.match((Reference)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeFormalParameter(boolean isVarArgs) {
        super.consumeFormalParameter(isVarArgs);
        this.patternLocator.match((LocalDeclaration)this.astStack[this.astPtr], this.nodeSet);
    }

    protected void consumeLocalVariableDeclaration() {
        super.consumeLocalVariableDeclaration();
        this.patternLocator.match((LocalDeclaration)this.astStack[this.astPtr], this.nodeSet);
    }

    protected void consumeMethodInvocationPrimary() {
        super.consumeMethodInvocationPrimary();
        this.patternLocator.match((MessageSend)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumePrimaryNoNewArray() {
        --this.intPtr;
        --this.intPtr;
    }

    protected void consumeUnaryExpression(int op, boolean post) {
        super.consumeUnaryExpression(op, post);
        this.patternLocator.match(this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected TypeReference copyDims(TypeReference typeRef, int dim) {
        TypeReference result = super.copyDims(typeRef, dim);
        if (this.nodeSet.removePossibleMatch(typeRef) != null) {
            this.nodeSet.addPossibleMatch(result);
        } else if (this.nodeSet.removeTrustedMatch(typeRef) != null) {
            this.nodeSet.addTrustedMatch((ASTNode)result, true);
        }
        return result;
    }

    protected TypeReference getTypeReference(int dim) {
        TypeReference typeRef = super.getTypeReference(dim);
        this.patternLocator.match(typeRef, this.nodeSet);
        return typeRef;
    }

    protected NameReference getUnspecifiedReference() {
        NameReference nameRef = super.getUnspecifiedReference();
        this.patternLocator.match(nameRef, this.nodeSet);
        return nameRef;
    }

    protected NameReference getUnspecifiedReferenceOptimized() {
        NameReference nameRef = super.getUnspecifiedReferenceOptimized();
        this.patternLocator.match(nameRef, this.nodeSet);
        return nameRef;
    }

    public void parseBodies(CompilationUnitDeclaration unit) {
        ProgramElement[] statements;
        TypeDeclaration[] types = unit.types;
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                TypeDeclaration type = types[i];
                this.patternLocator.match(type, this.nodeSet);
                this.parseBodies(type, unit);
                ++i;
            }
        }
        if ((statements = unit.statements) != null) {
            int i = 0;
            while (i < statements.length) {
                if (statements[i] instanceof LocalDeclaration) {
                    ((LocalDeclaration)statements[i]).traverse(this.localDeclarationVisitor, null);
                    if (this.patternLocator instanceof FieldLocator) {
                        ((FieldLocator)this.patternLocator).matchLocalDeclaration((LocalDeclaration)statements[i], this.nodeSet);
                    }
                } else if (statements[i] instanceof AbstractMethodDeclaration) {
                    AbstractMethodDeclaration methodDeclaration = (AbstractMethodDeclaration)statements[i];
                    methodDeclaration.traverse(this.localDeclarationVisitor, (Scope)null);
                    if (this.patternLocator instanceof MethodLocator) {
                        ((MethodLocator)this.patternLocator).match((MethodDeclaration)statements[i], this.nodeSet);
                    }
                }
                ++i;
            }
        }
        unit.traverseInferredTypes(this.localDeclarationVisitor, null);
    }

    protected void parseBodies(TypeDeclaration type, CompilationUnitDeclaration unit) {
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields = type.fields;
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                FieldDeclaration field = fields[i];
                if (field instanceof Initializer) {
                    this.parse((Initializer)field, type, unit);
                }
                field.traverse(this.localDeclarationVisitor, null);
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int i = 0;
            while (i < methods.length) {
                AbstractMethodDeclaration method = methods[i];
                if (method.sourceStart >= type.bodyStart) {
                    if (method instanceof MethodDeclaration) {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)method;
                        this.parse(methodDeclaration, unit);
                        methodDeclaration.traverse(this.localDeclarationVisitor, (Scope)null);
                    } else if (method instanceof ConstructorDeclaration) {
                        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)method;
                        this.parse(constructorDeclaration, unit);
                        constructorDeclaration.traverse(this.localDeclarationVisitor, (Scope)null);
                    }
                } else if (method.isDefaultConstructor()) {
                    method.parseStatements(this, unit);
                }
                ++i;
            }
        }
    }

    public class ClassAndMethodDeclarationVisitor
    extends ClassButNoMethodDeclarationVisitor {
        public boolean visit(TypeDeclaration localTypeDeclaration, Scope scope) {
            MatchLocatorParser.this.patternLocator.match(localTypeDeclaration, MatchLocatorParser.this.nodeSet);
            return true;
        }

        public boolean visit(InferredType localTypeDeclaration, BlockScope scope) {
            MatchLocatorParser.this.patternLocator.match(localTypeDeclaration, MatchLocatorParser.this.nodeSet);
            return true;
        }
    }

    public class ClassButNoMethodDeclarationVisitor
    extends ASTVisitor {
        public boolean visit(ConstructorDeclaration constructorDeclaration, Scope scope) {
            MatchLocatorParser.this.patternLocator.match(constructorDeclaration, MatchLocatorParser.this.nodeSet);
            return (constructorDeclaration.bits & 2) != 0;
        }

        public boolean visit(FieldDeclaration fieldDeclaration, Scope scope) {
            MatchLocatorParser.this.patternLocator.match(fieldDeclaration, MatchLocatorParser.this.nodeSet);
            return (fieldDeclaration.bits & 2) != 0;
        }

        public boolean visit(InferredAttribute field, BlockScope scope) {
            MatchLocatorParser.this.patternLocator.match(field, MatchLocatorParser.this.nodeSet);
            return false;
        }

        public boolean visit(Initializer initializer, MethodScope scope) {
            MatchLocatorParser.this.patternLocator.match(initializer, MatchLocatorParser.this.nodeSet);
            return (initializer.bits & 2) != 0;
        }

        public boolean visit(TypeDeclaration memberTypeDeclaration, Scope scope) {
            MatchLocatorParser.this.patternLocator.match(memberTypeDeclaration, MatchLocatorParser.this.nodeSet);
            return true;
        }

        public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
            MatchLocatorParser.this.patternLocator.match(methodDeclaration, MatchLocatorParser.this.nodeSet);
            return (methodDeclaration.bits & 2) != 0;
        }

        public boolean visit(InferredMethod inferredMethod, BlockScope scope) {
            MatchLocatorParser.this.patternLocator.match(inferredMethod, MatchLocatorParser.this.nodeSet);
            return false;
        }
    }

    public class MethodButNoClassDeclarationVisitor
    extends NoClassNoMethodDeclarationVisitor {
        public boolean visit(TypeDeclaration localTypeDeclaration, Scope scope) {
            MatchLocatorParser.this.patternLocator.match(localTypeDeclaration, MatchLocatorParser.this.nodeSet);
            return true;
        }

        public boolean visit(InferredType localTypeDeclaration, BlockScope scope) {
            MatchLocatorParser.this.patternLocator.match(localTypeDeclaration, MatchLocatorParser.this.nodeSet);
            return true;
        }
    }

    public class NoClassNoMethodDeclarationVisitor
    extends ASTVisitor {
        public boolean visit(ConstructorDeclaration constructorDeclaration, Scope scope) {
            return (constructorDeclaration.bits & 2) != 0;
        }

        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
            return (fieldDeclaration.bits & 2) != 0;
        }

        public boolean visit(Initializer initializer, MethodScope scope) {
            return (initializer.bits & 2) != 0;
        }

        public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
            return (methodDeclaration.bits & 2) != 0;
        }
    }
}

