/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.NamingConventions;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public final class StubUtility2 {
    public static void addOverrideAnnotation(ASTRewrite rewrite, FunctionDeclaration decl, IFunctionBinding binding) {
        binding.getJavaElement().getJavaScriptProject().getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
    }

    public static FunctionDeclaration createConstructorStub(IJavaScriptUnit unit, ASTRewrite rewrite, ImportRewrite imports, IFunctionBinding binding, String type, int modifiers, boolean omitSuperForDefConst, boolean todo, CodeGenerationSettings settings) throws CoreException {
        String string;
        AST ast = rewrite.getAST();
        FunctionDeclaration decl = ast.newFunctionDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(type));
        decl.setConstructor(true);
        List parameters = StubUtility2.createParameters(unit, imports, ast, binding, decl, null);
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaScriptElement)unit);
        String bodyStatement = "";
        if (!omitSuperForDefConst || !parameters.isEmpty()) {
            SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
            SingleVariableDeclaration varDecl = null;
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                varDecl = (SingleVariableDeclaration)iterator.next();
                invocation.arguments().add(ast.newSimpleName(varDecl.getName().getIdentifier()));
            }
            bodyStatement = ASTNodes.asFormattedString((ASTNode)invocation, 0, delimiter, unit.getJavaScriptProject().getOptions(true));
        }
        if (todo) {
            String placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), true, bodyStatement, delimiter);
            if (placeHolder != null) {
                ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        } else {
            ASTNode statementNode = rewrite.createStringPlaceholder(bodyStatement, 41);
            body.statements().add(statementNode);
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            JSdoc javadoc = (JSdoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    public static FunctionDeclaration createConstructorStub(IJavaScriptUnit unit, ASTRewrite rewrite, ImportRewrite imports, ITypeBinding typeBinding, AST ast, IFunctionBinding superConstructor, IVariableBinding[] variableBindings, int modifiers, CodeGenerationSettings settings) throws CoreException {
        String string;
        FunctionDeclaration decl = ast.newFunctionDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(typeBinding.getName()));
        decl.setConstructor(true);
        List parameters = decl.parameters();
        if (superConstructor != null) {
            StubUtility2.createParameters(unit, imports, ast, superConstructor, decl, null);
        }
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaScriptElement)unit);
        if (superConstructor != null) {
            SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
            SingleVariableDeclaration varDecl = null;
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                varDecl = (SingleVariableDeclaration)iterator.next();
                invocation.arguments().add(ast.newSimpleName(varDecl.getName().getIdentifier()));
            }
            body.statements().add(invocation);
        }
        ArrayList<String> prohibited = new ArrayList<String>();
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            prohibited.add(((SingleVariableDeclaration)iterator.next()).getName().getIdentifier());
        }
        String param = null;
        ArrayList<String> list = new ArrayList<String>(prohibited);
        String[] excluded = null;
        int i = 0;
        while (i < variableBindings.length) {
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            var.setType(imports.addImport(variableBindings[i].getType(), ast));
            excluded = new String[list.size()];
            list.toArray(excluded);
            param = StubUtility2.getParameterName(unit, variableBindings[i], excluded);
            list.add(param);
            var.setName(ast.newSimpleName(param));
            parameters.add(var);
            ++i;
        }
        list = new ArrayList(prohibited);
        i = 0;
        while (i < variableBindings.length) {
            excluded = new String[list.size()];
            list.toArray(excluded);
            String paramName = StubUtility2.getParameterName(unit, variableBindings[i], excluded);
            list.add(paramName);
            String fieldName = variableBindings[i].getName();
            SimpleName expression = null;
            if (paramName.equals(fieldName) || settings.useKeywordThis) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(fieldName));
                expression = access;
            } else {
                expression = ast.newSimpleName(fieldName);
            }
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)expression);
            assignment.setRightHandSide((Expression)ast.newSimpleName(paramName));
            assignment.setOperator(Assignment.Operator.ASSIGN);
            body.statements().add(ast.newExpressionStatement((Expression)assignment));
            ++i;
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, typeBinding.getName(), decl, superConstructor, delimiter)) != null) {
            JSdoc javadoc = (JSdoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    public static FunctionDeclaration createDelegationStub(IJavaScriptUnit unit, ASTRewrite rewrite, ImportRewrite imports, AST ast, IBinding[] bindings, CodeGenerationSettings settings) throws CoreException {
        Assert.isNotNull((Object)bindings);
        Assert.isNotNull((Object)settings);
        Assert.isTrue((bindings.length == 2 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(bindings[0] instanceof IVariableBinding));
        Assert.isTrue((boolean)(bindings[1] instanceof IFunctionBinding));
        IVariableBinding variableBinding = (IVariableBinding)bindings[0];
        IFunctionBinding methodBinding = (IFunctionBinding)bindings[1];
        FunctionDeclaration decl = ast.newFunctionDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, methodBinding.getModifiers() & 0xFFFFFFDF & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(methodBinding.getName()));
        decl.setConstructor(false);
        decl.setReturnType2(imports.addImport(methodBinding.getReturnType(), ast));
        List parameters = decl.parameters();
        ITypeBinding[] params = methodBinding.getParameterTypes();
        String[] paramNames = StubUtility.suggestArgumentNames(unit.getJavaScriptProject(), methodBinding);
        int i = 0;
        while (i < params.length) {
            SingleVariableDeclaration varDecl = ast.newSingleVariableDeclaration();
            if (methodBinding.isVarargs() && params[i].isArray() && i == params.length - 1) {
                StringBuffer buffer = new StringBuffer(imports.addImport(params[i].getElementType()));
                int dim = 1;
                while (dim < params[i].getDimensions()) {
                    buffer.append("[]");
                    ++dim;
                }
                varDecl.setType(ASTNodeFactory.newType(ast, buffer.toString()));
                varDecl.setVarargs(true);
            } else {
                varDecl.setType(imports.addImport(params[i], ast));
            }
            varDecl.setName(ast.newSimpleName(paramNames[i]));
            parameters.add(varDecl);
            ++i;
        }
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaScriptElement)unit);
        ReturnStatement statement = null;
        FunctionInvocation invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName(methodBinding.getName()));
        List arguments = invocation.arguments();
        int i2 = 0;
        while (i2 < params.length) {
            arguments.add(ast.newSimpleName(paramNames[i2]));
            ++i2;
        }
        if (settings.useKeywordThis) {
            FieldAccess access = ast.newFieldAccess();
            access.setExpression((Expression)ast.newThisExpression());
            access.setName(ast.newSimpleName(variableBinding.getName()));
            invocation.setExpression((Expression)access);
        } else {
            invocation.setExpression((Expression)ast.newSimpleName(variableBinding.getName()));
        }
        if (methodBinding.getReturnType().isPrimitive() && methodBinding.getReturnType().getName().equals("void")) {
            statement = ast.newExpressionStatement((Expression)invocation);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression((Expression)invocation);
            statement = returnStatement;
        }
        body.statements().add(statement);
        ITypeBinding declaringType = variableBinding.getDeclaringClass();
        if (declaringType == null) {
            return decl;
        }
        String qualifiedName = declaringType.getQualifiedName();
        IPackageBinding packageBinding = declaringType.getPackage();
        if (packageBinding != null && packageBinding.getName().length() > 0 && qualifiedName.startsWith(packageBinding.getName())) {
            qualifiedName = qualifiedName.substring(packageBinding.getName().length());
        }
        if (settings.createComments) {
            methodBinding = methodBinding.getMethodDeclaration();
            String declaringClassQualifiedName = methodBinding.getDeclaringClass().getQualifiedName();
            String linkToMethodName = methodBinding.getName();
            String[] parameterTypesQualifiedNames = StubUtility.getParameterTypeNamesForSeeTag(methodBinding);
            String string = StubUtility.getMethodComment(unit, qualifiedName, decl, methodBinding.isDeprecated(), linkToMethodName, declaringClassQualifiedName, parameterTypesQualifiedNames, true, delimiter);
            if (string != null) {
                JSdoc javadoc = (JSdoc)rewrite.createStringPlaceholder(string, 29);
                decl.setJavadoc(javadoc);
            }
        }
        return decl;
    }

    public static FunctionDeclaration createImplementationStub(IJavaScriptUnit unit, ASTRewrite rewrite, ImportRewrite imports, AST ast, IFunctionBinding binding, String type, CodeGenerationSettings settings, boolean deferred, ImportRewrite.ImportRewriteContext context) throws CoreException {
        String string;
        FunctionDeclaration decl = ast.newFunctionDeclaration();
        decl.modifiers().addAll(StubUtility2.getImplementationModifiers(ast, binding, deferred));
        decl.setName(ast.newSimpleName(binding.getName()));
        decl.setConstructor(false);
        decl.setReturnType2(imports.addImport(binding.getReturnType(), ast, context));
        List parameters = StubUtility2.createParameters(unit, imports, ast, binding, decl, context);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaScriptElement)unit);
        if (!deferred) {
            String placeHolder;
            Map options = unit.getJavaScriptProject().getOptions(true);
            Block body = ast.newBlock();
            decl.setBody(body);
            String bodyStatement = "";
            binding.getDeclaringClass();
            if (Modifier.isAbstract((int)binding.getModifiers())) {
                Expression expression = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
                if (expression != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            } else {
                SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
                invocation.setName(ast.newSimpleName(binding.getName()));
                SingleVariableDeclaration varDecl = null;
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    varDecl = (SingleVariableDeclaration)iterator.next();
                    invocation.arguments().add(ast.newSimpleName(varDecl.getName().getIdentifier()));
                }
                SuperMethodInvocation expression = invocation;
                Type returnType = decl.getReturnType2();
                if (returnType != null && returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)ast.newExpressionStatement((Expression)expression), 0, delimiter, options);
                } else {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression((Expression)expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            }
            if ((placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), false, bodyStatement, delimiter)) != null) {
                ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        }
        if (settings.createComments && (string = CodeGeneration.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            JSdoc javadoc = (JSdoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        if (settings.overrideAnnotation && JavaModelUtil.is50OrHigher(unit.getJavaScriptProject())) {
            StubUtility2.addOverrideAnnotation(rewrite, decl, binding);
        }
        return decl;
    }

    public static FunctionDeclaration createImplementationStub(IJavaScriptUnit unit, ASTRewrite rewrite, ImportRewrite importRewrite, IFunctionBinding binding, String type, boolean deferred, CodeGenerationSettings settings) throws CoreException {
        String string;
        AST ast = rewrite.getAST();
        FunctionDeclaration decl = ast.newFunctionDeclaration();
        decl.modifiers().addAll(StubUtility2.getImplementationModifiers(ast, binding, deferred));
        decl.setName(ast.newSimpleName(binding.getName()));
        decl.setConstructor(false);
        decl.setReturnType2(StubUtility2.createTypeNode(importRewrite, binding.getReturnType(), ast));
        List parameters = StubUtility2.createParameters(unit, importRewrite, ast, binding, decl);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaScriptElement)unit);
        if (!deferred) {
            String placeHolder;
            Map options = unit.getJavaScriptProject().getOptions(true);
            Block body = ast.newBlock();
            decl.setBody(body);
            String bodyStatement = "";
            binding.getDeclaringClass();
            if (Modifier.isAbstract((int)binding.getModifiers())) {
                Expression expression = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
                if (expression != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            } else {
                SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
                invocation.setName(ast.newSimpleName(binding.getName()));
                SingleVariableDeclaration varDecl = null;
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    varDecl = (SingleVariableDeclaration)iterator.next();
                    invocation.arguments().add(ast.newSimpleName(varDecl.getName().getIdentifier()));
                }
                SuperMethodInvocation expression = invocation;
                Type returnType = decl.getReturnType2();
                if (returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)ast.newExpressionStatement((Expression)expression), 0, delimiter, options);
                } else {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression((Expression)expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            }
            if ((placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), false, bodyStatement, delimiter)) != null) {
                ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            JSdoc javadoc = (JSdoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        if (settings != null && settings.overrideAnnotation && JavaModelUtil.is50OrHigher(unit.getJavaScriptProject())) {
            StubUtility2.addOverrideAnnotation(rewrite, decl, binding);
        }
        return decl;
    }

    private static List createParameters(IJavaScriptUnit unit, ImportRewrite imports, AST ast, IFunctionBinding binding, FunctionDeclaration decl, ImportRewrite.ImportRewriteContext context) {
        List parameters = decl.parameters();
        ITypeBinding[] params = binding.getParameterTypes();
        String[] paramNames = StubUtility.suggestArgumentNames(unit.getJavaScriptProject(), binding);
        int i = 0;
        while (i < params.length) {
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            if (binding.isVarargs() && params[i].isArray() && i == params.length - 1) {
                StringBuffer buffer = new StringBuffer(imports.addImport(params[i].getElementType(), context));
                int dim = 1;
                while (dim < params[i].getDimensions()) {
                    buffer.append("[]");
                    ++dim;
                }
                var.setType(ASTNodeFactory.newType(ast, buffer.toString()));
                var.setVarargs(true);
            } else {
                var.setType(imports.addImport(params[i], ast, context));
            }
            var.setName(ast.newSimpleName(paramNames[i]));
            parameters.add(var);
            ++i;
        }
        return parameters;
    }

    private static List createParameters(IJavaScriptUnit unit, ImportRewrite imports, AST ast, IFunctionBinding binding, FunctionDeclaration decl) {
        List parameters = decl.parameters();
        ITypeBinding[] params = binding.getParameterTypes();
        String[] paramNames = StubUtility.suggestArgumentNames(unit.getJavaScriptProject(), binding);
        int i = 0;
        while (i < params.length) {
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            if (binding.isVarargs() && params[i].isArray() && i == params.length - 1) {
                ITypeBinding elementType = params[i].getElementType();
                StringBuffer buffer = new StringBuffer(imports != null ? imports.addImport(elementType) : elementType.getQualifiedName());
                int dim = 1;
                while (dim < params[i].getDimensions()) {
                    buffer.append("[]");
                    ++dim;
                }
                var.setType(ASTNodeFactory.newType(ast, buffer.toString()));
                var.setVarargs(true);
            } else {
                var.setType(StubUtility2.createTypeNode(imports, params[i], ast));
            }
            var.setName(ast.newSimpleName(paramNames[i]));
            parameters.add(var);
            ++i;
        }
        return parameters;
    }

    private static Type createTypeNode(ImportRewrite importRewrite, ITypeBinding binding, AST ast) {
        if (importRewrite != null) {
            return importRewrite.addImport(binding, ast);
        }
        return StubUtility2.createTypeNode(binding, ast);
    }

    private static Type createTypeNode(ITypeBinding binding, AST ast) {
        if (binding.isPrimitive()) {
            return ast.newPrimitiveType(PrimitiveType.toCode((String)binding.getName()));
        }
        ITypeBinding normalized = Bindings.normalizeTypeBinding(binding);
        if (normalized == null) {
            return ast.newSimpleType((Name)ast.newSimpleName("invalid"));
        }
        if (normalized.isArray()) {
            return ast.newArrayType(StubUtility2.createTypeNode(normalized.getElementType(), ast), normalized.getDimensions());
        }
        String qualified = Bindings.getRawQualifiedName(normalized);
        if (qualified.length() > 0) {
            return ast.newSimpleType(ASTNodeFactory.newName(ast, qualified));
        }
        return ast.newSimpleType(ASTNodeFactory.newName(ast, Bindings.getRawName(normalized)));
    }

    private static IFunctionBinding findMethodBinding(IFunctionBinding method, List allMethods) {
        int i = 0;
        while (i < allMethods.size()) {
            IFunctionBinding curr = (IFunctionBinding)allMethods.get(i);
            if (Bindings.isSubsignature(method, curr)) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static IFunctionBinding findOverridingMethod(IFunctionBinding method, List allMethods) {
        int i = 0;
        while (i < allMethods.size()) {
            IFunctionBinding curr = (IFunctionBinding)allMethods.get(i);
            if (Bindings.areOverriddenMethods(curr, method) || Bindings.isSubsignature(curr, method)) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void findUnimplementedInterfaceMethods(ITypeBinding typeBinding, HashSet visited, ArrayList allMethods, IPackageBinding currPack, ArrayList toImplement) {
        if (visited.add(typeBinding)) {
            IFunctionBinding[] typeMethods = typeBinding.getDeclaredMethods();
            int i = 0;
            while (i < typeMethods.length) {
                IFunctionBinding curr = typeMethods[i];
                IFunctionBinding impl = StubUtility2.findMethodBinding(curr, allMethods);
                if (impl == null || !Bindings.isVisibleInHierarchy(impl, currPack)) {
                    if (impl != null) {
                        allMethods.remove(impl);
                    }
                    toImplement.add(curr);
                    allMethods.add(curr);
                }
                ++i;
            }
        }
    }

    public static IBinding[][] getDelegatableMethods(AST ast, ITypeBinding binding) {
        ArrayList tuples = new ArrayList();
        ArrayList<IFunctionBinding> declared = new ArrayList<IFunctionBinding>();
        IFunctionBinding[] typeMethods = binding.getDeclaredMethods();
        int index = 0;
        while (index < typeMethods.length) {
            declared.add(typeMethods[index]);
            ++index;
        }
        IVariableBinding[] typeFields = binding.getDeclaredFields();
        int index2 = 0;
        while (index2 < typeFields.length) {
            IVariableBinding fieldBinding = typeFields[index2];
            if (fieldBinding.isField()) {
                StubUtility2.getDelegatableMethods(ast, tuples, new ArrayList(declared), fieldBinding, fieldBinding.getType(), binding);
            }
            ++index2;
        }
        return (IBinding[][])tuples.toArray((T[])new IBinding[tuples.size()][2]);
    }

    private static void getDelegatableMethods(AST ast, List tuples, List methods, IVariableBinding fieldBinding, ITypeBinding typeBinding, ITypeBinding binding) {
        boolean match = false;
        IFunctionBinding[] candidates = StubUtility2.getDelegateCandidates(typeBinding, binding);
        int index = 0;
        while (index < candidates.length) {
            match = false;
            IFunctionBinding methodBinding = candidates[index];
            int offset = 0;
            while (offset < methods.size() && !match) {
                if (Bindings.areOverriddenMethods((IFunctionBinding)methods.get(offset), methodBinding)) {
                    match = true;
                }
                ++offset;
            }
            if (!match) {
                tuples.add(new IBinding[]{fieldBinding, methodBinding});
                methods.add(methodBinding);
            }
            ++index;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            StubUtility2.getDelegatableMethods(ast, tuples, methods, fieldBinding, superclass, binding);
        }
    }

    private static IFunctionBinding[] getDelegateCandidates(ITypeBinding binding, ITypeBinding hierarchy) {
        ArrayList<IFunctionBinding> allMethods = new ArrayList<IFunctionBinding>();
        IFunctionBinding[] typeMethods = binding.getDeclaredMethods();
        int index = 0;
        while (index < typeMethods.length) {
            int modifiers = typeMethods[index].getModifiers();
            if (!typeMethods[index].isConstructor() && !Modifier.isStatic((int)modifiers) && Modifier.isPublic((int)modifiers)) {
                Bindings.findOverriddenMethodInHierarchy(hierarchy, typeMethods[index]);
                typeMethods[index].getParameterTypes();
                boolean upper = false;
                if (!upper) {
                    allMethods.add(typeMethods[index]);
                }
            }
            ++index;
        }
        return allMethods.toArray(new IFunctionBinding[allMethods.size()]);
    }

    private static List getImplementationModifiers(AST ast, IFunctionBinding method, boolean deferred) {
        int modifiers = method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFFD;
        if (deferred) {
            modifiers &= 0xFFFFFFFB;
            modifiers |= 1;
        }
        return ASTNodeFactory.newModifiers(ast, modifiers);
    }

    public static IFunctionBinding[] getOverridableMethods(AST ast, ITypeBinding typeBinding, boolean isSubType) {
        int modifiers;
        ArrayList<IFunctionBinding> allMethods = new ArrayList<IFunctionBinding>();
        IFunctionBinding[] typeMethods = typeBinding.getDeclaredMethods();
        int index = 0;
        while (index < typeMethods.length) {
            modifiers = typeMethods[index].getModifiers();
            if (!(typeMethods[index].isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers))) {
                allMethods.add(typeMethods[index]);
            }
            ++index;
        }
        ITypeBinding clazz = typeBinding.getSuperclass();
        while (clazz != null) {
            IFunctionBinding[] methods = clazz.getDeclaredMethods();
            int offset = 0;
            while (offset < methods.length) {
                int modifiers2 = methods[offset].getModifiers();
                if (!(methods[offset].isConstructor() || Modifier.isStatic((int)modifiers2) || Modifier.isPrivate((int)modifiers2) || StubUtility2.findOverridingMethod(methods[offset], allMethods) != null)) {
                    allMethods.add(methods[offset]);
                }
                ++offset;
            }
            clazz = clazz.getSuperclass();
        }
        clazz = typeBinding;
        while (clazz != null) {
            clazz = clazz.getSuperclass();
        }
        if (!isSubType) {
            allMethods.removeAll(Arrays.asList(typeMethods));
        }
        modifiers = 0;
        int index2 = allMethods.size() - 1;
        while (index2 >= 0) {
            IFunctionBinding method = (IFunctionBinding)allMethods.get(index2);
            modifiers = method.getModifiers();
            if (Modifier.isFinal((int)modifiers)) {
                allMethods.remove(index2);
            }
            --index2;
        }
        return allMethods.toArray(new IFunctionBinding[allMethods.size()]);
    }

    private static void getOverridableMethods(AST ast, ITypeBinding superBinding, List allMethods) {
        IFunctionBinding[] methods = superBinding.getDeclaredMethods();
        int offset = 0;
        while (offset < methods.length) {
            int modifiers = methods[offset].getModifiers();
            if (!(methods[offset].isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || StubUtility2.findOverridingMethod(methods[offset], allMethods) != null || Modifier.isStatic((int)modifiers))) {
                allMethods.add(methods[offset]);
            }
            ++offset;
        }
    }

    private static String getParameterName(IJavaScriptUnit unit, IVariableBinding binding, String[] excluded) {
        String name = NamingConventions.removePrefixAndSuffixForFieldName((IJavaScriptProject)unit.getJavaScriptProject(), (String)binding.getName(), (int)binding.getModifiers());
        return StubUtility.suggestArgumentName(unit.getJavaScriptProject(), name, excluded);
    }

    public static IFunctionBinding[] getUnimplementedMethods(ITypeBinding typeBinding) {
        int modifiers;
        ArrayList<IFunctionBinding> allMethods = new ArrayList<IFunctionBinding>();
        ArrayList<IFunctionBinding> toImplement = new ArrayList<IFunctionBinding>();
        IFunctionBinding[] typeMethods = typeBinding.getDeclaredMethods();
        int i = 0;
        while (i < typeMethods.length) {
            IFunctionBinding curr = typeMethods[i];
            int modifiers2 = curr.getModifiers();
            if (!(curr.isConstructor() || Modifier.isStatic((int)modifiers2) || Modifier.isPrivate((int)modifiers2))) {
                allMethods.add(curr);
            }
            ++i;
        }
        ITypeBinding superClass = typeBinding.getSuperclass();
        while (superClass != null) {
            typeMethods = superClass.getDeclaredMethods();
            int i2 = 0;
            while (i2 < typeMethods.length) {
                IFunctionBinding curr = typeMethods[i2];
                modifiers = curr.getModifiers();
                if (!(curr.isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || StubUtility2.findMethodBinding(curr, allMethods) != null)) {
                    allMethods.add(curr);
                }
                ++i2;
            }
            superClass = superClass.getSuperclass();
        }
        int i3 = 0;
        while (i3 < allMethods.size()) {
            IFunctionBinding curr = (IFunctionBinding)allMethods.get(i3);
            modifiers = curr.getModifiers();
            if (Modifier.isAbstract((int)modifiers) && typeBinding != curr.getDeclaringClass()) {
                toImplement.add(curr);
            }
            ++i3;
        }
        new HashSet();
        ITypeBinding curr = typeBinding;
        while (curr != null) {
            curr = curr.getSuperclass();
        }
        return toImplement.toArray(new IFunctionBinding[toImplement.size()]);
    }

    public static IFunctionBinding[] getVisibleConstructors(ITypeBinding binding, boolean accountExisting, boolean proposeDefault) {
        IFunctionBinding[] methods;
        ArrayList constructorMethods = new ArrayList();
        ArrayList<IFunctionBinding> existingConstructors = null;
        ITypeBinding superType = binding.getSuperclass();
        if (superType == null) {
            return new IFunctionBinding[0];
        }
        if (accountExisting) {
            methods = binding.getDeclaredMethods();
            existingConstructors = new ArrayList<IFunctionBinding>(methods.length);
            int index = 0;
            while (index < methods.length) {
                IFunctionBinding method = methods[index];
                if (method.isConstructor() && !method.isDefaultConstructor()) {
                    existingConstructors.add(method);
                }
                ++index;
            }
        }
        if (existingConstructors != null) {
            constructorMethods.addAll(existingConstructors);
        }
        methods = binding.getDeclaredMethods();
        IFunctionBinding[] superMethods = superType.getDeclaredMethods();
        int index = 0;
        while (index < superMethods.length) {
            IFunctionBinding method = superMethods[index];
            if (method.isConstructor() && Bindings.isVisibleInHierarchy(method, binding.getPackage()) && (!accountExisting || !Bindings.containsSignatureEquivalentConstructor(methods, method))) {
                constructorMethods.add(method);
            }
            ++index;
        }
        if (existingConstructors != null) {
            constructorMethods.removeAll(existingConstructors);
        }
        if (constructorMethods.isEmpty()) {
            superType = binding;
            while (superType.getSuperclass() != null) {
                superType = superType.getSuperclass();
            }
            IFunctionBinding method = Bindings.findMethodInType(superType, "Object", new ITypeBinding[0]);
            if (!(method == null || !proposeDefault && accountExisting && existingConstructors != null && !existingConstructors.isEmpty() || accountExisting && Bindings.containsSignatureEquivalentConstructor(methods, method))) {
                constructorMethods.add(method);
            }
        }
        return constructorMethods.toArray(new IFunctionBinding[constructorMethods.size()]);
    }

    private StubUtility2() {
    }
}

