/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class RippleMethodFinder2 {
    private final IFunction fMethod;
    private List fDeclarations;
    private ITypeHierarchy fHierarchy;
    private Map fTypeToMethod;
    private Set fRootTypes;
    private MultiMap fRootReps;
    private Map fRootHierarchies;
    private UnionFind fUnionFind;
    private boolean fExcludeBinaries;

    private RippleMethodFinder2(IFunction method, boolean excludeBinaries) {
        this.fMethod = method;
        this.fExcludeBinaries = excludeBinaries;
    }

    public static IFunction[] getRelatedMethods(IFunction method, boolean excludeBinaries, IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        block3: {
            IFunction[] iFunctionArray;
            try {
                if (MethodChecks.isVirtual(method)) break block3;
                iFunctionArray = new IFunction[]{method};
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return iFunctionArray;
        }
        IFunction[] iFunctionArray = new RippleMethodFinder2(method, excludeBinaries).getAllRippleMethods(pm, owner);
        Object var4_7 = null;
        pm.done();
        return iFunctionArray;
    }

    public static IFunction[] getRelatedMethods(IFunction method, IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        return RippleMethodFinder2.getRelatedMethods(method, true, pm, owner);
    }

    private IFunction[] getAllRippleMethods(IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        pm.beginTask("", 4);
        this.findAllDeclarations((IProgressMonitor)new SubProgressMonitor(pm, 1), owner);
        Assert.isTrue((boolean)this.fDeclarations.contains(this.fMethod), (String)"Search for method declaration did not find original element");
        this.createHierarchyOfDeclarations((IProgressMonitor)new SubProgressMonitor(pm, 1), owner);
        this.createTypeToMethod();
        this.createUnionFind();
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fHierarchy = null;
        this.fRootTypes = null;
        HashMap<IType, ArrayList<IType>> partitioning = new HashMap<IType, ArrayList<IType>>();
        Iterator iter = this.fTypeToMethod.keySet().iterator();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            IType rep = this.fUnionFind.find(type);
            ArrayList<IType> types = (ArrayList<IType>)partitioning.get(rep);
            if (types == null) {
                types = new ArrayList<IType>();
            }
            types.add(type);
            partitioning.put(rep, types);
        }
        Assert.isTrue((partitioning.size() > 0 ? 1 : 0) != 0);
        if (partitioning.size() == 1) {
            return this.fDeclarations.toArray(new IFunction[this.fDeclarations.size()]);
        }
        IType methodTypeRep = this.fUnionFind.find(this.fMethod.getDeclaringType());
        List relatedTypes = (List)partitioning.get(methodTypeRep);
        boolean hasRelatedInterfaces = false;
        ArrayList relatedMethods = new ArrayList();
        Iterator iter2 = relatedTypes.iterator();
        while (iter2.hasNext()) {
            IType relatedType = (IType)iter2.next();
            relatedMethods.add(this.fTypeToMethod.get(relatedType));
        }
        ArrayList alienDeclarations = new ArrayList(this.fDeclarations);
        this.fDeclarations = null;
        alienDeclarations.removeAll(relatedMethods);
        ArrayList<IType> alienTypes = new ArrayList<IType>();
        boolean hasAlienInterfaces = false;
        Iterator iter3 = alienDeclarations.iterator();
        while (iter3.hasNext()) {
            IFunction alienDeclaration = (IFunction)iter3.next();
            IType alienType = alienDeclaration.getDeclaringType();
            alienTypes.add(alienType);
        }
        if (alienTypes.size() == 0) {
            return relatedMethods.toArray(new IFunction[relatedMethods.size()]);
        }
        if (!hasRelatedInterfaces && !hasAlienInterfaces) {
            return relatedMethods.toArray(new IFunction[relatedMethods.size()]);
        }
        HashSet<IType> relatedSubTypes = new HashSet<IType>();
        ArrayList relatedTypesToProcess = new ArrayList(relatedTypes);
        while (relatedTypesToProcess.size() > 0) {
            Iterator iter4 = relatedTypesToProcess.iterator();
            while (iter4.hasNext()) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IType relatedType = (IType)iter4.next();
                ITypeHierarchy hierarchy = this.getCachedHierarchy(relatedType, owner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (hierarchy == null) {
                    hierarchy = relatedType.newTypeHierarchy(owner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                IType[] allSubTypes = hierarchy.getAllSubtypes(relatedType);
                int i = 0;
                while (i < allSubTypes.length) {
                    relatedSubTypes.add(allSubTypes[i]);
                    ++i;
                }
            }
            relatedTypesToProcess.clear();
            HashSet<IType> marriedAlienTypeReps = new HashSet<IType>();
            Iterator iter5 = alienTypes.iterator();
            while (iter5.hasNext()) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IType alienType = (IType)iter5.next();
                IFunction alienMethod = (IFunction)this.fTypeToMethod.get(alienType);
                ITypeHierarchy hierarchy = this.getCachedHierarchy(alienType, owner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (hierarchy == null) {
                    hierarchy = alienType.newTypeHierarchy(owner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                IType[] allSubtypes = hierarchy.getAllSubtypes(alienType);
                int i = 0;
                while (i < allSubtypes.length) {
                    IType subtype = allSubtypes[i];
                    if (relatedSubTypes.contains(subtype) && JavaModelUtil.isVisibleInHierarchy((IMember)alienMethod, subtype.getPackageFragment())) {
                        marriedAlienTypeReps.add(this.fUnionFind.find(alienType));
                    }
                    ++i;
                }
            }
            if (marriedAlienTypeReps.size() == 0) {
                return relatedMethods.toArray(new IFunction[relatedMethods.size()]);
            }
            iter5 = marriedAlienTypeReps.iterator();
            while (iter5.hasNext()) {
                IType marriedAlienTypeRep = (IType)iter5.next();
                List marriedAlienTypes = (List)partitioning.get(marriedAlienTypeRep);
                Iterator iterator = marriedAlienTypes.iterator();
                while (iterator.hasNext()) {
                    IType marriedAlienInterfaceType = (IType)iterator.next();
                    relatedMethods.add(this.fTypeToMethod.get(marriedAlienInterfaceType));
                }
                alienTypes.removeAll(marriedAlienTypes);
                relatedTypesToProcess.addAll(marriedAlienTypes);
            }
        }
        this.fRootReps = null;
        this.fRootHierarchies = null;
        this.fTypeToMethod = null;
        this.fUnionFind = null;
        return relatedMethods.toArray(new IFunction[relatedMethods.size()]);
    }

    private ITypeHierarchy getCachedHierarchy(IType type, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        IType rep = this.fUnionFind.find(type);
        if (rep != null) {
            Collection collection = this.fRootReps.get(rep);
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                IType root = (IType)iter.next();
                ITypeHierarchy hierarchy = (ITypeHierarchy)this.fRootHierarchies.get(root);
                if (hierarchy == null) {
                    hierarchy = root.newTypeHierarchy(owner, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.fRootHierarchies.put(root, hierarchy);
                }
                if (!hierarchy.contains(type)) continue;
                return hierarchy;
            }
        }
        return null;
    }

    private void findAllDeclarations(IProgressMonitor monitor, WorkingCopyOwner owner) throws CoreException {
        this.fDeclarations = new ArrayList();
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaScriptElement)this.fMethod, (int)48, (int)24));
        if (owner != null) {
            engine.setOwner(owner);
        }
        engine.setScope(RefactoringScopeFactory.createRelatedProjectsScope(this.fMethod.getJavaScriptProject(), 7));
        engine.setFiltering(false, this.fExcludeBinaries);
        engine.setGrouping(false);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        SearchMatch[] matches = (SearchMatch[])engine.getResults();
        IFunction method = null;
        int index = 0;
        while (index < matches.length) {
            method = (IFunction)matches[index].getElement();
            if (method != null) {
                this.fDeclarations.add(method);
            }
            ++index;
        }
    }

    private void createHierarchyOfDeclarations(IProgressMonitor pm, WorkingCopyOwner owner) throws JavaScriptModelException {
        IRegion region = JavaScriptCore.newRegion();
        Iterator iter = this.fDeclarations.iterator();
        while (iter.hasNext()) {
            IType declaringType = ((IFunction)iter.next()).getDeclaringType();
            region.add((IJavaScriptElement)declaringType);
        }
        this.fHierarchy = JavaScriptCore.newTypeHierarchy((IRegion)region, (WorkingCopyOwner)owner, (IProgressMonitor)pm);
    }

    private void createTypeToMethod() {
        this.fTypeToMethod = new HashMap();
        Iterator iter = this.fDeclarations.iterator();
        while (iter.hasNext()) {
            IFunction declaration = (IFunction)iter.next();
            this.fTypeToMethod.put(declaration.getDeclaringType(), declaration);
        }
    }

    private void createUnionFind() throws JavaScriptModelException {
        IType type;
        this.fRootTypes = new HashSet(this.fTypeToMethod.keySet());
        this.fUnionFind = new UnionFind();
        Iterator<Object> iter = this.fTypeToMethod.keySet().iterator();
        while (iter.hasNext()) {
            type = (IType)iter.next();
            this.fUnionFind.init(type);
        }
        iter = this.fTypeToMethod.keySet().iterator();
        while (iter.hasNext()) {
            type = (IType)iter.next();
            this.uniteWithSupertypes(type, type);
        }
        this.fRootReps = new MultiMap();
        iter = this.fRootTypes.iterator();
        while (iter.hasNext()) {
            type = (IType)iter.next();
            IType rep = this.fUnionFind.find(type);
            if (rep == null) continue;
            this.fRootReps.put(rep, type);
        }
        this.fRootHierarchies = new HashMap();
    }

    private void uniteWithSupertypes(IType anchor, IType type) throws JavaScriptModelException {
        IType[] supertypes = this.fHierarchy.getSupertypes(type);
        int i = 0;
        while (i < supertypes.length) {
            IType supertype = supertypes[i];
            IType superRep = this.fUnionFind.find(supertype);
            if (superRep == null) {
                this.uniteWithSupertypes(anchor, supertype);
            } else {
                IMember superMethod = (IMember)this.fTypeToMethod.get(supertype);
                if (JavaModelUtil.isVisibleInHierarchy(superMethod, anchor.getPackageFragment())) {
                    IType rep = this.fUnionFind.find(anchor);
                    this.fUnionFind.union(rep, superRep);
                    this.fRootTypes.remove(anchor);
                    this.uniteWithSupertypes(supertype, supertype);
                }
            }
            ++i;
        }
    }

    private static class MultiMap {
        HashMap fImplementation = new HashMap();

        private MultiMap() {
        }

        public void put(IType key, IType value) {
            HashSet<IType> collection = (HashSet<IType>)this.fImplementation.get(key);
            if (collection == null) {
                collection = new HashSet<IType>();
                this.fImplementation.put(key, collection);
            }
            collection.add(value);
        }

        public Collection get(IType key) {
            return (Collection)this.fImplementation.get(key);
        }
    }

    private static class UnionFind {
        HashMap fElementToRepresentative = new HashMap();

        private UnionFind() {
        }

        public void init(IType type) {
            this.fElementToRepresentative.put(type, type);
        }

        public IType find(IType element) {
            IType root = element;
            IType rep = (IType)this.fElementToRepresentative.get(root);
            while (rep != null && !rep.equals(root)) {
                root = rep;
                rep = (IType)this.fElementToRepresentative.get(root);
            }
            if (rep == null) {
                return null;
            }
            rep = (IType)this.fElementToRepresentative.get(element);
            while (!rep.equals(root)) {
                IType temp = element;
                element = rep;
                this.fElementToRepresentative.put(temp, root);
                rep = (IType)this.fElementToRepresentative.get(element);
            }
            return root;
        }

        public void union(IType rep1, IType rep2) {
            this.fElementToRepresentative.put(rep1, rep2);
        }
    }
}

