/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaFormatter;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaVariable;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class JavaContext
extends CompilationUnitContext {
    private CompilationUnitCompletion fCompletion;
    private Set fUsedNames = new HashSet();
    private Map fVariables = new HashMap();

    public JavaContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, IJavaScriptUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    public JavaContext(TemplateContextType type, IDocument document, Position completionPosition, IJavaScriptUnit compilationUnit) {
        super(type, document, completionPosition, compilationUnit);
    }

    private int getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            IJavaScriptProject project = this.getJavaProject();
            return Strings.computeIndentUnits(lineContent, project);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        this.clear();
        if (!this.canEvaluate(template)) {
            throw new TemplateException(JavaTemplateMessages.Context_error_cannot_evaluate);
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(TemplateVariableType type, String name, int[] offsets) {
                JavaVariable variable = new JavaVariable(type, name, offsets);
                JavaContext.this.fVariables.put(name, variable);
                return variable;
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        IPreferenceStore prefs = JavaScriptPlugin.getDefault().getPreferenceStore();
        boolean useCodeFormatter = prefs.getBoolean("org.eclipse.wst.jsdt.ui.template.format");
        IJavaScriptProject project = this.getJavaProject();
        JavaFormatter formatter = new JavaFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), this.getIndentation(), useCodeFormatter, project);
        formatter.format(buffer, (TemplateContext)this);
        this.clear();
        return buffer;
    }

    private void clear() {
        this.fUsedNames.clear();
    }

    public boolean canEvaluate(Template template) {
        if (this.fForceEvaluation) {
            return true;
        }
        String key = this.getKey();
        return template.matches(key, this.getContextType().getId()) && key.length() != 0 && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public int getStart() {
        if (this.fIsManaged && this.getCompletionLength() > 0) {
            return super.getStart();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && this.isTempalteNamePart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }

    private boolean isTempalteNamePart(char ch) {
        return !Character.isWhitespace(ch) && ch != '(' && ch != ')' && ch != '{' && ch != '}' && ch != ';';
    }

    public int getEnd() {
        if (this.fIsManaged || this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public char getCharacterBeforeStart() {
        int start = this.getStart();
        try {
            return start == 0 ? (char)' ' : this.getDocument().getChar(start - 1);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }

    private static void handleException(Shell shell, Exception e) {
        String title = JavaTemplateMessages.JavaContext_error_title;
        if (e instanceof CoreException) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, null);
        } else if (e instanceof InvocationTargetException) {
            ExceptionHandler.handle((InvocationTargetException)e, shell, title, null);
        } else {
            JavaScriptPlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)title, (String)e.getMessage());
        }
    }

    private CompilationUnitCompletion getCompletion() {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit();
        if (this.fCompletion == null) {
            this.fCompletion = new CompilationUnitCompletion(compilationUnit);
            if (compilationUnit != null) {
                try {
                    compilationUnit.codeComplete(this.getStart(), (CompletionRequestor)this.fCompletion);
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
        }
        return this.fCompletion;
    }

    public CompilationUnitCompletion.Variable[] getArrays() {
        CompilationUnitCompletion.Variable[] localArrays = this.getCompletion().findLocalArrays();
        this.arrange(localArrays);
        return localArrays;
    }

    private void arrange(CompilationUnitCompletion.Variable[] variables) {
        Arrays.sort(variables, new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.rank((CompilationUnitCompletion.Variable)o1) - this.rank((CompilationUnitCompletion.Variable)o2);
            }

            private int rank(CompilationUnitCompletion.Variable l) {
                return JavaContext.this.fUsedNames.contains(l.getName()) ? 1 : 0;
            }
        });
    }

    public CompilationUnitCompletion.Variable[] getLocalVariables(String type) {
        CompilationUnitCompletion.Variable[] localVariables = this.getCompletion().findLocalVariables(type);
        this.arrange(localVariables);
        return localVariables;
    }

    public String[] getLocalVariableNames() {
        String[] localVariableNames = this.getCompletion().getLocalVariableNames();
        return localVariableNames;
    }

    public CompilationUnitCompletion.Variable[] getFields(String type) {
        CompilationUnitCompletion.Variable[] fields = this.getCompletion().findFieldVariables(type);
        this.arrange(fields);
        return fields;
    }

    public CompilationUnitCompletion.Variable[] getIterables() {
        CompilationUnitCompletion.Variable[] iterables = this.getCompletion().findLocalIterables();
        this.arrange(iterables);
        return iterables;
    }

    public void markAsUsed(String name) {
        this.fUsedNames.add(name);
    }

    public String[] suggestVariableNames(String type) throws IllegalArgumentException {
        String[] excludes = this.computeExcludes();
        String[] result = this.suggestVariableName(type, excludes);
        return result;
    }

    private String[] computeExcludes() {
        String[] excludes = this.getCompletion().getLocalVariableNames();
        if (!this.fUsedNames.isEmpty()) {
            String[] allExcludes = new String[this.fUsedNames.size() + excludes.length];
            System.arraycopy(excludes, 0, allExcludes, 0, excludes.length);
            System.arraycopy(this.fUsedNames.toArray(), 0, allExcludes, 0, this.fUsedNames.size());
            excludes = allExcludes;
        }
        return excludes;
    }

    private String[] suggestVariableName(String type, String[] excludes) throws IllegalArgumentException {
        int dim = 0;
        while (type.endsWith("[]")) {
            ++dim;
            type = type.substring(0, type.length() - 2);
        }
        IJavaScriptProject project = this.getJavaProject();
        if (project != null) {
            return StubUtility.getVariableNameSuggestions(5, project, type, dim, Arrays.asList(excludes), true);
        }
        return new String[]{Signature.getSimpleName((String)type).toLowerCase()};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addImport(String type) {
        if (this.isReadOnly()) {
            return;
        }
        IJavaScriptUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return;
        }
        try {
            boolean qualified;
            boolean bl = qualified = type.indexOf(46) != -1;
            if (!qualified) {
                SimpleName nameNode;
                IJavaScriptSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{cu.getJavaScriptProject()});
                TypeNameMatch[] matches = this.findAllTypes(type, searchScope, nameNode = null, null, cu);
                if (matches.length != 1) {
                    return;
                }
                type = matches[0].getFullyQualifiedName();
            }
            Position position = new Position(this.getCompletionOffset(), this.getCompletionLength());
            IDocument document = this.getDocument();
            String category = "__template_position_importer" + System.currentTimeMillis();
            DefaultPositionUpdater updater = new DefaultPositionUpdater(category);
            document.addPositionCategory(category);
            document.addPositionUpdater((IPositionUpdater)updater);
            document.addPosition(position);
            try {
                try {
                    ImportRewrite rewrite = StubUtility.createImportRewrite(cu, true);
                    JavaScriptUnit root = this.getASTRoot(cu);
                    ContextSensitiveImportRewriteContext context = root == null ? null : new ContextSensitiveImportRewriteContext(root, this.getCompletionOffset(), rewrite);
                    rewrite.addImport(type, type, context);
                    JavaModelUtil.applyEdit(cu, rewrite.rewriteImports(null), false, null);
                    this.setCompletionOffset(position.getOffset());
                    this.setCompletionLength(position.getLength());
                }
                catch (CoreException e) {
                    JavaContext.handleException(null, (Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                document.removePosition(position);
                document.removePositionUpdater((IPositionUpdater)updater);
                document.removePositionCategory(category);
                throw throwable;
            }
            {
                Object var11_17 = null;
                document.removePosition(position);
                document.removePositionUpdater((IPositionUpdater)updater);
                document.removePositionCategory(category);
                return;
            }
        }
        catch (BadLocationException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
            return;
        }
        catch (BadPositionCategoryException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
            return;
        }
        catch (JavaScriptModelException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
        }
    }

    private JavaScriptUnit getASTRoot(IJavaScriptUnit compilationUnit) {
        return JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)compilationUnit, ASTProvider.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }

    private TypeNameMatch[] findAllTypes(String simpleTypeName, IJavaScriptSearchScope searchScope, SimpleName nameNode, IProgressMonitor monitor, IJavaScriptUnit cu) throws JavaScriptModelException {
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(cu.getJavaScriptProject());
        int typeKinds = 126;
        if (nameNode != null) {
            typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)nameNode, is50OrHigher);
        }
        ArrayList typeInfos = new ArrayList();
        TypeNameMatchCollector requestor = new TypeNameMatchCollector(typeInfos);
        new SearchEngine().searchAllTypeNames(null, 0, simpleTypeName.toCharArray(), 8, this.getSearchForConstant(typeKinds), searchScope, (TypeNameMatchRequestor)requestor, 1, monitor);
        ArrayList<TypeNameMatch> typeRefsFound = new ArrayList<TypeNameMatch>(typeInfos.size());
        int i = 0;
        int len = typeInfos.size();
        while (i < len) {
            TypeNameMatch curr = (TypeNameMatch)typeInfos.get(i);
            if (curr.getPackageName().length() > 0 && this.isOfKind(curr, typeKinds, is50OrHigher) && this.isVisible(curr, cu)) {
                typeRefsFound.add(curr);
            }
            ++i;
        }
        return typeRefsFound.toArray(new TypeNameMatch[typeRefsFound.size()]);
    }

    private int getSearchForConstant(int typeKinds) {
        switch (typeKinds & 0x1E) {
            case 2: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 16: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 18: {
                return 9;
            }
        }
        return 0;
    }

    private boolean isOfKind(TypeNameMatch curr, int typeKinds, boolean is50OrHigher) {
        return (typeKinds & 2) != 0;
    }

    private boolean isVisible(TypeNameMatch curr, IJavaScriptUnit cu) {
        int flags = curr.getModifiers();
        if (Flags.isPrivate((int)flags)) {
            return false;
        }
        if (Flags.isPublic((int)flags)) {
            return true;
        }
        return curr.getPackageName().equals(cu.getParent().getElementName());
    }

    public static String evaluateTemplate(Template template, IJavaScriptUnit compilationUnit, int position) throws CoreException, BadLocationException, TemplateException {
        TemplateContextType contextType = JavaScriptPlugin.getDefault().getTemplateContextRegistry().getContextType("javaScript");
        if (contextType == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, JavaTemplateMessages.JavaContext_error_message, null));
        }
        Document document = new Document();
        if (compilationUnit != null && compilationUnit.exists()) {
            document.set(compilationUnit.getSource());
        }
        JavaContext context = new JavaContext(contextType, (IDocument)document, position, 0, compilationUnit);
        context.setForceEvaluation(true);
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return null;
        }
        return buffer.getString();
    }

    TemplateVariable getTemplateVariable(String name) {
        TemplateVariable variable = (TemplateVariable)this.fVariables.get(name);
        if (variable != null && !variable.isResolved()) {
            this.getContextType().resolve(variable, (TemplateContext)this);
        }
        return variable;
    }

    public void addDependency(MultiVariable master, MultiVariable slave) {
        MultiVariableGuess guess = this.getMultiVariableGuess();
        if (guess == null) {
            guess = new MultiVariableGuess();
            this.setMultiVariableGuess(guess);
        }
        guess.addDependency(master, slave);
    }
}

