/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.LRUMap;

public class MethodOverrideTester {
    private final IType fFocusType;
    private final ITypeHierarchy fHierarchy;
    private Map fMethodSubstitutions;
    private Map fTypeVariableSubstitutions;

    public MethodOverrideTester(IType focusType, ITypeHierarchy hierarchy) {
        if (focusType == null || hierarchy == null) {
            throw new IllegalArgumentException();
        }
        this.fFocusType = focusType;
        this.fHierarchy = hierarchy;
        this.fTypeVariableSubstitutions = null;
        this.fMethodSubstitutions = null;
    }

    public IType getFocusType() {
        return this.fFocusType;
    }

    public ITypeHierarchy getTypeHierarchy() {
        return this.fHierarchy;
    }

    public IFunction findDeclaringMethod(IFunction overriding, boolean testVisibility) throws JavaScriptModelException {
        IFunction result = null;
        IFunction overridden = this.findOverriddenMethod(overriding, testVisibility);
        while (overridden != null) {
            result = overridden;
            overridden = this.findOverriddenMethod(result, testVisibility);
        }
        return result;
    }

    public IFunction findOverriddenMethod(IFunction overriding, boolean testVisibility) throws JavaScriptModelException {
        IFunction res;
        int flags = overriding.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || overriding.isConstructor()) {
            return null;
        }
        IType type = overriding.getDeclaringType();
        if (type == null) {
            return null;
        }
        IType superClass = this.fHierarchy.getSuperclass(type);
        if (!(superClass == null || (res = this.findOverriddenMethodInHierarchy(superClass, overriding)) == null || Flags.isPrivate((int)res.getFlags()) || testVisibility && !JavaModelUtil.isVisibleInHierarchy((IMember)res, type.getPackageFragment()))) {
            return res;
        }
        return null;
    }

    public IFunction findOverriddenMethodInHierarchy(IType type, IFunction overriding) throws JavaScriptModelException {
        IFunction res;
        IFunction method = this.findOverriddenMethodInType(type, overriding);
        if (method != null) {
            return method;
        }
        IType superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null && (res = this.findOverriddenMethodInHierarchy(superClass, overriding)) != null) {
            return res;
        }
        return method;
    }

    public IFunction findOverriddenMethodInType(IType overriddenType, IFunction overriding) throws JavaScriptModelException {
        IFunction[] overriddenMethods = overriddenType.getFunctions();
        int i = 0;
        while (i < overriddenMethods.length) {
            if (this.isSubsignature(overriding, overriddenMethods[i])) {
                return overriddenMethods[i];
            }
            ++i;
        }
        return null;
    }

    public IFunction findOverridingMethodInType(IType overridingType, IFunction overridden) throws JavaScriptModelException {
        IFunction[] overridingMethods = overridingType.getFunctions();
        int i = 0;
        while (i < overridingMethods.length) {
            if (this.isSubsignature(overridingMethods[i], overridden)) {
                return overridingMethods[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isSubsignature(IFunction overriding, IFunction overridden) throws JavaScriptModelException {
        if (!overridden.getElementName().equals(overriding.getElementName())) {
            return false;
        }
        int nParameters = overridden.getNumberOfParameters();
        if (nParameters != overriding.getNumberOfParameters()) {
            return false;
        }
        return nParameters == 0 || this.hasCompatibleParameterTypes(overriding, overridden);
    }

    private boolean hasCompatibleParameterTypes(IFunction overriding, IFunction overridden) throws JavaScriptModelException {
        String overridingParamName;
        String overriddenParamName;
        String overriddenParamSig;
        String[] overriddenParamTypes = overridden.getParameterTypes();
        String[] overridingParamTypes = overriding.getParameterTypes();
        String[] substitutedOverriding = new String[overridingParamTypes.length];
        boolean testErasure = false;
        int i = 0;
        while (i < overridingParamTypes.length) {
            overriddenParamSig = overriddenParamTypes[i];
            overriddenParamName = this.getSubstitutedTypeName(overriddenParamSig, (IMember)overridden);
            substitutedOverriding[i] = overridingParamName = this.getSubstitutedTypeName(overridingParamTypes[i], (IMember)overriding);
            if (!overriddenParamName.equals(overridingParamName)) {
                testErasure = true;
                break;
            }
            ++i;
        }
        if (testErasure) {
            i = 0;
            while (i < overridingParamTypes.length) {
                overriddenParamSig = overriddenParamTypes[i];
                overriddenParamName = this.getErasedTypeName(overriddenParamSig, (IMember)overridden);
                overridingParamName = substitutedOverriding[i];
                if (overridingParamName == null) {
                    overridingParamName = this.getSubstitutedTypeName(overridingParamTypes[i], (IMember)overriding);
                }
                if (!overriddenParamName.equals(overridingParamName)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private String getVariableSubstitution(IMember context, String variableName) throws JavaScriptModelException {
        IType type;
        String subst;
        if (context instanceof IFunction) {
            subst = this.getMethodSubstitions((IFunction)context).getSubstitution(variableName);
            if (subst != null) {
                return subst;
            }
            type = context.getDeclaringType();
        } else {
            type = (IType)context;
        }
        subst = this.getTypeSubstitions(type).getSubstitution(variableName);
        if (subst != null) {
            return subst;
        }
        return variableName;
    }

    private String getVariableErasure(IMember context, String variableName) throws JavaScriptModelException {
        IType type;
        String subst;
        if (context instanceof IFunction) {
            subst = this.getMethodSubstitions((IFunction)context).getErasure(variableName);
            if (subst != null) {
                return subst;
            }
            type = context.getDeclaringType();
        } else {
            type = (IType)context;
        }
        subst = this.getTypeSubstitions(type).getErasure(variableName);
        if (subst != null) {
            return subst;
        }
        return variableName;
    }

    private Substitutions getMethodSubstitions(IFunction method) throws JavaScriptModelException {
        Substitutions s;
        if (this.fMethodSubstitutions == null) {
            this.fMethodSubstitutions = new LRUMap(3);
        }
        if ((s = (Substitutions)this.fMethodSubstitutions.get(method)) == null) {
            s = Substitutions.EMPTY_SUBST;
            this.fMethodSubstitutions.put(method, s);
        }
        return s;
    }

    private Substitutions getTypeSubstitions(IType type) throws JavaScriptModelException {
        Substitutions subst;
        if (this.fTypeVariableSubstitutions == null) {
            this.fTypeVariableSubstitutions = new HashMap();
            this.computeSubstitutions(this.fFocusType, null, null);
        }
        if ((subst = (Substitutions)this.fTypeVariableSubstitutions.get(type)) == null) {
            return Substitutions.EMPTY_SUBST;
        }
        return subst;
    }

    private void computeSubstitutions(IType instantiatedType, IType instantiatingType, String[] typeArguments) throws JavaScriptModelException {
        IType superclass;
        Substitutions s = new Substitutions();
        this.fTypeVariableSubstitutions.put(instantiatedType, s);
        String superclassTypeSignature = instantiatedType.getSuperclassTypeSignature();
        if (superclassTypeSignature != null && (superclass = this.fHierarchy.getSuperclass(instantiatedType)) != null && !this.fTypeVariableSubstitutions.containsKey(superclass)) {
            this.computeSubstitutions(superclass, instantiatedType, new String[0]);
        }
    }

    private String getSubstitutedTypeName(String typeSig, IMember context) throws JavaScriptModelException {
        return this.internalGetSubstitutedTypeName(typeSig, context, false, new StringBuffer()).toString();
    }

    private String getErasedTypeName(String typeSig, IMember context) throws JavaScriptModelException {
        return this.internalGetSubstitutedTypeName(typeSig, context, true, new StringBuffer()).toString();
    }

    private StringBuffer internalGetSubstitutedTypeName(String typeSig, IMember context, boolean erasure, StringBuffer buf) throws JavaScriptModelException {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                return buf.append(Signature.toString((String)typeSig));
            }
            case 4: {
                this.internalGetSubstitutedTypeName(Signature.getElementType((String)typeSig), context, erasure, buf);
                int i = Signature.getArrayCount((String)typeSig);
                while (i > 0) {
                    buf.append('[').append(']');
                    --i;
                }
                return buf;
            }
            case 1: {
                String erasureSig = typeSig;
                String erasureName = Signature.getSimpleName((String)Signature.toString((String)erasureSig));
                char ch = erasureSig.charAt(0);
                if (ch == 'L') {
                    buf.append(erasureName);
                } else if (ch == 'Q') {
                    if (erasure) {
                        buf.append(this.getVariableErasure(context, erasureName));
                    } else {
                        buf.append(this.getVariableSubstitution(context, erasureName));
                    }
                } else {
                    Assert.isTrue((boolean)false, (String)"Unknown class type signature");
                }
                return buf;
            }
            case 3: {
                String varName = Signature.toString((String)typeSig);
                if (erasure) {
                    return buf.append(this.getVariableErasure(context, varName));
                }
                return buf.append(this.getVariableSubstitution(context, varName));
            }
        }
        Assert.isTrue((boolean)false, (String)"Unhandled type signature kind");
        return buf;
    }

    private static class Substitutions {
        public static final Substitutions EMPTY_SUBST = new Substitutions();
        private HashMap fMap = null;

        private String[] getSubstArray(String typeVariable) {
            if (this.fMap != null) {
                return (String[])this.fMap.get(typeVariable);
            }
            return null;
        }

        public String getSubstitution(String typeVariable) {
            String[] subst = this.getSubstArray(typeVariable);
            if (subst != null) {
                return subst[0];
            }
            return null;
        }

        public String getErasure(String typeVariable) {
            String[] subst = this.getSubstArray(typeVariable);
            if (subst != null) {
                return subst[1];
            }
            return null;
        }
    }
}

