/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.html.BrowserInformationControl;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTMLPrinter;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTMLTextPresenter;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.wst.jsdt.ui.JSdocContentAccess;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class JavadocHover
extends AbstractJavaEditorTextHover
implements IInformationProviderExtension2,
ITextHoverExtension {
    private final long LABEL_FLAGS = JavaScriptElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private final long LOCAL_VARIABLE_FLAGS = this.LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator();
        }
        return this.fHoverControlCreator;
    }

    protected String getHoverInfo(IJavaScriptElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        boolean hasContents = false;
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList(buffer);
                IJavaScriptElement curr = result[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    HTMLPrinter.addBullet(buffer, this.getInfoText(curr));
                    hasContents = true;
                }
                HTMLPrinter.endBulletList(buffer);
                ++i;
            }
        } else {
            IJavaScriptElement curr = result[0];
            if (curr instanceof IMember) {
                Reader reader;
                IMember member = (IMember)curr;
                HTMLPrinter.addSmallHeader(buffer, this.getInfoText((IJavaScriptElement)member));
                try {
                    reader = JSdocContentAccess.getHTMLContentReader(member, true, true);
                    if (reader == null && member.isBinary()) {
                        boolean hasSource;
                        boolean hasAttachedJavadoc = JavaDocLocations.getJavadocBaseLocation((IJavaScriptElement)member) != null;
                        IPackageFragmentRoot root = (IPackageFragmentRoot)member.getAncestor(3);
                        boolean hasAttachedSource = root != null && root.getSourceAttachmentPath() != null;
                        IOpenable openable = member.getOpenable();
                        boolean bl = hasSource = openable.getBuffer() != null;
                        if (!hasAttachedSource && !hasAttachedJavadoc) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachments);
                        } else if (!hasAttachedJavadoc && !hasSource) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachedJavadoc);
                        } else if (!hasAttachedSource) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachedSource);
                        } else if (!hasSource) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noInformation);
                        }
                    }
                }
                catch (JavaScriptModelException ex) {
                    reader = new StringReader(JavaHoverMessages.JavadocHover_error_gettingJavadoc);
                    JavaScriptPlugin.log(ex.getStatus());
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph(buffer, reader);
                }
                hasContents = true;
            } else if (curr.getElementType() == 14) {
                HTMLPrinter.addSmallHeader(buffer, this.getInfoText(curr));
                hasContents = true;
            }
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0, JavadocHover.getStyleSheet());
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IJavaScriptElement member) {
        long flags = member.getElementType() == 14 ? this.LOCAL_VARIABLE_FLAGS : this.LABEL_FLAGS;
        String label = JavaScriptElementLabels.getElementLabel(member, flags);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < label.length()) {
            char ch = label.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    private static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private HoverControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                return new BrowserInformationControl(parent, 12, 0, EditorsUI.getTooltipAffordanceString());
            }
            return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), EditorsUI.getTooltipAffordanceString());
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)control).setStatusText(EditorsUI.getTooltipAffordanceString());
            }
            return true;
        }
    }

    private static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private PresenterControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            int shellStyle = 20;
            int style = 768;
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                return new BrowserInformationControl(parent, shellStyle, style);
            }
            return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
        }
    }
}

