/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.util.SequenceReader;
import org.eclipse.wst.jsdt.internal.core.MetadataFile;
import org.eclipse.wst.jsdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.OAADocReader;
import org.eclipse.wst.jsdt.ui.IDocumentationReader;

public class JSdocContentAccess {
    public static final String EXTENSION_POINT = "documentationProvider";
    protected static final String TAG_DOCUMENTATIONPROVIDER = "documentationProvider";
    protected static final String ATTR_DOCUMENTATIONPROVIDER_CLASS = "class";
    private static IDocumentationReader[] docReaders;

    private JSdocContentAccess() {
    }

    public static Reader getContentReader(IMember member, boolean allowInherited) throws JavaScriptModelException {
        ArrayList<Reader> readers = new ArrayList<Reader>(2);
        IDocumentationReader[] docReaders = JSdocContentAccess.getDocReaders(member);
        int i = 0;
        while (i < docReaders.length) {
            Reader contentReader = docReaders[i].getContentReader(member, allowInherited);
            if (contentReader != null) {
                readers.add(contentReader);
            }
            ++i;
        }
        IOpenable openable = member.getOpenable();
        if (openable instanceof MetadataFile) {
            return new OAADocReader((MetadataFile)openable, member);
        }
        IBuffer buf = openable.getBuffer();
        if (buf != null) {
            IFunction constructor;
            ISourceRange javadocRange = member.getJSdocRange();
            if (javadocRange == null && member.getElementType() == 7 && (constructor = ((IType)member).getFunction(member.getElementName(), null)).exists()) {
                javadocRange = constructor.getJSdocRange();
            }
            if (javadocRange != null) {
                Reader hierarchyDocReader;
                JavaDocCommentReader reader = new JavaDocCommentReader(buf, javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength() - 1);
                if (!JSdocContentAccess.containsOnlyInheritDoc(reader, javadocRange.getLength())) {
                    reader.reset();
                    readers.add(reader);
                } else if (allowInherited && member.getElementType() == 9 && (hierarchyDocReader = JSdocContentAccess.findDocInHierarchy((IFunction)member)) != null) {
                    readers.add(hierarchyDocReader);
                }
            }
        }
        if (!readers.isEmpty()) {
            if (readers.size() == 1) {
                return (Reader)readers.get(0);
            }
            return new SequenceReader(readers.toArray(new Reader[readers.size()]));
        }
        return null;
    }

    private static boolean containsOnlyInheritDoc(Reader reader, int length) {
        char[] content = new char[length];
        try {
            reader.read(content, 0, length);
        }
        catch (IOException iOException) {
            return false;
        }
        return new String(content).trim().equals("{@inheritDoc}");
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited, boolean useAttachedJavadoc) throws JavaScriptModelException {
        String s;
        Reader contentReader = JSdocContentAccess.getContentReader(member, allowInherited);
        if (contentReader != null) {
            IDocumentationReader[] docReaders = JSdocContentAccess.getDocReaders(member);
            if (docReaders.length > 0) {
                ArrayList<Reader> htmlReaders = new ArrayList<Reader>(docReaders.length);
                int i = 0;
                while (i < docReaders.length) {
                    Reader documentation2htmlReader = docReaders[i].getDocumentation2HTMLReader(contentReader);
                    if (documentation2htmlReader != null) {
                        htmlReaders.add(documentation2htmlReader);
                    }
                    ++i;
                }
                if (!htmlReaders.isEmpty()) {
                    htmlReaders.add(new JavaDoc2HTMLTextReader(contentReader));
                    return new SequenceReader(htmlReaders.toArray(new Reader[htmlReaders.size()]));
                }
            }
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        if (useAttachedJavadoc && member.getOpenable().getBuffer() == null && (s = member.getAttachedJavadoc(null)) != null) {
            return new StringReader(s);
        }
        return null;
    }

    public static Reader getHTMLContentReader(ILocalVariable variable, boolean allowInherited, boolean useAttachedDoc) throws JavaScriptModelException {
        Reader contentReader = JSdocContentAccess.getContentReader(variable, allowInherited);
        if (contentReader != null) {
            IDocumentationReader[] docReaders = new IDocumentationReader[0];
            if (docReaders.length > 0) {
                ArrayList<Reader> htmlReaders = new ArrayList<Reader>(docReaders.length);
                int i = 0;
                while (i < docReaders.length) {
                    Reader documentation2htmlReader = docReaders[i].getDocumentation2HTMLReader(contentReader);
                    if (documentation2htmlReader != null) {
                        htmlReaders.add(documentation2htmlReader);
                    }
                    ++i;
                }
                if (!htmlReaders.isEmpty()) {
                    htmlReaders.add(new JavaDoc2HTMLTextReader(contentReader));
                    return new SequenceReader(htmlReaders.toArray(new Reader[htmlReaders.size()]));
                }
            }
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        return null;
    }

    public static Reader getContentReader(ILocalVariable declaration, boolean allowInherited) throws JavaScriptModelException {
        ArrayList<Reader> readers = new ArrayList<Reader>(2);
        IDocumentationReader[] docReaders = JSdocContentAccess.getDocReaders(declaration);
        int i = 0;
        while (i < docReaders.length) {
            Reader contentReader = docReaders[i].getContentReader(declaration, allowInherited);
            if (contentReader != null) {
                readers.add(contentReader);
            }
            ++i;
        }
        if (!readers.isEmpty()) {
            if (readers.size() == 1) {
                return (Reader)readers.get(0);
            }
            return new SequenceReader(readers.toArray(new Reader[readers.size()]));
        }
        return null;
    }

    private static Reader findDocInHierarchy(IFunction method) throws JavaScriptModelException {
        IType type = method.getDeclaringType();
        if (type == null) {
            return null;
        }
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        MethodOverrideTester tester = new MethodOverrideTester(type, hierarchy);
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            Reader reader;
            IType curr = superTypes[i];
            IFunction overridden = tester.findOverriddenMethodInType(curr, method);
            if (overridden != null && (reader = JSdocContentAccess.getContentReader((IMember)overridden, false)) != null) {
                return reader;
            }
            ++i;
        }
        return null;
    }

    private static IDocumentationReader[] getDocReaders(IMember member) {
        if (docReaders == null) {
            JSdocContentAccess.loadExtensions();
        }
        ArrayList<IDocumentationReader> readers = new ArrayList<IDocumentationReader>(docReaders.length);
        int i = 0;
        while (i < docReaders.length) {
            if (docReaders[i].appliesTo(member)) {
                readers.add(docReaders[i]);
            }
            ++i;
        }
        return readers.toArray(new IDocumentationReader[readers.size()]);
    }

    private static IDocumentationReader[] getDocReaders(ILocalVariable declaration) {
        if (docReaders == null) {
            JSdocContentAccess.loadExtensions();
        }
        ArrayList<IDocumentationReader> readers = new ArrayList<IDocumentationReader>(docReaders.length);
        int i = 0;
        while (i < docReaders.length) {
            if (docReaders[i].appliesTo(declaration)) {
                readers.add(docReaders[i]);
            }
            ++i;
        }
        return readers.toArray(new IDocumentationReader[readers.size()]);
    }

    private static void loadExtensions() {
        IExtensionPoint point;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IDocumentationReader> extList = new ArrayList<IDocumentationReader>();
        if (registry != null && (point = registry.getExtensionPoint(JavaScriptPlugin.getPluginId(), "documentationProvider")) != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        IDocumentationReader docProvider = null;
                        if (elements[j].getName().equals("documentationProvider")) {
                            docProvider = (IDocumentationReader)elements[j].createExecutableExtension(ATTR_DOCUMENTATIONPROVIDER_CLASS);
                        }
                        extList.add(docProvider);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                ++i;
            }
        }
        docReaders = extList.toArray(new IDocumentationReader[extList.size()]);
    }
}

