/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.remote;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.examples.providers.RemoteStoreContentProvider;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStore;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.examples.remote.SemanticResourcesPluginExamplesCore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.QualifiedName;

public class RemoteStoreAdapter
implements IAdapterFactory {
    private static final QualifiedName STORE = new QualifiedName(SemanticResourcesPluginExamplesCore.PLUGIN_ID, "TransientStore");

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject != null && adaptableObject instanceof IContainer && adapterType.equals(RemoteStore.class)) {
            IContainer resource = (IContainer)adaptableObject;
            ISemanticFolder sfolder = (ISemanticFolder)resource.getAdapter(ISemanticFolder.class);
            if (sfolder != null) {
                try {
                    ISemanticProject sProject = (ISemanticProject)resource.getProject().getAdapter(ISemanticProject.class);
                    String remoteProjectName = sProject.getPersistentProperty(RemoteStoreContentProvider.USE_PROJECT);
                    if (remoteProjectName != null) {
                        IProject remoteProject = ResourcesPlugin.getWorkspace().getRoot().getProject(remoteProjectName);
                        if (remoteProject.isAccessible()) {
                            RemoteStore store = new RemoteStore((IContainer)remoteProject);
                            try {
                                store.deserialize();
                                return store;
                            }
                            catch (CoreException e) {
                                SemanticResourcesPluginExamplesCore.getDefault().getLog().log(e.getStatus());
                            }
                        }
                        return null;
                    }
                }
                catch (CoreException coreException) {}
            }
            RemoteStore newStore = new RemoteStore(resource);
            try {
                newStore.deserialize();
            }
            catch (CoreException e) {
                SemanticResourcesPluginExamplesCore.getDefault().getLog().log(e.getStatus());
            }
            return newStore;
        }
        if (adaptableObject != null && adaptableObject instanceof IContainer && adapterType.equals(RemoteStoreTransient.class)) {
            IContainer resource = (IContainer)adaptableObject;
            try {
                RemoteStoreTransient store = (RemoteStoreTransient)resource.getSessionProperty(STORE);
                if (store != null) {
                    return store;
                }
            }
            catch (CoreException coreException) {}
            RemoteStoreTransient newStore = new RemoteStoreTransient(resource);
            try {
                resource.setSessionProperty(STORE, (Object)newStore);
            }
            catch (CoreException e) {
                SemanticResourcesPluginExamplesCore.getDefault().getLog().log(e.getStatus());
            }
            return newStore;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{RemoteStore.class, RemoteStoreTransient.class};
    }
}

