/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.cacheservice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.internal.resources.semantic.cacheservice.CachingOutputStream;
import org.eclipse.core.internal.resources.semantic.cacheservice.ICachedContentHandle;
import org.eclipse.core.internal.resources.semantic.cacheservice.IContentHandleFactory;
import org.eclipse.core.internal.resources.semantic.cacheservice.ITemporaryContentHandle;
import org.eclipse.core.internal.resources.semantic.spi.SfsSpiTraceLocation;
import org.eclipse.core.resources.semantic.spi.ICacheService;
import org.eclipse.core.resources.semantic.spi.ICacheUpdateCallback;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CacheService
implements ICacheService {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private IContentHandleFactory handleFactory;

    public CacheService(IContentHandleFactory handleFactory) {
        this.handleFactory = handleFactory;
    }

    protected void lockForRead() {
        this.readLock.lock();
    }

    protected void unlockForRead() {
        this.readLock.unlock();
    }

    protected void lockForWrite() {
        this.writeLock.lock();
    }

    protected void unlockForWrite() {
        this.writeLock.unlock();
    }

    public void addContent(IPath path, InputStream input, int options, IProgressMonitor monitor) throws CoreException {
        ITemporaryContentHandle tempHandle;
        boolean append;
        boolean bl = append = (options & 1) > 0;
        if (SfsSpiTraceLocation.CACHESERVICE.isActive()) {
            SfsSpiTraceLocation.getTrace().traceEntry(SfsSpiTraceLocation.CACHESERVICE.getLocation(), new Object[]{path.toString(), new Boolean(append)});
        }
        try {
            this.lockForWrite();
            tempHandle = this.handleFactory.createTemporaryHandle(this, path, append);
            tempHandle.setContents(input, monitor);
        }
        finally {
            this.unlockForWrite();
        }
        this.addFromTempHandle(tempHandle);
    }

    public InputStream getContent(IPath path) throws CoreException {
        if (SfsSpiTraceLocation.CACHESERVICE.isActive()) {
            SfsSpiTraceLocation.getTrace().traceEntry(SfsSpiTraceLocation.CACHESERVICE.getLocation(), (Object)path.toString());
        }
        try {
            this.lockForRead();
            ICachedContentHandle cacheFile = this.createCacheContentHandle(path);
            if (!cacheFile.exists()) {
                return null;
            }
            InputStream result = cacheFile.openInputStream();
            if (SfsSpiTraceLocation.CACHESERVICE.isActive()) {
                if (result == null) {
                    SfsSpiTraceLocation.getTrace().traceExit(SfsSpiTraceLocation.CACHESERVICE.getLocation(), null);
                } else {
                    int available;
                    try {
                        available = result.available();
                    }
                    catch (IOException iOException) {
                        available = -1;
                    }
                    SfsSpiTraceLocation.getTrace().traceExit(SfsSpiTraceLocation.CACHESERVICE.getLocation(), (Object)("InputStream[" + available + "]"));
                }
            }
            InputStream inputStream = result;
            return inputStream;
        }
        finally {
            this.unlockForRead();
        }
    }

    public boolean hasContent(IPath path) throws CoreException {
        if (SfsSpiTraceLocation.CACHESERVICE.isActive()) {
            SfsSpiTraceLocation.getTrace().traceEntry(SfsSpiTraceLocation.CACHESERVICE.getLocation(), (Object)path.toString());
        }
        try {
            this.lockForRead();
            ICachedContentHandle cacheFile = this.createCacheContentHandle(path);
            if (SfsSpiTraceLocation.CACHESERVICE.isActive()) {
                SfsSpiTraceLocation.getTrace().traceExit(SfsSpiTraceLocation.CACHESERVICE.getLocation(), (Object)new Boolean(cacheFile.exists()));
            }
            boolean bl = cacheFile.exists();
            return bl;
        }
        finally {
            this.unlockForRead();
        }
    }

    public void removeContent(IPath path, IProgressMonitor monitor) throws CoreException {
        if (SfsSpiTraceLocation.CACHESERVICE.isActive()) {
            SfsSpiTraceLocation.getTrace().traceEntry(SfsSpiTraceLocation.CACHESERVICE.getLocation(), (Object)path.toString());
        }
        try {
            this.lockForWrite();
            ICachedContentHandle cacheFile = this.createCacheContentHandle(path);
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
        }
        finally {
            this.unlockForWrite();
        }
    }

    public OutputStream wrapOutputStream(IPath path, boolean append, ICacheUpdateCallback callback, IProgressMonitor monitor) throws CoreException {
        try {
            this.lockForWrite();
            ITemporaryContentHandle tempHandle = this.handleFactory.createTemporaryHandle(this, path, append);
            CachingOutputStream cachingOutputStream = new CachingOutputStream(this, tempHandle, append, callback);
            return cachingOutputStream;
        }
        finally {
            this.unlockForWrite();
        }
    }

    private ICachedContentHandle createCacheContentHandle(IPath path) throws CoreException {
        return this.handleFactory.createCacheContentHandle(this, path);
    }

    void addFromTempHandle(ITemporaryContentHandle tempHandle) throws CoreException {
        try {
            this.lockForWrite();
            tempHandle.commit();
        }
        finally {
            this.unlockForWrite();
        }
    }
}

