/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.spi.ContentProvider;
import org.eclipse.core.resources.semantic.spi.ICacheService;
import org.eclipse.core.resources.semantic.spi.ICacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ICacheUpdateCallback;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.Messages;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public abstract class CachingContentProvider
extends ContentProvider {
    private static final QualifiedName RESOURCE_TIMESTAMP = new QualifiedName("org.eclipse.core.resources.semantic", "ResourceTimestamp");
    public final IDropCacheVisitor deleteAllVisitor = new IDropCacheVisitor(){

        public boolean shouldDrop(ISemanticFileStore store) {
            return store.getType() == 1;
        }
    };
    private ICacheService m_cacheService;

    public ICacheService getCacheService() throws CoreException {
        if (this.m_cacheService == null) {
            this.m_cacheService = this.getCacheServiceFactory().getCacheService();
        }
        return this.m_cacheService;
    }

    public final InputStream openInputStream(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        IPath path;
        ICacheService cacheService = this.getCacheService();
        if (!cacheService.hasContent(path = childStore.getPath())) {
            ICacheTimestampSetter setter = new ICacheTimestampSetter(){
                long lastTimestamp = 0L;

                public void setTimestamp(long timestamp) {
                    this.lastTimestamp = timestamp;
                }

                public long getTimestamp() {
                    return this.lastTimestamp;
                }
            };
            InputStream is = null;
            try {
                is = this.openInputStreamInternal(childStore, monitor, setter);
                cacheService.addContent(path, is, 0, monitor);
                this.setResourceTimestamp(childStore, setter.getTimestamp(), monitor);
            }
            catch (Throwable throwable) {
                Util.safeClose(is);
                throw throwable;
            }
            Util.safeClose(is);
        }
        return cacheService.getContent(path);
    }

    public final OutputStream openOutputStream(final ISemanticFileStore childStore, int options, final IProgressMonitor monitor) throws CoreException {
        ICacheService cacheService = this.getCacheService();
        IPath path = childStore.getPath();
        boolean appendMode = (options & 1) > 0;
        ICacheUpdateCallback callback = new ICacheUpdateCallback(){

            public void cacheUpdated(InputStream newContent, long timestamp, boolean append) throws CoreException {
                CachingContentProvider.this.setResourceTimestamp(childStore, timestamp, monitor);
                CachingContentProvider.this.onCacheUpdate(childStore, newContent, timestamp, append, monitor);
            }
        };
        return cacheService.wrapOutputStream(path, appendMode, callback, monitor);
    }

    protected void deleteCache(ISemanticFileStore store, IProgressMonitor monitor) throws CoreException {
        MultiStatus status = new MultiStatus("org.eclipse.core.resources.semantic", 0, NLS.bind((String)Messages.CachingContentProvider_DeletingCache_XMSG, (Object)store.getPath().toString()), null);
        this.dropCache(store, monitor, this.deleteAllVisitor, status);
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    public void dropCache(ISemanticFileStore childStore, IProgressMonitor monitor, IDropCacheVisitor visitor, MultiStatus status) {
        if (childStore.getType() == 1) {
            if (visitor.shouldDrop(childStore)) {
                try {
                    ICacheService cacheService = this.getCacheService();
                    cacheService.removeContent(childStore.getPath(), monitor);
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                    return;
                }
            }
        } else {
            try {
                IFileStore[] iFileStoreArray = childStore.childStores(0, monitor);
                int n = iFileStoreArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISemanticFileStore sfs;
                    String providerId;
                    IFileStore store = iFileStoreArray[n2];
                    if (store instanceof ISemanticFileStore && (providerId = (sfs = (ISemanticFileStore)store).getContentProviderID()) == null) {
                        this.dropCache((ISemanticFileStore)store, monitor, visitor, status);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                status.add(e.getStatus());
                return;
            }
        }
    }

    protected void fillCache(ISemanticFileStore semanticFileStore, IProgressMonitor monitor, MultiStatus status) {
        if (semanticFileStore.getType() != 1) {
            try {
                IFileStore[] iFileStoreArray = semanticFileStore.childStores(0, monitor);
                int n = iFileStoreArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore store = iFileStoreArray[n2];
                    if (store instanceof ISemanticFileStore) {
                        ISemanticFileStore sfs = (ISemanticFileStore)store;
                        String providerId = sfs.getContentProviderID();
                        if (providerId == null) {
                            this.fillCache((ISemanticFileStore)store, monitor, status);
                        } else {
                            try {
                                ISemanticContentProvider provider = sfs.getEffectiveContentProvider();
                                if (provider instanceof CachingContentProvider) {
                                    ((CachingContentProvider)provider).fillCache((ISemanticFileStore)store, monitor, status);
                                }
                            }
                            catch (CoreException e) {
                                status.add(e.getStatus());
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        } else {
            boolean readOnly;
            if (semanticFileStore.isLocalOnly()) {
                return;
            }
            try {
                readOnly = this.fetchResourceInfo(semanticFileStore, 16, monitor).isReadOnly();
            }
            catch (CoreException e) {
                status.add(e.getStatus());
                return;
            }
            if (readOnly) {
                try {
                    Util.safeClose(this.openInputStream(semanticFileStore, monitor));
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
            }
        }
    }

    public abstract ICacheServiceFactory getCacheServiceFactory() throws CoreException;

    public abstract InputStream openInputStreamInternal(ISemanticFileStore var1, IProgressMonitor var2, ICacheTimestampSetter var3) throws CoreException;

    public void onCacheUpdate(ISemanticFileStore semanticFileStore, InputStream newContent, long timestamp, boolean append, IProgressMonitor monitor) {
    }

    public long getResourceTimestamp(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        if (!semanticFileStore.isExists()) {
            return 0L;
        }
        String stampString = semanticFileStore.getPersistentProperty(RESOURCE_TIMESTAMP);
        if (stampString != null) {
            return Long.parseLong(stampString);
        }
        MultiStatus stat = new MultiStatus("org.eclipse.core.resources.semantic", 0, NLS.bind((String)Messages.CachingContentProvider_FillCache_XGRP, (Object)semanticFileStore.getPath().toString()), null);
        this.fillCache(semanticFileStore, monitor, stat);
        if (!stat.isOK()) {
            throw new CoreException((IStatus)stat);
        }
        stampString = semanticFileStore.getPersistentProperty(RESOURCE_TIMESTAMP);
        if (stampString != null) {
            return Long.parseLong(stampString);
        }
        throw new SemanticResourceException(SemanticResourceStatusCode.CACHED_CONTENT_NOT_FOUND, semanticFileStore.getPath(), Messages.CachingContentProvider_TimestampNotInCache_XMSG);
    }

    public void setResourceTimestamp(ISemanticFileStore semanticFileStore, long timestamp, IProgressMonitor monitor) throws CoreException {
        semanticFileStore.setPersistentProperty(RESOURCE_TIMESTAMP, Long.toString(timestamp));
    }

    public static interface ICacheTimestampSetter {
        public void setTimestamp(long var1);

        public long getTimestamp();
    }

    public static interface IDropCacheVisitor {
        public boolean shouldDrop(ISemanticFileStore var1);
    }
}

