/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.context;

import java.util.WeakHashMap;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.core.services.internal.context.EclipseContext;
import org.eclipse.e4.internal.core.services.osgi.OSGiContextStrategy;
import org.osgi.framework.BundleContext;

public final class EclipseContextFactory {
    private static WeakHashMap serviceContexts = new WeakHashMap();

    public static IEclipseContext create() {
        return EclipseContextFactory.create(null, null);
    }

    public static IEclipseContext create(IEclipseContext parent, IEclipseContextStrategy strategy) {
        EclipseContext eclipseContext = new EclipseContext(parent, strategy);
        eclipseContext.set(IEclipseContext.class.getName(), eclipseContext);
        return eclipseContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IEclipseContext getServiceContext(BundleContext bundleContext) {
        WeakHashMap weakHashMap = serviceContexts;
        synchronized (weakHashMap) {
            IEclipseContext result = (IEclipseContext)serviceContexts.get(bundleContext);
            if (result == null) {
                result = EclipseContextFactory.create(null, new OSGiContextStrategy(bundleContext));
                result.set("debugString", "OSGi context for bundle: " + bundleContext.getBundle().getSymbolicName());
                serviceContexts.put(bundleContext, result);
            }
            return result;
        }
    }

    public static ContextChangeEvent createContextEvent(IEclipseContext context, int eventType, Object[] args, String name, Object oldValue) {
        return new ContextChangeEvent(context, eventType, args, name, oldValue);
    }
}

