/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.context.spi;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.internal.context.ObjectProviderContext;

public final class ContextInjectionFactory {
    private ContextInjectionFactory() {
    }

    public static Object inject(Object object, IEclipseContext context) {
        context.runAndTrack(ObjectProviderContext.getObjectProvider(context), new Object[]{object});
        return object;
    }

    public static Object invoke(Object object, String methodName, IEclipseContext context) throws InvocationTargetException, CoreException {
        ObjectProviderContext objectProvider = ObjectProviderContext.getObjectProvider(context);
        return objectProvider.getInjector().invoke(object, methodName);
    }

    public static Object invoke(Object object, String methodName, IEclipseContext context, Object defaultValue) throws InvocationTargetException {
        ObjectProviderContext objectProvider = ObjectProviderContext.getObjectProvider(context);
        return objectProvider.getInjector().invoke(object, methodName, defaultValue);
    }

    public static void uninject(Object object, IEclipseContext context) {
        ObjectProviderContext objectProvider = ObjectProviderContext.getObjectProvider(context);
        objectProvider.getInjector().uninject(object);
    }

    public static Object make(Class clazz, IEclipseContext context) throws InvocationTargetException, InstantiationException {
        ObjectProviderContext objectProvider = ObjectProviderContext.getObjectProvider(context);
        Object result = objectProvider.getInjector().make(clazz);
        if (result != null) {
            context.runAndTrack(objectProvider, new Object[]{result});
        }
        return result;
    }
}

