/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.internal.services.ServicesActivator;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.injector.IObjectDescriptor;
import org.eclipse.e4.core.services.injector.IObjectProvider;
import org.eclipse.e4.core.services.internal.annotations.AnnotationsSupport;
import org.eclipse.e4.core.services.internal.context.InjectionProperties;
import org.eclipse.e4.core.services.internal.context.WeakRefList;

public class ContextInjector {
    private static final String DEBUG_INJECTOR = "org.eclipse.e4.core.services/debug/injector";
    private static final boolean shouldTrace = ServicesActivator.getDefault().getBooleanDebugOption("org.eclipse.e4.core.services/debug/injector", false);
    private static final String JAVA_OBJECT = "java.lang.Object";
    protected final IObjectProvider context;
    private final AnnotationsSupport annotationSupport;
    protected WeakRefList userObjects = new WeakRefList(3);

    public ContextInjector(IObjectProvider context) {
        this.context = context;
        this.annotationSupport = new AnnotationsSupport(context);
    }

    public void added(IObjectDescriptor descriptor) {
        Object[] objectsCopy = this.userObjects.getSafeCopy();
        Processor processor = new Processor(descriptor, true, false);
        int i = 0;
        while (i < objectsCopy.length) {
            try {
                this.processClassHierarchy(objectsCopy[i], processor);
            }
            catch (InvocationTargetException e) {
                this.logExternalError("Exception occured while processing addition on", objectsCopy[i], e);
            }
            ++i;
        }
    }

    public boolean inject(Object userObject) {
        Processor processor = new Processor(null, true, false);
        processor.shouldProcessPostConstruct = true;
        boolean result = false;
        try {
            result = this.processClassHierarchy(userObject, processor);
        }
        catch (InvocationTargetException e) {
            this.logExternalError("Exception occured while processing injecting", userObject, e);
        }
        this.userObjects.add(userObject);
        return result;
    }

    public void reinject() {
        Processor processor = new Processor(null, true, false);
        Object[] objectsCopy = this.userObjects.getSafeCopy();
        int i = 0;
        while (i < objectsCopy.length) {
            try {
                this.processClassHierarchy(objectsCopy[i], processor);
            }
            catch (InvocationTargetException e) {
                this.logExternalError("Exception occured while processing removal on", objectsCopy[i], e);
            }
            ++i;
        }
    }

    public boolean injectStatic(Class clazz) {
        Processor processor = new Processor(null, true, false);
        processor.shouldProcessPostConstruct = true;
        processor.setProcessStatic(true);
        try {
            Object object = this.make(clazz);
            return this.processClassHierarchy(object, processor);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void removed(IObjectDescriptor descriptor) {
        Processor processor = new Processor(descriptor, false, false);
        Object[] objectsCopy = this.userObjects.getSafeCopy();
        int i = 0;
        while (i < objectsCopy.length) {
            try {
                this.processClassHierarchy(objectsCopy[i], processor);
            }
            catch (InvocationTargetException e) {
                this.logExternalError("Exception occured while processing removal on", objectsCopy[i], e);
            }
            ++i;
        }
    }

    public boolean uninject(Object releasedObject) {
        if (!this.userObjects.remove(releasedObject)) {
            return false;
        }
        Processor processor = new Processor(null, false, false);
        processor.setInjectNulls(true);
        try {
            return this.processClassHierarchy(releasedObject, processor);
        }
        catch (InvocationTargetException e) {
            this.logExternalError("Exception occured while uninjecting", releasedObject, e);
            return false;
        }
    }

    public void dispose() {
        Object[] objectsCopy = this.userObjects.getSafeCopy();
        Processor processor = new Processor(null, false, true);
        processor.setInjectNulls(true);
        int i = 0;
        while (i < objectsCopy.length) {
            if (objectsCopy[i] instanceof IDisposable) {
                ((IDisposable)objectsCopy[i]).dispose();
            }
            try {
                this.processClassHierarchy(objectsCopy[i], processor);
            }
            catch (InvocationTargetException e) {
                this.logExternalError("Exception occured while disposing", objectsCopy[i], e);
            }
            ++i;
        }
    }

    public void reparent(IObjectProvider oldParent) {
        if (oldParent == this.context) {
            return;
        }
        Object[] objectsCopy = this.userObjects.getSafeCopy();
        ReparentProcessor processor = new ReparentProcessor(oldParent);
        int i = 0;
        while (i < objectsCopy.length) {
            try {
                this.processClassHierarchy(objectsCopy[i], processor);
            }
            catch (InvocationTargetException e) {
                this.logExternalError("Exception occured while reparenting", objectsCopy[i], e);
            }
            ++i;
        }
    }

    private boolean processClass(Class objectsClass, Processor processor) throws InvocationTargetException {
        if (processor.addition) {
            Class superClass;
            if (objectsClass != null && !(superClass = objectsClass.getSuperclass()).getName().equals(JAVA_OBJECT)) {
                processor.classHierarchy.add(objectsClass);
                if (!this.processClass(superClass, processor)) {
                    return false;
                }
                processor.classHierarchy.remove(objectsClass);
            }
            if (!this.processFields(objectsClass, processor)) {
                return false;
            }
            if (!this.processMethods(objectsClass, processor)) {
                return false;
            }
        } else {
            Class superClass;
            if (!this.processMethods(objectsClass, processor)) {
                return false;
            }
            if (!this.processFields(objectsClass, processor)) {
                return false;
            }
            if (objectsClass != null && !(superClass = objectsClass.getSuperclass()).getName().equals(JAVA_OBJECT)) {
                processor.classHierarchy.add(objectsClass);
                if (!this.processClass(superClass, processor)) {
                    return false;
                }
                processor.classHierarchy.remove(objectsClass);
            }
        }
        return true;
    }

    private boolean processClassHierarchy(Object userObject, Processor processor) throws InvocationTargetException {
        processor.setObject(userObject);
        if (!this.processClass(userObject == null ? null : userObject.getClass(), processor)) {
            return false;
        }
        processor.processPostConstructMethod();
        return true;
    }

    private boolean processFields(Class objectsClass, Processor processor) {
        Field[] fields = objectsClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            InjectionProperties properties = this.annotationSupport.getInjectProperties(field);
            if (field.getName().startsWith("inject__")) {
                properties.setInject(true);
            }
            if (properties.shouldInject() && !processor.processField(field, properties)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean processMethods(Class objectsClass, Processor processor) throws InvocationTargetException {
        Method method;
        int i;
        Method[] methods = objectsClass.getDeclaredMethods();
        if (processor.isInDispose) {
            i = 0;
            while (i < methods.length) {
                method = methods[i];
                if (method.getParameterTypes().length <= 0 && this.annotationSupport.isPreDestory(method) && !this.isOverridden(method, processor)) {
                    this.callMethod(processor.userObject, method, null);
                }
                ++i;
            }
        }
        i = 0;
        while (i < methods.length) {
            method = methods[i];
            if (!this.isOverridden(method, processor)) {
                if (processor.shouldProcessPostConstruct && this.isPostConstruct(method)) {
                    processor.addPostConstructMethod(method);
                } else {
                    InjectionProperties properties = this.annotationSupport.getInjectProperties(method);
                    if (method.getName().startsWith("inject__")) {
                        properties.setInject(true);
                    }
                    if (properties.shouldInject() && !processor.processMethod(method, properties.isOptional())) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isPostConstruct(Method method) {
        boolean isPostConstruct = this.annotationSupport.isPostConstruct(method);
        if (isPostConstruct) {
            return true;
        }
        if (!method.getName().equals("contextSet")) {
            return false;
        }
        Class<?>[] parms = method.getParameterTypes();
        if (parms.length == 0) {
            return true;
        }
        return parms.length == 1 && parms[0].equals(IEclipseContext.class);
    }

    private boolean isOverridden(Method method, Processor processor) {
        int modifiers = method.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        boolean isDefault = !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers);
        for (Class subClass : processor.classHierarchy) {
            Method override = null;
            try {
                override = subClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (override == null) continue;
            if (isDefault) {
                Package originalPackage = method.getDeclaringClass().getPackage();
                Package overridePackage = subClass.getPackage();
                if (originalPackage == null && overridePackage == null) {
                    return true;
                }
                if (originalPackage == null || overridePackage == null) {
                    return false;
                }
                if (!originalPackage.equals(overridePackage)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public Object invoke(Object userObject, String methodName) throws InvocationTargetException, CoreException {
        Method[] methods = userObject.getClass().getDeclaredMethods();
        int j = 0;
        while (j < methods.length) {
            InjectionProperties[] properties;
            Object[] actualParams;
            Method method = methods[j];
            if (method.getName().equals(methodName) && (actualParams = this.processParams(properties = this.annotationSupport.getInjectParamProperties(method), method.getParameterTypes(), false, false)) != null) {
                return this.callMethod(userObject, method, actualParams);
            }
            ++j;
        }
        Status status = new Status(4, "org.eclipse.e4.core.services", "Unable to find matching method to invoke");
        throw new CoreException((IStatus)status);
    }

    public Object invoke(Object userObject, String methodName, Object defaultValue) throws InvocationTargetException {
        return this.invokeUsingClass(userObject, userObject.getClass(), methodName, defaultValue);
    }

    public Object invokeUsingClass(Object userObject, Class currentClass, String methodName, Object defaultValue) throws InvocationTargetException {
        Method[] methods = currentClass.getDeclaredMethods();
        int j = 0;
        while (j < methods.length) {
            InjectionProperties[] properties;
            Object[] actualParams;
            Method method = methods[j];
            if (method.getName().equals(methodName) && (actualParams = this.processParams(properties = this.annotationSupport.getInjectParamProperties(method), method.getParameterTypes(), false, false)) != null) {
                return this.callMethod(userObject, method, actualParams);
            }
            ++j;
        }
        Class superClass = currentClass.getSuperclass();
        if (superClass == null) {
            return defaultValue;
        }
        return this.invokeUsingClass(userObject, superClass, methodName, defaultValue);
    }

    public Object make(Class clazz) throws InvocationTargetException, InstantiationException {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        ArrayList sortedConstructors = new ArrayList(constructors.length);
        int i = 0;
        while (i < constructors.length) {
            sortedConstructors.add(constructors[i]);
            ++i;
        }
        Collections.sort(sortedConstructors, new Comparator(){

            public int compare(Object c1, Object c2) {
                int l1 = ((Constructor)c1).getParameterTypes().length;
                int l2 = ((Constructor)c2).getParameterTypes().length;
                return l2 - l1;
            }
        });
        for (Constructor constructor : sortedConstructors) {
            Object newInstance;
            InjectionProperties[] properties;
            Object[] actualParams;
            InjectionProperties cProps;
            if ((constructor.getModifiers() & 2) != 0 || (constructor.getModifiers() & 4) != 0 || !(cProps = this.annotationSupport.getInjectProperties(constructor)).shouldInject() && constructor.getParameterTypes().length != 0 || (actualParams = this.processParams(properties = this.annotationSupport.getInjectParamsProperties(constructor), constructor.getParameterTypes(), false, false)) == null || (newInstance = this.callConstructor(constructor, actualParams)) == null) continue;
            return newInstance;
        }
        if (shouldTrace) {
            System.out.println("Could not find satisfiable constructor in class " + clazz.getName());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Object[] processParams(InjectionProperties[] properties, Class[] parameterTypes, boolean ignoreMissing, boolean injectWithNulls) {
        actualParams = new Object[properties.length];
        i = 0;
        while (i < actualParams.length) {
            block8: {
                block7: {
                    provider = properties[i].getProvider();
                    if (provider == null) break block7;
                    actualParams[i] = provider;
                    break block8;
                }
                if (!this.context.containsKey(properties[i])) ** GOTO lbl-1000
                if (injectWithNulls) {
                    actualParams[i] = null;
                } else {
                    candidate = this.context.get(properties[i]);
                    if (candidate != null && parameterTypes[i].isAssignableFrom(candidate.getClass())) {
                        actualParams[i] = candidate;
                    } else if (ignoreMissing || properties[i].isOptional()) {
                        actualParams[i] = null;
                    } else {
                        return null;
                    }
                }
            }
            ++i;
        }
        return actualParams;
    }

    private boolean setField(Object userObject, Field field, Object value) {
        if (value != null && !field.getType().isAssignableFrom(value.getClass())) {
            return false;
        }
        boolean wasAccessible = true;
        if (!field.isAccessible()) {
            field.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                field.set(userObject, value);
            }
            catch (IllegalArgumentException e) {
                this.logError(field, e);
                if (!wasAccessible) {
                    field.setAccessible(false);
                }
                return false;
            }
            catch (IllegalAccessException e) {
                this.logError(field, e);
                if (!wasAccessible) {
                    field.setAccessible(false);
                }
                return false;
            }
        }
        finally {
            if (!wasAccessible) {
                field.setAccessible(false);
            }
        }
        return true;
    }

    private Object callMethod(Object userObject, Method method, Object[] args) throws InvocationTargetException {
        Object result = null;
        boolean wasAccessible = true;
        if (!method.isAccessible()) {
            method.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                result = method.invoke(userObject, args);
            }
            catch (IllegalArgumentException e) {
                this.logError(method, e);
                if (!wasAccessible) {
                    method.setAccessible(false);
                }
                return null;
            }
            catch (IllegalAccessException e) {
                this.logError(method, e);
                if (!wasAccessible) {
                    method.setAccessible(false);
                }
                return null;
            }
        }
        finally {
            if (!wasAccessible) {
                method.setAccessible(false);
            }
        }
        return result;
    }

    private Object callConstructor(Constructor constructor, Object[] args) throws InvocationTargetException, InstantiationException {
        if (args != null) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != args.length) {
                this.logError(constructor, new IllegalArgumentException());
                return null;
            }
            int i = 0;
            while (i < args.length) {
                if (args[i] != null && !parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    return null;
                }
                ++i;
            }
        }
        Object result = null;
        boolean wasAccessible = true;
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                result = constructor.newInstance(args);
            }
            catch (IllegalArgumentException e) {
                this.logError(constructor, e);
                if (!wasAccessible) {
                    constructor.setAccessible(false);
                }
                return null;
            }
            catch (IllegalAccessException e) {
                this.logError(constructor, e);
                if (!wasAccessible) {
                    constructor.setAccessible(false);
                }
                return null;
            }
        }
        finally {
            if (!wasAccessible) {
                constructor.setAccessible(false);
            }
        }
        return result;
    }

    private void logExternalError(String msg, Object destination, Exception e) {
        System.out.println(String.valueOf(msg) + " " + destination.toString());
        if (e != null) {
            e.printStackTrace();
        }
    }

    private void logError(Object destination, Exception e) {
        System.out.println("Injection failed " + destination.toString());
        if (e != null) {
            e.printStackTrace();
        }
    }

    private class Processor {
        private final IObjectDescriptor descriptor;
        protected boolean addition;
        protected boolean shouldProcessPostConstruct = false;
        protected boolean isInDispose = false;
        protected Object userObject;
        protected boolean injectWithNulls = false;
        protected boolean processStatic = false;
        private List postConstructMethods;
        public ArrayList classHierarchy = new ArrayList(5);

        public Processor(IObjectDescriptor descriptor, boolean addition, boolean isInDispose) {
            this.descriptor = descriptor;
            this.addition = addition;
            this.isInDispose = isInDispose;
        }

        public void setObject(Object userObject) {
            this.userObject = userObject;
            this.classHierarchy.clear();
        }

        public void setInjectNulls(boolean injectWithNulls) {
            this.injectWithNulls = injectWithNulls;
        }

        public void setProcessStatic(boolean processStatic) {
            this.processStatic = processStatic;
        }

        public boolean processField(Field field, InjectionProperties properties) {
            String descriptorsKey;
            if (Modifier.isStatic(field.getModifiers()) != this.processStatic) {
                return true;
            }
            if (this.descriptor != null && !(descriptorsKey = ContextInjector.this.context.getKey(this.descriptor)).equals(ContextInjector.this.context.getKey(properties))) {
                return true;
            }
            Object value = null;
            if (this.addition) {
                Object provider = properties.getProvider();
                if (provider != null) {
                    value = provider;
                } else if (ContextInjector.this.context.containsKey(properties)) {
                    value = ContextInjector.this.context.get(properties);
                } else {
                    if (!properties.isOptional()) {
                        if (shouldTrace) {
                            System.out.println("Could not set " + field.getName() + " because of the missing: " + ContextInjector.this.context.getKey(properties));
                        }
                        return false;
                    }
                    return true;
                }
            }
            return ContextInjector.this.setField(this.userObject, field, value);
        }

        public boolean processMethod(Method method, boolean optional) throws InvocationTargetException {
            Object[] actualParams;
            if (Modifier.isStatic(method.getModifiers()) != this.processStatic) {
                return true;
            }
            InjectionProperties[] properties = ContextInjector.this.annotationSupport.getInjectParamProperties(method);
            if (this.descriptor != null) {
                boolean found = false;
                String descriptorsKey = ContextInjector.this.context.getKey(this.descriptor);
                int i = 0;
                while (i < properties.length) {
                    if (descriptorsKey.equals(ContextInjector.this.context.getKey(properties[i]))) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    return true;
                }
            }
            if ((actualParams = ContextInjector.this.processParams(properties, method.getParameterTypes(), !this.addition, this.injectWithNulls)) != null) {
                ContextInjector.this.callMethod(this.userObject, method, actualParams);
            } else if (!optional) {
                if (shouldTrace) {
                    System.out.println("Could not invoke " + method.getName() + ": no matching context elements");
                }
                return false;
            }
            return true;
        }

        public void addPostConstructMethod(Method method) {
            if (this.postConstructMethods == null) {
                this.postConstructMethods = new ArrayList(1);
            }
            this.postConstructMethods.add(method);
        }

        public void processPostConstructMethod() throws InvocationTargetException {
            if (!this.shouldProcessPostConstruct) {
                return;
            }
            if (this.postConstructMethods == null) {
                return;
            }
            for (Method method : this.postConstructMethods) {
                InjectionProperties[] properties = ContextInjector.this.annotationSupport.getInjectParamProperties(method);
                Object[] actualParams = ContextInjector.this.processParams(properties, method.getParameterTypes(), !this.addition, this.injectWithNulls);
                if (actualParams == null) {
                    ContextInjector.this.logError(this.userObject, new IllegalArgumentException());
                    continue;
                }
                ContextInjector.this.callMethod(this.userObject, method, actualParams);
            }
            this.postConstructMethods.clear();
        }
    }

    private class ReparentProcessor
    extends Processor {
        private IObjectProvider oldParent;

        public ReparentProcessor(IObjectProvider oldParent) {
            super(null, true, false);
            this.oldParent = oldParent;
        }

        private boolean hasChanged(InjectionProperties key) {
            Object newValue;
            Object oldValue = this.oldParent.get(key);
            return oldValue != (newValue = ContextInjector.this.context.get(key));
        }

        public boolean processField(Field field, InjectionProperties properties) {
            if (this.hasChanged(properties)) {
                return super.processField(field, properties);
            }
            return true;
        }

        public boolean processMethod(Method method, boolean optional) throws InvocationTargetException {
            InjectionProperties[] properties = ContextInjector.this.annotationSupport.getInjectParamProperties(method);
            boolean changed = false;
            int i = 0;
            while (i < properties.length) {
                if (this.hasChanged(properties[i])) {
                    changed = true;
                    break;
                }
                ++i;
            }
            if (changed) {
                return super.processMethod(method, optional);
            }
            return true;
        }
    }
}

