/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IContextFunction;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.IRunAndTrack;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.core.services.context.spi.ILookupStrategy;
import org.eclipse.e4.core.services.context.spi.ISchedulerStrategy;
import org.eclipse.e4.core.services.internal.context.Computation;
import org.eclipse.e4.core.services.internal.context.ValueComputation;

public class EclipseContext
implements IEclipseContext,
IDisposable {
    static ThreadLocal currentComputation = new ThreadLocal();
    public static boolean DEBUG = false;
    public static boolean DEBUG_VERBOSE = false;
    public static String DEBUG_VERBOSE_NAME = null;
    private DebugSnap snapshot;
    private static final Object[] NO_ARGUMENTS = new Object[0];
    final Set listeners = new HashSet();
    final Map localValueComputations = Collections.synchronizedMap(new HashMap());
    final Map localValues = Collections.synchronizedMap(new HashMap());
    private final IEclipseContextStrategy strategy;
    private ArrayList modifiable;

    public EclipseContext(IEclipseContext parent, IEclipseContextStrategy strategy) {
        this.strategy = strategy;
        this.set("parentContext", parent);
    }

    public boolean containsKey(String name) {
        return this.containsKey(name, false);
    }

    public boolean containsKey(String name, boolean localOnly) {
        if (this.isSetLocally(name)) {
            return true;
        }
        if (localOnly) {
            return false;
        }
        IEclipseContext parent = (IEclipseContext)this.getLocal("parentContext");
        if (parent != null && parent.containsKey(name)) {
            return true;
        }
        return this.strategy instanceof ILookupStrategy && ((ILookupStrategy)this.strategy).containsKey(name, this);
    }

    public void debugSnap() {
        this.snapshot = new DebugSnap();
        this.snapshot.listeners = new HashSet(this.listeners);
        this.snapshot.localValueComputations = new HashMap(this.localValueComputations);
        this.snapshot.localValues = new HashMap(this.localValues);
    }

    public void debugDiff() {
        if (this.snapshot == null) {
            return;
        }
        HashSet listenerDiff = new HashSet(this.listeners);
        listenerDiff.removeAll(this.snapshot.listeners);
        listenerDiff = new HashSet(listenerDiff);
        System.out.println("Listener diff: ");
        Iterator it = listenerDiff.iterator();
        while (it.hasNext()) {
            System.out.println("\t" + it.next());
        }
        HashSet computationDiff = new HashSet(this.localValueComputations.values());
        computationDiff.removeAll(this.snapshot.localValueComputations.values());
        System.out.println("localValueComputations diff:");
        Iterator it2 = computationDiff.iterator();
        while (it2.hasNext()) {
            System.out.println("\t" + it2.next());
        }
        HashSet valuesDiff = new HashSet(this.localValues.values());
        valuesDiff.removeAll(this.snapshot.localValues.values());
        System.out.println("localValues diff:");
        Iterator it3 = valuesDiff.iterator();
        while (it3.hasNext()) {
            System.out.println("\t" + it3.next());
        }
    }

    public void dispose() {
        Computation[] ls = this.listeners.toArray(new Computation[this.listeners.size()]);
        ContextChangeEvent event = EclipseContextFactory.createContextEvent(this, 3, null, null, null);
        int i = 0;
        while (i < ls.length) {
            ArrayList scheduled = new ArrayList();
            ls[i].handleInvalid(event, scheduled);
            this.processScheduled(scheduled);
            ++i;
        }
        if (this.strategy instanceof IDisposable) {
            ((IDisposable)((Object)this.strategy)).dispose();
        }
    }

    public Object get(String name) {
        return this.internalGet(this, name, NO_ARGUMENTS, false);
    }

    public Object get(String name, Object[] arguments) {
        return this.internalGet(this, name, arguments, false);
    }

    public Object getLocal(String name) {
        return this.internalGet(this, name, null, true);
    }

    public Object internalGet(EclipseContext originatingContext, String name, Object[] arguments, boolean local) {
        IEclipseContext parent;
        ValueComputation valueComputation;
        this.trackAccess(name);
        if (DEBUG_VERBOSE) {
            System.out.println("IEC.get(" + name + ", " + arguments + ", " + local + "):" + originatingContext + " for " + this.toString());
        }
        LookupKey lookupKey = new LookupKey(name, arguments);
        if (this == originatingContext && (valueComputation = (ValueComputation)this.localValueComputations.get(lookupKey)) != null) {
            return valueComputation.get(arguments);
        }
        Object result = this.localValues.get(name);
        if (result == null && this.strategy instanceof ILookupStrategy) {
            result = ((ILookupStrategy)this.strategy).lookup(name, originatingContext);
        }
        if (result != null) {
            if (result instanceof IContextFunction) {
                ValueComputation valueComputation2 = new ValueComputation(this, originatingContext, name, (IContextFunction)result);
                if (DEBUG) {
                    System.out.println("created " + valueComputation2);
                }
                originatingContext.localValueComputations.put(lookupKey, valueComputation2);
                if (this != originatingContext) {
                    valueComputation2.addDependency(originatingContext, "parentContext");
                }
                result = valueComputation2.get(arguments);
            }
            if (DEBUG_VERBOSE) {
                System.out.println("IEC.get(" + name + "): " + result);
            }
            return result;
        }
        if (!local && (parent = (IEclipseContext)this.getLocal("parentContext")) != null) {
            return ((EclipseContext)parent).internalGet(originatingContext, name, arguments, local);
        }
        return null;
    }

    protected void invalidate(String name, int eventType, Object oldValue, List scheduled) {
        if (DEBUG) {
            System.out.println("invalidating " + this + ',' + name);
        }
        this.removeLocalValueComputations(name);
        Computation[] ls = this.listeners.toArray(new Computation[this.listeners.size()]);
        ContextChangeEvent event = EclipseContextFactory.createContextEvent(this, eventType, null, name, oldValue);
        int i = 0;
        while (i < ls.length) {
            ls[i].handleInvalid(event, scheduled);
            ++i;
        }
    }

    private boolean isSetLocally(String name) {
        this.trackAccess(name);
        return this.localValues.containsKey(name);
    }

    public void remove(String name) {
        if (this.isSetLocally(name)) {
            Object oldValue = this.localValues.remove(name);
            ArrayList scheduled = new ArrayList();
            this.invalidate(name, 2, oldValue, scheduled);
            this.processScheduled(scheduled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLocalValueComputations(String name) {
        Map map = this.localValueComputations;
        synchronized (map) {
            Iterator it = this.localValueComputations.keySet().iterator();
            while (it.hasNext()) {
                LookupKey key = (LookupKey)it.next();
                if (!key.name.equals(name)) continue;
                Object removed = this.localValueComputations.get(key);
                if (removed instanceof ValueComputation) {
                    ((ValueComputation)removed).clear(this, name);
                }
                it.remove();
            }
        }
    }

    public void runAndTrack(IRunAndTrack runnable, Object[] args) {
        ContextChangeEvent event = EclipseContextFactory.createContextEvent(this, 0, args, null, null);
        TrackableComputationExt computation = new TrackableComputationExt(runnable);
        computation.notify(event);
    }

    protected void processScheduled(List scheduledList) {
        boolean useScheduler = this.strategy != null && this.strategy instanceof ISchedulerStrategy;
        for (Scheduled scheduled : scheduledList) {
            if (useScheduler) {
                ((ISchedulerStrategy)this.strategy).schedule(scheduled.runnable, scheduled.event);
                continue;
            }
            scheduled.runnable.notify(scheduled.event);
        }
    }

    public void set(String name, Object value) {
        boolean containsKey = this.localValues.containsKey(name);
        Object oldValue = this.localValues.put(name, value);
        if (!containsKey || value != oldValue) {
            if (DEBUG_VERBOSE) {
                System.out.println("IEC.set(" + name + "," + value + "):" + oldValue + " for " + this.toString());
            }
            ArrayList scheduled = new ArrayList();
            this.invalidate(name, 1, oldValue, scheduled);
            this.processScheduled(scheduled);
        }
    }

    public void modify(String name, Object value) {
        ArrayList scheduled = new ArrayList();
        if (!this.internalModify(name, value, scheduled)) {
            this.set(name, value);
        }
        this.processScheduled(scheduled);
    }

    public boolean internalModify(String name, Object value, List scheduled) {
        boolean containsKey = this.localValues.containsKey(name);
        if (containsKey) {
            if (!this.checkModifiable(name)) {
                String tmp = "Variable " + name + " is not modifiable in the context " + this.toString();
                throw new IllegalArgumentException(tmp);
            }
            Object oldValue = this.localValues.put(name, value);
            if (value != oldValue) {
                if (DEBUG_VERBOSE) {
                    System.out.println("IEC.set(" + name + "," + value + "):" + oldValue + " for " + this.toString());
                }
                this.invalidate(name, 1, oldValue, scheduled);
            }
            return true;
        }
        EclipseContext parent = this.getParent();
        if (parent != null) {
            return parent.internalModify(name, value, scheduled);
        }
        return false;
    }

    public EclipseContext getParent() {
        return (EclipseContext)this.localValues.get("parentContext");
    }

    public String toString() {
        Object debugString = this.localValues.get("debugString");
        return debugString instanceof String ? (String)debugString : "Anonymous Context";
    }

    private void trackAccess(String name) {
        Computation computation = (Computation)currentComputation.get();
        if (computation != null) {
            computation.addDependency(this, name);
        }
    }

    public void declareModifiable(String name) {
        if (name == null) {
            return;
        }
        if (this.modifiable == null) {
            this.modifiable = new ArrayList(3);
        }
        this.modifiable.add(name);
        if (this.localValues.containsKey(name)) {
            return;
        }
        this.localValues.put(name, null);
    }

    private boolean checkModifiable(String name) {
        if (this.modifiable == null) {
            return false;
        }
        for (String candidate : this.modifiable) {
            if (!candidate.equals(name)) continue;
            return true;
        }
        return false;
    }

    static class DebugSnap {
        Set listeners = new HashSet();
        Map localValueComputations = Collections.synchronizedMap(new HashMap());
        Map localValues = Collections.synchronizedMap(new HashMap());

        DebugSnap() {
        }
    }

    static class LookupKey {
        Object[] arguments;
        String name;

        public LookupKey(String name, Object[] arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LookupKey other = (LookupKey)obj;
            if (!Arrays.equals(this.arguments, other.arguments)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int result = 1;
            result *= 31;
            if (this.arguments != null) {
                int i = 0;
                while (i < this.arguments.length) {
                    Object arg = this.arguments[i];
                    result = 31 * result + (arg == null ? 0 : arg.hashCode());
                    ++i;
                }
            }
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public String toString() {
            return "Key(" + this.name + ',' + Arrays.asList(this.arguments) + ')';
        }
    }

    private static class Scheduled {
        public IRunAndTrack runnable;
        public ContextChangeEvent event;

        public Scheduled(IRunAndTrack runnable, ContextChangeEvent event) {
            this.runnable = runnable;
            this.event = event;
        }

        public int hashCode() {
            return 31 * (31 + this.event.hashCode()) + this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Scheduled other = (Scheduled)obj;
            if (!this.event.equals(other.event)) {
                return false;
            }
            return this.runnable.equals(other.runnable);
        }
    }

    static class TrackableComputationExt
    extends Computation
    implements IRunAndTrack {
        private IRunAndTrack runnable;

        public int hashCode() {
            return 31 + (this.runnable == null ? 0 : this.runnable.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TrackableComputationExt other = (TrackableComputationExt)obj;
            return !(this.runnable == null ? other.runnable != null : !this.runnable.equals(other.runnable));
        }

        public TrackableComputationExt(IRunAndTrack runnable) {
            this.runnable = runnable;
        }

        protected final void doHandleInvalid(ContextChangeEvent event, List scheduledList) {
            int eventType = event.getEventType();
            if (eventType == 0 || eventType == 3) {
                this.notify(event);
            } else {
                Scheduled toBeScheduled = new Scheduled(this, event);
                for (Scheduled scheduled : scheduledList) {
                    if (!scheduled.equals(toBeScheduled)) continue;
                    return;
                }
                scheduledList.add(toBeScheduled);
            }
        }

        public boolean notify(ContextChangeEvent event) {
            Computation oldComputation = (Computation)currentComputation.get();
            currentComputation.set(this);
            boolean result = true;
            try {
                result = this.runnable.notify(event);
            }
            finally {
                currentComputation.set(oldComputation);
            }
            if (result) {
                this.startListening();
            } else {
                this.removeAll();
            }
            return result;
        }

        public String toString() {
            return "TrackableComputationExt(" + this.runnable + ')';
        }
    }
}

