/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.IRunAndTrack;
import org.eclipse.e4.core.services.injector.IObjectDescriptor;
import org.eclipse.e4.core.services.injector.IObjectProvider;
import org.eclipse.e4.core.services.injector.Injector;
import org.eclipse.e4.core.services.internal.context.InjectionProperties;

public class ObjectProviderContext
implements IObjectProvider,
IRunAndTrack {
    private static final String ECLIPSE_CONTEXT_NAME = IEclipseContext.class.getName();
    private final IEclipseContext context;
    private Injector injector;

    public ObjectProviderContext(IEclipseContext context) {
        this.context = context;
    }

    public boolean containsKey(IObjectDescriptor properties) {
        String key = this.getKey(properties);
        if (key == null) {
            return false;
        }
        if (ECLIPSE_CONTEXT_NAME.equals(key)) {
            return this.context != null;
        }
        return this.context.containsKey(key);
    }

    public Object get(IObjectDescriptor properties) {
        String key = this.getKey(properties);
        if (key == null) {
            return null;
        }
        if (ECLIPSE_CONTEXT_NAME.equals(key)) {
            return this.context;
        }
        return this.context.get(key);
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public String getKey(IObjectDescriptor key) {
        String result = key.getPropertyName();
        if (result != null) {
            return result;
        }
        Class elementClass = key.getElementClass();
        if (elementClass != null) {
            return elementClass.getName();
        }
        return null;
    }

    public String toString() {
        return "ContextToInjectorLink(" + this.context + ')';
    }

    public boolean notify(ContextChangeEvent event) {
        switch (event.getEventType()) {
            case 0: {
                this.injector.inject(event.getArguments()[0]);
                break;
            }
            case 4: {
                this.injector.uninject(event.getArguments()[0]);
                break;
            }
            case 3: {
                if (event.getContext() == this.context) {
                    this.injector.dispose();
                    break;
                }
                this.injector.reinject();
                break;
            }
            case 1: {
                String name = event.getName();
                if ("parentContext".equals(name)) {
                    this.handleParentChange(event);
                    break;
                }
                this.injector.added(new InjectionProperties(true, name, false, null));
                break;
            }
            case 2: {
                String name = event.getName();
                if ("parentContext".equals(name)) {
                    this.handleParentChange(event);
                    break;
                }
                this.injector.removed(new InjectionProperties(true, name, false, null));
            }
        }
        return true;
    }

    private void handleParentChange(ContextChangeEvent event) {
        IEclipseContext newParent;
        IEclipseContext eventContext = event.getContext();
        IEclipseContext oldParent = (IEclipseContext)event.getOldValue();
        if (oldParent == (newParent = (IEclipseContext)eventContext.get("parentContext"))) {
            return;
        }
        this.injector.reparent(ObjectProviderContext.getObjectProvider(oldParent));
    }

    public static ObjectProviderContext getObjectProvider(IEclipseContext context) {
        String key = ObjectProviderContext.class.getName();
        if (context.containsKey(key, true)) {
            return (ObjectProviderContext)context.get(key);
        }
        ObjectProviderContext objectProvider = new ObjectProviderContext(context);
        Injector injector = new Injector(objectProvider);
        objectProvider.setInjector(injector);
        context.set(key, objectProvider);
        return objectProvider;
    }
}

