/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.core.services.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IContextFunction;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ILookupStrategy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGiContextStrategy
implements ILookupStrategy,
IDisposable,
ServiceTrackerCustomizer {
    private final BundleContext bundleContext;
    private Map services = Collections.synchronizedMap(new HashMap());

    public OSGiContextStrategy(BundleContext bc) {
        this.bundleContext = bc;
    }

    public Object addingService(ServiceReference reference) {
        String name = this.serviceName(reference);
        Object newValue = this.bundleContext.getService(reference);
        if (newValue == null) {
            return null;
        }
        ServiceData data = (ServiceData)this.services.get(name);
        if (data == null) {
            return null;
        }
        Iterator it = data.users.keySet().iterator();
        while (it.hasNext()) {
            ((IEclipseContext)it.next()).set(name, newValue);
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanReferences() {
        Map map = this.services;
        synchronized (map) {
            Iterator it = this.services.values().iterator();
            while (it.hasNext()) {
                ServiceData data = (ServiceData)it.next();
                if (!data.users.isEmpty()) continue;
                data.tracker.close();
                it.remove();
            }
        }
    }

    public boolean containsKey(String name, IEclipseContext context) {
        this.cleanReferences();
        if (this.getContextFunction(name) != null) {
            return true;
        }
        return this.bundleContext.getServiceReference(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = this.services;
        synchronized (map) {
            Iterator it = this.services.values().iterator();
            while (it.hasNext()) {
                ((ServiceData)it.next()).tracker.close();
            }
            this.services.clear();
        }
    }

    public Object lookup(String name, IEclipseContext originatingContext) {
        this.cleanReferences();
        ServiceData data = (ServiceData)this.services.get(name);
        if (data == null) {
            ServiceReference ref = this.getContextFunction(name);
            if (ref != null) {
                return this.bundleContext.getService(ref);
            }
            data = new ServiceData(name);
            try {
                data.tracker = new ServiceTracker(this.bundleContext, name, (ServiceTrackerCustomizer)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            data.addContext(originatingContext);
            this.services.put(name, data);
            data.tracker.open();
        } else {
            data.addContext(originatingContext);
        }
        return data.tracker.getService();
    }

    private ServiceReference getContextFunction(String name) {
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(IContextFunction.SERVICE_NAME, "(service.context.key=" + name + ')');
            if (refs != null && refs.length > 0) {
                return refs[0];
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        String name = this.serviceName(reference);
        ServiceData data = (ServiceData)this.services.get(name);
        if (data == null) {
            return;
        }
        Iterator it = data.users.keySet().iterator();
        while (it.hasNext()) {
            ((IEclipseContext)it.next()).set(name, service);
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        String name = this.serviceName(reference);
        ServiceData data = (ServiceData)this.services.get(name);
        if (data == null) {
            return;
        }
        Iterator it = data.users.keySet().iterator();
        while (it.hasNext()) {
            ((IEclipseContext)it.next()).set(name, null);
        }
        this.bundleContext.ungetService(reference);
    }

    private String serviceName(ServiceReference reference) {
        return ((String[])reference.getProperty("objectClass"))[0];
    }

    class ServiceData {
        String name;
        ServiceTracker tracker;
        final Map users = new WeakHashMap();

        ServiceData(String name) {
            this.name = name;
        }

        public void addContext(IEclipseContext originatingContext) {
            this.users.put(originatingContext, null);
        }
    }
}

