/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextFunction;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;

public class ComputedValueLimitationTest
extends TestCase {
    public ComputedValueLimitationTest() {
    }

    public ComputedValueLimitationTest(String name) {
        super(name);
    }

    public synchronized void testInjection() {
        IEclipseContext context = EclipseContextFactory.create();
        int i = 0;
        while (i < 10) {
            context.set("arg" + Integer.toString(i), (Object)Integer.toString(i));
            ++i;
        }
        context.set("computed", (Object)new CalcColor());
        UserObject userObject = new UserObject();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        int i2 = 0;
        while (i2 < 20) {
            int before = ExtenralFactor.useChild();
            String actual = userObject.getComputed();
            int after = ExtenralFactor.useChild();
            System.out.println("[" + before + "] actual: " + actual + " [" + after + "]");
            try {
                ((Object)((Object)this)).wait(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i2;
        }
    }

    public void testVolatileFunction() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("time", (Object)new Time());
        long time = (Long)context.get("time");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        long newTime = (Long)context.get("time", new Object[]{new Long(System.currentTimeMillis())});
        ComputedValueLimitationTest.assertTrue((time != newTime ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(ComputedValueLimitationTest.class);
    }

    public class CalcColor
    extends ContextFunction {
        public Object compute(IEclipseContext context, Object[] arguments) {
            int useArg = ExtenralFactor.useChild();
            return context.get("arg" + Integer.toString(useArg));
        }
    }

    public static class ExtenralFactor {
        public static int useChild() {
            long time = System.currentTimeMillis();
            return (int)time % 10;
        }
    }

    public class Time
    extends ContextFunction {
        public Object compute(IEclipseContext context, Object[] arguments) {
            context.get(String.valueOf(System.currentTimeMillis()));
            return new Long(System.currentTimeMillis());
        }
    }

    public class UserObject {
        private String txt;

        public void inject__Computed(String txt) {
            this.txt = txt;
        }

        public String getComputed() {
            return this.txt;
        }
    }
}

