/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IContextFunction;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.internal.context.ObjectBasic;

public class ContextDynamicTest
extends TestCase {
    public ContextDynamicTest() {
    }

    public ContextDynamicTest(String name) {
        super(name);
    }

    public void testReplaceFunctionWithStaticValue() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext context = EclipseContextFactory.create((IEclipseContext)parent, null);
        ContextDynamicTest.assertNull((Object)context.getLocal("bar"));
        context.set("bar", (Object)"baz1");
        context.set("bar", (Object)new IContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                return "baz1";
            }
        });
        parent.set("bar", (Object)"baz2");
        ContextDynamicTest.assertEquals((Object)"baz1", (Object)context.get("bar"));
        context.set("bar", (Object)"baz3");
        ContextDynamicTest.assertEquals((Object)"baz3", (Object)context.get("bar"));
    }

    public synchronized void testAddRemove() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        Double testDouble = new Double(1.23);
        Float testFloat = new Float(12.3);
        Character testChar = new Character('v');
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class.getName(), (Object)testInt);
        context.set(String.class.getName(), (Object)testString);
        context.set(Double.class.getName(), (Object)testDouble);
        context.set(Float.class.getName(), (Object)testFloat);
        context.set(Character.class.getName(), (Object)testChar);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextDynamicTest.assertEquals((String)testString, (String)userObject.inject__String);
        ContextDynamicTest.assertEquals((Object)testInt, (Object)userObject.getInt());
        ContextDynamicTest.assertEquals((Object)context, (Object)userObject.context);
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setMethodCalled);
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setMethodCalled2);
        ContextDynamicTest.assertEquals((Object)testDouble, (Object)userObject.d);
        ContextDynamicTest.assertEquals((Object)testFloat, (Object)userObject.f);
        ContextDynamicTest.assertEquals((Object)testChar, (Object)userObject.c);
        Double testDouble2 = new Double(3.45);
        Integer testInt2 = new Integer(123);
        context.set(Double.class.getName(), (Object)testDouble2);
        context.set(Integer.class.getName(), (Object)testInt2);
        ContextDynamicTest.assertEquals((String)testString, (String)userObject.inject__String);
        ContextDynamicTest.assertEquals((Object)testInt2, (Object)userObject.getInt());
        ContextDynamicTest.assertEquals((Object)context, (Object)userObject.context);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setMethodCalled);
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setMethodCalled2);
        ContextDynamicTest.assertEquals((Object)testDouble2, (Object)userObject.d);
        ContextDynamicTest.assertEquals((Object)testFloat, (Object)userObject.f);
        ContextDynamicTest.assertEquals((Object)testChar, (Object)userObject.c);
        context.remove(String.class.getName());
        context.remove(Character.class.getName());
        ContextDynamicTest.assertNull((Object)userObject.inject__String);
        ContextDynamicTest.assertEquals((Object)testInt2, (Object)userObject.getInt());
        ContextDynamicTest.assertEquals((Object)context, (Object)userObject.context);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setMethodCalled);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setMethodCalled2);
        ContextDynamicTest.assertEquals((Object)testDouble2, (Object)userObject.d);
        ContextDynamicTest.assertEquals((Object)testFloat, (Object)userObject.f);
        ContextDynamicTest.assertNull((Object)userObject.c);
    }

    public synchronized void testParentAddRemove() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        Double testDouble = new Double(1.23);
        Float testFloat = new Float(12.3);
        Character testChar = new Character('v');
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set(Integer.class.getName(), (Object)testInt);
        parentContext.set(String.class.getName(), (Object)testString);
        parentContext.set(Double.class.getName(), (Object)testDouble);
        parentContext.set(Float.class.getName(), (Object)testFloat);
        parentContext.set(Character.class.getName(), (Object)testChar);
        IEclipseContext context = EclipseContextFactory.create((IEclipseContext)parentContext, null);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextDynamicTest.assertEquals((String)testString, (String)userObject.inject__String);
        ContextDynamicTest.assertEquals((Object)testInt, (Object)userObject.getInt());
        ContextDynamicTest.assertEquals((Object)context, (Object)userObject.context);
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setMethodCalled);
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setMethodCalled2);
        ContextDynamicTest.assertEquals((Object)testDouble, (Object)userObject.d);
        ContextDynamicTest.assertEquals((Object)testFloat, (Object)userObject.f);
        ContextDynamicTest.assertEquals((Object)testChar, (Object)userObject.c);
        Double testDouble2 = new Double(3.45);
        Integer testInt2 = new Integer(123);
        context.set(Double.class.getName(), (Object)testDouble2);
        context.set(Integer.class.getName(), (Object)testInt2);
        ContextDynamicTest.assertEquals((String)testString, (String)userObject.inject__String);
        ContextDynamicTest.assertEquals((Object)testInt2, (Object)userObject.getInt());
        ContextDynamicTest.assertEquals((Object)context, (Object)userObject.context);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setMethodCalled);
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setMethodCalled2);
        ContextDynamicTest.assertEquals((Object)testDouble2, (Object)userObject.d);
        ContextDynamicTest.assertEquals((Object)testFloat, (Object)userObject.f);
        ContextDynamicTest.assertEquals((Object)testChar, (Object)userObject.c);
        parentContext.remove(String.class.getName());
        parentContext.remove(Character.class.getName());
        ContextDynamicTest.assertNull((Object)userObject.inject__String);
        ContextDynamicTest.assertEquals((Object)testInt2, (Object)userObject.getInt());
        ContextDynamicTest.assertEquals((Object)context, (Object)userObject.context);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setMethodCalled);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setMethodCalled2);
        ContextDynamicTest.assertEquals((Object)testDouble2, (Object)userObject.d);
        ContextDynamicTest.assertEquals((Object)testFloat, (Object)userObject.f);
        ContextDynamicTest.assertNull((Object)userObject.c);
    }

    public static Test suite() {
        return new TestSuite(ContextDynamicTest.class);
    }
}

