/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.internal.context.ObjectBasic;
import org.eclipse.e4.core.services.internal.context.ObjectSubClass;

public class ContextInjectionTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(ContextInjectionTest.class);
    }

    public ContextInjectionTest() {
    }

    public ContextInjectionTest(String name) {
        super(name);
    }

    public void testContextSetOneArg() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue);
        class Injected {
            int contextSetCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            public void contextSet(IEclipseContext context) {
                ++this.contextSetCalled;
            }

            public void inject__InjectedMethod(TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)1, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
        TestData methodValue2 = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue2);
        ContextInjectionTest.assertEquals((int)2, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((Object)methodValue2, (Object)object.value);
        ContextInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
    }

    public void testContextSetZeroArgs() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue);
        class Injected {
            int contextSetCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            public void contextSet() {
                ++this.contextSetCalled;
            }

            public void inject__InjectedMethod(TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)1, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
        TestData methodValue2 = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue2);
        ContextInjectionTest.assertEquals((int)2, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((Object)methodValue2, (Object)object.value);
        ContextInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
    }

    public synchronized void testInjection() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        Double testDouble = new Double(1.23);
        Float testFloat = new Float(12.3);
        Character testChar = new Character('v');
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class.getName(), (Object)testInt);
        context.set(String.class.getName(), (Object)testString);
        context.set(Double.class.getName(), (Object)testDouble);
        context.set(Float.class.getName(), (Object)testFloat);
        context.set(Character.class.getName(), (Object)testChar);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((String)testString, (String)userObject.inject__String);
        ContextInjectionTest.assertEquals((Object)testInt, (Object)userObject.getInt());
        ContextInjectionTest.assertEquals((Object)context, (Object)userObject.context);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setMethodCalled2);
        ContextInjectionTest.assertEquals((Object)testDouble, (Object)userObject.d);
        ContextInjectionTest.assertEquals((Object)testFloat, (Object)userObject.f);
        ContextInjectionTest.assertEquals((Object)testChar, (Object)userObject.c);
        ContextInjectionTest.assertTrue((boolean)userObject.finalized);
    }

    public synchronized void testInjectionFromParent() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        Double testDouble = new Double(1.23);
        Float testFloat = new Float(12.3);
        Character testChar = new Character('v');
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set(Integer.class.getName(), (Object)testInt);
        parentContext.set(String.class.getName(), (Object)testString);
        IEclipseContext context = EclipseContextFactory.create((IEclipseContext)parentContext, null);
        context.set(Double.class.getName(), (Object)testDouble);
        context.set(Float.class.getName(), (Object)testFloat);
        context.set(Character.class.getName(), (Object)testChar);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((String)testString, (String)userObject.inject__String);
        ContextInjectionTest.assertEquals((Object)testInt, (Object)userObject.getInt());
        ContextInjectionTest.assertEquals((Object)context, (Object)userObject.context);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setMethodCalled2);
        ContextInjectionTest.assertEquals((Object)testDouble, (Object)userObject.d);
        ContextInjectionTest.assertEquals((Object)testFloat, (Object)userObject.f);
        ContextInjectionTest.assertEquals((Object)testChar, (Object)userObject.c);
        ContextInjectionTest.assertTrue((boolean)userObject.finalized);
    }

    public synchronized void testInjectionAndInheritance() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        Float testFloat = new Float(12.3);
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class.getName(), (Object)testInt);
        context.set(String.class.getName(), (Object)testString);
        context.set(Float.class.getName(), (Object)testFloat);
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((String)testString, (String)userObject.getString());
        ContextInjectionTest.assertEquals((Object)context, (Object)userObject.getContext());
        ContextInjectionTest.assertEquals((String)testString, (String)userObject.getStringViaMethod());
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setStringCalled);
        ContextInjectionTest.assertEquals((Object)testInt, (Object)userObject.getInteger());
        ContextInjectionTest.assertEquals((Object)testFloat, (Object)userObject.getObjectViaMethod());
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setObjectCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setOverriddenCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.getFinalizedCalled());
    }
}

