/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.services.JSONObject;

public class JSONObjectTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(JSONObjectTest.class);
    }

    public JSONObjectTest() {
        super("");
    }

    public JSONObjectTest(String name) {
        super(name);
    }

    public void testSimpleRoundTrip() {
        JSONObject input = new JSONObject();
        input.set("x", "value");
        String[] valueArray = new String[]{"a", "value", "array"};
        input.set("y", valueArray);
        JSONObject child = new JSONObject();
        String childValue = "\b\f\n\r\t";
        child.set("z", childValue);
        input.set("child", child);
        String result = input.serialize();
        JSONObject output = JSONObject.deserialize((String)result);
        JSONObjectTest.assertEquals((String)"value", (String)output.getString("x"));
        String[] childStrings = output.getStrings("y");
        JSONObjectTest.assertEquals((int)valueArray.length, (int)childStrings.length);
        int i = 0;
        while (i < childStrings.length) {
            JSONObjectTest.assertEquals((String)valueArray[i], (String)childStrings[i]);
            ++i;
        }
        JSONObject outputChild = output.getObject("child");
        JSONObjectTest.assertEquals((String)childValue, (String)outputChild.getString("z"));
    }
}

