/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.IRunAndTrack;
import org.eclipse.e4.core.services.context.spi.ContextFunction;
import org.eclipse.e4.core.tests.services.TestActivator;
import org.osgi.framework.BundleContext;

public class RunAndTrackTest
extends TestCase {
    static final String ACTIVE_CHILD = "activeChild";
    static final String ACTIVE_PART = "activePart";
    static final String ACTIVE_PART_ID = "activePartId";
    static final String INTERNAL_LOCAL_PART = "localPart";
    private List createdContexts = new ArrayList();

    private IEclipseContext createContext(IEclipseContext parentContext, String level) {
        IEclipseContext childContext = EclipseContextFactory.create((IEclipseContext)parentContext, null);
        this.createdContexts.add(childContext);
        childContext.set("debugString", (Object)level);
        return childContext;
    }

    private IEclipseContext getGlobalContext() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)TestActivator.bundleContext);
        IEclipseContext appContext = this.createContext(serviceContext, "globalContext");
        appContext.set("globalContext", (Object)appContext);
        return appContext;
    }

    private IEclipseContext[] createNextLevel(IEclipseContext parent, String prefix, int num) {
        RunAndTrackTest.assertTrue((num > 0 ? 1 : 0) != 0);
        IEclipseContext[] contexts = new IEclipseContext[num];
        int i = 0;
        while (i < num) {
            contexts[i] = this.createContext(parent, String.valueOf(prefix) + i);
            contexts[i].set(INTERNAL_LOCAL_PART, (Object)(String.valueOf(prefix) + i));
            ++i;
        }
        parent.set(ACTIVE_CHILD, (Object)contexts[0]);
        return contexts;
    }

    protected void tearDown() throws Exception {
        for (IDisposable context : this.createdContexts) {
            context.dispose();
        }
        this.createdContexts.clear();
        super.tearDown();
    }

    public void testActiveChain() throws Exception {
        IEclipseContext workbenchContext = this.getGlobalContext();
        workbenchContext.set(ACTIVE_PART, (Object)new ActivePartLookupFunction());
        IEclipseContext[] windows = this.createNextLevel(workbenchContext, "window", 1);
        this.createNextLevel(windows[0], "part", 2);
        RunAndTrackTest.assertEquals((Object)"part0", (Object)workbenchContext.get(ACTIVE_PART));
    }

    public void testActiveChange() throws Exception {
        IEclipseContext workbenchContext = this.getGlobalContext();
        workbenchContext.set(ACTIVE_PART, (Object)new ActivePartLookupFunction());
        IEclipseContext[] windows = this.createNextLevel(workbenchContext, "window", 1);
        IEclipseContext[] parts = this.createNextLevel(windows[0], "part", 2);
        RunAndTrackTest.assertEquals((Object)"part0", (Object)workbenchContext.get(ACTIVE_PART));
        windows[0].set(ACTIVE_CHILD, (Object)parts[1]);
        RunAndTrackTest.assertEquals((Object)"part1", (Object)workbenchContext.get(ACTIVE_PART));
    }

    public void testContextEventOldValue() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("Name", (Object)"Value");
        class ContextListener
        implements IRunAndTrack {
            public Object newValue;
            public Object oldValue;

            ContextListener() {
            }

            public boolean notify(ContextChangeEvent event) {
                this.oldValue = event.getOldValue();
                this.newValue = event.getContext().get("Name");
                return true;
            }
        }
        ContextListener listener = new ContextListener();
        context.runAndTrack((IRunAndTrack)listener, null);
        RunAndTrackTest.assertEquals((Object)"Value", (Object)listener.newValue);
        RunAndTrackTest.assertNull((Object)listener.oldValue);
        context.set("Name", (Object)"NewValue");
        RunAndTrackTest.assertEquals((Object)"Value", (Object)listener.oldValue);
        RunAndTrackTest.assertEquals((Object)"NewValue", (Object)listener.newValue);
        context.set("Name", null);
        RunAndTrackTest.assertEquals((Object)"NewValue", (Object)listener.oldValue);
        RunAndTrackTest.assertEquals(null, (Object)listener.newValue);
        context.set("Name", (Object)"Value");
        RunAndTrackTest.assertEquals(null, (Object)listener.oldValue);
        RunAndTrackTest.assertEquals((Object)"Value", (Object)listener.newValue);
        context.remove("Name");
        RunAndTrackTest.assertEquals((Object)"Value", (Object)listener.oldValue);
        RunAndTrackTest.assertEquals(null, (Object)listener.newValue);
    }

    public void testContextEventType() {
        IEclipseContext context = EclipseContextFactory.create();
        class ContextListener
        implements IRunAndTrack {
            int eventType;

            ContextListener() {
            }

            public boolean notify(ContextChangeEvent event) {
                this.eventType = event.getEventType();
                event.getContext().get("Name");
                return true;
            }
        }
        ContextListener listener = new ContextListener();
        context.runAndTrack((IRunAndTrack)listener, null);
        RunAndTrackTest.assertEquals((int)0, (int)listener.eventType);
        context.set("Name", (Object)"Value");
        RunAndTrackTest.assertEquals((int)1, (int)listener.eventType);
        context.set("Name", (Object)"NewValue");
        RunAndTrackTest.assertEquals((int)1, (int)listener.eventType);
        context.set("Name", null);
        RunAndTrackTest.assertEquals((int)1, (int)listener.eventType);
        context.set("Name", (Object)"Value");
        RunAndTrackTest.assertEquals((int)1, (int)listener.eventType);
        context.remove("Name");
        RunAndTrackTest.assertEquals((int)2, (int)listener.eventType);
        ((IDisposable)context).dispose();
        RunAndTrackTest.assertEquals((int)3, (int)listener.eventType);
    }

    public void testRunAndTrackComplex() throws Exception {
        IEclipseContext workbenchContext = this.getGlobalContext();
        workbenchContext.set(ACTIVE_PART, (Object)new ActivePartLookupFunction());
        final IEclipseContext[] windows = this.createNextLevel(workbenchContext, "window", 1);
        windows[0].runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                Object part = windows[0].get(RunAndTrackTest.ACTIVE_PART);
                windows[0].set(RunAndTrackTest.ACTIVE_PART_ID, part);
                return true;
            }

            public String toString() {
                return RunAndTrackTest.ACTIVE_PART_ID;
            }
        }, null);
        IEclipseContext[] mainSashes = this.createNextLevel(windows[0], "mainSash", 2);
        this.createNextLevel(mainSashes[1], "editorArea", 1);
        IEclipseContext[] viewSashes = this.createNextLevel(mainSashes[0], "viewSashes", 2);
        IEclipseContext[] packageStack = this.createNextLevel(viewSashes[0], "packageStack", 1);
        IEclipseContext[] packageViews = this.createNextLevel(packageStack[0], "packageViews", 3);
        RunAndTrackTest.assertNotNull((Object)packageViews);
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)windows[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)windows[0].get(ACTIVE_PART_ID));
        IEclipseContext[] problemsStack = this.createNextLevel(viewSashes[1], "problemsStack", 1);
        IEclipseContext[] problemsViews = this.createNextLevel(problemsStack[0], "problemViews", 5);
        RunAndTrackTest.assertNotNull((Object)problemsViews);
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)windows[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)windows[0].get(ACTIVE_PART_ID));
        RunAndTrackTest.assertEquals((Object)"problemViews0", (Object)problemsStack[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)problemsStack[0].get(ACTIVE_PART_ID));
        problemsStack[0].set(ACTIVE_CHILD, (Object)problemsViews[0]);
        viewSashes[1].set(ACTIVE_CHILD, (Object)problemsStack[0]);
        mainSashes[0].set(ACTIVE_CHILD, (Object)viewSashes[1]);
        windows[0].set(ACTIVE_CHILD, (Object)mainSashes[0]);
        workbenchContext.set(ACTIVE_CHILD, (Object)windows[0]);
        RunAndTrackTest.assertEquals((Object)"problemViews0", (Object)windows[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"problemViews0", (Object)windows[0].get(ACTIVE_PART_ID));
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)packageStack[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"problemViews0", (Object)packageStack[0].get(ACTIVE_PART_ID));
    }

    public void testRunAndTrackSimple() throws Exception {
        IEclipseContext workbenchContext = this.getGlobalContext();
        workbenchContext.set(ACTIVE_PART, (Object)new ActivePartLookupFunction());
        final IEclipseContext[] windows = this.createNextLevel(workbenchContext, "window", 1);
        windows[0].runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                Object part = windows[0].get(RunAndTrackTest.ACTIVE_PART);
                windows[0].set(RunAndTrackTest.ACTIVE_PART_ID, part);
                return true;
            }

            public String toString() {
                return RunAndTrackTest.ACTIVE_PART_ID;
            }
        }, null);
        IEclipseContext[] parts = this.createNextLevel(windows[0], "part", 2);
        RunAndTrackTest.assertEquals((Object)"part0", (Object)workbenchContext.get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"part0", (Object)windows[0].get(ACTIVE_PART_ID));
        windows[0].set(ACTIVE_CHILD, (Object)parts[1]);
        RunAndTrackTest.assertEquals((Object)"part1", (Object)windows[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"part1", (Object)windows[0].get(ACTIVE_PART_ID));
    }

    private class ActivePartLookupFunction
    extends ContextFunction {
        private ActivePartLookupFunction() {
        }

        public Object compute(IEclipseContext context, Object[] arguments) {
            IEclipseContext childContext = (IEclipseContext)context.getLocal(RunAndTrackTest.ACTIVE_CHILD);
            if (childContext != null) {
                return childContext.get(RunAndTrackTest.ACTIVE_PART);
            }
            return context.get(RunAndTrackTest.INTERNAL_LOCAL_PART);
        }
    }
}

