/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.contacts.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ThemeUtil {
    public static void switchTheme(MWindow window, final String css) {
        final Shell shell = (Shell)window.getWidget();
        if (shell == null) {
            return;
        }
        Display display = shell.getDisplay();
        final CSSEngine engine = (CSSEngine)display.getData("org.eclipse.e4.ui.css.core.engine");
        display.syncExec(new Runnable(){

            public void run() {
                try {
                    URL url = FileLocator.resolve((URL)new URL("platform:/plugin/org.eclipse.e4.demo.contacts/css/" + css));
                    InputStream stream = url.openStream();
                    InputStreamReader streamReader = new InputStreamReader(stream);
                    engine.reset();
                    engine.parseStyleSheet((Reader)streamReader);
                    stream.close();
                    streamReader.close();
                    try {
                        shell.setRedraw(false);
                        shell.reskin(1);
                    }
                    finally {
                        shell.setRedraw(true);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void applyDialogStyles(IStylingEngine engine, Control control) {
        if (engine != null) {
            Shell shell = control.getShell();
            if (shell.getBackgroundMode() == 0) {
                shell.setBackgroundMode(1);
            }
            engine.style((Object)shell);
        }
    }
}

