/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.contacts.views;

import javax.inject.Inject;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.e4.core.services.annotations.PreDestroy;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.demo.contacts.model.Contact;
import org.eclipse.e4.demo.contacts.model.ContactsRepositoryFactory;
import org.eclipse.e4.demo.contacts.views.ContactViewerComparator;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ListView {
    private final TableViewer contactsViewer;
    @Inject
    private IEclipseContext context;

    @Inject
    public ListView(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.contactsViewer = new TableViewer(tableComposite, 65536);
        this.contactsViewer.getTable().setHeaderVisible(true);
        this.contactsViewer.setComparator((ViewerComparator)new ContactViewerComparator());
        this.contactsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ListView.this.context.modify("selection", selection.getFirstElement());
            }
        });
        TableViewerColumn firstNameColumn = new TableViewerColumn(this.contactsViewer, 0);
        firstNameColumn.getColumn().setText("First Name");
        tableColumnLayout.setColumnData((Widget)firstNameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40));
        TableViewerColumn lastNameColumn = new TableViewerColumn(this.contactsViewer, 0);
        lastNameColumn.getColumn().setText("Last Name");
        tableColumnLayout.setColumnData((Widget)lastNameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(60));
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.contactsViewer.setContentProvider((IContentProvider)contentProvider);
        IObservableMap[] attributes = BeansObservables.observeMaps((IObservableSet)contentProvider.getKnownElements(), Contact.class, (String[])new String[]{"firstName", "lastName"});
        this.contactsViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(attributes));
        this.contactsViewer.setInput((Object)ContactsRepositoryFactory.getContactsRepository().getAllContacts());
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    @PreDestroy
    void preDestroy() {
        for (Object object : ContactsRepositoryFactory.getContactsRepository().getAllContacts()) {
            Contact contact = (Contact)object;
            Image image = contact.getImage();
            if (image == null) continue;
            image.dispose();
        }
    }
}

