/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.javascript.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.e4.emf.javascript.ui.AbstractSelectionView;
import org.eclipse.e4.emf.javascript.ui.Activator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ScriptSourceView
extends AbstractSelectionView {
    private Logger log = Logger.getLogger(Activator.getDefault().getBundle().getSymbolicName());
    private Text scriptTextControl;

    public void dispose() {
        this.disposeTextControl(this.scriptTextControl);
        super.dispose();
    }

    protected void selectionChanged(ISelection selection) {
        this.commitScriptText(this.getSelectedEObject());
        String scriptText = null;
        super.selectionChanged(selection);
        if (this.getSelectedEObject() != null) {
            scriptText = this.getScriptText(this.getSelectedEObject());
        }
        this.setScriptControlText(scriptText);
    }

    private String getScriptControlText() {
        return this.scriptTextControl.getText();
    }

    private void setScriptControlText(String scriptText) {
        this.scriptTextControl.setText(scriptText != null ? scriptText : "");
    }

    protected boolean isValidSelection(Object o) {
        return o instanceof EObject;
    }

    private String getScriptText(EObject eObject) {
        EAttribute scriptAttr = JavascriptSupport.getScriptSourceAttribute((EObject)eObject, (String)"js");
        return scriptAttr != null ? ScriptSourceView.getScriptText(eObject, scriptAttr) : "";
    }

    private static String getScriptText(EObject eObject, EAttribute scriptAttr) {
        Object value = eObject.eGet((EStructuralFeature)scriptAttr);
        return value != null ? value.toString().trim() : "";
    }

    private EObject getSelectedEObject() {
        return (EObject)this.selection;
    }

    private void commitScriptText(EObject eObject) {
        if (this.selection != null) {
            String scriptText = this.getScriptControlText();
            try {
                ScriptSourceView.commitScriptText(eObject, scriptText, this.editingDomainProvider);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Exception setting script text to " + scriptText + ": " + e, e);
            }
        }
    }

    static void commitScriptText(EObject eObject, String scriptText, IEditingDomainProvider editingDomainProvider) {
        EAttribute scriptAttr = JavascriptSupport.getScriptSourceAttribute((EObject)eObject, (String)"js");
        if (editingDomainProvider != null && scriptAttr != null) {
            SetCommand command;
            EditingDomain editingDomain = editingDomainProvider.getEditingDomain();
            if (!scriptText.equals(ScriptSourceView.getScriptText(eObject, scriptAttr)) && (command = new SetCommand(editingDomain, eObject, (EStructuralFeature)scriptAttr, (Object)scriptText)).canExecute()) {
                editingDomain.getCommandStack().execute((Command)command);
            }
        } else if (scriptAttr != null) {
            eObject.eSet((EStructuralFeature)scriptAttr, (Object)scriptText);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.scriptTextControl = this.createTextControl(parent, 578);
        this.scriptTextControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ScriptSourceView.this.commitScriptText(ScriptSourceView.this.getSelectedEObject());
            }
        });
    }

    public void setFocus() {
        this.scriptTextControl.setFocus();
    }
}

