/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.debug.rhino;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.languages.javascript.debug.connect.EventPacket;
import org.eclipse.e4.languages.javascript.debug.rhino.DebugFrameImpl;
import org.eclipse.e4.languages.javascript.debug.rhino.RhinoDebugger;
import org.eclipse.e4.languages.javascript.debug.rhino.ScriptImpl;

public class ContextData {
    private static final int CONTEXT_RUNNING = 0;
    private static final int CONTEXT_SUSPENDED = 1;
    private static final int STEP_CONTINUE = 0;
    private static final int STEP_IN = 1;
    private static final int STEP_NEXT = 2;
    private static final int STEP_OUT = 4;
    private final Long threadId;
    private final Long contextId;
    private final RhinoDebugger debugger;
    private final LinkedList frames = new LinkedList();
    private int contextState = 0;
    private int stepState = 0;
    private DebugFrameImpl stepFrame;

    public ContextData(Long threadId, Long contextId, RhinoDebugger debugger) {
        this.threadId = threadId;
        this.contextId = contextId;
        this.debugger = debugger;
    }

    public Long getId() {
        return this.contextId;
    }

    public synchronized List getFrameIds() {
        ArrayList<Long> result = new ArrayList<Long>();
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext()) {
            result.add(((DebugFrameImpl)iterator.next()).getId());
        }
        return result;
    }

    public synchronized DebugFrameImpl getFrame(Long frameId) {
        DebugFrameImpl frame = null;
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext()) {
            frame = (DebugFrameImpl)iterator.next();
            if (!frame.getId().equals(frameId)) continue;
            return frame;
        }
        return null;
    }

    public synchronized void pushFrame(DebugFrameImpl frame, ScriptImpl script, Integer lineNumber, String functionName) {
        boolean isStepBreak;
        this.frames.addFirst(frame);
        Collection breakpoints = script.getBreakpoints(functionName, lineNumber, frame);
        if (functionName == null) {
            functionName = "(toplevel)";
        }
        if (((isStepBreak = this.stepBreak(1)) || !breakpoints.isEmpty()) && this.sendBreakEvent(script, frame.getLineNumber(), functionName, breakpoints, isStepBreak, false)) {
            this.suspendState();
        }
    }

    private boolean stepBreak(int step) {
        return (step & this.stepState) != 0 && (this.stepFrame == null || this.stepFrame == this.frames.getFirst());
    }

    private void suspendState() {
        this.contextState = 1;
        while (this.contextState == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void popFrame(boolean byThrow, Object resultOrException) {
        DebugFrameImpl frame;
        this.frames.removeFirst();
        if (this.frames.isEmpty()) {
            return;
        }
        boolean isStepBreak = this.stepBreak(4);
        if (isStepBreak && this.sendBreakEvent((frame = (DebugFrameImpl)this.frames.getFirst()).getScript(), frame.getLineNumber(), null, Collections.EMPTY_LIST, isStepBreak, false)) {
            this.suspendState();
        }
    }

    public synchronized void resume(String stepType) {
        if (stepType == null) {
            this.stepState = 0;
            this.stepFrame = null;
        } else if (stepType.equals("in")) {
            this.stepState = 1;
            this.stepFrame = null;
        } else if (stepType.equals("next")) {
            this.stepState = 2;
            this.stepFrame = (DebugFrameImpl)this.frames.getFirst();
        } else if (stepType.equals("out")) {
            if (this.frames.size() > 1) {
                this.stepState = 4;
                this.stepFrame = (DebugFrameImpl)this.frames.get(1);
            } else {
                this.stepState = 0;
                this.stepFrame = null;
            }
        } else if (stepType.equals("any")) {
            this.stepState = 7;
            this.stepFrame = null;
        } else {
            throw new IllegalStateException("bad stepType: " + stepType);
        }
        this.contextState = 0;
        this.notifyAll();
    }

    public synchronized void suspend() {
        this.stepState = 7;
        this.stepFrame = null;
    }

    public synchronized void debuggerStatement(ScriptImpl script, Integer lineNumber) {
        boolean isStepBreak;
        DebugFrameImpl frame = (DebugFrameImpl)this.frames.getFirst();
        Collection breakpoints = script.getBreakpoints(null, lineNumber, frame);
        if (this.sendBreakEvent(script, lineNumber, null, breakpoints, isStepBreak = this.stepBreak(3), true)) {
            this.suspendState();
        }
    }

    public synchronized void lineChange(ScriptImpl script, Integer lineNumber) {
        DebugFrameImpl frame = (DebugFrameImpl)this.frames.getFirst();
        Collection breakpoints = script.getBreakpoints(null, lineNumber, frame);
        boolean isStepBreak = this.stepBreak(3);
        if ((isStepBreak || !breakpoints.isEmpty()) && this.sendBreakEvent(script, lineNumber, null, breakpoints, isStepBreak, false)) {
            this.suspendState();
        }
    }

    public synchronized void exceptionThrown(Throwable ex) {
        DebugFrameImpl frame = (DebugFrameImpl)this.frames.getFirst();
        if (this.sendExceptionEvent(frame.getScript(), frame.getLineNumber(), ex)) {
            this.suspendState();
        }
    }

    private boolean sendExceptionEvent(ScriptImpl script, Integer lineNumber, Throwable ex) {
        EventPacket exceptionEvent = new EventPacket("exception");
        Map body = exceptionEvent.getBody();
        body.put("contextId", this.contextId);
        body.put("threadId", this.threadId);
        body.put("scriptId", script.getId());
        body.put("lineNumber", lineNumber);
        body.put("message", ex.getMessage());
        return this.debugger.sendEvent(exceptionEvent);
    }

    private boolean sendBreakEvent(ScriptImpl script, Integer lineNumber, String functionName, Collection breakpoints, boolean isStepBreak, boolean isDebuggerStatement) {
        EventPacket breakEvent = new EventPacket("break");
        Map body = breakEvent.getBody();
        body.put("threadId", this.threadId);
        body.put("contextId", this.contextId);
        body.put("scriptId", script.getId());
        if (functionName != null) {
            body.put("functionName", functionName);
        }
        body.put("lineNumber", lineNumber);
        if (!breakpoints.isEmpty()) {
            body.put("breakpoints", breakpoints);
        }
        if (isStepBreak) {
            String stepType = this.stepState == 1 ? "in" : (this.stepState == 2 ? "next" : (this.stepState == 4 ? "out" : "suspend"));
            body.put("step", stepType);
            this.stepState = 0;
        }
        body.put("debuggerStatement", isDebuggerStatement);
        return this.debugger.sendEvent(breakEvent);
    }

    public synchronized void scriptLoaded(ScriptImpl script) {
        if (this.sendScriptEvent(script)) {
            this.suspendState();
        }
    }

    private boolean sendScriptEvent(ScriptImpl script) {
        EventPacket scriptEvent = new EventPacket("script");
        Map body = scriptEvent.getBody();
        body.put("threadId", this.threadId);
        body.put("contextId", this.contextId);
        body.put("scriptId", script.getId());
        return this.debugger.sendEvent(scriptEvent);
    }

    public String getState() {
        return this.contextState == 0 ? "running" : "suspended";
    }

    public Long getThreadId() {
        return this.threadId;
    }
}

