/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.debug.rhino;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.languages.javascript.debug.connect.Connection;
import org.eclipse.e4.languages.javascript.debug.connect.DebugRuntime;
import org.eclipse.e4.languages.javascript.debug.connect.DisconnectException;
import org.eclipse.e4.languages.javascript.debug.connect.EventPacket;
import org.eclipse.e4.languages.javascript.debug.connect.SocketTransportService;
import org.eclipse.e4.languages.javascript.debug.connect.TimeoutException;
import org.eclipse.e4.languages.javascript.debug.connect.TransportService;
import org.eclipse.e4.languages.javascript.debug.rhino.BreakpointImpl;
import org.eclipse.e4.languages.javascript.debug.rhino.ContextData;
import org.eclipse.e4.languages.javascript.debug.rhino.DebugFrameImpl;
import org.eclipse.e4.languages.javascript.debug.rhino.RequestHandler;
import org.eclipse.e4.languages.javascript.debug.rhino.ScriptImpl;
import org.eclipse.e4.languages.javascript.debug.rhino.ThreadData;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class RhinoDebugger
implements Debugger,
ContextFactory.Listener,
Runnable {
    private static final String SUSPEND = "suspend";
    private static final String ADDRESS = "address";
    private static final String SOCKET = "socket";
    private static final String TRANSPORT = "transport";
    private final Thread requestHandlerThread = new Thread((Runnable)this, "RhinoDebugger - Request Handler");
    private final RequestHandler requestHandler = new RequestHandler(this);
    private volatile boolean shutdown = false;
    private DebugRuntime runtime;
    private final Map threadToThreadId = new HashMap();
    private final Map threadIdToData = new HashMap();
    private final Map scripts = new HashMap();
    private final Map debuggableScripts = new HashMap();
    private final Map breakpoints = new HashMap();
    private long currentThreadId = 0L;
    private long currentBreakpointId = 0L;
    private long currentScriptId = 0L;
    private ArrayList disabledThreads = new ArrayList();
    private final TransportService transportService;
    private final String address;
    private boolean startSuspended;
    private TransportService.ListenerKey listenerKey;
    private volatile Connection connection;

    public RhinoDebugger(String configString) {
        Map config = RhinoDebugger.parseConfigString(configString);
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nRhino attaching debugger\n");
        buffer.append("Start at time: ").append(DateFormat.getDateTimeInstance(1, 1).format(Calendar.getInstance().getTime()));
        buffer.append("\nListening to ");
        String transport = (String)config.get(TRANSPORT);
        if (!SOCKET.equals(transport)) {
            throw new IllegalArgumentException("transport: " + transport);
        }
        this.transportService = new SocketTransportService();
        buffer.append("socket on ");
        this.address = (String)config.get(ADDRESS);
        buffer.append("port ").append(this.address);
        this.startSuspended = Boolean.valueOf((String)config.get(SUSPEND));
        System.err.println(buffer.toString());
    }

    private static Map parseConfigString(String configString) {
        HashMap<String, String> config = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(configString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int equalsIndex = token.indexOf(61);
            if (equalsIndex == -1) {
                config.put(token, null);
                continue;
            }
            config.put(token.substring(0, equalsIndex), token.substring(equalsIndex + 1));
        }
        return config;
    }

    public RhinoDebugger(TransportService transportService, String address, boolean startSuspended) {
        this.transportService = transportService;
        this.address = address;
        this.startSuspended = startSuspended;
        try {
            if (startSuspended) {
                this.listenerKey = transportService.startListening(address);
                this.acceptConnection(300000L);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isStartSuspended() {
        return this.startSuspended;
    }

    public synchronized boolean suspendForRuntime(long timeout) {
        while (this.runtime == null) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.runtime != null;
    }

    public void start() {
        try {
            if (this.listenerKey == null) {
                this.listenerKey = this.transportService.startListening(this.address);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.requestHandlerThread.start();
    }

    public void stop() {
        this.shutdown = true;
        try {
            this.requestHandlerThread.interrupt();
            this.requestHandlerThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            this.transportService.stopListening(this.listenerKey);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try lbl-1000:
        // 2 sources

        {
            while (true) {
                if (this.shutdown) {
                    return;
                }
                try {
                    this.acceptConnection(10000L);
                    ** GOTO lbl24
                }
                catch (IOException v0) {
                    if (this.connection == null) {
                        continue;
                    }
                    ** GOTO lbl24
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return;
lbl-1000:
        // 1 sources

        {
            try {
                request = this.runtime.receiveRequest(1000);
                response = this.requestHandler.handleRequest(request);
                this.runtime.sendResponse(response);
                continue;
            }
            catch (TimeoutException v1) {
                continue;
            }
            catch (DisconnectException v2) {
                break;
            }
lbl24:
            // 4 sources

            ** while (!this.shutdown && this.connection.isOpen())
        }
lbl25:
        // 2 sources

        this.closeConnection();
        ** while (true)
    }

    private void closeConnection() throws IOException {
        if (this.connection != null) {
            this.runtime.dispose();
            this.setRuntime(null);
            this.connection.close();
            this.connection = null;
        }
    }

    private void acceptConnection(long timeout) throws IOException {
        if (this.connection == null) {
            this.connection = this.transportService.accept(this.listenerKey, timeout, timeout);
            this.setRuntime(new DebugRuntime(this.connection));
        }
    }

    public DebugFrame getFrame(Context context, DebuggableScript debuggableScript) {
        ScriptImpl script = this.getScript(debuggableScript);
        ContextData contextData = (ContextData)context.getDebuggerContextData();
        ThreadData thread = (ThreadData)this.threadIdToData.get(contextData.getThreadId());
        return thread.getFrame(context, debuggableScript, script);
    }

    private ScriptImpl getScript(DebuggableScript debuggableScript) {
        while (!debuggableScript.isTopLevel()) {
            debuggableScript = debuggableScript.getParent();
        }
        return (ScriptImpl)this.debuggableScripts.get(debuggableScript);
    }

    public void handleCompilationDone(Context context, DebuggableScript debuggableScript, String source) {
        if (!debuggableScript.isTopLevel()) {
            return;
        }
        Long scriptId = this.nextScriptId();
        ScriptImpl script = new ScriptImpl(scriptId, debuggableScript, source);
        this.scripts.put(scriptId, script);
        this.debuggableScripts.put(debuggableScript, script);
        ContextData contextData = (ContextData)context.getDebuggerContextData();
        contextData.scriptLoaded(script);
    }

    private synchronized Long nextScriptId() {
        return new Long(this.currentScriptId++);
    }

    public synchronized void contextCreated(Context context) {
        ThreadData threadData;
        Thread thread = Thread.currentThread();
        if (this.disabledThreads.contains(thread)) {
            return;
        }
        Long threadId = (Long)this.threadToThreadId.get(thread);
        if (threadId == null) {
            threadId = new Long(this.currentThreadId++);
            this.threadToThreadId.put(thread, threadId);
        }
        if ((threadData = (ThreadData)this.threadIdToData.get(threadId)) == null) {
            threadData = new ThreadData(threadId, this);
            this.threadIdToData.put(threadId, threadData);
        }
        threadData.contextCreated(context);
    }

    public synchronized void contextReleased(Context context) {
        Thread thread = Thread.currentThread();
        if (this.disabledThreads.contains(thread)) {
            return;
        }
        Long threadId = (Long)this.threadToThreadId.get(thread);
        if (threadId == null) {
            return;
        }
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        threadData.contextReleased(context);
        if (!threadData.hasContext()) {
            this.threadToThreadId.remove(thread);
            this.threadIdToData.remove(threadId);
        }
    }

    public synchronized void resume(Long threadId, String stepType) {
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        if (threadData != null) {
            threadData.resume(stepType);
        }
    }

    public synchronized void resumeAll() {
        Iterator it = this.threadIdToData.keySet().iterator();
        while (it.hasNext()) {
            Long threadId = (Long)it.next();
            this.resume(threadId, null);
        }
    }

    public synchronized void suspend(Long threadId) {
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        if (threadData != null) {
            threadData.suspend();
        }
    }

    public synchronized void suspendAll() {
        Iterator it = this.threadIdToData.keySet().iterator();
        while (it.hasNext()) {
            Long threadId = (Long)it.next();
            this.suspend(threadId);
        }
    }

    public void disconnect() {
    }

    public synchronized List getFrameIds(Long threadId) {
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        if (threadData == null) {
            return Collections.EMPTY_LIST;
        }
        return threadData.getFrameIds();
    }

    public synchronized DebugFrameImpl getFrame(Long threadId, Long frameId) {
        ThreadData threadData = (ThreadData)this.threadIdToData.get(threadId);
        if (threadData != null) {
            return threadData.getFrame(frameId);
        }
        return null;
    }

    public synchronized List getScriptIds() {
        return new ArrayList(this.scripts.keySet());
    }

    public synchronized ScriptImpl getScript(Long scriptId) {
        return (ScriptImpl)this.scripts.get(scriptId);
    }

    public synchronized Collection getBreakpoints() {
        return this.breakpoints.keySet();
    }

    public synchronized BreakpointImpl setBreakpoint(Long scriptId, Integer lineNumber, String functionName, String condition, Long threadId) {
        ScriptImpl script = (ScriptImpl)this.scripts.get(scriptId);
        if (!script.isValid(lineNumber, functionName)) {
            return null;
        }
        BreakpointImpl breakpoint = new BreakpointImpl(this.nextBreakpointId(), script, lineNumber, functionName, condition, threadId);
        this.breakpoints.put(breakpoint.getId(), breakpoint);
        script.addBreakpoint(breakpoint);
        return breakpoint;
    }

    private synchronized Long nextBreakpointId() {
        return new Long(this.currentBreakpointId++);
    }

    public synchronized BreakpointImpl clearBreakpoint(Long breakpointId) {
        BreakpointImpl breakpoint = (BreakpointImpl)this.breakpoints.remove(breakpointId);
        if (breakpoint != null) {
            ScriptImpl script = breakpoint.getScript();
            script.removeBreakpoint(breakpoint);
        }
        return breakpoint;
    }

    public synchronized boolean sendEvent(EventPacket event) {
        try {
            if (this.runtime != null) {
                this.runtime.sendEvent(event);
                return true;
            }
        }
        catch (DisconnectException e) {
            e.printStackTrace();
        }
        return false;
    }

    private synchronized void setRuntime(DebugRuntime runtime) {
        this.runtime = runtime;
        this.notify();
    }

    public BreakpointImpl getBreakpoint(Long breakpointId) {
        return (BreakpointImpl)this.breakpoints.get(breakpointId);
    }

    public ThreadData getThreadData(Long threadId) {
        return (ThreadData)this.threadIdToData.get(threadId);
    }

    public List getThreadIds() {
        return new ArrayList(this.threadIdToData.keySet());
    }

    public void disableThread() {
        this.disabledThreads.add(Thread.currentThread());
    }

    public void enableThread() {
        this.disabledThreads.remove(Thread.currentThread());
    }
}

