/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.debug.rhino;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.e4.languages.javascript.debug.connect.JSONUtil;
import org.eclipse.e4.languages.javascript.debug.rhino.BreakpointImpl;
import org.eclipse.e4.languages.javascript.debug.rhino.DebugFrameImpl;
import org.mozilla.javascript.debug.DebuggableScript;

public class ScriptImpl {
    private static final String TOP_NAME = "";
    private final Long scriptId;
    private final String location;
    private final Map sourceProperties;
    private final String source;
    private final Boolean generated;
    private final Collection functionNames = new HashSet();
    private final Collection lineNumbers = new HashSet();
    private final Map scriptRecords = new HashMap();
    private Collection breakpoints = new ArrayList();

    public ScriptImpl(Long scriptId, DebuggableScript debuggableScript, String source) {
        this.scriptId = scriptId;
        String sourceName = debuggableScript.getSourceName();
        this.sourceProperties = ScriptImpl.parseSourceProperties(sourceName);
        this.location = this.sourceProperties == null ? sourceName : (String)this.sourceProperties.get("name");
        this.generated = debuggableScript.isGeneratedScript();
        this.source = source;
        int[] scriptLineNumbers = debuggableScript.getLineNumbers();
        int i = 0;
        while (i < scriptLineNumbers.length) {
            this.lineNumbers.add(new Integer(scriptLineNumbers[i] + 1));
            ++i;
        }
        this.scriptRecords.put(debuggableScript, new ScriptRecord());
        this.expandFunctions(TOP_NAME, debuggableScript);
    }

    private static Map parseSourceProperties(String sourceName) {
        if (sourceName != null && sourceName.charAt(0) == '{') {
            try {
                Object json = JSONUtil.read((String)sourceName);
                if (json instanceof Map) {
                    return (Map)json;
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }

    private void expandFunctions(String prefix, DebuggableScript debuggableScript) {
        int functionCount = debuggableScript.getFunctionCount();
        int i = 0;
        while (i < functionCount) {
            DebuggableScript functionScript = debuggableScript.getFunction(i);
            ScriptRecord record = new ScriptRecord();
            this.scriptRecords.put(functionScript, record);
            String functionName = functionScript.getFunctionName();
            if (functionName == null || functionName.equals(TOP_NAME)) {
                functionName = "%" + i;
            }
            record.name = String.valueOf(prefix) + functionName;
            this.functionNames.add(record.name);
            int[] scriptLineNumbers = functionScript.getLineNumbers();
            if (scriptLineNumbers != null && scriptLineNumbers.length != 0) {
                record.firstLine = scriptLineNumbers[0] + 1;
                int j = 0;
                while (j < scriptLineNumbers.length) {
                    int currentLine = scriptLineNumbers[j] + 1;
                    if (currentLine < record.firstLine) {
                        record.firstLine = currentLine;
                    }
                    this.lineNumbers.add(new Integer(currentLine));
                    ++j;
                }
            }
            this.expandFunctions(String.valueOf(record.name) + ".", functionScript);
            ++i;
        }
    }

    public Object toJSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("scriptId", this.scriptId);
        result.put("location", this.location);
        result.put("properties", this.sourceProperties);
        result.put("source", this.source);
        result.put("generated", this.generated);
        result.put("lines", new TreeSet(this.lineNumbers));
        result.put("functions", new TreeSet(this.functionNames));
        return result;
    }

    public Long getId() {
        return this.scriptId;
    }

    public synchronized Collection getBreakpoints(String functionName, Integer lineNumber, DebugFrameImpl frame) {
        ArrayList<Long> result = new ArrayList<Long>();
        Iterator iterator = this.breakpoints.iterator();
        while (iterator.hasNext()) {
            BreakpointImpl breakpoint = (BreakpointImpl)iterator.next();
            if (!breakpoint.matches(functionName, lineNumber, frame)) continue;
            result.add(breakpoint.getId());
        }
        return result;
    }

    public boolean isValid(Integer lineNumber, String functionName) {
        if (lineNumber != null) {
            return this.lineNumbers.contains(lineNumber);
        }
        if (functionName != null) {
            return this.functionNames.contains(functionName);
        }
        return functionName == null;
    }

    public synchronized void addBreakpoint(BreakpointImpl breakpoint) {
        this.breakpoints.add(breakpoint);
    }

    public synchronized void removeBreakpoint(BreakpointImpl breakpoint) {
        this.breakpoints.remove(breakpoint);
    }

    public String getLocation() {
        return this.location;
    }

    public ScriptRecord getRecord(DebuggableScript debuggableScript) {
        return (ScriptRecord)this.scriptRecords.get(debuggableScript);
    }

    static class ScriptRecord {
        String name = null;
        int firstLine = 1;

        ScriptRecord() {
        }
    }
}

