/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.debug.rhino;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.languages.javascript.debug.connect.EventPacket;
import org.eclipse.e4.languages.javascript.debug.rhino.ContextData;
import org.eclipse.e4.languages.javascript.debug.rhino.DebugFrameImpl;
import org.eclipse.e4.languages.javascript.debug.rhino.RhinoDebugger;
import org.eclipse.e4.languages.javascript.debug.rhino.ScriptImpl;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class ThreadData {
    private final LinkedList contexts = new LinkedList();
    private final Long threadId;
    private final RhinoDebugger debugger;
    private long currentContextId = 0L;
    private long currentFrameId = 0L;

    public ThreadData(Long threadId, RhinoDebugger debugger) {
        this.threadId = threadId;
        this.debugger = debugger;
    }

    public synchronized Object toJSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("threadId", this.threadId);
        if (this.contexts.isEmpty()) {
            result.put("state", "running");
        } else {
            Context top = (Context)this.contexts.getFirst();
            result.put("state", ((ContextData)top.getDebuggerContextData()).getState());
        }
        ArrayList<Long> contextIds = new ArrayList<Long>(this.contexts.size());
        Iterator iterator = this.contexts.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            ContextData data = (ContextData)context.getDebuggerContextData();
            contextIds.add(data.getId());
        }
        result.put("contexts", contextIds);
        return result;
    }

    public synchronized void contextCreated(Context context) {
        context.setGeneratingDebug(true);
        context.setOptimizationLevel(-1);
        ContextData contextData = new ContextData(this.threadId, new Long(this.currentContextId++), this.debugger);
        context.setDebugger((Debugger)this.debugger, (Object)contextData);
        this.contexts.addFirst(context);
        if (this.contexts.size() == 1) {
            this.sendThreadEvent("enter");
        }
    }

    public synchronized void contextReleased(Context context) {
        this.contexts.removeFirst();
        if (this.contexts.isEmpty()) {
            this.sendThreadEvent("exit");
        }
    }

    private void sendThreadEvent(String type) {
        EventPacket threadEvent = new EventPacket("thread");
        Map body = threadEvent.getBody();
        body.put("type", type);
        body.put("threadId", this.threadId);
        this.debugger.sendEvent(threadEvent);
    }

    public synchronized boolean hasContext() {
        return !this.contexts.isEmpty();
    }

    public synchronized List getFrameIds() {
        ArrayList result = new ArrayList(this.contexts.size());
        Iterator iterator = this.contexts.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            ContextData data = (ContextData)context.getDebuggerContextData();
            result.addAll(data.getFrameIds());
        }
        return result;
    }

    public synchronized void suspend() {
        Context context = (Context)this.contexts.getFirst();
        if (context == null) {
            return;
        }
        ContextData data = (ContextData)context.getDebuggerContextData();
        data.suspend();
    }

    public synchronized void resume(String stepType) {
        Context context = (Context)this.contexts.getFirst();
        if (context == null) {
            return;
        }
        ContextData data = (ContextData)context.getDebuggerContextData();
        data.resume(stepType);
    }

    public DebugFrameImpl getFrame(Long frameId) {
        Iterator iterator = this.contexts.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            ContextData data = (ContextData)context.getDebuggerContextData();
            DebugFrameImpl frame = data.getFrame(frameId);
            if (frame == null) continue;
            return frame;
        }
        return null;
    }

    public synchronized DebugFrame getFrame(Context context, DebuggableScript debuggableScript, ScriptImpl script) {
        return new DebugFrameImpl(new Long(this.currentFrameId++), context, debuggableScript, script);
    }
}

