/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.graphics.tests;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PRect;
import edu.umd.cs.piccolo.nodes.PText;
import junit.framework.Assert;
import org.eclipse.e4.tm.builder.TmModelTest;
import org.eclipse.e4.tm.builder.TmTestCase;
import org.eclipse.e4.tm.graphics.util.Rectangle;
import org.eclipse.e4.tm.graphics2d.Canvas;
import org.eclipse.e4.tm.graphics2d.Graphics2dFactory;
import org.eclipse.e4.tm.graphics2d.Graphics2dPackage;
import org.eclipse.e4.tm.graphics2d.Layer2d;
import org.eclipse.e4.tm.graphics2d.Rect2d;
import org.eclipse.e4.tm.graphics2d.Text2d;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphical2dTest
extends TmModelTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected <T> T getChild(PNode node, int i, Class<T> c) {
        PNode child = node.getChild(i);
        return (T)(c.isInstance(child) ? child : null);
    }

    public void testPNodes() {
        Graphics2dPackage graphicsPackage = Graphics2dPackage.eINSTANCE;
        Canvas parent = (Canvas)Graphics2dFactory.eINSTANCE.create(graphicsPackage.getCanvas());
        Layer2d eLayer = (Layer2d)Graphics2dFactory.eINSTANCE.create(graphicsPackage.getLayer2d());
        eLayer.setBounds(new Rectangle());
        parent.getLayers().add((Object)eLayer);
        Text2d eTextNode = (Text2d)Graphics2dFactory.eINSTANCE.create(graphicsPackage.getText2d());
        eTextNode.setBounds(new Rectangle());
        eTextNode.setText("A text node");
        eLayer.getChildren().add((Object)eTextNode);
        Rect2d eRectNode = (Rect2d)Graphics2dFactory.eINSTANCE.create(graphicsPackage.getRect2d());
        eRectNode.setBounds(new Rectangle(10.0, 10.0, 30.0, 30.0));
        eLayer.getChildren().add((Object)eRectNode);
        this.builder.build((EObject)parent, (Object)this.getTopLevel());
        Composite comp = (Composite)this.getChild(0, Composite.class);
        Assert.assertNotNull((Object)comp);
        Graphical2dTest.assertEquals((Object)comp, (Object)this.builder.getObject((EObject)parent, Composite.class));
        PCanvas pCanvas = (PCanvas)this.builder.getObject((EObject)parent, PCanvas.class);
        Graphical2dTest.assertEquals((int)pCanvas.getCamera().getLayerCount(), (int)1);
        PLayer layer = pCanvas.getCamera().getLayer(0);
        Graphical2dTest.assertEquals((Object)pCanvas.getLayer(), (Object)layer);
        PText pTextNode = this.getChild((PNode)layer, 0, PText.class);
        Assert.assertNotNull((Object)pTextNode);
        Graphical2dTest.assertEquals((String)eTextNode.getText(), (String)pTextNode.getText());
        PRect pRectNode = this.getChild((PNode)layer, 1, PRect.class);
        Assert.assertNotNull((Object)pRectNode);
        this.testRectangle(eRectNode.getBounds(), (Rectangle)pRectNode.getBoundsReference());
    }

    private void testRectangle(Rectangle expected, Rectangle actual) {
        Graphical2dTest.assertEquals((Object)expected.x, (Object)actual.x);
        Graphical2dTest.assertEquals((Object)expected.y, (Object)actual.y);
        Graphical2dTest.assertEquals((Object)expected.width, (Object)actual.width);
        Graphical2dTest.assertEquals((Object)expected.height, (Object)actual.height);
    }

    public static void main(String[] args) {
        TmTestCase.doRun(Graphical2dTest.class);
    }
}

