/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.tests;

import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.TriggerSequence;
import org.eclipse.e4.ui.bindings.tests.Activator;
import org.eclipse.e4.ui.bindings.tests.TestUtil;

public class BindingLookupTest
extends TestCase {
    private static final String TEST_CAT1 = "test.cat1";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_ID2 = "test.id2";
    private IEclipseContext workbenchContext;

    private IEclipseContext createWorkbenchContext(IEclipseContext globalContext) {
        IEclipseContext wb = TestUtil.createContext(globalContext, "workbenchContext");
        return wb;
    }

    private void defineCommands(IEclipseContext context) {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        Category category = cs.defineCategory(TEST_CAT1, "CAT1", null);
        cs.defineCommand(TEST_ID1, "ID1", null, category, null);
        cs.defineCommand(TEST_ID2, "ID2", null, category, null);
    }

    protected void setUp() throws Exception {
        this.workbenchContext = this.createWorkbenchContext(Activator.getDefault().getGlobalContext());
        this.defineCommands(this.workbenchContext);
    }

    protected void tearDown() throws Exception {
        if (this.workbenchContext instanceof IDisposable) {
            ((IDisposable)this.workbenchContext).dispose();
        }
        this.workbenchContext = null;
    }

    public void testFindBinding() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        bs.activateBinding(seq, cmd);
        ParameterizedCommand perfectMatch = bs.getPerfectMatch(seq);
        BindingLookupTest.assertEquals((Object)cmd, (Object)perfectMatch);
        bs.deactivateBinding(seq, cmd);
        BindingLookupTest.assertNull((Object)bs.getPerfectMatch(seq));
        bs.activateBinding(seq, cmd);
        BindingLookupTest.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq));
    }

    public void testMultipleBindings() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        TriggerSequence seq2 = bs.createSequence("CTRL+2 X");
        bs.activateBinding(seq, cmd);
        bs.activateBinding(seq2, cmd);
        BindingLookupTest.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq2));
    }

    public void testLookupChildBinding() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        bs1.activateBinding(seq, cmd);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        BindingLookupTest.assertEquals((Object)cmd, (Object)wBS.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd, (Object)bs1.getPerfectMatch(seq));
        bs1.deactivateBinding(seq, cmd);
        BindingLookupTest.assertNull((Object)wBS.getPerfectMatch(seq));
        BindingLookupTest.assertNull((Object)bs1.getPerfectMatch(seq));
    }

    public void testLookupWithTwoChildren() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd1 = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = wBS.createSequence("CTRL+5 T");
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        bs1.activateBinding(seq, cmd1);
        IEclipseContext c2 = TestUtil.createContext(this.workbenchContext, "c2");
        EBindingService bs2 = (EBindingService)c2.get(EBindingService.class.getName());
        bs2.activateBinding(seq, cmd2);
        BindingLookupTest.assertEquals((Object)cmd1, (Object)wBS.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq));
    }

    public void testLookupWithDifferentActiveChild() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd1 = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = wBS.createSequence("CTRL+5 T");
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        bs1.activateBinding(seq, cmd1);
        IEclipseContext c2 = TestUtil.createContext(this.workbenchContext, "c2");
        EBindingService bs2 = (EBindingService)c2.get(EBindingService.class.getName());
        bs2.activateBinding(seq, cmd2);
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd1, (Object)wBS.getPerfectMatch(seq));
        this.workbenchContext.set("activeChildContext", (Object)c2);
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd2, (Object)wBS.getPerfectMatch(seq));
        this.workbenchContext.set("activeChildContext", (Object)c1);
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd1, (Object)wBS.getPerfectMatch(seq));
        this.workbenchContext.set("activeChildContext", (Object)c2);
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq));
        BindingLookupTest.assertEquals((Object)cmd2, (Object)wBS.getPerfectMatch(seq));
        BindingLookupTest.assertTrue((boolean)wBS.isPerfectMatch(seq));
    }

    public void testLookupShortcut() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        bs.activateBinding(seq, cmd);
        BindingLookupTest.assertEquals((Object)seq, (Object)bs.getBestSequenceFor(cmd));
    }

    public void testLookupShortcuts() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        TriggerSequence seq2 = bs.createSequence("CTRL+2 X");
        bs.activateBinding(seq, cmd);
        bs.activateBinding(seq2, cmd);
        TriggerSequence foundSequence = bs.getBestSequenceFor(cmd);
        BindingLookupTest.assertNotNull((Object)foundSequence);
        BindingLookupTest.assertEquals((Object)seq, (Object)foundSequence);
    }

    public void testLookupBestShortcut() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = bs.createSequence("ALT+5 X");
        bs.activateBinding(seq2, cmd);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        bs.activateBinding(seq, cmd);
        TriggerSequence foundSequence = bs.getBestSequenceFor(cmd);
        BindingLookupTest.assertNotNull((Object)foundSequence);
        BindingLookupTest.assertEquals((Object)seq, (Object)foundSequence);
    }

    public void testLookupBestShortcutWithChild() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = bs.createSequence("CTRL+5 T");
        bs.activateBinding(seq2, cmd);
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("ALT+5 X");
        bs1.activateBinding(seq, cmd);
        TriggerSequence foundSequence = bs.getBestSequenceFor(cmd);
        BindingLookupTest.assertNotNull((Object)foundSequence);
        BindingLookupTest.assertEquals((Object)seq, (Object)foundSequence);
    }

    public void testLookupShortcutsTwoChildren() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd1 = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = wBS.createSequence("CTRL+5 T");
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        bs1.activateBinding(seq, cmd1);
        IEclipseContext c2 = TestUtil.createContext(this.workbenchContext, "c2");
        EBindingService bs2 = (EBindingService)c2.get(EBindingService.class.getName());
        bs2.activateBinding(seq, cmd2);
        BindingLookupTest.assertEquals((Object)seq, (Object)wBS.getBestSequenceFor(cmd1));
        BindingLookupTest.assertNull((Object)wBS.getBestSequenceFor(cmd2));
        BindingLookupTest.assertEquals((Object)seq, (Object)bs1.getBestSequenceFor(cmd1));
        BindingLookupTest.assertNull((Object)bs1.getBestSequenceFor(cmd2));
        BindingLookupTest.assertEquals((Object)seq, (Object)bs2.getBestSequenceFor(cmd2));
        BindingLookupTest.assertNull((Object)bs2.getBestSequenceFor(cmd1));
    }

    public void testLookupAllShortcuts() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = bs.createSequence("ALT+5 X");
        bs.activateBinding(seq2, cmd);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        bs.activateBinding(seq, cmd);
        HashSet<TriggerSequence> set = new HashSet<TriggerSequence>();
        set.add(seq);
        set.add(seq2);
        BindingLookupTest.assertEquals(set, (Object)bs.getSequencesFor(cmd));
    }

    public void testLookupAllShortcutsWithChild() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = wBS.createSequence("ALT+5 X");
        wBS.activateBinding(seq2, cmd);
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        bs1.activateBinding(seq, cmd);
        HashSet<TriggerSequence> set = new HashSet<TriggerSequence>();
        set.add(seq);
        set.add(seq2);
        BindingLookupTest.assertEquals(set, (Object)wBS.getSequencesFor(cmd));
    }

    public void testPartialMatch() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = wBS.createSequence("ALT+5 X");
        wBS.activateBinding(seq2, cmd);
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        bs1.activateBinding(seq, cmd);
        TriggerSequence partialMatch = bs1.createSequence("CTRL+5");
        TriggerSequence partialNoMatch = bs1.createSequence("CTRL+8");
        BindingLookupTest.assertFalse((boolean)bs1.isPartialMatch(partialNoMatch));
        BindingLookupTest.assertTrue((boolean)bs1.isPartialMatch(partialMatch));
    }

    public void testGetPartialMatches() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = wBS.createSequence("ALT+5 X");
        wBS.activateBinding(seq2, cmd);
        IEclipseContext c1 = TestUtil.createContext(this.workbenchContext, "c1");
        this.workbenchContext.set("activeChildContext", (Object)c1);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        bs1.activateBinding(seq, cmd);
        TriggerSequence sseq = bs1.createSequence("CTRL+5 Y");
        bs1.activateBinding(sseq, cmd2);
        HashSet<ParameterizedCommand> commandMatches = new HashSet<ParameterizedCommand>();
        commandMatches.add(cmd2);
        commandMatches.add(cmd);
        TriggerSequence partialMatch = bs1.createSequence("CTRL+5");
        TriggerSequence partialNoMatch = bs1.createSequence("CTRL+8");
        BindingLookupTest.assertFalse((boolean)bs1.isPartialMatch(partialNoMatch));
        BindingLookupTest.assertTrue((boolean)bs1.isPartialMatch(partialMatch));
        Collection matches = bs1.getPartialMatches(partialMatch);
        BindingLookupTest.assertEquals(commandMatches, (Object)matches);
    }
}

