/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.tests;

import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.TriggerSequence;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.e4.ui.bindings.tests.Activator;
import org.eclipse.e4.ui.bindings.tests.TestUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class KeyDispatcherTest
extends TestCase {
    private static final String TEST_CAT1 = "test.cat1";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_ID2 = "test.id2";
    private Display display;
    private IEclipseContext workbenchContext;
    private CallHandler handler;
    private CallHandler twoStrokeHandler;

    private void defineCommands(IEclipseContext context) {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        Category category = cs.defineCategory(TEST_CAT1, "CAT1", null);
        cs.defineCommand(TEST_ID1, "ID1", null, category, null);
        cs.defineCommand(TEST_ID2, "ID2", null, category, null);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService hs = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        this.handler = new CallHandler();
        hs.activateHandler(TEST_ID1, (Object)this.handler);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = bs.createSequence("CTRL+A");
        bs.activateBinding(seq, cmd);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        this.twoStrokeHandler = new CallHandler();
        hs.activateHandler(TEST_ID2, (Object)this.twoStrokeHandler);
        TriggerSequence twoKeys = bs.createSequence("CTRL+5 CTRL+A");
        bs.activateBinding(twoKeys, cmd2);
    }

    private IEclipseContext createWorkbenchContext(IEclipseContext globalContext) {
        IEclipseContext wb = TestUtil.createContext(globalContext, "workbenchContext");
        return wb;
    }

    protected void setUp() throws Exception {
        this.display = new Display();
        this.workbenchContext = this.createWorkbenchContext(Activator.getDefault().getGlobalContext());
        this.defineCommands(this.workbenchContext);
    }

    protected void tearDown() throws Exception {
        if (this.workbenchContext instanceof IDisposable) {
            ((IDisposable)this.workbenchContext).dispose();
        }
        this.workbenchContext = null;
        this.display.dispose();
        this.display = null;
    }

    public void testExecuteOneCommand() throws Exception {
        KeyBindingDispatcher dispatcher = new KeyBindingDispatcher();
        ContextInjectionFactory.inject((Object)dispatcher, (IEclipseContext)this.workbenchContext);
        KeyBindingDispatcher.KeyDownFilter listener = dispatcher.getKeyDownFilter();
        this.display.addFilter(1, (Listener)listener);
        this.display.addFilter(31, (Listener)listener);
        KeyDispatcherTest.assertFalse((boolean)this.handler.q2);
        Shell shell = new Shell(this.display, 0);
        Event event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 65;
        shell.notifyListeners(1, event);
        KeyDispatcherTest.assertTrue((boolean)this.handler.q2);
    }

    public void testExecuteMultiStrokeBinding() throws Exception {
        KeyBindingDispatcher dispatcher = new KeyBindingDispatcher();
        ContextInjectionFactory.inject((Object)dispatcher, (IEclipseContext)this.workbenchContext);
        KeyBindingDispatcher.KeyDownFilter listener = dispatcher.getKeyDownFilter();
        this.display.addFilter(1, (Listener)listener);
        this.display.addFilter(31, (Listener)listener);
        KeyDispatcherTest.assertFalse((boolean)this.twoStrokeHandler.q2);
        Shell shell = new Shell(this.display, 0);
        Event event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 53;
        shell.notifyListeners(1, event);
        KeyDispatcherTest.assertFalse((boolean)this.twoStrokeHandler.q2);
        event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 65;
        shell.notifyListeners(1, event);
        this.processEvents();
        KeyDispatcherTest.assertTrue((boolean)this.twoStrokeHandler.q2);
        KeyDispatcherTest.assertFalse((boolean)this.handler.q2);
    }

    public void testKeyDispatcherReset() throws Exception {
        KeyBindingDispatcher dispatcher = new KeyBindingDispatcher();
        ContextInjectionFactory.inject((Object)dispatcher, (IEclipseContext)this.workbenchContext);
        KeyBindingDispatcher.KeyDownFilter listener = dispatcher.getKeyDownFilter();
        this.display.addFilter(1, (Listener)listener);
        this.display.addFilter(31, (Listener)listener);
        KeyDispatcherTest.assertFalse((boolean)this.twoStrokeHandler.q2);
        Shell shell = new Shell(this.display, 0);
        Event event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 53;
        shell.notifyListeners(1, event);
        KeyDispatcherTest.assertFalse((boolean)this.twoStrokeHandler.q2);
        Thread.sleep(2000L);
        this.processEvents();
        event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 65;
        shell.notifyListeners(1, event);
        this.processEvents();
        KeyDispatcherTest.assertFalse((boolean)this.twoStrokeHandler.q2);
        KeyDispatcherTest.assertTrue((boolean)this.handler.q2);
    }

    public void testSendKeyStroke() throws Exception {
        KeyBindingDispatcher dispatcher = (KeyBindingDispatcher)ContextInjectionFactory.make(KeyBindingDispatcher.class, (IEclipseContext)this.workbenchContext);
        KeyBindingDispatcher.KeyDownFilter listener = dispatcher.getKeyDownFilter();
        this.display.addFilter(1, (Listener)listener);
        this.display.addFilter(31, (Listener)listener);
        Shell shell = new Shell(this.display, 0);
        shell.setLayout((Layout)new FillLayout());
        StyledText text = new StyledText((Composite)shell, 66);
        shell.setBounds(100, 100, 100, 100);
        shell.layout();
        this.processEvents();
        KeyDispatcherTest.assertEquals((String)"", (String)text.getText());
        Event event = new Event();
        event.type = 1;
        event.stateMask = 131072;
        event.keyCode = 40;
        event.character = (char)40;
        text.notifyListeners(1, event);
        event = new Event();
        event.type = 2;
        event.stateMask = 131072;
        event.keyCode = 40;
        event.character = (char)40;
        text.notifyListeners(2, event);
        this.processEvents();
        KeyDispatcherTest.assertEquals((String)"(", (String)text.getText());
    }

    private void processEvents() {
        while (this.display.readAndDispatch()) {
        }
    }

    static class CallHandler {
        public boolean q1;
        public boolean q2;

        CallHandler() {
        }

        public boolean canExecute() {
            this.q1 = true;
            return true;
        }

        public Object execute() {
            this.q2 = true;
            if (this.q1) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

