/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.Trigger;
import org.eclipse.e4.ui.bindings.TriggerSequence;
import org.eclipse.e4.ui.bindings.keys.IKeyLookup;
import org.eclipse.e4.ui.bindings.keys.KeyLookupFactory;
import org.eclipse.e4.ui.bindings.keys.KeySequence;
import org.eclipse.e4.ui.bindings.keys.KeyStroke;
import org.eclipse.e4.ui.bindings.keys.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingServiceImpl
implements EBindingService {
    static final Comparator<Binding> BEST_SEQUENCE = new Comparator<Binding>(){

        @Override
        public int compare(Binding o1, Binding o2) {
            Trigger[] currentTriggers;
            Trigger[] bestTriggers = o1.sequence.getTriggers();
            int compareTo = bestTriggers.length - (currentTriggers = o2.sequence.getTriggers()).length;
            if (compareTo != 0) {
                return compareTo;
            }
            compareTo = this.countStrokes(bestTriggers) - this.countStrokes(currentTriggers);
            if (compareTo != 0) {
                return compareTo;
            }
            return o1.sequence.format().length() - o2.sequence.format().length();
        }

        private final int countStrokes(Trigger[] triggers) {
            int strokeCount = triggers.length;
            int i = 0;
            while (i < triggers.length) {
                Trigger trigger = triggers[i];
                if (trigger instanceof KeyStroke) {
                    IKeyLookup lookup;
                    KeyStroke keyStroke = (KeyStroke)trigger;
                    int modifierKeys = keyStroke.getModifierKeys();
                    if ((modifierKeys & (lookup = KeyLookupFactory.getDefault()).getAlt()) != 0) {
                        strokeCount += 8;
                    }
                    if ((modifierKeys & lookup.getCtrl()) != 0) {
                        strokeCount += 2;
                    }
                    if ((modifierKeys & lookup.getShift()) != 0) {
                        strokeCount += 4;
                    }
                    if ((modifierKeys & lookup.getCommand()) != 0) {
                        strokeCount += 2;
                    }
                } else {
                    strokeCount += 99;
                }
                ++i;
            }
            return strokeCount;
        }
    };
    static final String LOOKUP_BINDING = "binding";
    static final String LOOKUP_CMD = "cmd";
    static final String BINDING_LOOKUP = "org.eclipse.e4.ui.bindings.EBindingLookup";
    static final String BINDING_PREFIX_LOOKUP = "org.eclipse.e4.ui.bindings.EBindingPrefixLookup";
    static final String CMD_LOOKUP = "org.eclipse.e4.ui.bindings.ECommandLookup";
    static final String CMD_SEQ_LOOKUP = "org.eclipse.e4.ui.bindings.ECommandSequenceLookup";
    static final String LOOKUP_PARTIAL_MATCH = "org.eclipse.e4.ui.bindings.EPartialMatchLookup";
    static final String B_ID = "binding::";
    static final String B_SEQ = "bindSeq::";
    static final String P_ID = "parmCmd::";
    private IEclipseContext context;

    @Override
    public void activateBinding(TriggerSequence sequence, ParameterizedCommand command) {
        Binding binding = new Binding(sequence, command);
        this.context.set(binding.getBindingId(), (Object)binding);
        this.addLocalArray(binding.getCommandId(), binding);
        String[] prefixes = binding.getPrefixes();
        int i = 0;
        while (i < prefixes.length) {
            this.addLocalArray(prefixes[i], binding);
            ++i;
        }
    }

    private void addLocalArray(String id, Binding binding) {
        ArrayList<Binding> bindings = new ArrayList<Binding>(3);
        ArrayList tmp = (ArrayList)this.context.getLocal(id);
        if (tmp != null) {
            bindings.addAll(tmp);
        }
        bindings.add(binding);
        Collections.sort(bindings, BEST_SEQUENCE);
        this.context.set(id, bindings);
    }

    private void removeLocalArray(String id, Binding binding) {
        ArrayList tmp = (ArrayList)this.context.getLocal(id);
        if (tmp.size() < 2) {
            this.context.remove(id);
        } else {
            tmp.remove(binding);
            this.context.set(id, new ArrayList(tmp));
        }
    }

    @Override
    public void deactivateBinding(TriggerSequence sequence, ParameterizedCommand command) {
        Binding binding = new Binding(sequence, command);
        this.context.remove(binding.getBindingId());
        this.removeLocalArray(binding.getCommandId(), binding);
        String[] prefixes = binding.getPrefixes();
        int i = 0;
        while (i < prefixes.length) {
            this.removeLocalArray(prefixes[i], binding);
            ++i;
        }
    }

    @Override
    public TriggerSequence createSequence(String sequence) {
        try {
            return KeySequence.getInstance(sequence);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Collection<ParameterizedCommand> getConflictsFor(TriggerSequence sequence) {
        return null;
    }

    @Override
    public ParameterizedCommand getPerfectMatch(TriggerSequence trigger) {
        Binding binding = (Binding)this.context.get(BINDING_LOOKUP, this.lookupBinding(trigger.format()));
        return binding == null ? null : binding.command;
    }

    @Override
    public boolean isPartialMatch(TriggerSequence keySequence) {
        return this.context.get(BINDING_PREFIX_LOOKUP, this.lookupSequence(keySequence.format())) != null;
    }

    @Override
    public TriggerSequence getBestSequenceFor(ParameterizedCommand command) {
        String cmdString = command.serialize();
        ArrayList tmp = (ArrayList)this.context.get(CMD_LOOKUP, this.lookupCommand(cmdString));
        if (tmp != null && !tmp.isEmpty()) {
            return ((Binding)tmp.get((int)0)).sequence;
        }
        return null;
    }

    @Override
    public Collection<TriggerSequence> getSequencesFor(ParameterizedCommand command) {
        String cmdString = command.serialize();
        return (Collection)this.context.get(CMD_SEQ_LOOKUP, this.lookupCommand(cmdString));
    }

    @Override
    public boolean isPerfectMatch(TriggerSequence sequence) {
        return this.getPerfectMatch(sequence) != null;
    }

    @Override
    public Collection<ParameterizedCommand> getPartialMatches(TriggerSequence sequence) {
        return (Collection)this.context.get(LOOKUP_PARTIAL_MATCH, this.lookupSequence(sequence.format()));
    }

    @Inject
    public void setContext(IEclipseContext c) {
        this.context = c;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    private Object[] lookupBinding(String bindingId) {
        return new Object[]{B_ID + bindingId};
    }

    private Object[] lookupCommand(String cmdString) {
        return new Object[]{P_ID + cmdString};
    }

    private Object[] lookupSequence(String sequence) {
        return new Object[]{B_SEQ + sequence};
    }

    static final class Binding {
        public TriggerSequence sequence;
        public ParameterizedCommand command;
        private String[] prefixes;
        private String bindingId;
        private String commandId;
        private int hashCode = -1;

        public Binding(TriggerSequence s, ParameterizedCommand c) {
            this.sequence = s;
            this.command = c;
        }

        String[] getPrefixes() {
            if (this.prefixes == null) {
                TriggerSequence[] prefs = this.sequence.getPrefixes();
                this.prefixes = new String[prefs.length - 1];
                int i = 1;
                while (i < prefs.length) {
                    this.prefixes[i - 1] = BindingServiceImpl.B_SEQ + prefs[i];
                    ++i;
                }
            }
            return this.prefixes;
        }

        String getBindingId() {
            if (this.bindingId == null) {
                this.bindingId = BindingServiceImpl.B_ID + this.sequence.format();
            }
            return this.bindingId;
        }

        String getCommandId() {
            if (this.commandId == null) {
                this.commandId = BindingServiceImpl.P_ID + this.command.serialize();
            }
            return this.commandId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binding)) {
                return false;
            }
            Binding b = (Binding)o;
            return this.sequence.equals(b.sequence) && this.command.equals((Object)b.command);
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = this.sequence.hashCode() * 81 + this.command.hashCode();
            }
            return this.hashCode;
        }
    }
}

