/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParser;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyCompositeHandler;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2Delegate;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.selectors.IDynamicPseudoClassesHandler;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedPropertyException;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.core.impl.engine.CSSElementContextImpl;
import org.eclipse.e4.ui.css.core.impl.sac.ExtendedSelector;
import org.eclipse.e4.ui.css.core.resources.CSSResourcesHelpers;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.eclipse.e4.ui.css.core.util.impl.resources.ResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.util.resources.IResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.utils.StringUtils;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public abstract class AbstractCSSEngine
implements CSSEngine {
    private static final IResourcesLocatorManager defaultResourcesLocatorManager = ResourcesLocatorManager.INSTANCE;
    private ExtendedDocumentCSS documentCSS;
    private ViewCSS viewCSS;
    private IElementProvider elementProvider;
    protected boolean computeDefaultStyle = false;
    private Map elementsWithDynamicPseudoClasses = null;
    private Map elementsContext = null;
    private CSSErrorHandler errorHandler;
    private IResourcesLocatorManager resourcesLocatorManager;
    private Map dynamicPseudoClassesHandler = new HashMap();
    private IResourcesRegistry resourcesRegistry;
    private List propertyHandlerProviders = new ArrayList();
    private Map currentCSSPropertiesApplyed = new HashMap();
    private boolean throwError;
    private Map valueConverters = null;

    public AbstractCSSEngine() {
        this(new DocumentCSSImpl());
    }

    public AbstractCSSEngine(ExtendedDocumentCSS documentCSS) {
        this.documentCSS = documentCSS;
        this.viewCSS = new ViewCSSImpl(documentCSS);
    }

    public StyleSheet parseStyleSheet(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parseStyleSheet(source);
    }

    public StyleSheet parseStyleSheet(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parseStyleSheet(source);
    }

    public StyleSheet parseStyleSheet(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        CSSStyleSheet styleSheet = parser.parseStyleSheet(source);
        if (this.documentCSS instanceof ExtendedDocumentCSS) {
            this.documentCSS.addStyleSheet(styleSheet);
        }
        return styleSheet;
    }

    private void checkInputSource(InputSource source) throws IOException {
        Reader reader = source.getCharacterStream();
        InputStream stream = source.getByteStream();
        if (reader == null && stream == null) {
            throw new IOException("CharacterStream or ByteStream cannot be null for the InputSource.");
        }
    }

    public CSSStyleDeclaration parseStyleDeclaration(String style) throws IOException {
        StringReader reader = new StringReader(style);
        return this.parseStyleDeclaration(reader);
    }

    public CSSStyleDeclaration parseStyleDeclaration(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parseStyleDeclaration(source);
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parseStyleDeclaration(source);
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        CSSStyleDeclaration styleDeclaration = parser.parseStyleDeclaration(source);
        return styleDeclaration;
    }

    public CSSValue parsePropertyValue(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parsePropertyValue(source);
    }

    public CSSValue parsePropertyValue(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parsePropertyValue(source);
    }

    public CSSValue parsePropertyValue(String value) throws IOException {
        StringReader reader = new StringReader(value);
        return this.parsePropertyValue(reader);
    }

    public CSSValue parsePropertyValue(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        return parser.parsePropertyValue(source);
    }

    public void applyStyles(Object element, boolean applyStylesToChildNodes) {
        this.applyStyles(element, applyStylesToChildNodes, this.computeDefaultStyle);
    }

    public void applyStyles(Object element, boolean applyStylesToChildNodes, boolean computeDefaultStyle) {
        Element elt = this.getElement(element);
        if (elt != null) {
            NodeList nodes;
            CSSStyleDeclaration style = this.viewCSS.getComputedStyle(elt, null);
            if (computeDefaultStyle) {
                if (applyStylesToChildNodes) {
                    this.computeDefaultStyle = computeDefaultStyle;
                }
                this.applyDefaultStyleDeclaration(element, false, style, null);
            }
            this.initializeDynamicPseudoClassesIfNeeded(element);
            String[] pseudoInstances = this.getStaticPseudoInstances(elt);
            if (pseudoInstances != null) {
                int i = 0;
                while (i < pseudoInstances.length) {
                    String pseudoInstance = pseudoInstances[i];
                    CSSStyleDeclaration styleWithPseudoInstance = this.viewCSS.getComputedStyle(elt, pseudoInstance);
                    if (computeDefaultStyle) {
                        this.applyDefaultStyleDeclaration(element, false, styleWithPseudoInstance, pseudoInstance);
                    }
                    if (styleWithPseudoInstance != null) {
                        CSSRule parentRule = styleWithPseudoInstance.getParentRule();
                        if (parentRule instanceof ExtendedCSSRule) {
                            this.applyConditionalPseudoStyle((ExtendedCSSRule)parentRule, pseudoInstance, element, styleWithPseudoInstance);
                        } else {
                            this.applyStyleDeclaration(element, styleWithPseudoInstance, pseudoInstance);
                        }
                    }
                    ++i;
                }
            }
            if (style != null) {
                this.applyStyleDeclaration(element, style, null);
            }
            try {
                this.applyInlineStyle(elt, false);
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
            if (applyStylesToChildNodes && (nodes = elt.getChildNodes()) != null) {
                int k = 0;
                while (k < nodes.getLength()) {
                    this.applyStyles(nodes.item(k), applyStylesToChildNodes);
                    ++k;
                }
                this.onStylesAppliedToChildNodes(elt, nodes);
            }
        }
    }

    private void applyConditionalPseudoStyle(ExtendedCSSRule parentRule, String pseudoInstance, Object element, CSSStyleDeclaration styleWithPseudoInstance) {
        SelectorList selectorList = parentRule.getSelectorList();
        int j = 0;
        while (j < selectorList.getLength()) {
            String value;
            Condition condition;
            Selector item = selectorList.item(j);
            if (item instanceof ConditionalSelector && (condition = ((ConditionalSelector)item).getCondition()) instanceof AttributeCondition && (value = ((AttributeCondition)condition).getValue()).equals(pseudoInstance)) {
                this.applyStyleDeclaration(element, styleWithPseudoInstance, pseudoInstance);
                return;
            }
            ++j;
        }
    }

    protected String[] getStaticPseudoInstances(Element element) {
        if (element instanceof CSSStylableElement) {
            CSSStylableElement stylableElement = (CSSStylableElement)element;
            return stylableElement.getStaticPseudoInstances();
        }
        return null;
    }

    protected void onStylesAppliedToChildNodes(Element element, NodeList nodes) {
        if (element instanceof CSSStylableElement) {
            ((CSSStylableElement)element).onStylesApplied(nodes);
        }
    }

    public void applyStyleDeclaration(Object element, CSSStyleDeclaration style, String pseudo) {
        this.currentCSSPropertiesApplyed.clear();
        ArrayList<ICSSPropertyHandler2> handlers2 = null;
        int i = 0;
        while (i < style.getLength()) {
            block13: {
                String property = style.item(i);
                CSSValue value = style.getPropertyCSSValue(property);
                try {
                    ICSSPropertyHandler handler = this.applyCSSProperty(element, property, value, pseudo);
                    ICSSPropertyHandler2 propertyHandler2 = null;
                    if (handler instanceof ICSSPropertyHandler2) {
                        propertyHandler2 = (ICSSPropertyHandler2)((Object)handler);
                    } else if (handler instanceof ICSSPropertyHandler2Delegate) {
                        propertyHandler2 = ((ICSSPropertyHandler2Delegate)((Object)handler)).getCSSPropertyHandler2();
                    }
                    if (propertyHandler2 != null) {
                        if (handlers2 == null) {
                            handlers2 = new ArrayList<ICSSPropertyHandler2>();
                        }
                        if (!handlers2.contains(propertyHandler2)) {
                            handlers2.add(propertyHandler2);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.throwError && (this.throwError || e instanceof UnsupportedPropertyException)) break block13;
                    this.handleExceptions(e);
                }
            }
            ++i;
        }
        if (handlers2 != null) {
            for (ICSSPropertyHandler2 handler2 : handlers2) {
                try {
                    handler2.onAllCSSPropertiesApplyed(element, this);
                }
                catch (Exception e) {
                    this.handleExceptions(e);
                }
            }
        }
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, Reader reader) throws IOException {
        CSSStyleDeclaration style = this.parseStyleDeclaration(reader);
        this.applyStyleDeclaration(node, style, null);
        return style;
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, InputStream stream) throws IOException {
        CSSStyleDeclaration style = this.parseStyleDeclaration(stream);
        this.applyStyleDeclaration(node, style, null);
        return style;
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, InputSource source) throws IOException {
        CSSStyleDeclaration style = this.parseStyleDeclaration(source);
        this.applyStyleDeclaration(node, style, null);
        return style;
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, String style) throws IOException {
        CSSStyleDeclaration styleDeclaration = this.parseStyleDeclaration(style);
        this.applyStyleDeclaration(node, styleDeclaration, null);
        return styleDeclaration;
    }

    public void applyInlineStyle(Object node, boolean applyStylesToChildNodes) throws IOException {
        Element elt = this.getElement(node);
        if (elt != null) {
            NodeList nodes;
            CSSStylableElement stylableElement;
            String style;
            if (elt instanceof CSSStylableElement && (style = (stylableElement = (CSSStylableElement)elt).getCSSStyle()) != null && style.length() > 0) {
                this.parseAndApplyStyleDeclaration(stylableElement.getNativeWidget(), style);
            }
            if (applyStylesToChildNodes && (nodes = elt.getChildNodes()) != null) {
                int k = 0;
                while (k < nodes.getLength()) {
                    this.applyInlineStyle(nodes.item(k), applyStylesToChildNodes);
                    ++k;
                }
            }
        }
    }

    public CSSStyleDeclaration getDefaultStyleDeclaration(Object element, String pseudoE) {
        return this.getDefaultStyleDeclaration(element, null, pseudoE);
    }

    public CSSStyleDeclaration getDefaultStyleDeclaration(Object widget, CSSStyleDeclaration newStyle, String pseudoE) {
        CSSStyleDeclaration style = null;
        for (ICSSPropertyHandlerProvider provider : this.propertyHandlerProviders) {
            try {
                style = provider.getDefaultCSSStyleDeclaration(this, widget, newStyle, pseudoE);
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return style;
    }

    public void applyDefaultStyleDeclaration(Object element, boolean applyStylesToChildNodes) {
        this.applyDefaultStyleDeclaration(element, applyStylesToChildNodes, null, null);
    }

    public void applyDefaultStyleDeclaration(Object element, boolean applyStylesToChildNodes, CSSStyleDeclaration newStyle, String pseudoE) {
        Element elt = this.getElement(element);
        if (elt != null) {
            NodeList nodes;
            if (elt instanceof CSSStylableElement) {
                CSSStylableElement stylableElement = (CSSStylableElement)elt;
                CSSStyleDeclaration oldDefaultStyleDeclaration = stylableElement.getDefaultStyleDeclaration(pseudoE);
                CSSStyleDeclaration defaultStyleDeclaration = this.getDefaultStyleDeclaration(element, newStyle, pseudoE);
                if (oldDefaultStyleDeclaration != null) {
                    try {
                        this.throwError = false;
                        this.applyStyleDeclaration(element, defaultStyleDeclaration, pseudoE);
                    }
                    finally {
                        this.throwError = true;
                    }
                }
            }
            if (applyStylesToChildNodes && (nodes = elt.getChildNodes()) != null) {
                int k = 0;
                while (k < nodes.getLength()) {
                    this.applyDefaultStyleDeclaration(nodes.item(k), applyStylesToChildNodes);
                    ++k;
                }
                this.onStylesAppliedToChildNodes(elt, nodes);
            }
        }
    }

    public ICSSPropertyHandler applyCSSProperty(Object widget, String property, CSSValue value, String pseudo) throws Exception {
        block6: {
            if (this.currentCSSPropertiesApplyed.containsKey(property)) {
                return null;
            }
            Collection handlers = this.getCSSPropertyHandlers(property);
            if (handlers == null) {
                if (this.throwError) {
                    throw new UnsupportedPropertyException(property);
                }
                return null;
            }
            try {
                for (ICSSPropertyHandler handler : handlers) {
                    boolean result = handler.applyCSSProperty(widget, property, value, pseudo, this);
                    if (!result) continue;
                    this.currentCSSPropertiesApplyed.put(property, property);
                    return handler;
                }
            }
            catch (Exception e) {
                if (!this.throwError && (this.throwError || e instanceof UnsupportedPropertyException)) break block6;
                this.handleExceptions(e);
            }
        }
        return null;
    }

    public String retrieveCSSProperty(Object widget, String property, String pseudo) {
        Collection handlers;
        block4: {
            handlers = this.getCSSPropertyHandlers(property);
            if (handlers != null) break block4;
            return null;
        }
        try {
            for (ICSSPropertyHandler handler : handlers) {
                String value = handler.retrieveCSSProperty(widget, property, pseudo, this);
                if (StringUtils.isEmpty(value)) continue;
                return value;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        return null;
    }

    public String[] getCSSCompositePropertiesNames(String property) {
        Collection handlers;
        block4: {
            handlers = this.getCSSPropertyHandlers(property);
            if (handlers != null) break block4;
            return null;
        }
        try {
            for (ICSSPropertyHandler handler : handlers) {
                ICSSPropertyCompositeHandler compositeHandler;
                if (!(handler instanceof ICSSPropertyCompositeHandler) || !(compositeHandler = (ICSSPropertyCompositeHandler)handler).isCSSPropertyComposite(property)) continue;
                return compositeHandler.getCSSPropertiesNames(property);
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        return null;
    }

    protected Collection getCSSPropertyHandlers(String property) throws Exception {
        ArrayList handlers = null;
        for (ICSSPropertyHandlerProvider provider : this.propertyHandlerProviders) {
            ArrayList h = provider.getCSSPropertyHandlers(property);
            if (handlers == null) {
                handlers = h;
                continue;
            }
            handlers = new ArrayList(handlers);
            handlers.addAll(h);
        }
        return handlers;
    }

    public void registerDynamicPseudoClassHandler(String pseudo, IDynamicPseudoClassesHandler dynamicPseudoClassHandler) {
        this.dynamicPseudoClassesHandler.put(pseudo, dynamicPseudoClassHandler);
    }

    protected void initializeDynamicPseudoClassesIfNeeded(Object node) {
        if (this.dynamicPseudoClassesHandler == null || this.dynamicPseudoClassesHandler.values().size() < 1) {
            return;
        }
        Element element = this.getElement(node);
        if (element == null) {
            return;
        }
        if (this.isElementsWithDynamicPseudoClassesInitialized(element)) {
            return;
        }
        List list = this.documentCSS.queryConditionSelector(10);
        if (list == null) {
            return;
        }
        for (Selector selector : list) {
            IDynamicPseudoClassesHandler handler;
            ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
            String value = ((AttributeCondition)conditionalSelector.getCondition()).getValue();
            if (!((ExtendedSelector)conditionalSelector.getSimpleSelector()).match(element, value) || (handler = (IDynamicPseudoClassesHandler)this.dynamicPseudoClassesHandler.get(value)) == null) continue;
            handler.intialize(element, this);
            this.addElementsWithDynamicPseudoClasses(element);
        }
    }

    protected void addElementsWithDynamicPseudoClasses(Element element) {
        if (this.elementsWithDynamicPseudoClasses == null) {
            this.elementsWithDynamicPseudoClasses = new HashMap();
        }
        this.elementsWithDynamicPseudoClasses.put(element, element);
    }

    protected boolean isElementsWithDynamicPseudoClassesInitialized(Element element) {
        if (this.elementsWithDynamicPseudoClasses == null) {
            return false;
        }
        return this.elementsWithDynamicPseudoClasses.get(element) != null;
    }

    public IElementProvider getElementProvider() {
        return this.elementProvider;
    }

    public void setElementProvider(IElementProvider elementProvider) {
        this.elementProvider = elementProvider;
    }

    public Element getElement(Object element) {
        Element elt = null;
        CSSElementContext elementContext = this.getCSSElementContext(element);
        if (elementContext != null && !elementContext.elementMustBeRefreshed(this.elementProvider)) {
            return elementContext.getElement();
        }
        if (element instanceof Element) {
            elt = (Element)element;
        } else if (this.elementProvider != null) {
            elt = this.elementProvider.getElement(element, this);
        }
        if (elt != null) {
            if (elementContext == null) {
                elementContext = new CSSElementContextImpl();
                this.getElementsContext().put(this.getNativeWidget(element), elementContext);
            }
            elementContext.setElementProvider(this.elementProvider);
            elementContext.setElement(elt);
        }
        return elt;
    }

    public Object getDocument() {
        return null;
    }

    public CSSElementContext getCSSElementContext(Object element) {
        Object o = this.getNativeWidget(element);
        return (CSSElementContext)this.getElementsContext().get(o);
    }

    public Object getNativeWidget(Object element) {
        Object o = element;
        if (element instanceof CSSStylableElement) {
            o = ((CSSStylableElement)o).getNativeWidget();
        }
        return o;
    }

    protected Map getElementsContext() {
        if (this.elementsContext == null) {
            this.elementsContext = new HashMap();
        }
        return this.elementsContext;
    }

    public void handleExceptions(Exception e) {
        if (this.errorHandler != null) {
            this.errorHandler.error(e);
        }
    }

    public CSSErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(CSSErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public IResourcesLocatorManager getResourcesLocatorManager() {
        if (this.resourcesLocatorManager == null) {
            return defaultResourcesLocatorManager;
        }
        return this.resourcesLocatorManager;
    }

    public void setResourcesLocatorManager(IResourcesLocatorManager resourcesLocatorManager) {
        this.resourcesLocatorManager = resourcesLocatorManager;
    }

    public DocumentCSS getDocumentCSS() {
        return this.documentCSS;
    }

    public ViewCSS getViewCSS() {
        return this.viewCSS;
    }

    public void dispose() {
        this.reset();
        this.elementsContext = null;
        if (this.resourcesRegistry != null) {
            this.resourcesRegistry.dispose();
        }
    }

    public void reset() {
        this.documentCSS.removeAllStyleSheets();
        if (this.elementsWithDynamicPseudoClasses != null) {
            Collection elements = this.elementsWithDynamicPseudoClasses.values();
            for (Element element : elements) {
                Collection handlers = this.dynamicPseudoClassesHandler.values();
                for (IDynamicPseudoClassesHandler handler : handlers) {
                    handler.dispose(element, this);
                }
            }
            this.elementsWithDynamicPseudoClasses = null;
        }
    }

    public IResourcesRegistry getResourcesRegistry() {
        return this.resourcesRegistry;
    }

    public void setResourcesRegistry(IResourcesRegistry resourcesRegistry) {
        this.resourcesRegistry = resourcesRegistry;
    }

    public void registerCSSPropertyHandlerProvider(ICSSPropertyHandlerProvider handlerProvider) {
        this.propertyHandlerProviders.add(handlerProvider);
    }

    public void unregisterCSSPropertyHandlerProvider(ICSSPropertyHandlerProvider handlerProvider) {
        this.propertyHandlerProviders.remove(handlerProvider);
    }

    public void registerCSSValueConverter(ICSSValueConverter converter) {
        if (this.valueConverters == null) {
            this.valueConverters = new HashMap();
        }
        this.valueConverters.put(converter.getToType(), converter);
    }

    public void unregisterCSSValueConverter(ICSSValueConverter converter) {
        if (this.valueConverters == null) {
            return;
        }
        this.valueConverters.remove(converter);
    }

    public ICSSValueConverter getCSSValueConverter(Object toType) {
        if (this.valueConverters != null) {
            return (ICSSValueConverter)this.valueConverters.get(toType);
        }
        return null;
    }

    public Object convert(CSSValue value, Object toType, Object context) throws Exception {
        ICSSValueConverter converter;
        Object newValue = null;
        String key = CSSResourcesHelpers.getCSSValueKey(value);
        IResourcesRegistry resourcesRegistry = this.getResourcesRegistry();
        if (resourcesRegistry != null && key != null) {
            newValue = resourcesRegistry.getResource(toType, key);
        }
        if (newValue == null && (converter = this.getCSSValueConverter(toType)) != null && (newValue = converter.convert(value, (CSSEngine)this, context)) != null && resourcesRegistry != null && key != null) {
            resourcesRegistry.registerResource(toType, key, newValue);
        }
        return newValue;
    }

    public String convert(Object value, Object toType, Object context) throws Exception {
        if (value == null) {
            return null;
        }
        ICSSValueConverter converter = this.getCSSValueConverter(toType);
        if (converter != null) {
            return converter.convert(value, (CSSEngine)this, context);
        }
        return null;
    }

    public abstract CSSParser makeCSSParser();
}

