/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.annotations.Optional;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.IRunAndTrack;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.E4Application;
import org.eclipse.e4.workbench.modeling.EPartService;
import org.eclipse.e4.workbench.modeling.ESelectionService;
import org.eclipse.e4.workbench.modeling.ISelectionListener;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.internal.UIEventPublisher;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.emf.common.notify.Notifier;

public class ESelectionServiceTest
extends TestCase {
    private IEclipseContext applicationContext;
    private IPresentationEngine engine;

    protected void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        super.setUp();
    }

    protected String getEngineURI() {
        return "platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.HeadlessContextPresentationEngine";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext instanceof IDisposable) {
            ((IDisposable)this.applicationContext).dispose();
        }
    }

    private IPresentationEngine getEngine() {
        if (this.engine == null) {
            IContributionFactory contributionFactory = (IContributionFactory)this.applicationContext.get(IContributionFactory.class.getName());
            Object newEngine = contributionFactory.create(this.getEngineURI(), this.applicationContext);
            ESelectionServiceTest.assertTrue((boolean)(newEngine instanceof IPresentationEngine));
            this.applicationContext.set(IPresentationEngine.class.getName(), newEngine);
            this.engine = (IPresentationEngine)newEngine;
        }
        return this.engine;
    }

    public void testGetSelection() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        window.getChildren().add((Object)partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        window.getChildren().add((Object)partB);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class.getName());
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class.getName());
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class.getName());
        EPartService partService = (EPartService)windowContext.get(EPartService.class.getName());
        Object selection1 = new Object();
        Object selection2 = new Object();
        serviceA.setSelection(selection1);
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)windowService.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)serviceA.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)serviceB.getSelection());
        serviceB.setSelection(selection2);
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)windowService.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)serviceA.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)serviceB.getSelection());
        partService.activate(partB);
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)windowService.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)serviceA.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)serviceB.getSelection());
    }

    public void testGetSelection_Id() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        window.getChildren().add((Object)partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        window.getChildren().add((Object)partB);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class.getName());
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class.getName());
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class.getName());
        Object selection1 = new Object();
        Object selection2 = new Object();
        serviceA.setSelection(selection1);
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)windowService.getSelection("partA"));
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)serviceA.getSelection("partA"));
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)serviceB.getSelection("partA"));
        ESelectionServiceTest.assertNull((Object)windowService.getSelection("partB"));
        ESelectionServiceTest.assertNull((Object)serviceA.getSelection("partB"));
        ESelectionServiceTest.assertNull((Object)serviceB.getSelection("partB"));
        serviceB.setSelection(selection2);
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)windowService.getSelection("partA"));
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)serviceA.getSelection("partA"));
        ESelectionServiceTest.assertEquals((Object)selection1, (Object)serviceB.getSelection("partA"));
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)windowService.getSelection("partB"));
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)serviceA.getSelection("partB"));
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)serviceB.getSelection("partB"));
    }

    public void testSelectionListener() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        window.getChildren().add((Object)partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        window.getChildren().add((Object)partB);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class.getName());
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class.getName());
        EPartService partService = (EPartService)windowContext.get(EPartService.class.getName());
        Object selection = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener((ISelectionListener)listener);
        serviceB.setSelection(selection);
        listener.reset();
        partService.activate(partB);
        ESelectionServiceTest.assertEquals((Object)partB, (Object)listener.getPart());
        ESelectionServiceTest.assertEquals((Object)selection, (Object)listener.getSelection());
        windowService.removeSelectionListener((ISelectionListener)listener);
        listener.reset();
        partService.activate(partA);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
    }

    public void testSelectionListener2() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        window.getChildren().add((Object)partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        window.getChildren().add((Object)partB);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class.getName());
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class.getName());
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class.getName());
        EPartService partService = (EPartService)windowContext.get(EPartService.class.getName());
        Object selectionA = new Object();
        Object selectionB = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener((ISelectionListener)listener);
        serviceA.setSelection(selectionA);
        ESelectionServiceTest.assertEquals((Object)partA, (Object)listener.getPart());
        ESelectionServiceTest.assertEquals((Object)selectionA, (Object)listener.getSelection());
        listener.reset();
        serviceA.setSelection(selectionA);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        serviceB.setSelection(selectionB);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        ESelectionServiceTest.assertEquals((Object)partB, (Object)listener.getPart());
        ESelectionServiceTest.assertEquals((Object)selectionB, (Object)listener.getSelection());
        windowService.removeSelectionListener((ISelectionListener)listener);
        listener.reset();
        partService.activate(partA);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
    }

    public void testSelectionListener3() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        window.getChildren().add((Object)partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        window.getChildren().add((Object)partB);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class.getName());
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class.getName());
        EPartService partService = (EPartService)windowContext.get(EPartService.class.getName());
        Object selectionA = new Object();
        Object selectionB = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener((ISelectionListener)listener);
        serviceA.setSelection(selectionA);
        ESelectionServiceTest.assertEquals((Object)partA, (Object)listener.getPart());
        ESelectionServiceTest.assertEquals((Object)selectionA, (Object)listener.getSelection());
        listener.reset();
        serviceA.setSelection(selectionA);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        ESelectionServiceTest.assertEquals((Object)partB, (Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        serviceA.setSelection(selectionB);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
    }

    public void testSelectionListener_Id() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        window.getChildren().add((Object)partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        window.getChildren().add((Object)partB);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class.getName());
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class.getName());
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class.getName());
        EPartService partService = (EPartService)windowContext.get(EPartService.class.getName());
        Object selectionA = new Object();
        Object selectionB = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener("partB", (ISelectionListener)listener);
        serviceA.setSelection(selectionA);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        ESelectionServiceTest.assertEquals((Object)partB, (Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        serviceB.setSelection(selectionB);
        ESelectionServiceTest.assertEquals((Object)partB, (Object)listener.getPart());
        ESelectionServiceTest.assertEquals((Object)selectionB, (Object)listener.getSelection());
        listener.reset();
        serviceA.setSelection(selectionB);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        windowService.removeSelectionListener("partB", (ISelectionListener)listener);
        serviceB.setSelection(selectionA);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
    }

    public void testSelectionListener_Id2() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        window.getChildren().add((Object)partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        window.getChildren().add((Object)partB);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class.getName());
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class.getName());
        EPartService partService = (EPartService)windowContext.get(EPartService.class.getName());
        Object selectionB = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener("partB", (ISelectionListener)listener);
        partService.activate(partA);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        listener.reset();
        serviceB.setSelection(selectionB);
        ESelectionServiceTest.assertEquals((Object)partB, (Object)listener.getPart());
        ESelectionServiceTest.assertEquals((Object)selectionB, (Object)listener.getSelection());
    }

    public void testSelectionListener_Id3() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        window.getChildren().add((Object)partA);
        window.setSelectedElement((MUIElement)partA);
        MPartStack partStack = MApplicationFactory.eINSTANCE.createPartStack();
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        partStack.getChildren().add((Object)partB);
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        partC.setId("partC");
        partStack.getChildren().add((Object)partC);
        partStack.setSelectedElement((MUIElement)partB);
        window.getChildren().add((Object)partStack);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class.getName());
        EPartService partService = (EPartService)windowContext.get(EPartService.class.getName());
        Object selection = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener("partC", (ISelectionListener)listener);
        partService.showPart("partC", EPartService.PartState.CREATE);
        ESelectionServiceTest.assertNull((Object)listener.getPart());
        ESelectionServiceTest.assertNull((Object)listener.getSelection());
        IEclipseContext contextC = partC.getContext();
        ESelectionService serviceC = (ESelectionService)contextC.get(ESelectionService.class.getName());
        listener.reset();
        serviceC.setSelection(selection);
        ESelectionServiceTest.assertEquals((Object)partC, (Object)listener.getPart());
        ESelectionServiceTest.assertEquals((Object)selection, (Object)listener.getSelection());
    }

    public void testOnePartSelection() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        ProviderPart p = new ProviderPart();
        ContextInjectionFactory.inject((Object)p, (IEclipseContext)window.getContext());
        ESelectionServiceTest.assertNull((Object)p.input);
        Object selection = new Object();
        p.setSelection(selection);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)p.input);
        p.setSelection(null);
        ESelectionServiceTest.assertNull((Object)p.input);
    }

    public void testTwoPartHandlerExecute() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partB);
        window.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        IEclipseContext partContextA = partA.getContext();
        IEclipseContext partContextB = partB.getContext();
        ProviderPart partOneImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partOneImpl, (IEclipseContext)partContextA);
        ConsumerPart partTwoImpl = new ConsumerPart();
        ContextInjectionFactory.inject((Object)partTwoImpl, (IEclipseContext)partContextB);
        Object selection = new Object();
        partOneImpl.setSelection(selection);
        UseSelectionHandler handler = new UseSelectionHandler();
        ESelectionServiceTest.assertNull((Object)handler.selection);
        ContextInjectionFactory.invoke((Object)handler, (String)"execute", (IEclipseContext)this.applicationContext, null);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)handler.selection);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, (String)"execute", (IEclipseContext)windowContext, null);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)handler.selection);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, (String)"execute", (IEclipseContext)partContextA, null);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)handler.selection);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, (String)"execute", (IEclipseContext)partContextB, null);
        ESelectionServiceTest.assertNull((Object)handler.selection);
        EPartService partService = (EPartService)windowContext.get(EPartService.class.getName());
        partService.activate(partB);
        ContextInjectionFactory.invoke((Object)handler, (String)"execute", (IEclipseContext)this.applicationContext, null);
        ESelectionServiceTest.assertNull((Object)handler.selection);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, (String)"execute", (IEclipseContext)windowContext, null);
        ESelectionServiceTest.assertNull((Object)handler.selection);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, (String)"execute", (IEclipseContext)partContextA, null);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)handler.selection);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, (String)"execute", (IEclipseContext)partContextB, null);
        ESelectionServiceTest.assertNull((Object)handler.selection);
    }

    public void testThreePartSelection() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partB);
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partC);
        window.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        IEclipseContext partContextA = partA.getContext();
        IEclipseContext partContextB = partB.getContext();
        IEclipseContext partContextC = partC.getContext();
        ProviderPart partOneImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partOneImpl, (IEclipseContext)partContextA);
        ConsumerPart partTwoImpl = new ConsumerPart();
        ContextInjectionFactory.inject((Object)partTwoImpl, (IEclipseContext)partContextB);
        ProviderPart partThreeImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partThreeImpl, (IEclipseContext)partContextC);
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class.getName());
        EPartService partService = (EPartService)windowContext.get(EPartService.class.getName());
        Object selection = new Object();
        Object selection2 = new Object();
        ESelectionServiceTest.assertNull((Object)windowService.getSelection());
        ESelectionServiceTest.assertNull((Object)partOneImpl.input);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertNull((Object)partThreeImpl.input);
        partOneImpl.setSelection(selection);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)windowService.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertNull((Object)partThreeImpl.input);
        partThreeImpl.setSelection(selection2);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)windowService.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)partThreeImpl.input);
        partService.activate(partB);
        ESelectionServiceTest.assertNull((Object)windowService.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)partThreeImpl.input);
        partService.activate(partC);
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)windowService.getSelection());
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)partThreeImpl.input);
    }

    public void testPartOneTracksPartThree() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partB);
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        partC.setId("partC");
        window.getChildren().add((Object)partC);
        window.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        final IEclipseContext partContextA = partA.getContext();
        IEclipseContext partContextB = partB.getContext();
        IEclipseContext partContextC = partC.getContext();
        final TrackingProviderPart partOneImpl = new TrackingProviderPart();
        ContextInjectionFactory.inject((Object)partOneImpl, (IEclipseContext)partContextA);
        ConsumerPart partTwoImpl = new ConsumerPart();
        ContextInjectionFactory.inject((Object)partTwoImpl, (IEclipseContext)partContextB);
        ProviderPart partThreeImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partThreeImpl, (IEclipseContext)partContextC);
        Object selection = new Object();
        Object selection2 = new Object();
        partOneImpl.setSelection(selection);
        partThreeImpl.setSelection(selection2);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertNull((Object)partOneImpl.otherSelection);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)partThreeImpl.input);
        partContextC.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                if (event.getEventType() == 3) {
                    return false;
                }
                ESelectionService s = (ESelectionService)partContextA.get(ESelectionService.class.getName());
                partOneImpl.setOtherSelection(s.getSelection("partC"));
                return true;
            }
        }, null);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)partOneImpl.otherSelection);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)partThreeImpl.input);
        partThreeImpl.setSelection(selection);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.otherSelection);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partThreeImpl.input);
        partThreeImpl.setSelection(null);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertNull((Object)partOneImpl.otherSelection);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertNull((Object)partThreeImpl.input);
    }

    public void testPartOneTracksPartThree2() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partA);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partB);
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        partC.setId("partC");
        window.getChildren().add((Object)partC);
        window.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext partContextA = partA.getContext();
        IEclipseContext partContextB = partB.getContext();
        IEclipseContext partContextC = partC.getContext();
        final TrackingProviderPart partOneImpl = new TrackingProviderPart();
        ContextInjectionFactory.inject((Object)partOneImpl, (IEclipseContext)partContextA);
        ConsumerPart partTwoImpl = new ConsumerPart();
        ContextInjectionFactory.inject((Object)partTwoImpl, (IEclipseContext)partContextB);
        ProviderPart partThreeImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partThreeImpl, (IEclipseContext)partContextC);
        Object selection = new Object();
        Object selection2 = new Object();
        Object selection3 = new Object();
        partOneImpl.setSelection(selection);
        partThreeImpl.setSelection(selection2);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertNull((Object)partOneImpl.otherSelection);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection2, (Object)partThreeImpl.input);
        ESelectionService selectionService = (ESelectionService)partContextA.get(ESelectionService.class.getName());
        selectionService.addSelectionListener(partC.getId(), new ISelectionListener(){

            public void selectionChanged(MPart part, Object selection) {
                partOneImpl.setOtherSelection(selection);
            }
        });
        partThreeImpl.setSelection(selection3);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection3, (Object)partOneImpl.otherSelection);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection3, (Object)partThreeImpl.input);
        partThreeImpl.setSelection(selection);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.otherSelection);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partThreeImpl.input);
        partThreeImpl.setSelection(null);
        ESelectionServiceTest.assertEquals((Object)selection, (Object)partOneImpl.input);
        ESelectionServiceTest.assertNull((Object)partOneImpl.otherSelection);
        ESelectionServiceTest.assertNull((Object)partTwoImpl.input);
        ESelectionServiceTest.assertNull((Object)partThreeImpl.input);
    }

    private void initialize(IEclipseContext applicationContext, MApplication application) {
        applicationContext.set(MApplication.class.getName(), (Object)application);
        application.setContext(applicationContext);
        Workbench.processHierarchy((Object)application);
        ((Notifier)application).eAdapters().add((Object)new UIEventPublisher(applicationContext));
    }

    static class ConsumerPart {
        public Object input;

        ConsumerPart() {
        }

        @Inject
        @Optional
        public void setInput(@Named(value="in.selection") Object current) {
            this.input = current;
        }
    }

    static class ProviderPart
    extends ConsumerPart {
        private ESelectionService selectionService;

        ProviderPart() {
        }

        @Inject
        public void setSelectionService(ESelectionService s) {
            this.selectionService = s;
        }

        public void setSelection(Object selection) {
            this.selectionService.setSelection(selection);
        }
    }

    static class SelectionListener
    implements ISelectionListener {
        private MPart part;
        private Object selection;

        SelectionListener() {
        }

        public void reset() {
            this.part = null;
            this.selection = null;
        }

        public void selectionChanged(MPart part, Object selection) {
            this.part = part;
            this.selection = selection;
        }

        public MPart getPart() {
            return this.part;
        }

        public Object getSelection() {
            return this.selection;
        }
    }

    static class TrackingProviderPart
    extends ProviderPart {
        public Object otherSelection;

        TrackingProviderPart() {
        }

        public void setOtherSelection(Object selection) {
            this.otherSelection = selection;
        }
    }

    static class UseSelectionHandler {
        public Object selection;

        UseSelectionHandler() {
        }

        public void execute(@Optional @Named(value="in.selection") Object s) {
            this.selection = s;
        }
    }
}

