/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import junit.framework.TestCase;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.IRunAndTrack;
import org.eclipse.e4.core.services.context.spi.ContextFunction;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.core.services.context.spi.ISchedulerStrategy;
import org.eclipse.e4.ui.internal.services.ActiveContextsFunction;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.workbench.swt.Activator;
import org.eclipse.e4.workbench.ui.IExceptionHandler;
import org.eclipse.e4.workbench.ui.internal.ActivePartLookupFunction;
import org.eclipse.e4.workbench.ui.internal.ExceptionHandler;
import org.eclipse.e4.workbench.ui.internal.ReflectionContributionFactory;
import org.eclipse.e4.workbench.ui.internal.WorkbenchLogger;
import org.osgi.framework.BundleContext;

public abstract class HeadlessStartupTest
extends TestCase {
    protected IEclipseContext osgiContext;
    protected IEclipseContext applicationContext;

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        this.applicationContext.set("debugString", (Object)"Application Context");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext instanceof IDisposable) {
            ((IDisposable)this.applicationContext).dispose();
        }
    }

    private IEclipseContext createOSGiContext() {
        this.osgiContext = EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
        return this.osgiContext;
    }

    private IEclipseContext createApplicationContext() {
        return this.createApplicationContext(this.createOSGiContext());
    }

    protected ISchedulerStrategy getApplicationSchedulerStrategy() {
        return null;
    }

    protected IEclipseContext createApplicationContext(IEclipseContext osgiContext) {
        HeadlessStartupTest.assertNotNull((Object)osgiContext);
        IEclipseContext appContext = this.createContext(osgiContext, (IEclipseContextStrategy)this.getApplicationSchedulerStrategy());
        appContext.set(IEclipseContext.class.getName(), (Object)appContext);
        appContext.set(IContributionFactory.class.getName(), (Object)new ReflectionContributionFactory((IExtensionRegistry)appContext.get(IExtensionRegistry.class.getName())));
        appContext.set(IExceptionHandler.class.getName(), (Object)new ExceptionHandler());
        appContext.set(Logger.class.getName(), (Object)new WorkbenchLogger());
        appContext.set(ContextManager.class.getName(), (Object)new ContextManager());
        appContext.set("activeContexts", (Object)new ActiveContextsFunction());
        appContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        appContext.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                IEclipseContext eventsContext = event.getContext();
                Object o = eventsContext.get("e4ActivePart");
                if (o instanceof MPart) {
                    eventsContext.set("activePartId", (Object)((MPart)o).getId());
                }
                return true;
            }

            public String toString() {
                return "HeadlessStartupTest$RunAndTrack[activePartId]";
            }
        }, null);
        appContext.set("input", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                Object adapted;
                IAdapterManager adapters;
                Class adapterType = null;
                if (arguments.length > 0 && arguments[0] instanceof Class) {
                    adapterType = (Class)arguments[0];
                }
                Object newInput = null;
                Object newValue = context.get("selection");
                if (adapterType == null || adapterType.isInstance(newValue)) {
                    newInput = newValue;
                } else if (newValue != null && adapterType != null && (adapters = (IAdapterManager)context.get(IAdapterManager.class.getName())) != null && (adapted = adapters.loadAdapter(newValue, adapterType.getName())) != null) {
                    newInput = adapted;
                }
                return newInput;
            }
        });
        return appContext;
    }

    private IEclipseContext createContext(IEclipseContext parent, IEclipseContextStrategy strategy) {
        IEclipseContext eclipseContext = EclipseContextFactory.create((IEclipseContext)parent, (IEclipseContextStrategy)strategy);
        return eclipseContext;
    }
}

