/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.IModelReconcilingService;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;
import org.eclipse.e4.workbench.ui.internal.ModelReconcilingService;

public class E4XMIResourceFactoryTest
extends ModelReconcilerTest {
    public void testNonConflictingIds() {
        MApplication application = this.createApplication();
        this.saveModel();
        application = this.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        E4XMIResourceFactoryTest.assertFalse((boolean)this.getId((MApplicationElement)application).equals(this.getId((MApplicationElement)window)));
    }

    public void testNonConflictingIds2() {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window1 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        MWindow window2 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window2);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        E4XMIResourceFactoryTest.assertEquals((int)1, (int)application.getChildren().size());
        E4XMIResourceFactoryTest.assertEquals((Object)window2, (Object)application.getChildren().get(0));
        this.applyAll(deltas);
        window1 = (MWindow)application.getChildren().get(0);
        window2 = (MWindow)application.getChildren().get(1);
        String applicationId = this.getId((MApplicationElement)application);
        String window1Id = this.getId((MApplicationElement)window1);
        String window2Id = this.getId((MApplicationElement)window2);
        E4XMIResourceFactoryTest.assertFalse((boolean)applicationId.equals(window1Id));
        E4XMIResourceFactoryTest.assertFalse((boolean)applicationId.equals(window2Id));
        E4XMIResourceFactoryTest.assertFalse((boolean)window1Id.equals(window2Id));
    }

    public void testNonConflictingIds3_Bug303841() {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        command.setId("id");
        application.getCommands().add((Object)command);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        part.setId("id");
        window.getChildren().add((Object)part);
        window.setSelectedElement((MUIElement)part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        E4XMIResourceFactoryTest.assertEquals((int)0, (int)application.getChildren().size());
        E4XMIResourceFactoryTest.assertEquals((int)0, (int)application.getCommands().size());
        this.applyAll(deltas);
    }

    protected IModelReconcilingService getModelReconcilingService() {
        return new ModelReconcilingService();
    }
}

