/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MKeyBinding;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerBindingContainerTest
extends ModelReconcilerTest {
    private void testBindingContainer_Add_KeyBinding(String keySequence) throws Exception {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MKeyBinding keyBinding = MApplicationFactory.eINSTANCE.createKeyBinding();
        keyBinding.setKeySequence(keySequence);
        application.getBindings().add((Object)keyBinding);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerBindingContainerTest.assertEquals((int)0, (int)application.getBindings().size());
        this.applyAll(deltas);
        ModelReconcilerBindingContainerTest.assertEquals((int)1, (int)application.getBindings().size());
        keyBinding = (MKeyBinding)application.getBindings().get(0);
        ModelReconcilerBindingContainerTest.assertNull((Object)keyBinding.getCommand());
        ModelReconcilerBindingContainerTest.assertEquals((String)keySequence, (String)keyBinding.getKeySequence());
        ModelReconcilerBindingContainerTest.assertEquals((int)0, (int)keyBinding.getParameters().size());
    }

    public void testBindingContainer_Add_KeyBinding_Null() throws Exception {
        this.testBindingContainer_Add_KeyBinding(null);
    }

    public void testBindingContainer_Add_KeyBinding_Empty() throws Exception {
        this.testBindingContainer_Add_KeyBinding("");
    }

    public void testBindingContainer_Add_KeyBinding_String() throws Exception {
        this.testBindingContainer_Add_KeyBinding("Ctrl+S");
    }

    private void testBindingContainer_Remove_KeyBinding(String keySequence) throws Exception {
        MApplication application = this.createApplication();
        MKeyBinding keyBinding = MApplicationFactory.eINSTANCE.createKeyBinding();
        keyBinding.setKeySequence(keySequence);
        application.getBindings().add((Object)keyBinding);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        application.getBindings().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerBindingContainerTest.assertEquals((int)1, (int)application.getBindings().size());
        keyBinding = (MKeyBinding)application.getBindings().get(0);
        ModelReconcilerBindingContainerTest.assertNull((Object)keyBinding.getCommand());
        ModelReconcilerBindingContainerTest.assertEquals((String)keySequence, (String)keyBinding.getKeySequence());
        ModelReconcilerBindingContainerTest.assertEquals((int)0, (int)keyBinding.getParameters().size());
        this.applyAll(deltas);
        ModelReconcilerBindingContainerTest.assertEquals((int)0, (int)application.getBindings().size());
    }

    public void testBindingContainer_Remove_KeyBinding_Null() throws Exception {
        this.testBindingContainer_Remove_KeyBinding(null);
    }

    public void testBindingContainer_Remove_KeyBinding_Empty() throws Exception {
        this.testBindingContainer_Remove_KeyBinding("");
    }

    public void testBindingContainer_Remove_KeyBinding_String() throws Exception {
        this.testBindingContainer_Remove_KeyBinding("Ctrl+S");
    }

    private void testBindingContainer_Add_BoundKeyBinding(String keySequence) throws Exception {
        MApplication application = this.createApplication();
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        application.getCommands().add((Object)command);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MKeyBinding keyBinding = MApplicationFactory.eINSTANCE.createKeyBinding();
        keyBinding.setKeySequence(keySequence);
        keyBinding.setCommand(command);
        application.getBindings().add((Object)keyBinding);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerBindingContainerTest.assertEquals((int)0, (int)application.getBindings().size());
        this.applyAll(deltas);
        ModelReconcilerBindingContainerTest.assertEquals((int)1, (int)application.getBindings().size());
        keyBinding = (MKeyBinding)application.getBindings().get(0);
        ModelReconcilerBindingContainerTest.assertEquals((Object)command, (Object)keyBinding.getCommand());
        ModelReconcilerBindingContainerTest.assertEquals((String)keySequence, (String)keyBinding.getKeySequence());
    }

    public void testBindingContainer_Add_BoundKeyBinding_Null() throws Exception {
        this.testBindingContainer_Add_BoundKeyBinding(null);
    }

    public void testBindingContainer_Add_BoundKeyBinding_Empty() throws Exception {
        this.testBindingContainer_Add_BoundKeyBinding("");
    }

    public void testBindingContainer_Add_BoundKeyBinding_String() throws Exception {
        this.testBindingContainer_Add_BoundKeyBinding("Ctrl+S");
    }

    private void testBindingContainer_Remove_BoundKeyBinding(String keySequence) throws Exception {
        MApplication application = this.createApplication();
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        application.getCommands().add((Object)command);
        MKeyBinding keyBinding = MApplicationFactory.eINSTANCE.createKeyBinding();
        keyBinding.setKeySequence(keySequence);
        keyBinding.setCommand(command);
        application.getBindings().add((Object)keyBinding);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        application.getBindings().remove((Object)keyBinding);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerBindingContainerTest.assertEquals((int)1, (int)application.getBindings().size());
        keyBinding = (MKeyBinding)application.getBindings().get(0);
        ModelReconcilerBindingContainerTest.assertEquals((Object)command, (Object)keyBinding.getCommand());
        ModelReconcilerBindingContainerTest.assertEquals((String)keySequence, (String)keyBinding.getKeySequence());
        ModelReconcilerBindingContainerTest.assertEquals((int)0, (int)keyBinding.getParameters().size());
        this.applyAll(deltas);
        ModelReconcilerBindingContainerTest.assertEquals((int)0, (int)application.getBindings().size());
    }

    public void testBindingContainer_Remove_BoundKeyBinding_Null() throws Exception {
        this.testBindingContainer_Remove_BoundKeyBinding(null);
    }

    public void testBindingContainer_Remove_BoundKeyBinding_Empty() throws Exception {
        this.testBindingContainer_Remove_BoundKeyBinding("");
    }

    public void testBindingContainer_Remove_BoundKeyBinding_String() throws Exception {
        this.testBindingContainer_Remove_BoundKeyBinding("Ctrl+S");
    }
}

